package com.ptteng.common.skill.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.common.skill.model.Cities;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface CitiesService extends BaseDaoService {

	



   		   
		
		public Long insert(Cities cities)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Cities> insertList(List<Cities> citiesList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Cities cities)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Cities> citiesList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Cities getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Cities> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countCitiesIdsByProvinceIdOrderByCreateAt(Long provinceId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getCitiesIdByCity(String city)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getCitiesIdsByProvinceIdOrderByCreateAt(Long provinceId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getCitiesIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countCitiesIds() throws ServiceException, ServiceDaoException;
	

}

