package com.ptteng.common.skill.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.common.skill.model.Account;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface AccountService extends BaseDaoService {



		public Long insert(Account account)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Account> insertList(List<Account> accountList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Account account)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Account> accountList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Account getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Account> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  

	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countAccountIdsByAccount(String account)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getAccountIdsByAccount(String account, Integer start, Integer limit)throws ServiceException, ServiceDaoException;

	public List<Long>  getAccountByMobile(String mobile, Integer start, Integer limit)throws ServiceException, ServiceDaoException;



	public List<Long>  getAccountIdsByServerIdandStatus(Long account,Integer status, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getAccountIdsByServerId(Long serverId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;



	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getAccountIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getAccountByUid(Long uid, Integer start, Integer limit)

		throws ServiceException, ServiceDaoException;


    public List<Long> getAccountByStatus(Integer status, Integer start, Integer limit)
		throws ServiceDaoException,ServiceDaoException;



	public List<Long> getAccountByStatusAndType(Integer status,Long type ,Integer start, Integer limit)
			throws ServiceDaoException,ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countAccountIds() throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countAccountByUid(Long uid) throws ServiceException, ServiceDaoException;


	public List<Long> getExpireAccountIds(Long endTime, Integer start, Integer limit) throws ServiceException, ServiceDaoException;
}

