package com.ptteng.common.skill.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "ctype")
public class Ctype implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 9132837621592771584L;
    public static final int Status_Disable = 0;
    public static final int Status_Enable = 1;
    public static final int Statistics_InitialValue = 0;

    private Long id;

    /**
     * 卡券名称
     */
    private String title;

    /**
     * 卡券封面
     */
    private String img;

    /**
     * 卡券使用规则限制描述
     */
    private String description;


    /**
     * 卡券过期时间：单位小时
     */
    private Integer expire;

    /**
     * 卡券类型启用禁用状态 0禁用 1启用
     */
    private Integer status;

    /**
     * 卡券类型生成人
     */
    private Long createBy;

    /**
     * 卡券类型更新人
     */
    private Long updateBy;

    /**
     * 卡券类型更新时间
     */
    private Long updateAt;

    /**
     * 卡券类型生成时间
     */
    private Long createAt;

    /**
     * 卡券生成数量
     */
    private Integer createCount;

    /**
     * 卡券发放未使用数量
     */
    private Integer assignCount;

    /**
     * 卡券核销中数量
     */
    private Integer verifyingCount;

    /**
     * 卡券已核销数量
     */
    private Integer verifiedCount;

    /**
     * 卡券已转让数量
     */
    private Integer cessionCount;

    /**
     * 卡券已过期数量
     */
    private Integer expiredCount;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "title")
    public String getTitle() {
        return title;
    }


    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name = "img")
    public String getImg() {
        return img;
    }


    public void setImg(String img) {
        this.img = img;
    }

    @Column(name = "description")
    public String getDescription() {
        return description;
    }


    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name = "expire")
    public Integer getExpire() {
        return expire;
    }


    public void setExpire(Integer expire) {
        this.expire = expire;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }


    @Column(name = "create_count")
    public Integer getCreateCount() {
        return createCount;
    }

    public void setCreateCount(Integer createCount) {
        this.createCount = createCount;
    }

    @Column(name = "assign_count")
    public Integer getAssignCount() {
        return assignCount;
    }

    public void setAssignCount(Integer assignCount) {
        this.assignCount = assignCount;
    }


    @Column(name = "verifying_count")
    public Integer getVerifyingCount() {
        return verifyingCount;
    }

    public void setVerifyingCount(Integer verifyingCount) {
        this.verifyingCount = verifyingCount;
    }

    @Column(name = "verified_count")
    public Integer getVerifiedCount() {
        return verifiedCount;
    }

    public void setVerifiedCount(Integer verifiedCount) {
        this.verifiedCount = verifiedCount;
    }

    @Column(name = "cession_count")
    public Integer getCessionCount() {
        return cessionCount;
    }

    public void setCessionCount(Integer cessionCount) {
        this.cessionCount = cessionCount;
    }

    @Column(name = "expired_count")
    public Integer getExpiredCount() {
        return expiredCount;
    }

    public void setExpiredCount(Integer expiredCount) {
        this.expiredCount = expiredCount;
    }


    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

