package com.ptteng.common.skill.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "message")
public class Message implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 5074540398389866496L;

    /**
     * message类型
     * daily--日报评论
     * task--任务提交
     */
    public static final String DAILY_TYPE="daily";
    public static final String TEACHER_TYPE="teacher";
    public static final String CLASS_TYPE="classes";
    public static final String TASK_TYPE="task";
    public static final String SCORE_TYPE="score";
    /**
     * 未读
     */
	public static final Integer Status_Unread = 1;
	/**
	 * 已读
	 */
	public static final Integer Status_read = 0; 

	
	private Long id;

    private Long sendId = 0L;


    private Long receiveId = 0L;


    private String sendName = "admin";


    private String receiveName;


    private String content;



    private Integer status = 1;


    private Integer unread = 1;


    private String type;


    private Long relationId;


    private Long createBy = 0L;


    private Long updateBy = 0L;


    private Long updateAt = 0L;


    private Long createAt = 0L;


    public Message() {
    }

    public Message(Long receiveId, String receiveName, String type, Long relationId) {
        this.receiveId = receiveId;
        this.receiveName = receiveName;
        this.type = type;
        this.relationId = relationId;
    }

    public Message(Long receiveId, String receiveName, String content, String type, Long relationId) {
        this.receiveId = receiveId;
        this.receiveName = receiveName;
        this.content = content;
        this.type = type;
        this.relationId = relationId;
    }



    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "send_id")
    public Long getSendId() {
        return sendId;
    }


    public void setSendId(Long sendId) {
        this.sendId = sendId;
    }

    @Column(name = "receive_id")
    public Long getReceiveId() {
        return receiveId;
    }


    public void setReceiveId(Long receiveId) {
        this.receiveId = receiveId;
    }

    @Column(name = "send_name")
    public String getSendName() {
        return sendName;
    }


    public void setSendName(String sendName) {
        this.sendName = sendName;
    }

    @Column(name = "receive_name")
    public String getReceiveName() {
        return receiveName;
    }


    public void setReceiveName(String receiveName) {
        this.receiveName = receiveName;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }


    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "unread")
    public Integer getUnread() {
        return unread;
    }

    public void setUnread(Integer unread) {
        this.unread = unread;
    }

    @Column(name = "type")
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Column(name = "relation_id")
    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }








    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

