package com.ptteng.skill.service.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "user_task_relation")
public class UserTaskRelation implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 2754204627096540160L;

	/**
	 *  师兄查看的任务类型
	 *  1-待审核
	 *  2-审核不通过
	 *  3-审核通过
	 *
	 */
	public static final int UNJUDGE = 1;
	public static final int JUDGE_FAILD = 2;
	public static final int JUDGE_PASS = 3;

	/**
	 * 任务阶段
	 * receive--领取
	 * submit--提交
	 * review--审核
	 */
	public static final String RECEIVE="receive";
	public static final String SUBMIT="submit";
	public static final String REVIEW="review";


	/**
	 *  1-未领取
	 * 
	 */
	public static final int PROGRESS_UNRECEIVE = 1;
    	
	/**
	 *  2-已领取
	 * 
	 */
	public static final int PROGRESS_RECEIVE = 2;
    	
	/**
	 *  3-已提交
	 * 
	 */
	public static final int PROGRESS_SUBMITED = 3;
    	
	/**
	 *  4-审核失败
	 * 
	 */
	public static final int PROGRESS_FAIL = 4;
    	
	/**
	 *  5-审核通过
	 * 
	 */
	public static final int PROGRESS_PASSED = 5;
    	
   	 
    private  Long id;
	
  	 
    private  Long tid;
	
  	 
    private  Long uid;
	
  	 
    private  Long oid;
	
  	 
    private  Integer progress=PROGRESS_RECEIVE;
	
  	 
    private  String resultUrl;
	
  	 
    private  String codeUrl;
	
  	 
    private  Long receiveAt;
	
  	 
    private  Long submitAt;
	
  	 
    private  Long judgeUid;
	
  	 
    private  String judgeRemark;
	
  	 
    private  Long judgeAt;
	
  	 
    private  Long createBy;
	
  	 
    private  Long updateBy;
	
  	 
    private  Long updateAt;
	
  	 
    private  Long createAt;
    
    /**
     * 修真院13期，新增4个字段，
     * 数据库没有新增字段，只是在类里。
     */
	
    private int topArticleCount;
    private int middleArticleCount;
    private int lowerArticleCount;
    private int selfTaskScore;
	
    @Transient
	public int getTopArticleCount() {
		return topArticleCount;
	}

	public void setTopArticleCount(int topArticleCount) {
		this.topArticleCount = topArticleCount;
	}
	@Transient
	public int getMiddleArticleCount() {
		return middleArticleCount;
	}

	public void setMiddleArticleCount(int middleArticleCount) {
		this.middleArticleCount = middleArticleCount;
	}
	@Transient
	public int getLowerArticleCount() {
		return lowerArticleCount;
	}

	public void setLowerArticleCount(int lowerArticleCount) {
		this.lowerArticleCount = lowerArticleCount;
	}
	@Transient
	public int getSelfTaskScore() {
		return selfTaskScore;
	}

	public void setSelfTaskScore(int selfTaskScore) {
		this.selfTaskScore = selfTaskScore;
	}

				@Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "tid")
	public Long getTid() {
		return tid;
	}
	
	
	public void setTid(Long tid) {
		this.tid = tid;
	}
		 	@Column(name = "uid")
	public Long getUid() {
		return uid;
	}
	
	
	public void setUid(Long uid) {
		this.uid = uid;
	}
		 	@Column(name = "oid")
	public Long getOid() {
		return oid;
	}
	
	
	public void setOid(Long oid) {
		this.oid = oid;
	}
		 	@Column(name = "progress")
	public Integer getProgress() {
		return progress;
	}
	
	
	public void setProgress(Integer progress) {
		this.progress = progress;
	}
		 	@Column(name = "result_url")
	public String getResultUrl() {
		return resultUrl;
	}
	
	
	public void setResultUrl(String resultUrl) {
		this.resultUrl = resultUrl;
	}
		 	@Column(name = "code_url")
	public String getCodeUrl() {
		return codeUrl;
	}
	
	
	public void setCodeUrl(String codeUrl) {
		this.codeUrl = codeUrl;
	}
		 	@Column(name = "receive_at")
	public Long getReceiveAt() {
		return receiveAt;
	}
	
	
	public void setReceiveAt(Long receiveAt) {
		this.receiveAt = receiveAt;
	}
		 	@Column(name = "submit_at")
	public Long getSubmitAt() {
		return submitAt;
	}
	
	
	public void setSubmitAt(Long submitAt) {
		this.submitAt = submitAt;
	}
		 	@Column(name = "judge_uid")
	public Long getJudgeUid() {
		return judgeUid;
	}
	
	
	public void setJudgeUid(Long judgeUid) {
		this.judgeUid = judgeUid;
	}
		 	@Column(name = "judge_remark")
	public String getJudgeRemark() {
		return judgeRemark;
	}
	
	
	public void setJudgeRemark(String judgeRemark) {
		this.judgeRemark = judgeRemark;
	}
		 	@Column(name = "judge_at")
	public Long getJudgeAt() {
		return judgeAt;
	}
	
	
	public void setJudgeAt(Long judgeAt) {
		this.judgeAt = judgeAt;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

