/**
 *
 */
package com.ptteng.sca.common.skill.client;

import java.util.List;
import java.util.Map;

import com.ptteng.common.skill.model.Document;
import com.ptteng.common.skill.service.DocumentService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class DocumentSCAClient implements DocumentService {

    private DocumentService documentService;

    public DocumentService getDocumentService() {
        return documentService;
    }


    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }


    @Override
    public Long insert(Document document) throws ServiceException, ServiceDaoException {

        return documentService.insert(document);


    }


    @Override
    public List<Document> insertList(List<Document> documentList) throws ServiceException, ServiceDaoException {

        return documentService.insertList(documentList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return documentService.delete(id);


    }


    @Override
    public boolean update(Document document) throws ServiceException, ServiceDaoException {

        return documentService.update(document);


    }


    @Override
    public boolean updateList(List<Document> documentList) throws ServiceException, ServiceDaoException {

        return documentService.updateList(documentList);


    }


    @Override
    public Document getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return documentService.getObjectById(id);


    }


    @Override
    public List<Document> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return documentService.getObjectsByIds(ids);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getDocumentIdBySid(Long sid) throws ServiceException, ServiceDaoException {

        return documentService.getDocumentIdBySid(sid);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getDocumentIdByOidAndType(Long oid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return documentService.getDocumentIdByOidAndType(oid, type, start, limit);


    }

    @Override
    public Integer countDocumentIdByOidAndType(Long oid, Integer type) throws ServiceException, ServiceDaoException {
        return documentService.countDocumentIdByOidAndType(oid, type);
    }


    @Override
    public List<Long> getDocumentIdBySidAndType(Long sid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return documentService.getDocumentIdBySidAndType(sid, type, start, limit);
    }

    @Override
    public Integer countDocumentIdBySidAndType(Long sid, Integer type) throws ServiceException, ServiceDaoException {
        return documentService.countDocumentIdBySidAndType(sid, type);
    }


    @Override
    public List<Long> getDocumentIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return documentService.getDocumentIds(start, limit);
    }

    @Override
    public List<Long> getDocumentIdsByType(Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return documentService.getDocumentIdsByType(type, start, limit);
    }

    @Override
    public Integer countDocumentIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return documentService.countDocumentIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return documentService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return documentService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        documentService.deleteList(clz, ids);

    }


}

