/**
 * 
 */
package com.ptteng.sca.common.skill.client;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.Account;
import com.ptteng.common.skill.service.AccountService;

import java.util.List;
import java.util.Map;

public class AccountSCAClient implements AccountService {

    private AccountService accountService;

	public AccountService getAccountService() {
		return accountService;
	}
	
	
	public void setAccountService(AccountService accountService) {
		this.accountService =accountService;
	}
	
	
			   
		@Override
		public Long insert(Account account)throws ServiceException, ServiceDaoException{
		
		return accountService.insert(account);
		          
		
		}	
		  
    	   
		@Override
		public List<Account> insertList(List<Account> accountList)throws ServiceException, ServiceDaoException{
		
		return accountService.insertList(accountList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return accountService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Account account)throws ServiceException, ServiceDaoException{
		
		return accountService.update(account);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Account> accountList)throws ServiceException, ServiceDaoException{
		
		return accountService.updateList(accountList);
		          
		
		}	
		  
    	   
		@Override
		public Account getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return accountService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Account> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return accountService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
	/**
	 * 
	 * @param 2222
	 * @return 2222
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getAccountIdsByAccount(String account,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return accountService.getAccountIdsByAccount(account, start, limit);
	
	
	}

	@Override
	public List<Long> getAccountByMobile(String mobile, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return accountService.getAccountByMobile(mobile,start,limit);
	}

	@Override
	public List<Long> getAccountIdsByServerIdandStatus(Long serverId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return accountService.getAccountIdsByServerIdandStatus(serverId,status,start,limit);
	}

	@Override
	public List<Long> getAccountIdsByServerId(Long serverId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return accountService.getAccountIdsByServerId(serverId,start,limit);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countAccountIdsByAccount(String account)throws ServiceException, ServiceDaoException{



		return accountService.countAccountIdsByAccount(account);
	
	
	}
	
		
	
		@Override
	public List<Long> getAccountIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return accountService.getAccountIds(start, limit);
	}

	@Override
	public List<Long> getAccountByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

		return accountService.getAccountByUid(uid,start,limit);
	}

	@Override
	public List<Long> getAccountByStatus(Integer status, Integer start, Integer limit) throws ServiceDaoException, ServiceDaoException {
		return accountService.getAccountByStatus(status,start,limit);
	}

	@Override
	public List<Long> getAccountByStatusAndType(Integer status, Long type, Integer start, Integer limit) throws ServiceDaoException, ServiceDaoException {
		return accountService.getAccountByStatusAndType(status,type,start,limit);
	}

	@Override
	public Integer countAccountIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return accountService.countAccountIds();
	}

	@Override
	public Integer countAccountByUid(Long uid) throws ServiceException, ServiceDaoException {
		return accountService.countAccountByUid(uid);
	}


	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return accountService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return accountService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   accountService.deleteList(clz, ids);
		
	}


 
}

