package com.ptteng.common.skill.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.TaskSkillRelation;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface TaskSkillRelationService extends BaseDaoService {

	



   		   
		
		public Long insert(TaskSkillRelation taskSkillRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<TaskSkillRelation> insertList(List<TaskSkillRelation> taskSkillRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(TaskSkillRelation taskSkillRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<TaskSkillRelation> taskSkillRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public TaskSkillRelation getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<TaskSkillRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countTaskSkillRelationIdsBySid(Long sid)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countTaskSkillRelationIdsByTid(Long tid)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getTaskSkillRelationIdByTidAndSid(Long tid, Long uid)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getTaskSkillRelationIdsBySid(Long sid, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getSidsByOid(Long oid, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getTaskSkillRelationIdsByTid(Long tid, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getSkillIdsByTid(Long tid, Integer start, Integer limit)throws ServiceException, ServiceDaoException;




	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getTaskSkillRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countTaskSkillRelationIds() throws ServiceException, ServiceDaoException;
	

}

