package com.ptteng.common.skill.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.common.skill.model.Order;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface OrderService extends BaseDaoService {

	



   		   
		
		public Long insert(Order order)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Order> insertList(List<Order> orderList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Order order)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Order> orderList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Order getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
	    public Order getObjectByOrderId(String orderId)throws ServiceException, ServiceDaoException;
		
		public List<Order> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countOrderIdsByBuyer(Long buyer)throws ServiceException, ServiceDaoException;
					



	public Integer countOrderIdsByStatus(Integer status) throws ServiceException, ServiceDaoException;


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getOrderIdsByBuyer(Long buyer, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	public List<Long> getOrderIdsByStatus(Integer status ,Integer start, Integer limit)throws ServiceException, ServiceDaoException;
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getOrderIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countOrderIds() throws ServiceException, ServiceDaoException;
	

}

