package com.ptteng.common.skill.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.common.skill.model.Goods;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface GoodsService extends BaseDaoService {

	



   		   
		
		public Long insert(Goods goods)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Goods> insertList(List<Goods> goodsList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Goods goods)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Goods> goodsList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Goods getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Goods> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	public List<Long> getGoodsByBuyerAndOrderid(Long uid, String orderId, Integer start, Integer limit)

			throws ServiceDaoException, ServiceException;


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countGoodsIdsByBuyerAndIsConfirm(Long buyer, Integer isConfirm)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countGoodsIdBybuyerAndorderId(Long buyer, Long orderId)throws ServiceException, ServiceDaoException;



	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getGoodsIdsByBuyerAndIsConfirm(Long buyer, Integer isConfirm, Integer start, Integer limit)throws ServiceException, ServiceDaoException;




	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getGoodsIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countGoodsIds() throws ServiceException, ServiceDaoException;


}

