package com.ptteng.common.skill.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "occupation")
public class Occupation implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 4962248169743004672L;
    /**
     *  未发布
     *
     */
    public static final Integer Status_Unpublished = 1;

    /**
     * 发布
     */
    public static final Integer Status_Published = 2;//强制更新
    /**
     * 在常量表中标记职业的Type
     */
	public static final String Constant_Type_occupation = "occupation_type";
    private Long id;


    private String name;


    private String CnName;


    private String qq;


    private String qqUrl;


    private String brief;


    private String description;


    private Integer threshold;


    private Integer difficult;


    private String cycle;
    
    private String basis;


    private Integer company;

    private String skillImg;


    private String img;


    private Long onlineGradeCount=0L;


    private Long offlineGradeCount=0L;


    private Long classCount=0L;


    private Long onlineClassCount=0L;


    private Long offlineClassCount=0L;


    private Long onlineUserCount=0L;


    private Long offlineUserCount=0L;


    private Long coreUserCount=0L;
    
    
   
    private Integer people;
    
    /**
     * 职业分组，跟Constant表里的name对应一致
     *
     */
    private String type;
    
    private String salary;
    
    private String modules;

    private Long publishAt;
    
    private Integer status;
    
    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;
  
    


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }
    @Column(name = "modules")
    public String getModules() {
        return modules;
    }

    public void setModules(String modules) {
        this.modules = modules;
    }


    @Column(name = "publish_at")
    public Long getPublishAt() {
        return publishAt;
    }

    public void setPublishAt(Long publishAt) {
        this.publishAt = publishAt;
    }
    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    @Column(name = "people")
    public Integer getPeople() {
        return people;
    }

    public void setPeople(Integer people) {
        this.people = people;
    }
    @Column(name = "salary")
    public String getSalary() {
        return salary;
    }

    public void setSalary(String salary) {
        this.salary = salary;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "cn_name")
    public String getCnName() {
        return CnName;
    }

    public void setCnName(String cnName) {
        CnName = cnName;
    }


    @Column(name = "qq")
    public String getQq() {
        return qq;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    @Column(name = "qq_url")
    public String getQqUrl() {
        return qqUrl;
    }

    public void setQqUrl(String qqUrl) {
        this.qqUrl = qqUrl;
    }

    @Column(name = "brief")
    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }
    
    
    
    @Column(name = "basis")
    public String getBasis() {
		return basis;
	}


	public void setBasis(String basis) {
		this.basis = basis;
	}


	@Column(name = "description")
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name = "threshold")
    public Integer getThreshold() {
        return threshold;
    }

    public void setThreshold(Integer threshold) {
        this.threshold = threshold;
    }

    @Column(name = "difficult")
    public Integer getDifficult() {
        return difficult;
    }

    public void setDifficult(Integer difficult) {
        this.difficult = difficult;
    }

    @Column(name = "cycle")
    public String getCycle() {
        return cycle;
    }

    public void setCycle(String cycle) {
        this.cycle = cycle;
    }

    @Column(name = "company")
    public Integer getCompany() {
        return company;
    }

    public void setCompany(Integer company) {
        this.company = company;
    }

 
    @Column(name = "skill_img")
    public String getSkillImg() {
        return skillImg;
    }

    public void setSkillImg(String skillImg) {
        this.skillImg = skillImg;
    }


    @Column(name = "img")
    public String getImg() {
        return img;
    }

    public void setImg(String img) {
        this.img = img;
    }
    
    
    
    
    @Column(name = "type")
    public String getType() {
		return type;
	}


	public void setType(String type) {
		this.type = type;
	}


	@Column(name = "online_grade_count")
    public Long getOnlineGradeCount() {
        return onlineGradeCount;
    }

    public void setOnlineGradeCount(Long onlineGradeCount) {
        this.onlineGradeCount = onlineGradeCount;
    }

    @Column(name = "offline_grade_count")
    public Long getOfflineGradeCount() {
        return offlineGradeCount;
    }

    public void setOfflineGradeCount(Long offlineGradeCount) {
        this.offlineGradeCount = offlineGradeCount;
    }

    @Column(name = "online_class_count")
    public Long getOnlineClassCount() {
        return onlineClassCount;
    }

    public void setOnlineClassCount(Long onlineClassCount) {
        this.onlineClassCount = onlineClassCount;
    }

    @Column(name = "offline_class_count")
    public Long getOfflineClassCount() {
        return offlineClassCount;
    }

    public void setOfflineClassCount(Long offlineClassCount) {
        this.offlineClassCount = offlineClassCount;
    }


    @Column(name = "class_count")
    public Long getClassCount() {
        return classCount;
    }


    public void setClassCount(Long classCount) {
        this.classCount = classCount;
    }

    @Column(name = "online_user_count")
    public Long getOnlineUserCount() {
        return onlineUserCount;
    }

    public void setOnlineUserCount(Long onlineUserCount) {
        this.onlineUserCount = onlineUserCount;
    }

    @Column(name = "offline_user_count")
    public Long getOfflineUserCount() {
        return offlineUserCount;
    }

    public void setOfflineUserCount(Long offlineUserCount) {
        this.offlineUserCount = offlineUserCount;
    }

    @Column(name = "core_user_count")
    public Long getCoreUserCount() {
        return coreUserCount;
    }

    public void setCoreUserCount(Long coreUserCount) {
        this.coreUserCount = coreUserCount;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

