package com.ptteng.common.skill.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "document")
public class Document implements Serializable , Comparable<Document>{

    /**
     *
     */
    private static final long serialVersionUID = 3998663945023772672L;


    /**
     * 文档
     */
	public static final int Type_Document = 1;
	/**
	 * 视频
	 */
	public static final int Type_Video = 2;


    private Long id;


    private Long sid;


    private Long oid;


    private Integer type;


    private String url;


    private Long love;


    private String introduce;


    private String resource;


    private Long author;


    private String documentName;


    private String img;


    private String writer;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "sid")
    public Long getSid() {
        return sid;
    }

    public void setSid(Long sid) {
        this.sid = sid;
    }


    @Column(name = "type")
    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "url")
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Column(name = "love")
    public Long getLove() {
        return love;
    }

    public void setLove(Long love) {
        this.love = love;
    }

    @Column(name = "introduce")
    public String getIntroduce() {
        return introduce;
    }


    public void setIntroduce(String introduce) {
        this.introduce = introduce;
    }

    @Column(name = "resource")
    public String getResource() {
        return resource;
    }


    public void setResource(String resource) {
        this.resource = resource;
    }

    @Column(name = "author")
    public Long getAuthor() {
        return author;
    }


    public void setAuthor(Long author) {
        this.author = author;
    }

    @Column(name = "document_name")
    public String getDocumentName() {
        return documentName;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }



    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }


    @Column(name = "oid")
    public Long getOid() {
        return oid;
    }

    public void setOid(Long oid) {
        this.oid = oid;
    }

    @Column(name = "img")
    public String getImg() {
        return img;
    }

    public void setImg(String img) {
        this.img = img;
    }

    @Column(name = "writer")
    public String getWriter() {
        return writer;
    }

    public void setWriter(String writer) {
        this.writer = writer;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public int compareTo(Document o) {
        Long time = o.getCreateAt();
        //对字段进行升序，如果欲降序可采用before方法
        if(this.getCreateAt()>time){
            return -1;
        }
        if(this.getCreateAt()<time){
            return 1;
        }
        return 0;

    }

}

