/**
 *
 */
package com.ptteng.sca.common.skill.client;

import java.util.List;
import java.util.Map;

import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.skill.model.UserDocumentRelation;
import com.ptteng.common.skill.service.UserDocumentRelationService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class UserDocumentRelationSCAClient implements UserDocumentRelationService {

    private UserDocumentRelationService userDocumentRelationService;

    public UserDocumentRelationService getUserDocumentRelationService() {
        return userDocumentRelationService;
    }


    public void setUserDocumentRelationService(UserDocumentRelationService userDocumentRelationService) {
        this.userDocumentRelationService = userDocumentRelationService;
    }


    @Override
    public Long insert(UserDocumentRelation userDocumentRelation) throws ServiceException, ServiceDaoException {

        return userDocumentRelationService.insert(userDocumentRelation);


    }


    @Override
    public List<UserDocumentRelation> insertList(List<UserDocumentRelation> userDocumentRelationList) throws ServiceException, ServiceDaoException {

        return userDocumentRelationService.insertList(userDocumentRelationList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return userDocumentRelationService.delete(id);


    }


    @Override
    public boolean update(UserDocumentRelation userDocumentRelation) throws ServiceException, ServiceDaoException {

        return userDocumentRelationService.update(userDocumentRelation);


    }


    @Override
    public boolean updateList(List<UserDocumentRelation> userDocumentRelationList) throws ServiceException, ServiceDaoException {

        return userDocumentRelationService.updateList(userDocumentRelationList);


    }


    @Override
    public UserDocumentRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return userDocumentRelationService.getObjectById(id);


    }


    @Override
    public List<UserDocumentRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return userDocumentRelationService.getObjectsByIds(ids);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserDocumentRelationIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return userDocumentRelationService.getUserDocumentRelationIdsByUid(uid, start, limit);


    }

    @Override
    public List<Long> getUserDocumentRelationIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return userDocumentRelationService.getUserDocumentRelationIdsByUidAndStatus(uid, status, start, limit);
    }

    @Override
    public List<Long> getUserDocumentRelationIdsByUidAndStatusAndWhether(Long uid, Integer type, Integer status, Integer whether, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return userDocumentRelationService.getUserDocumentRelationIdsByUidAndStatusAndWhether(uid, type, status, whether, start, limit);
    }

    /**
     * @param uid
     * @param status
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserDocumentRelationIdsByUidAndStatus(Long uid, Integer status) throws ServiceException, ServiceDaoException {
        return userDocumentRelationService.countUserDocumentRelationIdsByUidAndStatus(uid, status);
    }

    @Override
    public Integer countUserDocumentRelationIdsByUidAndStatusAndWhether(Long uid, Integer type, Integer status, Integer whether) throws ServiceException, ServiceDaoException {
        return userDocumentRelationService.countUserDocumentRelationIdsByUidAndStatusAndWhether(uid,type, status, whether);
    }

    @Override
    public List<Long> getUserDocumentRelationIdsByUidAndType(Long uid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return userDocumentRelationService.getUserDocumentRelationIdsByUidAndType(uid, type, start, limit);
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserDocumentRelationIdsByDocumentId(Long documentId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return userDocumentRelationService.getUserDocumentRelationIdsByDocumentId(documentId, start, limit);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getUserDocumentRelationIdByUidAndDocumentId(Long uid, Long documentId) throws ServiceException, ServiceDaoException {

        return userDocumentRelationService.getUserDocumentRelationIdByUidAndDocumentId(uid, documentId);


    }

    @Override
    public Long getUserDocumentRelationIdByUidAndDocumentIdAndStatus(Long uid, Long documentId, Integer status) throws ServiceException, ServiceDaoException {
        return userDocumentRelationService.getUserDocumentRelationIdByUidAndDocumentIdAndStatus(uid, documentId, status);
    }

    @Override
    public Long getUserDocumentRelationIdByUidAndDocumentIdAndStatusAndWhether(Long uid, Long documentId, Integer status, Integer whether) throws ServiceException, ServiceDaoException {
        return userDocumentRelationService.getUserDocumentRelationIdByUidAndDocumentIdAndStatusAndWhether(uid, documentId, status, whether);
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserDocumentRelationIdsByUid(Long uid) throws ServiceException, ServiceDaoException {

        return userDocumentRelationService.countUserDocumentRelationIdsByUid(uid);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserDocumentRelationIdsByDocumentId(Long documentId) throws ServiceException, ServiceDaoException {

        return userDocumentRelationService.countUserDocumentRelationIdsByDocumentId(documentId);


    }


    @Override
    public List<Long> getUserDocumentRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return userDocumentRelationService.getUserDocumentRelationIds(start, limit);
    }

    @Override
    public Integer countUserDocumentRelationIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return userDocumentRelationService.countUserDocumentRelationIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return userDocumentRelationService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return userDocumentRelationService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        userDocumentRelationService.deleteList(clz, ids);

    }


	@Override
	public Long getUserDocumentRelationIdByUidAndDidAndStatusAndWether(Long uid, Long documentId,Integer status,Integer wether)  {
		// TODO Auto-generated method stub
		return userDocumentRelationService.getUserDocumentRelationIdByUidAndDidAndStatusAndWether(uid, documentId,status,wether);
	}

   
}

