package com.ptteng.common.skill.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.UserClassRelation;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface UserClassRelationService extends BaseDaoService {


    public Long insert(UserClassRelation userClassRelation) throws ServiceException, ServiceDaoException;


    public List<UserClassRelation> insertList(List<UserClassRelation> userClassRelationList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(UserClassRelation userClassRelation) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<UserClassRelation> userClassRelationList) throws ServiceException, ServiceDaoException;


    public UserClassRelation getObjectById(Long id) throws ServiceException, ServiceDaoException;



    public List<UserClassRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long>  getUserClassRelationIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long  getUserClassRelationIdsByUidAndStatus(Long uid,Integer status)throws ServiceException, ServiceDaoException;


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer  countUserClassRelationIdsByUid(Long uid)throws ServiceException, ServiceDaoException;



    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long  getUserClassRelationIdByCidAndUid(Long cid,Long uid)throws ServiceException, ServiceDaoException;

    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long  getUserClassRelationIdByCidAndUidAndStatus(Long cid,Long uid,Integer status)throws ServiceException, ServiceDaoException;


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long>  getUserClassRelationIdByOidAndUid(Long oid,Long uid, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserClassRelationIdsByCid(Long cid) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserClassRelationIdsByCid(Long cid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;
    
    
    
    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserIdsByCid(Long cid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;
    

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserClassRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserClassRelationIds() throws ServiceException, ServiceDaoException;



    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Map<Long,Map<Long,Long>> getUidNumRelationListByCids(List<Long> cids, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Map<Long,Map<Long,String>> getUidSwearRelationListByCids(List<Long> cids, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

  
 	   
}

