package com.ptteng.common.skill.model;


import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "user")
public class User implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 3963145948088947712L;
    
    

    
    
    /**
     * 无当前所在班级
     */
    public static final Long Classes_None=-1L;
    
    
    /**
     * 无学号
     */
    public static final Integer Study_Number_None=-1;
    
    
    
    private Long id;


    private String nick;


    private String qq;


    private String mobile;


    private String pwd;


    private Long sex;


    private String thumb;


    private Integer isLook;


    private String sign;


    private Long birthday;


    private String school;


    private String province;


    private String city;
    
  
    private Long userTeacherId;
    
    private Integer status;
  
    
    private String oname;
   


	/**
     * 类型 0 :none, 无班级 1:online  散修班 ,2:outside  外门班 ,3:offline 内门班
     */
    private String type;
    
    
    /**
     * 学号，在用户表里冗余一份，方便查询
     */
    private Integer studyNumber;
    
    /**
     * 日报数量
     */
    private int dailyCount;
    
    /**
     * 最新的班级ID，为负代表着当前没有班级
     */
    private Long cid=User.Classes_None;
    
    
    /**
     * 最新的用户和班级关联表ID，为负代表着当前没有班级
     */
    private Long userClassID=User.Classes_None;

    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;

    private String cname;

    private Boolean isTeacher;
    
    private String teacher;

    private  Integer title;

    private  Long oid;

    @Column(name = "title")
    public Integer getTitle() {
        return title;
    }


    public void setTitle(Integer title) {
        this.title = title;
    }
    @Column(name = "user_teacher_id")
    public Long getUserTeacherId() {
        return userTeacherId;
    }


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "nick")
    public String getNick() {
        return nick;
    }


    public void setNick(String nick) {
        this.nick = nick;
    }

    @Column(name = "qq")
    public String getQq() {
        return qq;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }


    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "pwd")
    public String getPwd() {
        return pwd;
    }


    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    @Column(name = "sex")
    public Long getSex() {
        return sex;
    }


    public void setSex(Long sex) {
        this.sex = sex;
    }

    @Column(name = "thumb")
    public String getThumb() {
        return thumb;
    }


    public void setThumb(String thumb) {
        this.thumb = thumb;
    }

    @Column(name = "sign")
    public String getSign() {
        return sign;
    }


    public void setSign(String sign) {
        this.sign = sign;
    }

    @Column(name = "birthday")
    public Long getBirthday() {
        return birthday;
    }

    public void setBirthday(Long birthday) {
        this.birthday = birthday;
    }

    @Column(name = "school")
    public String getSchool() {
        return school;
    }

    public void setSchool(String school) {
        this.school = school;
    }

    @Column(name = "province")
    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    @Column(name = "city")
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }
    
    
    
    
    @Column(name = "type")
    public String getType() {
		return type;
	}


	public void setType(String type) {
		this.type = type;
	}

	@Column(name = "daily_count")
	public int getDailyCount() {
		return dailyCount;
	}


	public void setDailyCount(int dailyCount) {
		this.dailyCount = dailyCount;
	}
	
	
	


	@Column(name = "cid")
	public Long getCid() {
		return cid;
	}


	public void setCid(Long cid) {
		this.cid = cid;
	}
	
	
	
	

	@Column(name = "study_number")
	public Integer getStudyNumber() {
		return studyNumber;
	}

	public void setStudyNumber(Integer studyNumber) {
		this.studyNumber = studyNumber;
	}




	@Column(name = "user_class_id")
	public Long getUserClassID() {
		return userClassID;
	}


	

	public void setUserClassID(Long userClassID) {
		this.userClassID = userClassID;
	}


	@Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }



    @Column(name = "is_look")
    public Integer getIsLook() {
        return isLook;
    }

    public void setIsLook(Integer isLook) {
        this.isLook = isLook;
    }


	
	 @Column(name = "oid")
	public Long getOid() {
		return oid;
	}



	public void setOid(Long oid) {
		this.oid = oid;
	}


	 public void setUserTeacherId(Long userTeacherId) {
		this.userTeacherId = userTeacherId;
	}




	 @Column(name = "status")
	public Integer getStatus() {
		return status;
	}


	public void setStatus(Integer status) {
		this.status = status;
	}

	@Transient
	public String getOname() {
		return oname;
	}


	public void setOname(String oname) {
		this.oname = oname;
	}


	@Transient
	public String getCname() {
		return cname;
	}


	public void setCname(String cname) {
		this.cname = cname;
	}


	@Transient
	public Boolean getIsTeacher() {
		return isTeacher;
	}


	public void setIsTeacher(Boolean isTeacher) {
		this.isTeacher = isTeacher;
	}

	@Transient
	public String getTeacher() {
		return teacher;
	}


	public void setTeacher(String teacher) {
		this.teacher = teacher;
	}


	public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

