package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.util.DynamicUtil;
//import com.ptteng.util.OccuptionUtil;
import com.ptteng.util.SkillUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.json.GsonUtil;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

/**
 * Skill crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class SkillController {
	private static final Log log = LogFactory.getLog(SkillController.class);

	@Autowired
	private TaskService taskService;

	@Autowired
	private SkillService skillService;

	@Autowired
	private OccupationService occupationService;

	@Autowired
	private DocumentService documentService;

	@Autowired
	private TaskSkillRelationService taskSkillRelationService;

	@Autowired
	private UserDocumentRelationService userDocumentRelationService;

	/**
	 * @param
	 * @return
	 */
	// 1. 获取职业下的技能列表
	@RequestMapping(value = "/a/occupation/{oid}/skill", method = RequestMethod.GET)
	public String getSkillDetailByOccupationId(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long oid)
			throws Exception {

		// 校验
		if (oid == null) {
			log.info("the oid is null");
			model.addAttribute("code", -14008);
			return "/common/success";
		}
		Occupation occupation = occupationService.getObjectById(oid);
		if (occupation == null) {
			log.info("the Occupation is null");
			model.addAttribute("code", -14011);
			return "/common/success";
		}
		log.info("get Occupation, oid is  " + oid);

		try {
			List<Long> sidList = skillService.getIdsByOccupationId(oid, 0,
					Integer.MAX_VALUE);// 通过skill表中的occupation_id获取所有id
			List<Skill> skillList = skillService.getObjectsByIds(sidList); // 获取对应的Skill对象

			if (skillList == null) {
				log.info("skillList is null");
				model.addAttribute("code", -14001);
				return "/common/success";
			}

			model.addAttribute("code", 0);
			model.addAttribute("list", skillList);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get skill detail error, oid is  " + oid);
			model.addAttribute("code", -1);
		}

		return "/common-skill-service/skill/json/skillListByOccupationJson";
	}

	// 2. 新建技能
	@RequestMapping(value = "/a/u/skill", method = RequestMethod.POST)
	public String addSkill(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Skill skill)
			throws Exception {
		
		// 1-校验		parentId和occupationId不能为空
		Long parentId = skill.getParentId();
		Long occupationId = skill.getOccupationId();
		if (parentId == null) {
			log.info("the parentId is null");
			model.addAttribute("code", -14006);
			return "/common/success";
		}
		if (occupationId == null) {
			log.info("the occupationId is null");
			model.addAttribute("code", -14008);
			return "/common/success";
		}

		log.info("add skill : " + skill);

		// 2-更新技能
		try {
			Occupation occupation = occupationService.getObjectById(occupationId);
			if (occupation == null) {		//occupationId对应职业不存在
				log.info("the occupation is null");
				model.addAttribute("code", -14011);
				return "/common/success";
			}
			
			if (parentId <= 0L) {			// 父节点为根节点
				skill.setParentId(0L);		// 老大你的意思是当输入parentId为负时也允许，所以这只能加上这句
			} else {
				Skill parentSkill = skillService.getObjectById(parentId);
				if (parentSkill == null) {	// parentId对应结点不存在
					log.info("the parentSkill is null");
					model.addAttribute("code", -14010);
					return "/common/success";
				}
			}

			//更新父类价值
			Long parentSkillId = skill.getParentId();
			List<Skill> parentSkills = new ArrayList<>();
			while (!Skill.ROOT_SKILL.equals(parentSkillId)){
				log.info(" now parentSkillId = "+parentSkillId);
				Skill parentSkill = skillService.getObjectById(parentSkillId);
				BigDecimal parentSkillValue = parentSkill.getValue()==null?new BigDecimal("0"):parentSkill.getValue();
				log.info(" parentSkill old value = "+parentSkillValue);
				parentSkillValue = parentSkillValue.add(skill.getValue());
				log.info(" parentSkill new  value = "+parentSkillValue);

				parentSkill.setValue(parentSkillValue);
				log.info(" parentSkill new value = "+parentSkill.getValue());
				parentSkills.add(parentSkill);
				parentSkillId = parentSkill.getParentId();
			}
			if(CollectionUtils.isNotEmpty(parentSkills)){
				log.info(" parentSkills size = "+parentSkills.size());
				skillService.updateList(parentSkills);

			}
			Long sid = skillService.insert(skill);// 添加此Skill，获得此SKill的id

			if (sid == null) {
				log.info("add skill error");
				model.addAttribute("code", -1);
				return "/common/success";
			}
			
			log.info("insert skill, sid: " + sid);
			model.addAttribute("code", 0);
			model.addAttribute("id", sid);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add skill error ");
			model.addAttribute("code", -1);
		}

		return "/common/insert";
	}

	// 3. 交换技能顺序
	@RequestMapping(value = "/a/u/skill/switch/sort", method = RequestMethod.POST)
	public String switchSkillSort(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long firstID,
			Long secondID) throws Exception {

		// 校验
		if (firstID == null || secondID == null) {
			log.info("firstID or secondID is null");
			model.addAttribute("code", -14008);
			return "/common/success";
		}
		log.info("switch order of task " + firstID + " and " + secondID);
		Skill firstSkill = skillService.getObjectById(firstID);
		Skill secondSkill = skillService.getObjectById(secondID);
		if (firstSkill == null) {
			log.info("the first skill is null");
			model.addAttribute("code", -14000);
			return "/common/success";
		} else if (secondSkill == null) {
			log.info("the second skill is null");
			model.addAttribute("code", -14000);
			return "/common/success";
		}

		try {
			// 交换firstSkill和secondSkill的sort
			Integer temp = firstSkill.getSort();
			firstSkill.setSort(secondSkill.getSort());
			secondSkill.setSort(temp);

			boolean updateFirstSkill = skillService.update(firstSkill);		//更新firstSkill
			boolean updateSecondSkill = skillService.update(secondSkill);	//更新secondSkill
			
			if ( updateFirstSkill && updateSecondSkill ) {
				model.addAttribute("code", 0);
			} else {
				log.info("switch skill order error, updateFirstSkill: " + updateFirstSkill + ", updateSecondSkill: " + secondSkill);
				model.addAttribute("code", -1);
				return "/common/success";
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("switch skill order error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	// 4. 删除技能
	@RequestMapping(value = "/a/u/skill/{id}", method = RequestMethod.DELETE)
	public String deleteSkill(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		// 校验
		if (id == null) {
			log.info("id is null");
			model.addAttribute("code", -14009);
			return "/common/success";
		}
		Skill skill = skillService.getObjectById(id);
		if (skill == null) {
			log.info("skill of id " + id + " doesn't exist ");
			model.addAttribute("code", -14000);
			return "/common/success";
		}
		log.info("get skill, id is " + id);

		try {
			List<Long> taskSkillRelationIds = new ArrayList<Long> ();
			taskSkillRelationIds = taskSkillRelationService
					.getTaskSkillRelationIdsBySid(id, 0, Integer.MAX_VALUE);
			List<Long> documentIds = new ArrayList<Long> ();
			documentIds = documentService.getDocumentIdBySid(id);

			// 先删除task_skill_relation表中相应关系
			for(Long taskSkillRelationId : taskSkillRelationIds) {
				boolean deleteTaskSkillRelation = taskSkillRelationService.delete(taskSkillRelationId);
				if (!deleteTaskSkillRelation) {
					log.info("delete task_skill_relation error, relation id: " + taskSkillRelationId);
					model.addAttribute("code", -1);
					return "/common/success";
				}
			}
			
			// 删除技能对应文档和视频
			for(Long documentId : documentIds) {
				boolean deletedocument = documentService.delete(documentId);
				if(!deletedocument) {
					log.info("delete document error, document id: " + documentId);
					model.addAttribute("code", -1);
					return "/common/success";
				}
			}
			
			// 再删除对应Skill
			if (!(skillService.delete(id))) {
				log.info("delete skill error ");
				model.addAttribute("code", -1);
				return "/common/success";
			}
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete skill error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	// 5. 编辑技能
	@RequestMapping(value = "/a/u/skill/{id}", method = RequestMethod.PUT)
	public String ediSkill(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,
			@PathVariable Long id, Skill newSkill) throws Exception {
		// 为id所指技能进行编辑，当传入字段(name, content, priority, sort)为空时，该字段不更新，也就是只更新有实际参数传入的字段

		// 校验
		if (id == null) {
			log.info("id is null");
			model.addAttribute("code", -14009);
			return "/common/success";
		}
		Skill skill = skillService.getObjectById(id);
		if (skill == null) {
			log.info("skill of id " + id + " doesn't exist ");
			model.addAttribute("code", -14000);
			return "/common/success";
		}
		log.info("get skill, id is " + id);

		
		// 更新技能
		try {
			if(!StringUtils.isBlank(newSkill.getName()))
				skill.setName(newSkill.getName());
			if(!StringUtils.isBlank(newSkill.getContent()))
				skill.setContent(newSkill.getContent());
			if(newSkill.getPriority() != null && newSkill.getPriority() > 0)
				skill.setPriority(newSkill.getPriority());
			if(newSkill.getSort() != null && newSkill.getSort()  > 0)
				skill.setSort(newSkill.getSort() );
			List<Task> tasks = new ArrayList<>();

			BigDecimal oldValue = skill.getValue()==null?new BigDecimal("0"):skill.getValue();
			BigDecimal newValue = newSkill.getValue()==null?new BigDecimal("0"):newSkill.getValue();

			//更新相关任务的价值
			List<Long> taskSkillRelaitonIds = taskSkillRelationService.getTaskSkillRelationIdsBySid(id, 0, Integer.MAX_VALUE);
			if(CollectionUtils.isEmpty(taskSkillRelaitonIds)){
				log.info(" taskSkillRelaitonIds is empty ");
			}else {
				log.info(" taskSkillRelaitonIds size = "+taskSkillRelaitonIds.size());
				List<TaskSkillRelation> taskSkillRelations = taskSkillRelationService.getObjectsByIds(taskSkillRelaitonIds);
				List<Long> taskIds = new ArrayList<>();
				for(TaskSkillRelation taskSkillRelation : taskSkillRelations){
					taskIds.add(taskSkillRelation.getTid());
				}
				if(CollectionUtils.isEmpty(taskIds)){
					log.info("  taskIds is empty  ");
				}else {
					log.info(" taskIds is "+taskIds);
					tasks = taskService.getObjectsByIds(taskIds);
					for(Task task : tasks){
						log.info(" task old  value = "+task.getValue());
						task.setValue(task.getValue()==null?new BigDecimal("0"):task.getValue().subtract(oldValue));
						task.setValue(task.getValue()==null?new BigDecimal("0"):task.getValue().add(newValue));
						log.info(" task new value = "+task.getValue());
					}
				}

			}
			Long parentSkillId = skill.getParentId();

			//更新父类价值
				List<Skill> parentSkills = new ArrayList<>();
				while (!Skill.ROOT_SKILL.equals(parentSkillId)){
					log.info(" now parentSkillId = "+parentSkillId);
					Skill parentSkill = skillService.getObjectById(parentSkillId);
					BigDecimal parentSkillValue = parentSkill.getValue()==null?new BigDecimal("0"):parentSkill.getValue();
					log.info(" parentSkill old value = "+parentSkillValue);
					parentSkillValue = parentSkillValue .subtract(oldValue);
					log.info(" parentSkill 1 value = "+parentSkillValue);

					log.info("============= parentSkillValue = "+parentSkillValue);
					log.info("=========== newValue  "+newValue);


					parentSkillValue = parentSkillValue.add(newValue);
					log.info(" parentSkill 2 value = "+parentSkillValue);

					parentSkill.setValue(parentSkillValue);
					log.info(" parentSkill new value = "+parentSkill.getValue());
					parentSkills.add(parentSkill);
					parentSkillId = parentSkill.getParentId();
				}
			if(CollectionUtils.isNotEmpty(parentSkills)){
				log.info(" parentSkills size = "+parentSkills.size());
				skillService.updateList(parentSkills);

			}




			skill.setValue(newValue);

			if (!(skillService.update(skill))) {
				log.info("compile skill error");
				model.addAttribute("code", -1);
				return "/common/success";
			}
			taskService.updateList(tasks);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("compile skill error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}


	
	/**
	 * 此处直接取DB里的Token。获取Token由Python完成。之后由Crontab控制，每天更新一次。
	 * 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
    @RequestMapping(value = "/a/init/skill", method = RequestMethod.GET)
    public String initSkill(HttpServletRequest request, HttpServletResponse response, ModelMap model, String pwd ,Long endAt,Integer step ) throws ServiceException, ServiceDaoException {
        log.info(pwd + " will init user step is "+step+" and  endAt "+endAt );

       
        if("xdylxdyl".equals(pwd)){
        	
        	
        	Integer skillCounts=this.skillService.countSkillIds();
        	log.info(" all skillCounts is "+skillCounts);
        	int start=0;
        	if(step==null){
        		 step=200;
        	}
        	
        	while(start<=skillCounts){
        		Long batchStart=System.currentTimeMillis();
        		List<Long> sids=this.skillService.getSkillIds(start, step);
        		List<Skill> skills=this.skillService.getObjectsByIds(sids);
        		
        		for(Skill skill:skills){
        			Long startAt=System.currentTimeMillis();
        			Long skillID=skill.getId();
        			List<Long> documentIDS=this.documentService.getDocumentIdBySidAndType(skillID, Document.Type_Document, 0, Integer.MAX_VALUE);
        			skill.setDocumentCount(documentIDS.size());
        			
        			List<Long> videoIDS=this.documentService.getDocumentIdBySidAndType(skillID, Document.Type_Video, 0, Integer.MAX_VALUE);
        			skill.setVideoCount(videoIDS.size());
        			
        			this.skillService.update(skill);
        			log.info(skillID+" user time is "+(System.currentTimeMillis()-startAt));
    				
        		}
        		
        		start=start+step;
        		log.info(start +" ====================== is update ,step is ====================== "+step +" user time is "+(System.currentTimeMillis()-batchStart));
				
			}
        	
        	
        
        } else {
           
                model.addAttribute("code", -10000);
                return "/common/success";
           
        }
        model.addAttribute("code", 0);
     
        return "/common/success";

    }

	
}
