package com.ptteng.util;

import com.gemantic.common.util.StringUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * Created by liangxj on 2016/9/28.
 */
public class OccuptionUtil {

    private static final Log log = LogFactory.getLog(OccuptionUtil.class);

    public static Map<String,Object> getOccupationList(String name){
        Map<String,Object> params=new HashedMap();
        Long now = System.currentTimeMillis();

        Set<String> tables = new HashSet();
        tables.add("occupation");

        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("occupation.name & like", " '%" + name + "%'");
        }

        params.put("occupation.create_by", "manager.id");
        tables.add("manager");

        params.put("@order", "  occupation.update_at desc ");
        params.put("@query", " occupation.id");
        String table = convertTable(tables);
        params.put("@table", table);

        return params;
    }
    public static String convertTable(Set<String> tables) {
        StringBuffer tableBuffer = new StringBuffer();
        int index = 0;
        Iterator var4 = tables.iterator();

        while(var4.hasNext()) {
            String table = (String)var4.next();
            ++index;
            tableBuffer = tableBuffer.append(table);
            if(index < tables.size()) {
                tableBuffer = tableBuffer.append(",");
            }
        }

        return tableBuffer.toString();
    }
}
