package com.ptteng.controller;

import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.common.skill.model.Document;
import com.ptteng.common.skill.model.Manager;
import com.ptteng.common.skill.model.School;
import com.ptteng.common.skill.service.ManagerService;
import com.ptteng.common.skill.service.SchoolService;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import com.sleepycat.je.tree.IN;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import com.ptteng.common.skill.model.Contents;
import com.ptteng.common.skill.service.ContentsService;

/**
 * Contents  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ContentsController {
    private static final Log log = LogFactory.getLog(ContentsController.class);

    @Autowired
    private ContentsService contentsService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private ManagerService managerService;

    @Autowired
    private SchoolService schoolService;

    /**
     * 获取单个内容信息
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/contents/{id}", method = RequestMethod.GET)
    public String getContents(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        if (id.equals(null)) {
            model.addAttribute("code", -37003);
            log.info("id is null");
            return "/common/success";
        }

        log.info("get  content : content id = " + id);

        try {

            Contents contents = contentsService.getObjectById(id);

            if (contents == null) {
                model.addAttribute("code", -37002);
                log.info("no this contents");
                return "/common/success";
            } else {
                log.info("get contents data is " + contents);

                //返回学校相关信息
                if (contents.getType() == Contents.Content_Type_School
                        && contents.getSubType() == Contents.Content_Subtype_Pic) {
                    Long schoolId = Long.parseLong(contents.getAuthor());
                    School school = schoolService.getObjectById(schoolId);
                    model.addAttribute("school", school);
                }

                model.addAttribute("contents", contents);
                model.addAttribute("code", 0);
            }


        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get contents error, id is " + id);
            model.addAttribute("code", -37001);
        }


        return "/common-skill-service/contents/json/contentsDetailJson";
    }


    /**
     * 修改内容
     *
     * @param request
     * @param response
     * @param model
     * @param id：记录id
     * @param contents ：内容数据
     * @return
     */
    @RequestMapping(value = "/a/u/contents/{id}", method = RequestMethod.PUT)
    public String updateContentsJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, Contents contents, @PathVariable Long id)
            throws Exception {

        log.info("update contents : contents= " + contents);


        if (contents == null || contents.getId() == null || contents.getType() == null || contents.getStatus() == null) {
            model.addAttribute("code", -37002);
            log.info("id/type/status is null, id: " + id);
            return "/data/json";
        } else {
            log.info("contents params is ok, id: " + id);
        }

        Contents orignContent = contentsService.getObjectById(id);
        if (orignContent == null) {
            model.addAttribute("code", -37001);
            log.info(id + " contents is null");
            return "/data/json";
        } else {
            log.info("contents " + id + " is ready");
        }


        String userId = cookieUtil.getKeyIdentity(request,
                CookieUtil.USER_ID);

        contents.setCreateAt(orignContent.getCreateAt());
        contents.setCreateBy(orignContent.getCreateBy());
        contents.setUpdateBy(Long.parseLong(userId));
        contents.setPublishAt(System.currentTimeMillis());

        try {

            boolean result = contentsService.update(contents);
            if (result) {
                log.info(id + " contents update success");
            } else {
                log.info(id + " contents update fail");
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update contents error,id is  " + contents.getId());
            model.addAttribute("code", -25001);
        }


        model.addAttribute("code", 0);
        model.addAttribute("contents", contents);

        return "/data/json";
    }


    /**
     * 新增内容
     *
     * @param request
     * @param response
     * @param model
     * @param contents ：内容数据
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/contents", method = RequestMethod.POST)
    public String addContentsJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, Contents contents) throws Exception {

        log.info("update contents : contents= " + contents);


        contents.setId(null);

        String userId = cookieUtil.getKeyIdentity(request,
                CookieUtil.USER_ID);
        /*
         * 新增默认不置顶
         * */
        contents.setIsTop(Contents.Not_Top);
        contents.setCreateAt(System.currentTimeMillis());
        contents.setCreateBy(Long.parseLong(userId));
        contents.setUpdateBy(Long.parseLong(userId));
        contents.setPublishAt(System.currentTimeMillis());

        try {
            //新增校园图片时，必须传author，代表校园id
            if (contents.getType() == Contents.Content_Type_School
                    && contents.getSubType() == Contents.Content_Subtype_Pic
                    && DataUtils.isNullOrEmpty(contents.getAuthor())) {
                model.addAttribute("code", -60024);
            } else {
                Long result = contentsService.insert(contents);
                log.info(result);
                model.addAttribute("code", 0);
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update contents error ");
            model.addAttribute("code", -25004);
        }

        return "/data/json";
    }

    /**
     * 删除内容
     *
     * @param request
     * @param response
     * @param model
     * @param id       ：记录id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/contents/{id}", method = RequestMethod.DELETE)
    public String deleteContentsJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete contents : id= " + id);
        try {
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            Long adminId = Long.parseLong(userId);
            Manager manager = managerService.getObjectById(adminId);

            Contents contents = contentsService.getObjectById(id);
            //记录操作人，日志里就能查到是谁删除的
            contents.setUpdateBy(manager.getId());
            contentsService.delete(id);

            log.info("add contents success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete contents error,id is  " + id);
            model.addAttribute("code", -25005);

        }

        return "/data/json";
    }

    /**
     * 上下架
     *
     * @param request
     * @param response
     * @param model
     * @param id       ：记录id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/contents/{id}/status/{status}", method = RequestMethod.PUT)
    public String updateContentsStatus(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                       @PathVariable Long id, @PathVariable Integer status)
            throws Exception {

        log.info("content id is: " + id + ", status is: " + status);

        if (id == null) {
            model.addAttribute("code", -37002);
            return "/data/json";
        }
        if (status == null) {
            model.addAttribute("code", -37002);
            return "/data/json";
        }
        if (status != 1 && status != 0) {
            model.addAttribute("code", -37006);
            return "/data/json";
        }

        try {
            Contents content = contentsService.getObjectById(id);
            log.info("content==" + content);

            if (content != null) {
                if (content.getStatus() == status.intValue()) {
                    log.info("content status is equal, no need update status: " + status);
                } else {
                    //校园banner最多只能上架8个
                    int type = content.getType();
                    int subType = content.getSubType();
                    if (status.intValue() == Contents.Status_Online
                            && type == Contents.Content_Type_School
                            && subType == Contents.Content_Subtype_Banner) {
                        Integer[] contentsType = {Contents.Content_Type_School};
                        Map<String, Object> schoolBannerCountParam = DynamicUtil.getContentsQueryListParam(contentsType,
                                Contents.Content_Subtype_Banner, Contents.Status_Online, null, null,
                                null, null, null, null, null,
                                null, false);
                        List<Long> ids = contentsService.getIdsByDynamicCondition(Contents.class, schoolBannerCountParam,
                                0, Integer.MAX_VALUE);
                        if (ids.size() >= Contents.Max_School_Banner_Count) {
                            model.addAttribute("code", -60026);
                            return "/data/json";
                        }
                    }


                    String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
                    content.setStatus(status);
                    content.setUpdateAt(System.currentTimeMillis());
                    content.setUpdateBy(Long.parseLong(userId));
                    content.setPublishAt(System.currentTimeMillis());

                    contentsService.update(content);
                    model.addAttribute("code", 0);
                }
            } else {
                model.addAttribute("code", -37008);
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update contents status error, id is  " + id);
            model.addAttribute("code", -25001);
        }

        return "/data/json";
    }

    /**
     * 置顶
     *
     * @param request
     * @param response
     * @param model
     * @param id       ：记录id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/contents/{id}/top/{top}", method = RequestMethod.PUT)
    public String updateContentsTop(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                    @PathVariable Long id, @PathVariable Integer top) throws Exception {

        log.info("content id is: " + id + ", top is: " + top);

        if (id == null) {
            model.addAttribute("code", -37002);
            return "/data/json";
        }
        if (top == null) {
            model.addAttribute("code", -37002);
            return "/data/json";
        }
        if (top != Contents.Is_Top && top != Contents.Not_Top) {
            model.addAttribute("code", -37010);
            return "/data/json";
        }

        try {
            Contents content = contentsService.getObjectById(id);
            log.info("content==" + content);

            if (content != null) {
                if (content.getIsTop() != null && (content.getIsTop() == top.intValue())) {
                    log.info("content top is equal, no need update top: " + top);
                    model.addAttribute("code", -37011);
                } else {
                    String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
                    content.setIsTop(top);
                    content.setUpdateAt(System.currentTimeMillis());
                    content.setUpdateBy(Long.parseLong(userId));
                    content.setPublishAt(System.currentTimeMillis());

                    contentsService.update(content);
                    model.addAttribute("code", 0);
                }
            } else {
                model.addAttribute("code", -37008);
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update contents top error, id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/data/json";
    }

    /**
     * 内容搜索
     *
     * @param request
     * @param response
     * @param model
     * @param type
     * @param title
     * @param status
     * @param createBy
     * @param createStartAt
     * @param createEndAt
     * @param publishStartAt
     * @param publishEndAt
     * @param page
     * @param size
     * @return
     */
    @RequestMapping(value = "/a/u/contents/search", method = RequestMethod.GET)
    public String searchContents(HttpServletRequest request,
                                 HttpServletResponse response,
                                 ModelMap model,
                                 Integer[] type,
                                 Integer subType,
                                 Integer status,
                                 String title,
                                 String schoolName,
                                 //当type=20,subType=1(校园图片)时，author代表校园id
                                 String author,
                                 Long createBy,
                                 Long createStartAt,
                                 Long createEndAt,
                                 Long publishStartAt,
                                 Long publishEndAt,
                                 Integer page,
                                 Integer size
    ) {
        /* 1 初始化参数 */
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        log.info("pageList : start= " + start + " , size=" + size);
        try {

            Map<String, Object> param = DynamicUtil.getContentsQueryListParam(type, subType, status, title, schoolName,
                    author, createBy, createStartAt, createEndAt, publishStartAt, publishEndAt, false);
            log.info("contents params is: " + param);
            List<Long> ids = contentsService.getIdsByDynamicCondition(Contents.class, param, start, size);
            log.info("the ids is " + ids.size());

            List<Contents> contentsList = new ArrayList<>();
            List<School> schoolList = new ArrayList<>();
            Integer total = 0;
            if (CollectionUtils.isNotEmpty(ids)) {
                contentsList = contentsService.getObjectsByIds(ids);
                log.info("get contents data is " + contentsList.size());

                List<Long> schoolIdList = new ArrayList<>();


                //获取校园图片列表时，要返回对应的校园名称
                if (DataUtils.isNotNullOrEmpty(type)
                        && Arrays.asList(type).contains(Contents.Content_Type_School)
                        && DataUtils.isNotNullOrEmpty(subType)
                        && subType.intValue() == Contents.Content_Subtype_Pic) {
                    log.info("here===");
                    for (int i = 0; i < contentsList.size(); i++) {
                        schoolIdList.add(Long.parseLong(contentsList.get(i).getAuthor()));
                    }
                    schoolList = schoolService.getObjectsByIds(schoolIdList);
                }
                log.info("schoolList===" + schoolList.size());


                // get total
                Map<String, Object> paramCount = DynamicUtil.getContentsQueryListParam(type, subType, status, title, schoolName, author, createBy, createStartAt, createEndAt, publishStartAt, publishEndAt, true);
                log.info("count content sql: " + paramCount);
                List<Long> totalList = contentsService.getIdsByDynamicCondition(Contents.class, paramCount, 0, Integer.MAX_VALUE);
                log.info("count contents list: " + totalList);
                total = totalList.get(0).intValue();
                log.info("get contents size is " + total);
            }


            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("contentsList", contentsList);
            model.addAttribute("schoolList", schoolList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get contentsList error");
            model.addAttribute("code", -25001);
        }

        return "/common-skill-service/contents/json/contentsListJson";
    }


    @RequestMapping(value = "/a/u/contents/sort", method = RequestMethod.PUT)
    public String sortContents(HttpServletRequest request,
                               HttpServletResponse response,
                               ModelMap model,
                               @RequestParam(value = "ids[]") Long[] ids) throws Exception {

        if (ids == null) {
            log.info("sort contents ids is null");
            model.addAttribute("code", -25003);
            return "/data/json";
        } else {
            log.info("sort contents : ids= " + ids);
        }

        List<Long> idList = new ArrayList();
        idList = Arrays.asList(ids);

        try {

            List<Contents> contents = this.contentsService.getObjectsByIds(idList);

            int index = 0;
            for (Contents content : contents) {
                content.setLevel(index);
                index = index + 10;
            }
            this.contentsService.updateList(contents);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("sort contents error,ids is  " + ids);
            model.addAttribute("code", -25007);
        }

        return "/data/json";
    }


}

