package com.ptteng.controller;

import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.ConstantService;
import com.ptteng.common.skill.service.TeacherService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * Teacher  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class TeacherController {
	private static final Log log = LogFactory.getLog(TeacherController.class);

	@Autowired
	private TeacherService teacherService;

	@Autowired
	private UserService userService;


	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private ConstantService constantService;



	// 4.获取师兄列表
	@RequestMapping(value = "/a/u/teacher/list", method = RequestMethod.GET)
	public String getTeacherList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
							 Long oid, Integer status) throws Exception {

		log.info(" get teacher list by oid:" + oid + " status:" + status);

		if (oid == null) {
			model.addAttribute("code", -10091);
			model.addAttribute("message", "职业信息缺失");
			return "/common/failure";
		}

		try {

			Map<String, Object> paramList = DynamicUtil.getTeacherListParam(oid, status, false);
			log.info("get param:" + paramList);
			List<Long> userIds = this.userService.getIdsByDynamicCondition(User.class, paramList, 0, Integer.MAX_VALUE);
			log.info("get userIds:" + userIds);

			List<User> teacherInfoList = this.userService.getObjectsByIds(userIds);
			log.info("get teacherInfoList:" + teacherInfoList.size());

			model.addAttribute("code", 0);
			model.addAttribute("teachers", teacherInfoList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error(" get user error ");
			model.addAttribute("code", -1);
		}

		return "/common-skill-service/teacher/json/teacherListJson";
	}

}

