package com.ptteng.controller;

import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.qding.common.util.http.cookie.CookieUtil;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Skill  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class TaskController {
    private static final Log log = LogFactory.getLog(TaskController.class);

    @Autowired
    private SkillService skillService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private TaskSkillRelationService taskSkillRelationService;

    @Autowired
    private UserDocumentRelationService userDocumentRelationService;
    
    
    
    
    @RequestMapping(value = "/a/task/{id}", method = RequestMethod.GET)
	public String getMultiOccupationTypeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,@PathVariable Long id)
			throws Exception {
			
	
		
	   if (id == null) {

		     log.info("task id cannot be null ");
		    
			model.addAttribute("code", -9000);
			return "/common/success";
		} else {
			
		}
		try {

			List<Skill> skills=new ArrayList();
			

			Task task=this.taskService.getObjectById(id);
			if(task==null){
				
				log.info(id+" get task is null ");
				   model.addAttribute("code",-4008);
	               return "/common/success";
			}else{
				Long taskID=task.getId();
				List<Long> skillIDS=this.taskSkillRelationService.getSkillIdsByTid(taskID, 0, Integer.MAX_VALUE);
				if(CollectionUtils.isEmpty(skillIDS)){
					log.info(taskID+" not get any skill  ids ");
				}else{
					log.info(taskID+" not get  skill  ids size is "+skillIDS.size());
					skills=this.skillService.getObjectsByIds(skillIDS);
					
				}
				
				
				
				model.addAttribute("code", 0);
				model.addAttribute("task", task);
				model.addAttribute("skills", skills);
				
				
			}

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get task error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/task/json/taskDetailJson";
	}
    
    


    


    //38、新增任务
    @RequestMapping(value = "/a/u/task", method = RequestMethod.POST)
    public String addTask(HttpServletRequest request,
                           HttpServletResponse response, ModelMap model,   String skill,Task task) throws Exception {

       log.info(task+" skill is "+skill);

        try {
        	
        
        	// 1. 校验
        	Long oid=task.getOid();
        	if(oid==null){
        		  log.info("the oid is null");
                  model.addAttribute("code", -9007);
                  return "/common/success";
        	}else{
        		
        	}
            Occupation occupation = occupationService.getObjectById(oid);

            if(occupation==null){
                log.info("the occupation is null");
                model.addAttribute("code", -9005);
                return "/common/success";
            }else{
            	
            }
            //计算任务价值
            BigDecimal taskValue = new BigDecimal("0");
            if(StringUtils.isNotEmpty(skill)){
                String[] ids=skill.split(",");
                List<Long> idList = new ArrayList<>();
                for(String skillId : ids){
                    idList.add(Long.valueOf(skillId));
                }
                List<Skill> skills =  skillService.getObjectsByIds(idList);
                for (Skill skill1 : skills){
                    taskValue = taskValue.add(skill1.getValue()==null?new BigDecimal("0"):skill1.getValue());
                }
            }

            Manager manager = (Manager)request.getAttribute("manager");

            //2.更新任务
            Long tid=null;
            if (null != task){
                task.setValue(taskValue);
                //记录创建者相关信息
                task.setCreateBy(manager.getId());

                 tid=taskService.insert(task);
                log.info(tid+" insert success  ");
            }else{
            	  log.info("task is null");
                  model.addAttribute("code", -9006);
                  return "/common/success";
            }
            
            
            
            // 3 更新技能
          
            if(StringUtils.isBlank(skill)){
            	
            }else{
            	List<TaskSkillRelation> relations=new ArrayList();
            	String[] ids=skill.split(",");
            	for(String id:ids){
            		TaskSkillRelation relation=new TaskSkillRelation();
            		relation.setOid(oid);
            		relation.setSid(Long.valueOf(id));
            		relation.setTid(tid);
            		relations.add(relation);
            	}
            	this.taskSkillRelationService.insertList(relations) ;
                log.info(tid+" insert relations "+oid+" size is "+relations.size());	
            }

            model.addAttribute("code", 0);
            model.addAttribute("id", tid);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add skill error ");
            model.addAttribute("code", -1);
        }

        return "/common/insert";
    }

    //38、删除任务
    @RequestMapping(value = "/a/u/task/{tid}", method = RequestMethod.DELETE)
    public String addSkill(HttpServletRequest request,
                           HttpServletResponse response, ModelMap model, @PathVariable Long tid) throws Exception {

        log.info("add task : tid = " + tid);

        Manager manager = (Manager)request.getAttribute("manager");

        try {
        	
        	
        	if(tid==null){
        		 log.info("tid is null");
                 model.addAttribute("code", -9007);
                 return "/common/success";
        		
        	}else{
        		
        	}
        	
        	List<Long> relationIDS=this.taskSkillRelationService.getTaskSkillRelationIdsByTid(tid, 0, Integer.MAX_VALUE);
        	this.taskSkillRelationService.deleteList(TaskSkillRelation.class, relationIDS);
        	log.info(tid+" delete skill relation ids is "+relationIDS);
        	
            Task task = taskService.getObjectById(tid);

            if(task==null){
                log.info("the task is null");
                
            }else{
                //记录操作人
                task.setUpdateBy(manager.getId());
            	  taskService.delete(tid);
            	  log.info(tid+" delete success ");
            }

          

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add skill error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    //38、修改任务
    @RequestMapping(value = "/a/u/task/{tid}", method = RequestMethod.PUT)
    public String updateSkill(HttpServletRequest request,
                           HttpServletResponse response, ModelMap model, @PathVariable Long tid, String skill,Task task) throws Exception {

        log.info(task+" will be update,and skill is "+skill);

        Manager manager = (Manager)request.getAttribute("manager");
         try {
         	
         
         	// 1. 校验
         	 Long oid=task.getOid();
             Occupation occupation = occupationService.getObjectById(oid);

             if(occupation.equals(null)){
                 log.info("the occupation is null");
                 model.addAttribute("code", -9005);
                 return "/common/success";
             }
             //计算任务价值
             BigDecimal taskValue = new BigDecimal("0");
             if(StringUtils.isNotEmpty(skill)){
                 String[] ids=skill.split(",");
                 List<Long> idList = new ArrayList<>();
                 for(String skillId : ids){
                     idList.add(Long.valueOf(skillId));
                 }
                 log.info(" skill idList = "+idList);
                 List<Skill> skills =  skillService.getObjectsByIds(idList);
                 for (Skill skill1 : skills){
                     taskValue = taskValue.add(skill1.getValue()==null?new BigDecimal("0"):skill1.getValue());
                 }
                 log.info(" taskValue = "+taskValue);
             }
             //2.更新任务
             
             if (null != task){
                 task.setValue(taskValue);
                 //记录操作人
                 task.setUpdateBy(manager.getId());

                 boolean result=taskService.update(task);
                  
                 log.info(tid+" insert result  "+result);
             }else{
             	  log.info("task is null");
                   model.addAttribute("code", -9006);
                   return "/common/success";
             }
             
             
             
             // 3 更新技能
           
             List<Long> oldRelationIDS=this.taskSkillRelationService.getTaskSkillRelationIdsByTid(tid, 0, Integer.MAX_VALUE);
             if(CollectionUtils.isEmpty(oldRelationIDS)){
            	 oldRelationIDS=new ArrayList();
             }else{
                 this.taskSkillRelationService.deleteList(TaskSkillRelation.class, oldRelationIDS);
             }
      
             log.info(tid+" delete old relatoin ids "+oldRelationIDS+" success ");
             
             if(StringUtils.isBlank(skill)){
             	
             }else{
            	 
            	 
             	List<TaskSkillRelation> relations=new ArrayList();
             	String[] ids=skill.split(",");
             	for(String id:ids){
             		TaskSkillRelation relation=new TaskSkillRelation();
             		relation.setOid(oid);
             		relation.setSid(Long.valueOf(id));
             		relation.setTid(tid);
             		relations.add(relation);
             	}
             	this.taskSkillRelationService.insertList(relations) ;
                 log.info(tid+" insert relations "+oid+" size is "+relations.size());	
             }

             model.addAttribute("code", 0);

         } catch (Throwable t) {
             t.printStackTrace();
             log.error(t.getMessage());
             log.error("add skill error ");
             model.addAttribute("code", -1);
         }

         return "/common/success";
     }

}

