package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.common.skill.model.BranchInstitute;
import com.ptteng.common.skill.model.Manager;
import com.ptteng.common.skill.model.Stage;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.BranchInstituteService;
import com.ptteng.common.skill.service.ManagerService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * BranchInstitute  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class BranchInstituteController {
    private static final Log log = LogFactory.getLog(BranchInstituteController.class);

    @Autowired
    private BranchInstituteService branchInstituteService;
    @Autowired
    private UserService userService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private ManagerService managerService;

    //分院列表拖动排序
    @RequestMapping(value = "/a/u/branch/sort", method = RequestMethod.POST)
    public String sortStage(HttpServletRequest request,
                            HttpServletResponse response, ModelMap model, @RequestBody List<Long> ids)
            throws Exception{
        log.info("sort branch:ids="+ids);
        try {
            List<BranchInstitute> branches = this.branchInstituteService.getObjectsByIds(ids);
            int index = 0;
            for (BranchInstitute branch:branches){
                branch.setSort(index);
                index = index +10;
            }
            this.branchInstituteService.updateList(branches);
            model.addAttribute("code",0);
        }catch (Throwable t){
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("order branches error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    //获取分院列表数据长度
    private Integer getBranchSize() throws ServiceException, ServiceDaoException {
        Map<String, Object> param = DynamicUtil.getSingleFieldParam(
                "sort desc", "branch_institute");
        List<Long> sizes = this.branchInstituteService.getIdsByDynamicCondition(
                BranchInstitute.class, param, 0, Integer.MAX_VALUE);
        int size = 0;
        if (org.apache.commons.collections.CollectionUtils.isEmpty(sizes)) {
            log.info("first order ");

        } else {
            Long sizeId = sizes.get(0);
            BranchInstitute branch = this.branchInstituteService.getObjectById(sizeId);

            size =branch.getSort().intValue();
            log.info("quiz size order is" + size);
        }
        return size+3;
    }

    //获取分院详情
    @RequestMapping(value = "/a/u/branchInstitute/{id}", method = RequestMethod.GET)
    public String getBranchInstituteJson(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            BranchInstitute branchInstitute = branchInstituteService.getObjectById(id);
            log.info("get branchInstitute data is " + branchInstitute);
            if (branchInstitute == null) {
                model.addAttribute("code", -18007);
                return "/common/success";
            }

            User user = new User();
            Long uid = branchInstitute.getUid();

            user = this.userService.getObjectById(uid);


            model.addAttribute("code", 0);

            model.addAttribute("branchInstitute", branchInstitute);
            model.addAttribute("user", user);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get branchInstitute error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/branchInstitute/json/branchInstituteDetailJson";
    }

    //修改分院信息
    @RequestMapping(value = "/a/u/branchInstitute/{id}", method = RequestMethod.PUT)
    public String updateBranchInstituteJson(HttpServletRequest request,
                                            HttpServletResponse response, @PathVariable Long id, ModelMap model, String name, Long uid,
                                            String qq, Integer period, String phone, String url, String address, Integer status,Integer teacher, String occupation, String fee) throws Exception {

        BranchInstitute branchInstitute = branchInstituteService.getObjectById(id);
        log.info("update branchInstitute : branchInstitute= " + branchInstitute);

        //获取后台管理者信息

        String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
        Long adminId = Long.parseLong(userId);
        Manager manager = managerService.getObjectById(adminId);
        try {

            log.info("update the branch to start :");

            log.info("check name =>>");
            if (StringUtil.isEmpty(name)) {
                log.info("name is null");
                model.addAttribute("code", -18000);
                return "/common/success";
            }
            log.info("name is " + name);

            log.info("check uid =>>");
            if (DataUtils.isNullOrEmpty(uid)) {
                log.info("uid is null");
                model.addAttribute("code", -18003);
                return "/common/success";
            }

            log.info("check user =>>");
            User user = this.userService.getObjectById(uid);
            if (user == null) {
                log.info("user is null");
                model.addAttribute("code", -15000);
                return "/common/success";
            }
            log.info("uid is " + uid);

            log.info("check qq =>>");
            if (StringUtil.isEmpty(qq)) {
                log.info("qq is null");
                model.addAttribute("code", -18004);
                return "/common/success";
            }
            log.info("qq is " + qq);

            log.info("check period =>>");
            if (period == null) {
                log.info("period is null");
                model.addAttribute("code",-18008);
                return "/common/success";
            }
            log.info("period is " + period);

            log.info("check phone");
            if (StringUtil.isEmpty(phone)) {
                log.info("phone is null");
                model.addAttribute("code", -18002);
                return "/common/success";
            }
            log.info("phone is " + phone);

            log.info("check url");
            if (StringUtil.isEmpty(url)) {
                log.info("url is null");
                model.addAttribute("code", -18006);
                return "/common/success";
            }
            log.info("url is " + url);

            log.info("check address");
            if (StringUtil.isEmpty(address)) {
                log.info("address is null");
                model.addAttribute("code", -18005);
                return "/common/success";
            }
            log.info("address is " + address);

            log.info("check status");
            if (status == null) {
                log.info("status is null and add ");
                model.addAttribute("code",-18009);
                return "/common/success";
            }
            log.info("status is " + status);

            if (teacher == null) {
                log.info("teacher is null and add ");
                model.addAttribute("code",-18011);
                return "/common/success";
            }
            log.info("teacher is " + teacher);

            branchInstitute.setId(id);
            branchInstitute.setUid(uid);
            branchInstitute.setPhone(phone);
            branchInstitute.setPeriod(period);
            branchInstitute.setQq(qq);
            branchInstitute.setAddress(address);
            branchInstitute.setName(name);
            branchInstitute.setStatus(status);
            branchInstitute.setTeacher(teacher);
            branchInstitute.setUrl(url);

            //记录操作人
            branchInstitute.setUpdateBy(manager.getId());

            if (occupation != null) {
                log.info("~~~~~~~ branch occupation is " + occupation);
                branchInstitute.setOccupation(occupation);
            }
            if (fee != null) {
                log.info("~~~~~~~ branch fee is " + fee);
                branchInstitute.setFee(fee);
            }
            log.info("~~~~~~~~ branch updated is " + branchInstitute);

            branchInstituteService.update(branchInstitute);
            model.addAttribute("code", 0);

            model.addAttribute("branchInstitute", branchInstitute);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update branchInstitute error,id is  " + branchInstitute.getId());
            model.addAttribute("code", -6003);

        }

        return "/common/success";
    }


    //新增分院
    @RequestMapping(value = "/a/u/branchInstitute", method = RequestMethod.POST)
    public String addBranchInstituteJson(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, BranchInstitute branchInstitute, String name, Long uid,
                                         String qq, Integer period, String phone, String url, String address, Integer status, Integer teacher,String occupation, String fee) throws Exception {

        log.info("update branchInstitute : branchInstitute= " + branchInstitute);


        //获取后台管理者信息
        String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
        Long adminId = Long.parseLong(userId);
        Manager manager = managerService.getObjectById(adminId);
        try {
            log.info("add the branch to start :");

            log.info("check name =>>");
            if (StringUtil.isEmpty(name)) {
                log.info("name is null");
                model.addAttribute("code", -18000);
                return "/common/success";
            }
            log.info("name is " + name);

            log.info("check uid =>>");
            if (DataUtils.isNullOrEmpty(uid)) {
                log.info("uid is null");
                model.addAttribute("code", -18003);
                return "/common/success";
            }

            log.info("check user =>>");
            User user = this.userService.getObjectById(uid);
            if (user == null) {
                log.info("user is null");
                model.addAttribute("code", -15000);
                return "/common/success";
            }
            log.info("uid is " + uid);

            log.info("check qq =>>");
            if (StringUtil.isEmpty(qq)) {
                log.info("qq is null");
                model.addAttribute("code", -18004);
                return "/common/success";
            }
            log.info("qq is " + qq);

            log.info("check period =>>");
            if (period == null) {
                log.info("period is null");
                model.addAttribute("code",-18008);
                return "/common/success";
            }
            log.info("period is " + period);

            log.info("check phone");
            if (StringUtil.isEmpty(phone)) {
                log.info("phone is null");
                model.addAttribute("code", -18002);
                return "/common/success";
            }
            log.info("phone is " + phone);

            log.info("check url");
            if (StringUtil.isEmpty(url)) {
                log.info("url is null");
                model.addAttribute("code", -18006);
                return "/common/success";
            }
            log.info("url is " + url);

            log.info("check address");
            if (StringUtil.isEmpty(address)) {
                log.info("address is null");
                model.addAttribute("code", -18005);
                return "/common/success";
            }
            log.info("address is " + address);

            log.info("check status");
            if (status == null) {
                log.info("status is null and add ");
                model.addAttribute("code",-18009);
                return "/common/success";
            }
            log.info("status is " + status);

            if (teacher == null) {
                log.info("teacher is null and add ");
                model.addAttribute("code",-18011);
                return "/common/success";
            }
            log.info("teacher is " + teacher);

            int size = this.getBranchSize();

            branchInstitute.setSort(size);

            branchInstitute.setUid(uid);
            branchInstitute.setPhone(phone);
            branchInstitute.setPeriod(period);
            branchInstitute.setQq(qq);
            branchInstitute.setAddress(address);
            branchInstitute.setName(name);
            branchInstitute.setStatus(status);
            branchInstitute.setTeacher(teacher);
            branchInstitute.setUrl(url);

            //记录创建人
            branchInstitute.setCreateBy(manager.getId());



            if (occupation != null) {
                branchInstitute.setOccupation(occupation);
            }
            if (fee != null) {
                branchInstitute.setFee(fee);
            }


            branchInstituteService.insert(branchInstitute);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add branchInstitute error ");
            model.addAttribute("code", -6002);
        }

        return "/common/success";
    }

    //删除分院
    @RequestMapping(value = "/a/u/branchInstitute/{id}", method = RequestMethod.DELETE)
    public String deleteBranchInstituteJson(HttpServletRequest request,
                                            HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete branchInstitute : id= " + id);
        //获取后台管理者信息
        String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
        Long adminId = Long.parseLong(userId);
        Manager manager = managerService.getObjectById(adminId);
        try {
            BranchInstitute branchInstitute = branchInstituteService.getObjectById(id);

            if (branchInstitute == null) {
                model.addAttribute("code", -18007);
                log.info("The branch does not exist");
                return "/common/success";
            }
            //记录操作人，日志里就能查到是谁删除的
            branchInstitute.setUpdateBy(manager.getId());

            branchInstituteService.delete(id);

            log.info("add branchInstitute success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete branchInstitute error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/common/success";
    }


    //修改分院上下架状态    0:上架,1:下架
    @RequestMapping(value = "/a/u/branchInstitute/{id}/status", method = RequestMethod.PUT)
    public String updateBranchStauts(ModelMap model, @PathVariable Long id) throws Exception {
        log.info("update branch status : id is " + id);
        try {

            BranchInstitute branchInstitute = branchInstituteService.getObjectById(id);
            log.info("check status");

            if (branchInstitute == null){
                model.addAttribute("code", -18007);
                log.info("The branch does not exist");
                return "/common/success";
            }

            Integer status = branchInstitute.getStatus();


            //下架操作
            if (status == 0) {
                branchInstitute.setStatus(1);
            } else if (status == 1) {
                //上架操作
                branchInstitute.setStatus(0);
            } else {
                log.info("status is " + status);
                model.addAttribute("code",-18010);
            }

            log.info("now status is :" + branchInstitute.getStatus());
            branchInstituteService.update(branchInstitute);
            model.addAttribute("code", 0);



        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update branch status error,id is " + id);
            model.addAttribute("code", -6004);
        }
        return "/common/success";
    }


    @RequestMapping(value = "/a/multi/branchInstitute", method = RequestMethod.GET)
    public String getMultiBranchInstituteJson(HttpServletRequest request,
                                              HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        List<Long> idList = new ArrayList();
        if (ids == null) {

        } else {
            idList = Arrays.asList(ids);
        }
        try {


            List<BranchInstitute> branchInstituteList = branchInstituteService.getObjectsByIds(idList);
            log.info("get  branchInstitute data is " + branchInstituteList.size());

            model.addAttribute("code", 0);
            model.addAttribute("total", branchInstituteList.size());

            model.addAttribute("branchInstituteList", branchInstituteList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get branchInstitute error,id is  " + idList);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/branchInstitute/json/branchInstituteListJson";
    }


    //分院列表
    @RequestMapping(value = "/a/branch/search/query", method = RequestMethod.GET)
    public String searchDaily(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, String name, Long uid,
                              String qq, Integer period, String phone, String url, String address, Integer status,
                              Integer page, Integer size, String nick, Integer orderBy, Integer sort) {

		/* 1 初始化参数 */
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int limit = size + 1;
        boolean next = false;

        List<Long> idList = null;
        List<Long> totalList = null;
        List<Long> userIdList = null;
        List<User> userList = null;
        List<User> users = new ArrayList();
        Integer total = null;
        List<BranchInstitute> branchInstituteList = new ArrayList<>();
        try {

            Map<String, Object> param = DynamicUtil.getQueryBranchList(name, uid, qq, period, phone, url, address, status, nick, false);
            idList = branchInstituteService.getIdsByDynamicCondition(BranchInstitute.class, param, start, size);
            log.info("====== branch idlist is " + idList);
            branchInstituteList = branchInstituteService.getObjectsByIds(idList);

            Map<String, Object> paramTotal = DynamicUtil.getQueryBranchList(name, uid, qq, period, phone, url, address, status, nick, true);
            totalList = branchInstituteService.getIdsByDynamicCondition(BranchInstitute.class, paramTotal, 0, Integer.MAX_VALUE);
            total = totalList.get(0).intValue();

            Set<Long> uids = new HashSet();
            for (BranchInstitute branchInstitute : branchInstituteList) {
                uids.add(branchInstitute.getUid());
            }
            log.info("branch uids is " + idList);

            if (CollectionUtils.isEmpty(uids)) {} else {
                users = this.userService.getObjectsByIds(new ArrayList(uids));
            }

            if (page * size >= total) {
                next = false;
            } else {
                next = true;
            }


            model.addAttribute("users", users);
            model.addAttribute("code", 0);
            model.addAttribute("branchInstituteList", branchInstituteList);
            model.addAttribute("total", total);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("page",page);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
            log.error(t.getMessage());
            log.error("get classesDailyList error,oid is ");
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/branchInstitute/json/branchInstituteListJson";

    }


}