package com.ptteng.controller;

import com.ptteng.common.skill.model.Account;
import com.ptteng.common.skill.model.Message;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.AccountService;
import com.ptteng.common.skill.service.MessageService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.model.accountMdl;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.JavaShellUtil;
import com.ptteng.util.Password;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Account  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class AccountController {
    private static final Log log = LogFactory.getLog(AccountController.class);

    @Autowired
    private AccountService accountService;


    @Autowired
    private CookieUtil cookieUtil;


    @Autowired
    private UserService userService;


    @Autowired
    private MessageService messageService;


    /**
     * 获取账号详情
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param account
     * @param type
     * @param support
     * @param deploy
     * @param serverIp
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/account ", method = RequestMethod.GET)
    public String getAccountIdsByAccountJsonList(HttpServletRequest request,
                                                 HttpServletResponse response, ModelMap model, Integer page,
                                                 Integer size, String account, Integer type, String support, String deploy, String serverIp, Integer status
    ) throws Exception {


        if (page == null) {
            page = 1;

        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            List<Long> ids = new ArrayList<>();
            Map<String, Object> param = DynamicUtil.getAccountListParam(type, support, deploy, serverIp, false, account, status);

            log.info("the param is" + param);

            ids = accountService.getIdsByDynamicCondition(Account.class, param, start, size);
            log.info("the ids is " + ids);
            log.info("get countAccountIdsByAccount size is " + ids.size());

            List<Account> accountList = accountService.getObjectsByIds(ids);
            log.info("get account data is " + accountList.size());

            Integer total = accountService.countAccountIds();
            log.info("get account count is " + total);


            List<Long> unused = accountService.getAccountByStatus(2, 0, Integer.MAX_VALUE);
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);

            model.addAttribute("total", total);
            model.addAttribute("unused", unused.size());

            model.addAttribute("accountList", accountList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get account list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/account/json/accountListJson";
    }


    @RequestMapping(value = "/a/u/account/{id}", method = RequestMethod.GET)
    public String getAccountJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Account account = accountService.getObjectById(id);
            log.info("get account data is " + account);

            model.addAttribute("code", 0);

            model.addAttribute("account", account);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get account error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/account/json/accountDetailJson";
    }


    /**
     * 修改账号信息
     *
     * @param request
     * @param response
     * @param model
     * @param account
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/account/{id}", method = RequestMethod.PUT)
    public String updateAccountJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Account account, @PathVariable Long id) throws Exception {

        log.info("update account : account= " + account);

        try {
            // 取出原有的旧账号
            Account account1 = accountService.getObjectById(id);

            if (DataUtils.isNotNullOrEmpty(account1) && DataUtils.isNotNullOrEmpty(account.getEndTime())) {
                account1.setEndTime(account.getEndTime());
                accountService.update(account1);
            } else if (DataUtils.isNullOrEmpty(account1)){  //账号不存在直接返回
                model.addAttribute("code", -38000);
                return "/common/failure";
            } else if (DataUtils.isNullOrEmpty(account.getEndTime()) && ObjectUtils.equals(Account.Status_Using, account.getStatus())) {
                //使用中的账号，过期时间不能为空
                model.addAttribute("code", -38001);
                return "/common/failure";
            }

            Long uid = userService.getUserIdByMobile(account1.getMobile());
            User receiver = userService.getObjectById(uid);

            //存入系统消息
            Message message = new Message();
            message.setStatus(Message.Status_Unread);
            message.setReceiveName(receiver.getNick());
            message.setSendName("admin");
            message.setSendId(0L);
            message.setContent("");
            message.setReceiveId(receiver.getId());
            message.setUnread(1);
            message.setType(Message.CLASS_TYPE);

            Long mid = messageService.insert(message);

            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String time = df.format(new Date(System.currentTimeMillis()));

            //发送系统信息
            String content = "<span  class=\\\"font-16px system-alert-outline\\\">" + "<span class=\\\"font-green\\\">您</span>" +
                    "<span class=\\\"font-orange\\\" data-mid=" + mid + ">" + time + "</span>" +
                    "购买的服务器已发货,<a   data-mid=" + mid + " class=\\\"font-blue\\\" target=\"_blank\" href=\\\"/skill/userMessage///myAccount/" + uid + "#1" + "\\\">点击查看</a>" +
                    "</span>";
            log.info("user : " + receiver.getMobile() + " send : " + content);
            adminSend(receiver.getMobile(), content);

            message = messageService.getObjectById(mid);
            message.setContent(content);
            log.info("message is " + message);

            Boolean result = messageService.update(message);
            log.info("result is " + result);

            // 获取用户,更改用户查看消息列表的状态
            receiver.setIsLook(receiver.getIsLook() + 1);
            receiver.setLatestMsg(Message.CLASS_TYPE);
            userService.update(receiver);

            model.addAttribute("code", 0);

            model.addAttribute("account", account);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update account error,id is  " + account.getId());
            model.addAttribute("code", -1);

        }

        return "/data/json";
    }


    public static String adminSend(String mobile, String content) {


        String param = "{\n" +
                "    \"target_type\" : \"users\", \n" +
                "    \"target\" : [\"" + mobile + "\"],   \n" +
                "                                   \n" +
                "                                   \n" +
                "    \"msg\" : {\n" +
                "        \"type\" : \"txt\",\n" +
                "        \"msg\" : \"" + content + "\" \n" +
                "        },\n" +
                "    \"from\" : \"admin\"\n" +
                "}";
        String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");


        return result;
    }

    // 更改用户的密码
    @RequestMapping(value = "/a/u/account/{status}/{id}", method = RequestMethod.PUT)
    public String stopAccountJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, @PathVariable Long id, @PathVariable Long status) throws Exception {

        log.info("update account : account= " + id);

        try {
            Account account = accountService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(account)) {
                model.addAttribute("code", -14001);
                return "/data/json";
            }

            if (ObjectUtils.equals(Account.Status_Using, status)) { // 当传入的status=1（启用）
                account.setStatus(Account.Status_Using);
                account.setPwd(account.getNewPwd());
                // 清除新密码
                account.setNewPwd(null);
                boolean bool = accountService.update(account);
                log.info("the status is 1" + bool);

            } else { // 将状态改为过期

                // 执行脚本
                JavaShellUtil shellUtil = new JavaShellUtil();

                // 生成新密码
                String pwd = Password.getRandomS();
                shellUtil.executeShell("sh" + " " + shellUtil.basePath + "changepwd.sh" + " " + account.getAccount() + " " + pwd + " " + account.getServerIp());

                if (DataUtils.isNotNullOrEmpty(account)) {
                    account.setStatus(Account.Status_Expire);
                    account.setNewPwd(pwd);
                    boolean bool = accountService.update(account);
                    log.info("the status is 3" + bool);
                }

            }
            model.addAttribute("code", 0);
            model.addAttribute("account", account);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update account error,id is  ");
            model.addAttribute("code", -1);
        }

        return "/data/jsonpwd";
    }


    // 批量新增服务器账号
    @RequestMapping(value = "/a/u/account", method = RequestMethod.POST)
    public String addAccountJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, accountMdl mdl) throws Exception {

        log.info("update account : account= " + mdl.getStart() + mdl.getEnd() + mdl);

        try {


            Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
                    com.qding.common.util.http.cookie.CookieUtil.USER_ID));


            if (null != mdl.getStart() && null != mdl.getEnd()) {

                int startNum = Integer.parseInt(mdl.getStart());
                int endNum = Integer.parseInt(mdl.getEnd());

                log.info(startNum + "---" + endNum);

                List<Account> accountList = new ArrayList<>();
                for (int i = startNum; i <= endNum; i++) {

                    // 生成帐号名(这里只能是3位数，会不会有bug？)
                    String str = String.format("%03d", i);
                    String acName = mdl.getName() + str;

                    // 生成密码
                    String pwd = Password.getRandomS();

                    // webDic
                    String webDic = "home" + "/" + acName;

                    //webUrl
                    String webUrl = mdl.getIp() + ":" + mdl.getPort() + "/" + acName + "/";


                    // 执行脚本
                    JavaShellUtil shellUtil = new JavaShellUtil();
                    log.info("sh" + " " + shellUtil.basePath + "makeaccount.sh" + " " + acName + " " + pwd + " " + mdl.getIp());
                    shellUtil.executeShell("sh" + " " + shellUtil.basePath + "makeaccount.sh" + " " + acName + " " + pwd + " " + mdl.getIp());


                    // 创建一个新账号,并且赋值
                    Account account = new Account();
                    account.setAccount(acName);
                    account.setPwd(pwd);
                    account.setWebDirectory(webDic);
                    account.setWebUrl(webUrl);
                    account.setStatus(2);
                    account.setType(1);
                    account.setServerId(mdl.getServerId());
                    account.setCreateBy(uid);
                    account.setUpdateBy(uid);
                    account.setServerIp(mdl.getIp());
                    account.setDeploy(mdl.getDeploy());
                    accountList.add(account);

                }

                accountService.insertList(accountList);
            }

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add account error ");
            model.addAttribute("code", -1);
        }

        return "/data/json";
    }

    @RequestMapping(value = "/a/u/account/{id}", method = RequestMethod.DELETE)
    public String deleteAccountJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete account : id= " + id);
        try {
            accountService.delete(id);

            log.info("add account success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete account error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/data/json";
    }


    @RequestMapping(value = "/web/a/multi/account", method = RequestMethod.GET)
    public String getMultiAccountJson(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        List<Long> idList = new ArrayList();
        if (ids == null) {

        } else {
            idList = Arrays.asList(ids);
        }
        try {

            List<Account> accountList = accountService.getObjectsByIds(idList);
            log.info("get  account data is " + accountList.size());

            model.addAttribute("code", 0);
            model.addAttribute("total", accountList.size());

            model.addAttribute("accountList", accountList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get account error,id is  " + idList);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/account/json/accountListJson";
    }


}

