package com.ptteng.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.gemantic.common.util.StringUtil;
import com.qding.common.util.http.cookie.CookieUtil;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.model.Stage;
import com.ptteng.common.skill.model.Task;
import com.ptteng.common.skill.service.ArticleService;
import com.ptteng.common.skill.service.OccupationService;
import com.ptteng.common.skill.service.StageService;
import com.ptteng.common.skill.service.TaskService;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


import com.ptteng.common.skill.model.StageReplay;
import com.ptteng.common.skill.service.StageReplayService;

/**
 * StageReplay  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class StageReplayController {
	private static final Log log = LogFactory.getLog(StageReplayController.class);

	@Autowired
	private StageReplayService stageReplayService;
	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private StageService stageService;



	//修改复盘阶段上下架状态    0:下架,1:上架
//	@RequestMapping(value = "/a/u/stageReplay/{id}/status", method = RequestMethod.PUT)
//	public String updateBranchStauts(ModelMap model, @PathVariable Long id) throws Exception {
//		log.info("update stageReplay status : id is " + id);
//		try {
//
//			StageReplay stageReplay = stageReplayService.getObjectById(id);
//			log.info("check status");
//
//			if (stageReplay == null){
//				model.addAttribute("code", -18007);
//				log.info("The stage does not exist");
//				return "/common/success";
//			}
//			Integer status = stageReplay.getStatus();
//
//			//上架操作
//			if (status == 0) {
//				stageReplay.setStatus(1);
//			} else if (status == 1) {
//				//下架操作
//				stageReplay.setStatus(0);
//			} else {
//				log.info("status is " + status);
//				model.addAttribute("code",-18010);
//			}
//
//			log.info("now status is :" + stageReplay.getStatus());
//			stageReplayService.update(stageReplay);
//			model.addAttribute("code", 0);
//		} catch (Throwable t) {
//			t.printStackTrace();
//			log.error(t.getMessage());
//			log.error("update branch status error,id is " + id);
//			model.addAttribute("code", -6005);
//		}
//		return "/common/success";
//	}
	//复盘阶段拖动排序
	@RequestMapping(value = "/a/u/stageReplay/sort", method = RequestMethod.POST)
	public String sortStage(HttpServletRequest request,
							HttpServletResponse response, ModelMap model,@RequestBody List<Long> ids)
			throws Exception{
		log.info("sort stage:ids="+ids);
		try {
			List<StageReplay> stageReplays = this.stageReplayService.getObjectsByIds(ids);
			int index = 0;
			for (StageReplay stageReplay:stageReplays){
				stageReplay.setSort(index);
				index = index +10;
			}
			this.stageReplayService.updateList(stageReplays);
			model.addAttribute("code",0);
		}catch (Throwable t){
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("order stages error ");
			model.addAttribute("code", -1);
		}
		return "/common/success";
	}



	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	//复盘阶段列表
	@RequestMapping(value = "/a/u/stageReplay/search", method = RequestMethod.GET)
	public String getstageReplayList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,String name,Integer status
			, Integer page, Integer size) throws Exception {
		log.info("name"+name+"status"+status+"page"+page+"size"+size);
		/* 1 默认分页 */
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		try{
			//初始值
//			List<Long> stageReplayList = new ArrayList<>();
			Long total = 0L;
			//后台根据名称和状态动态查询，获取参数列表
			Map<String,Object> paramList = DynamicUtil.getReplaysListParam(name,status, false);
			log.info("paramList size =" + paramList.size());
			//获取replay id 列表
			List<Long> replaysIdList= stageReplayService.getIdsByDynamicCondition(StageReplay.class,paramList,start,size);
			//获取total
			Map<String,Object> paramCount = DynamicUtil.getReplaysListParam(name,status,true);
			List<Long> replaysIdCount = stageReplayService.getIdsByDynamicCondition(StageReplay.class, paramCount, 0, Integer.MAX_VALUE);
			if (CollectionUtils.isNotEmpty(replaysIdCount)) {
				total = replaysIdCount.get(0);
			}
			//获取replays列表
			List<StageReplay> stageReplayList= stageReplayService.getObjectsByIds(replaysIdList);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total",total);
			model.addAttribute("stageReplayList",stageReplayList);


		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error(" search stageReplay list error ");
			model.addAttribute("code", -1);
		}

		return "/common-skill-service/stageReplay/json/stageReplayListJson";
	}



	//复盘阶段详情
	@RequestMapping(value = "/a/u/stageReplay/{id}", method = RequestMethod.GET)
	public String getStageReplayJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			StageReplay stageReplay = stageReplayService.getObjectById(id);
			log.info("get stageReplay data is " + stageReplay);

			model.addAttribute("code", 0);

			model.addAttribute("stageReplay", stageReplay);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get stageReplay error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/stageReplay/json/stageReplayDetailJson";
	}
	//编辑阶段
	@RequestMapping(value = "/a/u/stageReplay/{id}", method = RequestMethod.PUT)
	public String updateStageReplayJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,  @PathVariable Long id,StageReplay stageReplay) throws Exception {
		log.info("get data : id= " + id);
		if (id == null) {
			model.addAttribute("code", -18007);
			log.info("id is null");
			return "/common/success";
		}
		StageReplay oldReplay = stageReplayService.getObjectById(id);
		if (oldReplay == null){
				model.addAttribute("code", -22020);
				log.info("The stage does not exist");
				return "/common/success";
			}
		if (stageReplay.getName()==null){
			model.addAttribute("code", -22000);
			log.info("name is null");
			return "/common/success";
		}


		try {
			//将修改数据的人记录进数据库
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			stageReplay.setUpdateBy(Long.parseLong(userId));
			//将创建数据记录到数据库
			stageReplay.setCreateAt(oldReplay.getCreateAt());
			stageReplay.setCreateBy(oldReplay.getCreateBy());

			stageReplayService.update(stageReplay);

			model.addAttribute("code", 0);
			model.addAttribute("stageReplay", stageReplay);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update stageReplay error,id is  " + stageReplay.getId());
			model.addAttribute("code", -1);

		}

		return "/data/json";
	}
	//获取复盘阶段列表数据长度
	private Integer getStageSize() throws ServiceException, ServiceDaoException {
		Map<String, Object> param = DynamicUtil.getSingleFieldParam(
				"sort desc", "stage_replay");
		List<Long> sizes = this.stageReplayService.getIdsByDynamicCondition(
				StageReplay.class, param, 0, Integer.MAX_VALUE);
		int size = 0;
		if (CollectionUtils.isEmpty(sizes)) {
			log.info("first order ");
		} else {
			Long sizeId = sizes.get(0);
			StageReplay replay= this.stageReplayService.getObjectById(sizeId);
			size =replay.getSort().intValue();
		}
		return size+3;
	}
	//新增复盘阶段
	@RequestMapping(value = "/a/u/stageReplay", method = RequestMethod.POST)
	public String addStageReplayJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, StageReplay stageReplay) throws Exception {

		if (stageReplay.getName() == null|| StringUtil.isEmpty(stageReplay.getContents())) {
			model.addAttribute("code", -1000);
			log.info("param is null");
			return "/common/success";
		}
		//验证名称是否重复
		List<Long> alreadyReplay=stageReplayService.getStageReplayIdsByNameOrderBySort(stageReplay.getName(),0,Integer.MAX_VALUE);
		if (alreadyReplay.size()==0){
			log.info("this name is new");
		}else {
			model.addAttribute("code", -22021);
			log.info("this name is already exist");
			return "/common/success";
		}
		try {
			int size = this.getStageSize();
			stageReplay.setSort(size);
			//新增阶段默认下架
			stageReplay.setStatus(0);
			log.info(stageReplay);
			//记录更改数据的操作者
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			stageReplay.setCreateBy(Long.parseLong(userId));
			stageReplay.setUpdateBy(Long.parseLong(userId));

			Long sid=stageReplayService.insert(stageReplay);

			model.addAttribute("code", 0);
			model.addAttribute("sid", sid);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add stageReplay error ");
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/stageReplay/json/addStageReplay";
	}

	@RequestMapping(value = "/a/stageReplay/{id}", method = RequestMethod.DELETE)
	public String deleteStageReplayJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete stageReplay : id= " + id);
		try {
			stageReplayService.delete(id);

			log.info("add stageReplay success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete stageReplay error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/common/success";
	}

	
}

