package com.ptteng.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.common.skill.model.Iteration;
import com.ptteng.common.skill.model.StageReplay;
import com.ptteng.common.skill.service.IterationService;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.skill.model.Product;
import com.ptteng.common.skill.service.ProductService;

/**
 * Product  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ProductController {
	private static final Log log = LogFactory.getLog(ProductController.class);

	@Autowired
	private ProductService productService;
	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private IterationService iterationService;



    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	//产品列表
	@RequestMapping(value = "/a/u/product/search", method = RequestMethod.GET)
	public String getproductList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page, Integer size,
								 String name,String industry,Integer status,String client) throws Exception {
		log.info("name"+name+"industry"+industry+"status"+status+"page"+page+"size"+size+"client"+client);
		/* 1 默认分页 */
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		try{
			//初始值
			Long total =0L;
			//动态查询
			Map<String,Object> paramList = DynamicUtil.getProductListParam(name,industry,status,client,false);
			log.info("paramList size =" + paramList.size());
			//获取产品Id列表
			List<Long> productIdList = productService.getIdsByDynamicCondition(Product.class,paramList,start,size);
			//获取total
			Map<String,Object> paramCount = DynamicUtil.getProductListParam(name,industry,status,client,true);
			List<Long> productsIdCount = productService.getIdsByDynamicCondition(Product.class,paramCount, 0, Integer.MAX_VALUE);
			if (CollectionUtils.isNotEmpty(productsIdCount)) {
				total = productsIdCount.get(0);
			}
			//获取products列表
			List<Product> productList = productService.getObjectsByIds(productIdList);
			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total",total);
			model.addAttribute("productList",productList);
		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error(" search product list error ");
			model.addAttribute("code", -1);
		}
		return "/common-skill-service/product/json/productListJson";
	}
    
    

	
	//产品详情
	@RequestMapping(value = "/a/u/product/{id}", method = RequestMethod.GET)
	public String getProductJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		if (id==null){
			log.info("product id cannot be null");
			model.addAttribute("code", -22001);
		}
		try {
			Product product = productService.getObjectById(id);
//			log.info("get product data is " + product);

			model.addAttribute("code", 0);

			model.addAttribute("product", product);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get product error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/product/json/productDetailJson";
	}
	//编辑产品
	@RequestMapping(value = " /a/u/product/{id}", method = RequestMethod.PUT)
	public String updateProductJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id,Product product) throws Exception {
		//判空
		if (id == null) {
			model.addAttribute("code", -18007);
			log.info("id is null");
			return "/common/success";
		}
		Product oldProduct = productService.getObjectById(id);
		if (oldProduct == null) {
			model.addAttribute("code", -22010);
			log.info("this product does not exist");
			return "/common/success";
		}

		log.info("product"+product);
		if (product.getName() == null|| product.getIndustry()==null||product.getNums()==null
				||product.getClient()==null||product.getDifficulty()==null) {
			model.addAttribute("code", -1000);
			log.info("param is null");
			return "/common/success";
		}


		try {
			//将修改数据的人记录进数据库
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			product.setUpdateBy(Long.parseLong(userId));
			//将创建数据记录进数据库
			product.setCreateBy(oldProduct.getCreateBy());
			product.setCreateAt(oldProduct.getCreateAt());
			//下架前验证有无上架迭代
			if (product.getStatus()==0){
				List<Long> iteration= iterationService.getIterationIdsByProductIdAndStatusOrderBySort(product.getId(),1,0,Integer.MAX_VALUE);
//				log.info(iteration);
				if (CollectionUtils.isEmpty(iteration)) {

				}else {
					model.addAttribute("code", -22013);
					return "/common/success";
				}
			}

			productService.update(product);

			model.addAttribute("code", 0);

			model.addAttribute("product", product);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update product error,id is  " + product.getId());
			model.addAttribute("code", -6003);

		}

		return "/common/success";
	}


	//新增产品
	@RequestMapping(value = "/a/u/product", method = RequestMethod.POST)
	public String addProductJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Product product) throws Exception {
		//判空
		if (product.getName() == null|| product.getIndustry()==null||product.getNums()==null
				||product.getClient()==null||product.getDifficulty()==null) {
			model.addAttribute("code", -1000);
			log.info("param is null");
			return "/common/success";
		}
		//验证名称是否重复
		List<Long> alreadyProduct=productService.getProductIdsByNameOrderByLevel(product.getName(),0,Integer.MAX_VALUE);
		if (alreadyProduct.size()==0){
			log.info("this name is new");
		}else {
			model.addAttribute("code", -22021);
			log.info("this name is already exist");
			return "/common/success";
		}
		try {
			int size = this.getProductSize();
			product.setLevel(size);
			//新增产品默认下架
			product.setStatus(0);
			//记录更改数据的操作者
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			product.setCreateBy(Long.parseLong(userId));
			product.setUpdateBy(Long.parseLong(userId));


			Long productId=productService.insert(product);

			model.addAttribute("code", 0);
			model.addAttribute("productId",productId);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add product error ");
			model.addAttribute("code", -6002);
		}

		return "/common-skill-service/product/json/addProduct";
	}
	//获取产品列表数据长度
	private Integer getProductSize() throws ServiceException, ServiceDaoException {
		Map<String, Object> param = DynamicUtil.getSingleFieldParam(
				"level desc", "product");
		List<Long> sizes = this.productService.getIdsByDynamicCondition(
				Product.class, param, 0, Integer.MAX_VALUE);
		int size = 0;
		if (CollectionUtils.isEmpty(sizes)) {
			log.info("first order ");
		} else {
			Long sizeId = sizes.get(0);
			Product product= this.productService.getObjectById(sizeId);
			size =product.getLevel().intValue();
		}
		return size+3;
	}

	@RequestMapping(value = "/a/product/{id}", method = RequestMethod.DELETE)
	public String deleteProductJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete product : id= " + id);
		try {
			productService.delete(id);

			log.info("add product success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete product error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	//产品拖动排序
	@RequestMapping(value = "/a/u/product/sort", method = RequestMethod.POST)
	public String sortProduct(HttpServletRequest request,
							HttpServletResponse response, ModelMap model,@RequestBody List<Long> ids)
			throws Exception{
		log.info("level product:ids="+ids);
		try {
			List<Product> products = this.productService.getObjectsByIds(ids);
			int index = 0;
			for (Product product:products){
				product.setLevel(index);
				index = index +10;
			}
			this.productService.updateList(products);
			model.addAttribute("code",0);
		}catch (Throwable t){
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("order products error ");
			model.addAttribute("code", -1);
		}
		return "/common/success";
	}
	//修改产品上下架状态    0:下架,1:上架
//	@RequestMapping(value = "/a/u/product/{id}", method = RequestMethod.PUT)
//	public String updateBranchStauts(ModelMap model,Integer status, @PathVariable Long id) throws Exception {
//		log.info("id " + id+"status"+status);
//		try {
//			Product product = productService.getObjectById(id);
//			log.info("check status");
//
//			if (product == null){
//				model.addAttribute("code", -18007);
//				log.info("The stage does not exist");
//				return "/common/success";
//			}
//			Integer oldStatus = product.getStatus();
//			log.info("oldStatus"+oldStatus);
//
//			//上下架操作
//			if (status == oldStatus) {
//				log.info("status is same" );
//				model.addAttribute("code",-18010);
//			} else {
//				product.setStatus(status);
//			}
//
//			log.info("now status is :" + product.getStatus());
//			productService.update(product);
//			model.addAttribute("code", 0);
//		} catch (Throwable t) {
//			t.printStackTrace();
//			log.error(t.getMessage());
//			log.error("update branch status error,id is " + id);
//			model.addAttribute("code", -6005);
//		}
//		return "/common/success";
//	}
	
//	@RequestMapping(value = "/a/u/product/search", method = RequestMethod.GET)
//	public String getProductListJson(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, Long[] ids)
//			throws Exception {
//
//		List<Long> idList = new ArrayList();
//	   if (ids == null) {
//
//		} else {
//			idList = Arrays.asList(ids);
//		}
//		try {
//
//			List<Product> productList = productService.getObjectsByIds(idList);
//			log.info("get  product data is " + productList);
//
//			model.addAttribute("code", 0);
//			model.addAttribute("total",productList.size());
//
//			model.addAttribute("productList", productList);
//
//		} catch (Throwable t) {
//			log.error(t.getMessage());
//			log.error("get product error,id is  " + idList);
//			model.addAttribute("code", -100000);
//		}
//
//		return "/common-skill-service/product/json/productListJson";
//	}
//
	
	
	
	
}

