package com.ptteng.util;

import com.gemantic.common.util.StringUtil;
import com.ptteng.common.skill.model.Record;
import com.qding.common.util.DataUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.regex.Pattern;

/**
 * Created by J.w on 2018/1/18.
 * 功能描述：
 */
public class DataValidatorUtil {
    /**
     * 正则表达式：验证用户名
     */
    public static final String REGEX_USERNAME = "^[a-zA-Z]\\w{5,20}$";

    /**
     * 正则表达式：验证密码
     */
    public static final String REGEX_PASSWORD = "^[a-zA-Z0-9]{6,20}$";

    /**
     * 正则表达式：验证手机号
     */
    public static final String REGEX_MOBILE = "^((17[0-9])|(14[0-9])|(13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$";

    /**
     * 正则表达式：验证邮箱
     */
    public static final String REGEX_EMAIL = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";

    /**
     * 正则表达式：验证汉字
     */
    public static final String REGEX_CHINESE = "^[\u4e00-\u9fa5],{0,}$";

    /**
     * 正则表达式：验证身份证
     */
    public static final String REGEX_ID_CARD = "(^\\d{18}$)|(^\\d{15}$)";

    /**
     * 正则表达式：验证URL
     */
    public static final String REGEX_URL = "http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?";

    /**
     * 正则表达式：验证IP地址
     */
    public static final String REGEX_IP_ADDR = "(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)";

    /**
     * 校验用户名
     *
     * @param username
     * @return 校验通过返回true，否则返回false
     */
    public static boolean isUsername(String username) {
        return Pattern.matches(REGEX_USERNAME, username);
    }

    /**
     * 校验密码
     *
     * @param password
     * @return 校验通过返回true，否则返回false
     */
    public static boolean isPassword(String password) {
        return Pattern.matches(REGEX_PASSWORD, password);
    }

    /**
     * 校验手机号
     *
     * @param mobile
     * @return 校验通过返回true，否则返回false
     */
    public static boolean isMobile(String mobile) {
        return Pattern.matches(REGEX_MOBILE, mobile);
    }

    /**
     * 校验邮箱
     *
     * @param email
     * @return 校验通过返回true，否则返回false
     */
    public static boolean isEmail(String email) {
        return Pattern.matches(REGEX_EMAIL, email);
    }

    /**
     * 校验汉字
     *
     * @param chinese
     * @return 校验通过返回true，否则返回false
     */
    public static boolean isChinese(String chinese) {
        return Pattern.matches(REGEX_CHINESE, chinese);
    }

    /**
     * 校验身份证
     *
     * @param idCard
     * @return 校验通过返回true，否则返回false
     */
    public static boolean isIDCard(String idCard) {
        return Pattern.matches(REGEX_ID_CARD, idCard);
    }

    /**
     * 校验URL
     *
     * @param url
     * @return 校验通过返回true，否则返回false
     */
    public static boolean isUrl(String url) {
        return Pattern.matches(REGEX_URL, url);
    }

    /**
     * 校验IP地址
     *
     * @param ipAddr
     * @return
     */
    public static boolean isIPAddr(String ipAddr) {
        return Pattern.matches(REGEX_IP_ADDR, ipAddr);
    }

    /**
     * 对传入的Record实体对象的属性做非空校验
     * 此处还做了address的非空校验
     * 但是没做银行卡号的校验
     */
    public static boolean checkRecord(Record record) {
        if (StringUtil.isEmpty(record.getName()) || DataUtils.isNullOrEmpty(record.getUid()) || DataUtils.isNullOrEmpty(record.getAvatar())
                || DataUtils.isNullOrEmpty(record.getSex()) || StringUtil.isEmpty(record.getIdentityNum()) || StringUtil.isEmpty(record.getProvince())
                || StringUtil.isEmpty(record.getCity()) || StringUtil.isEmpty(record.getCounty())
                || DataUtils.isNullOrEmpty(record.getEducatedStartAt()) || DataUtils.isNullOrEmpty(record.getEducatedEndAt())
                || DataUtils.isNullOrEmpty(record.getGrade()) || StringUtil.isEmpty(record.getContactName()) || StringUtil.isEmpty(record.getContactRelation())
                || StringUtil.isEmpty(record.getContactMobile()) || StringUtil.isEmpty(record.getCardNum()) || StringUtil.isEmpty(record.getBank())
                || StringUtil.isEmpty(record.getSource()) || StringUtil.isEmpty(record.getIdentityFrontUrl()) || DataUtils.isNullOrEmpty(record.getIsWork())
                || StringUtil.isEmpty(record.getIdentityReverseUrl()) || DataUtils.isNullOrEmpty(record.getIsLoan())) {
            return false;
        }

        //用有工作经验的，工作经历不能为空
        if (record.getIsWork().equals(Record.WORK_YES) && StringUtils.isEmpty(record.getWorkExp())) {
            return false;
        }

        //贷款学员户口簿本人页照片不能为空
        if (record.getIsLoan().equals(Record.LOAN_YES) && StringUtil.isEmpty(record.getHouseholdRegisterUrl())) {
            return false;
        }

        //性别校验
        if (record.getSex() < Record.SEX_MALES || record.getSex() > Record.SEX_FEMALES) {
            return  false;
        }

        //身份证号校验
        if (!DataValidatorUtil.isIDCard(record.getIdentityNum())) {
            return false;
        }

        //学历校验,不能低于小学或高于博士后
        if (record.getGrade() < Record.GRADE_PRIMARY || record.getGrade() > Record.GRADE_DOCTOR) {
            return false;
        }

        //学历为中专以上的，学校和专业不能为空
        if (record.getGrade() > Record.GRADE_SECONDARY && (StringUtils.isEmpty(record.getSchool()) || StringUtils.isEmpty(record.getMajor()))) {
            return false;
        }

        if (!DataValidatorUtil.isMobile(record.getContactMobile())) {
            return false;
        }

        return true;
    }
}
