package com.ptteng.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * UserTeamRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserTeamRelationController {
	private static final Log log = LogFactory.getLog(UserTeamRelationController.class);

	@Autowired
	private UserTeamRelationService userTeamRelationService;

	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private UserService userService;
	@Autowired
	private TeamService teamService;
	@Autowired
	private IterationService iterationService;
	@Autowired
	private ProjectService projectService;


    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	//组员详情
	@RequestMapping(value = "/a/u/member/{id}", method = RequestMethod.GET)
	public String getUserTeamRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		if (id==null){
			log.info("iteration id cannot be null");
			model.addAttribute("code", -22002);
		}
		try {
			UserTeamRelation userTeamRelation = userTeamRelationService.getObjectById(id);
//			log.info("get userTeamRelation data is " + userTeamRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userTeamRelation", userTeamRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userTeamRelation error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userTeamRelation/json/userTeamRelationDetailJson";
	}
	//编辑感言
	@RequestMapping(value = "/a/u/member/{id}", method = RequestMethod.PUT)
	public String updateUserTeamRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,@PathVariable Long id, UserTeamRelation member) throws Exception {
		
		log.info("update userTeamRelation : userTeamRelation= " + member);
		if (id == null) {
			model.addAttribute("code", -18007);
			log.info("id is null");
			return "/common/success";
		}
		UserTeamRelation oldIdea=userTeamRelationService.getObjectById(id);
		if (oldIdea == null){
			model.addAttribute("code", -22006);
			log.info("This member does not exist");
			return "/common/success";
		}
		if (member.getTid() == null|| member.getUid()==null) {
			model.addAttribute("code", -1000);
			log.info("param is null");
			return "/common/success";
		}

		try {
			//将修改数据的人记录进数据库
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			member.setUpdateBy(Long.parseLong(userId));
			//将创建数据记录进数据库
			member.setCreateAt(oldIdea.getCreateAt());
			member.setCreateBy(oldIdea.getCreateBy());
			
			userTeamRelationService.update(member);

			model.addAttribute("code", 0);

			model.addAttribute("userTeamRelation", member);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userTeamRelation error,id is  " + member.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	//设置、更换组长
	@RequestMapping(value = "/a/u/member/changeLeader/{id}", method = RequestMethod.PUT)
	public String updateTeamLeader(HttpServletRequest request,
											 HttpServletResponse response, ModelMap model,@PathVariable Long id, Long uid,Long tid) throws Exception {

//		log.info('');
		if (id == null) {
			model.addAttribute("code", -18007);
			log.info("id is null");
			return "/common/success";
		}
		if (tid == null|| uid==null) {
			model.addAttribute("code", -1000);
			log.info("param is null");
			return "/common/success";
		}
		UserTeamRelation member=userTeamRelationService.getObjectById(id);

		try {
			//将修改数据的人记录进数据库
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			member.setUpdateBy(Long.parseLong(userId));

			//获取当前用户所在小组
			Team team =teamService.getObjectById(member.getTid());
			//获取原组长id
			Long oldLeaderId = team.getLeaderId();
			//更新组长id
			team.setLeaderId(member.getUid());

			//清空原组长的用户表关联字段
			User oldLeader= userService.getObjectById(oldLeaderId);
			if (oldLeader!=null) {
				oldLeader.setUserTeamId("-1");
			}
			//更新新组长用户表关联字段
			User newLeader=userService.getObjectById(member.getUid());
			newLeader.setUserTeamId(String.valueOf(member.getId()));


			teamService.update(team);
			userService.update(oldLeader);
			userService.update(newLeader);
			userTeamRelationService.update(member);

			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userTeamRelation error,id is  " + member.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	//新增组员
	@RequestMapping(value = "/a/u/member", method = RequestMethod.POST)
	public String addUserTeamRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserTeamRelation member) throws Exception {

		if (member.getTid() == null|| member.getUid()==null) {
			model.addAttribute("code", -1000);
			log.info("param is null");
			return "/common/success";
		}

		User user=userService.getObjectById(member.getUid());
		//判断用户是否存在
		if (user==null){
			model.addAttribute("code", -22019);
			log.info("user is not exist");
			return "/common/success";
		}
		//组员身份判断，只能是外门、内门、首席
		int userIdentity = user.getIdentity();
		if (userIdentity==40||userIdentity==30||userIdentity==50){

		}else {
			model.addAttribute("code", -22005);
			log.info("leaderId is wrong");
			return "/common/success";
		}
		try {
			//记录更改数据的操作者
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			member.setCreateBy(Long.parseLong(userId));
			member.setUpdateBy(Long.parseLong(userId));

			//同一个小组不可以重复添加用户
			List<Long>  members =userTeamRelationService.getUserTeamRelationIdsByTidAndUidOrderByCreateAt(member.getTid(),member.getUid(),0,Integer.MAX_VALUE);
			if (CollectionUtils.isEmpty(members)){
				//小组没添加过该用户，判断用户是否处于其他项目（小组），若已经在一个项目中，且项目没有完成则不可以添加
				//可以通过用户表关联字段判断，因为组员或者小组长只能同时做一个项目，用户处于项目中的时候该字段才有值，项目做完了值会清空
				if (user.getUserTeamId().equals("-1")){

				}else {
					model.addAttribute("code", -22017);
					log.info("this user is already in one project");
					return "/common/success";
				}
			}else {
				model.addAttribute("code", -22016);
				log.info("this user is already in this team");
				return "/common/success";
			}


			Long userTeamId=userTeamRelationService.insert(member);


			//小组人数增加
			Team team = teamService.getObjectById(member.getTid());
			team.setNums(team.getNums()+1);
			teamService.update(team);

			//用户表关联字段更新
			user.setUserTeamId(String.valueOf(userTeamId));
			userService.update(user);

			//迭代数据更新，如果有进行中的项目，进行中人数+1
			//先获取项目
			List<Long> projectIdList = new ArrayList();
			List<Project> projectList =new ArrayList();
			Project project;

			List<Long> projectIds= projectService.getProjectIdsByTidOrderByCreateAt(member.getTid(),0,Integer.MAX_VALUE);
			if (projectIds!=null){
				int projectIdsSize=projectIds.size();
				for (int i=0;i<projectIdsSize;i++){
					projectIdList.add(projectIds.get(i));
				}
			}
			projectList = projectService.getObjectsByIds(projectIdList);
			//再取当前项目里处于进行中状态的,从而取到当前迭代
			int projectListSize=projectList.size();
			for (int k=0;k<projectListSize;k++){
				project = projectList.get(k);
				if (project.getStatus()==1||project.getStatus()==3){
					Iteration	iteration = iterationService.getObjectById(project.getIterationId());
					//如果迭代不为空，那么才可以进行迭代数据的操作
					if (iteration!=null){
						iteration.setGoingUsers(iteration.getGoingUsers()+1);
						iterationService.update(iteration);
					}
				}

			}


			model.addAttribute("code", 0);
			model.addAttribute("userTeamId",userTeamId);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userTeamRelation error ");
			model.addAttribute("code", -6002);
		}

		return "/common-skill-service/userTeamRelation/json/addMember";
	}
	//删除组员
	@RequestMapping(value = "/a/u/member/{id}", method = RequestMethod.DELETE)
	public String deleteUserTeamRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete userTeamRelation : id= " + id);
		if (id == null) {
			model.addAttribute("code", -18007);
			log.info("id is null");
			return "/common/success";
		}


		try {
			UserTeamRelation member = userTeamRelationService.getObjectById(id);
			if (DataUtils.isNullOrEmpty(member)) {
				log.info(" delete member error :member == null");
				model.addAttribute("code", -22018);
				return "/common/success";
			} else {
				log.info("get member data is " + member);
			}

			Team team =teamService.getObjectById(member.getTid());
			Long uid =member.getUid();
			Long leaderId =team.getLeaderId();
			Long seniorId = team.getSeniorId();
			log.info("小组："+team+"组员用户id："+uid+"小组长id："+leaderId+"复盘师兄："+seniorId);
			//组员是小组长不可删除,小组长可能是空
			if (leaderId!=null){
				if (uid.longValue()==leaderId.longValue()){
					model.addAttribute("code", -22007);
					log.info("leader cannot be deleted");
					return "/common/success";
				}
			}
			//组员是复盘师兄不可删除
			if (uid.longValue()==seniorId.longValue()){
				model.addAttribute("code", -22008);
				log.info("senior cannot be deleted");
				return "/common/success";
			}

			//终于可以删毫无地位的组员了
			userTeamRelationService.delete(id);

			//清空用户表中关系字段
			User user = userService.getObjectById(uid);
			user.setUserTeamId("-1");
			userService.update(user);

			//小组人数-1
			team.setNums(team.getNums()-1);
			teamService.update(team);

			//迭代数据更新，进行中人数-1
			//先获取项目
			List<Long> projectIdList = new ArrayList();
			List<Project> projectList =new ArrayList();
			Project project;


			List<Long> projectIds= projectService.getProjectIdsByTidOrderByCreateAt(member.getTid(),0,Integer.MAX_VALUE);
			if (projectIds!=null){
				int projectIdsSize=projectIds.size();
				for (int i=0;i<projectIdsSize;i++){
					projectIdList.add(projectIds.get(i));
				}
			}
			projectList = projectService.getObjectsByIds(projectIdList);
			//再取当前项目里处于进行中状态的,从而取到当前迭代
			int projectListSize=projectList.size();
			for (int k=0;k<projectListSize;k++){
				project = projectList.get(k);
				if (project.getStatus()==1||project.getStatus()==3){
					Iteration	iteration = iterationService.getObjectById(project.getIterationId());
					//如果迭代不为空，那么才可以进行迭代数据的操作
					if (iteration!=null){
						iteration.setGoingUsers(iteration.getGoingUsers()-1);
						iterationService.update(iteration);
					}
				}

			}
			log.info("add userTeamRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete userTeamRelation error,id is  " + id);
			model.addAttribute("code", -6004);
		}
		return "/data/json";
	}
	
	//组员列表
	@RequestMapping(value = "/a/u/members/search", method = RequestMethod.GET)
	public String getMultiUserTeamRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page, Integer size,
						Long uid,String nick,Long oid,Long tid)
			throws Exception {

		log.info("uid"+uid+"nick"+nick+"oid"+oid);
		/* 1 默认分页 */
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		try {
			//初始值
			List<Long> userIdList = new ArrayList<>();
			List<Long> teamIdList = new ArrayList<>();
			Long total =0L;
			//动态查询
			Map<String,Object> paramList = DynamicUtil.getMembersListParam(uid,nick,oid,tid,false);
			log.info("paramList size =" + paramList.size());
			//获取组员Id列表
			List<Long> membersIdList = userTeamRelationService.getIdsByDynamicCondition(UserTeamRelation.class,paramList,start,size);
			//获取total
			Map<String,Object> paramCount = DynamicUtil.getMembersListParam(uid,nick,oid,tid,true);
			List<Long> membersIdCount = userTeamRelationService.getIdsByDynamicCondition(UserTeamRelation.class,paramCount, 0, Integer.MAX_VALUE);
			if (CollectionUtils.isNotEmpty(membersIdCount)) {
				total = membersIdCount.get(0);
			}
			//获取组员列表
			List<UserTeamRelation> userTeamRelationList = userTeamRelationService.getObjectsByIds(membersIdList);
			log.info("get  userTeamRelation data is " + userTeamRelationList.size());

			//获取userIdList
			//获取teamIdList
			int membersSize = userTeamRelationList.size();
			for (int i=0;i<membersSize;i++){
				UserTeamRelation members = userTeamRelationList.get(i);
				userIdList.add(members.getUid());
				teamIdList.add(members.getTid());
			}
			//获取userList
			List<User> userList = userService.getObjectsByIds(userIdList);
			//获取teamList
			List<Team> teamList = teamService.getObjectsByIds(teamIdList);



			model.addAttribute("code", 0);
			model.addAttribute("total",total);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("userTeamRelationList", userTeamRelationList);
			model.addAttribute("users",userList);
			model.addAttribute("teams",teamList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userTeamRelation list error " );
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userTeamRelation/json/userTeamRelationListJson";
	}
	
	
	
	
	
}

