package com.ptteng.controller;

//import com.fasterxml.jackson.databind.ObjectMapper;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.json.GsonUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.DocumentService;
import com.ptteng.common.skill.service.SkillService;
import com.ptteng.common.skill.service.UserDocumentRelationService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.model.DocumentEx;
import com.ptteng.util.DynamicUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Document  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class DocumentController {
    private static final Log log = LogFactory.getLog(DocumentController.class);

    private StringBuffer logBuf = new StringBuffer();

    @Autowired
    private UserService userService;

    @Autowired
    private DocumentService documentService;

    @Autowired
    private SkillService skillService;

    @Autowired
    private UserDocumentRelationService userDocumentRelationService;


    //30、新增文档
    @RequestMapping(value = "/a/u/document", method = RequestMethod.POST)
    public String addDocument(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                              Long oid, Long sid, Integer type, String url, String introduce, String resource,
                              String documentName, String img, String writer) throws Exception {

        try {

            Boolean checkParam = this.judgeNecessaryTradition(oid, sid, type, url, introduce, resource, documentName, img, writer);
            if (checkParam) {
                log.info(" some necessary params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            Document documentObj = this.createDocumentObj(oid, sid, type, url, introduce, resource, documentName, img, writer);

            Manager manager = (Manager) request.getAttribute("manager");

            log.info("manager========" + manager);

            Long uid = manager.getId();

            log.info("documentObj: " + documentObj);

            Skill skill = skillService.getObjectById(sid);//取得对应Skill
            if (skill != null) {
                if (type == Document.Type_Document)    //如果是文档，Skill对应文档数加1
                    skill.setDocumentCount(skill.getDocumentCount() + 1);
                if (type == Document.Type_Video)        //如果是视频，Skill对应视频数加1
                    skill.setVideoCount(skill.getVideoCount() + 1);
                if (!skillService.update(skill)) {
                    log.info("update skill error, sid: " + sid);
                }
            }

            documentObj.setAuthor(uid);
            documentObj.setLove(0L);

            log.info("user : " + uid + " insert :" + documentObj);

            Long documentId = documentService.insert(documentObj);
            if (documentId == null) {
                log.info("add document error :documentId == null");
                model.addAttribute("code", -1);
                return "/common/success";
            }
            model.addAttribute("code", 0);
            model.addAttribute("documentId", documentId);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add document error :runtime error");
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/document/json/addDocumentJson";
    }

    //31、搜索文档
    @RequestMapping(value = "/a/document/search/query", method = RequestMethod.GET)
    public String searchDocument(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                   Integer type, Long oid, Long[] sid, String name, String mobile, String nick,
                                   Integer page, Integer size)  throws Exception {

        if (null == type) {
            log.info("type is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;

        
        logBuf.append("get oid: ");
        logBuf.append(oid);
        logBuf.append(", get sid: ");
        logBuf.append(sid);
        logBuf.append(",  get type: ");
        logBuf.append(type);
        logBuf.append(",  get name: ");
        logBuf.append(name);
        logBuf.append(",  get mobile: ");
        logBuf.append(mobile);
        logBuf.append(",  get nick: ");
        logBuf.append(nick);
        log.info(logBuf.toString());
        logBuf.setLength(0);
        

        try {
            //获取单页的documentIds
            Map<String, Object> param = DynamicUtil.getDocumentQueryListParam(type, oid, sid, name, mobile, nick, false);
            log.info("query document_id sql: " + param);
            List<Long> documentIds = this.documentService.getIdsByDynamicCondition(Document.class, param, start, size);

            log.info("documentIds has:" + documentIds);
            //获取匹配的单页document类
            List<Document> documents = documentService.getObjectsByIds(documentIds);

            //统计技能名、作者名、收藏数
            List<DocumentEx> documentExs = new ArrayList<>();
            List<Long> uids = new ArrayList<>(),
                       sids = new ArrayList<>();
            Map<Long, String> authorNames = new HashMap<>(),
                              skillNames = new HashMap<>();

            for (Document document: documents) {
                DocumentEx documentEx = new DocumentEx(document);
                uids.add(document.getAuthor());
                sids.add(document.getSid());
                documentExs.add(documentEx);
            }

            //获取文档、视频关联技能名称LIST
            List<Skill> skills = skillService.getObjectsByIds(sids);
            for (Skill skill: skills) {
                skillNames.put(skill.getId(), skill.getName());
            }

            //获取作者名LIST
            List<User> users = userService.getObjectsByIds(uids);
            for (User user: users) {
                authorNames.put(user.getId(), user.getNick());
            }

            for (DocumentEx documentEx: documentExs) {
                Long skillId = documentEx.getDocument().getSid();
                String skillName = skillNames.get(skillId);
                documentEx.setSkillName(skillName);

                Long author = documentEx.getDocument().getAuthor();
                String authorName = authorNames.get(author);
                documentEx.setAuthorName(authorName);
            }

            //获取total
            Map<String, Object> paramCountDocument = DynamicUtil.getDocumentQueryListParam(type, oid, sid, name, mobile, nick, true);
            log.info("count document sql: " + param);
            List<Long> totalList = this.documentService.getIdsByDynamicCondition(Document.class, paramCountDocument, 0, Integer.MAX_VALUE);
            log.info("totalList is " + totalList);
            Integer total = totalList.get(0).intValue();


//            Map<Long, String> sid_name = new HashMap<>();
//            for (Document document : documents) {
//                if(document.getType()==3)
//                    continue;
//                Long skillId = document.getSid();
//                Skill skill = skillService.getObjectById(skillId);
//                if (skill == null) {
//                    log.info("documentId:  "+ document.getId() + " sid: " + skillId + " is null");
//                } else {
//                    String skillName = skill.getName();
//                    sid_name.put(skillId, skillName);
//                }
//            }


            //获取各documentId对应的收藏数
//            Map<Long, Integer> collections = new HashMap<>();
//            for (Long documentId: documentIds){
//                Map<String, Object> paramCountCollection = DynamicUtil.getUserDocumentRelationCountListParam(documentId);
//                List<Long> totalCollection = this.userDocumentRelationService.getIdsByDynamicCondition(UserDocumentRelation.class, paramCountCollection, 0, Integer.MAX_VALUE);
//                Integer collection = totalCollection.get(0).intValue();
//                collections.put(documentId, collection);
//            }

            boolean next = false;
            if (total > end) {
                next = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("message", "success");
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", total);
            model.addAttribute("documentExs", documentExs);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get skill document error,oid= " + oid);
            model.addAttribute("code", -1);
            model.addAttribute("message", "failed");
        }

        return "/common-skill-service/document/json/documentExListJson";
    }

    //32、修改文档
    @RequestMapping(value = "/a/u/document/{did}", method = RequestMethod.PUT)
    public String updateDocument(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long did,
                                 Long oid, Long sid, Integer type, String url, String introduce, String resource,
                                 String documentName, String img, String writer) throws Exception {

        log.info("ready to update document id: " + did);

        if (did == null) {
            log.info("params is null");
            model.addAttribute("code", -1000);
            model.addAttribute("message", "document_id is null");
            return "/common/success";
        }

        try {

            Boolean checkParam = this.judgeNecessaryTradition(oid, sid, type, url, introduce, resource, documentName, img, writer);
            if (checkParam) {
                log.info(" some necessary params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            Document documentOld = this.documentService.getObjectById(did);
            Document documentNew = this.createDocumentObj(oid, sid, type, url, introduce, resource, documentName, img, writer);

            documentNew.setId(documentOld.getId());
            documentNew.setLove(documentOld.getLove());
            documentNew.setAuthor(documentOld.getAuthor());
            documentNew.setCreateAt(documentOld.getCreateAt());

            log.info("documentNew detail:" + documentNew);

            documentService.update(documentNew);

            if (type == 1 || type == 2) {
                if (skillRelatedToDocument(documentOld, documentNew)) {
                    log.info("table skill has been changed for the update");
                } else {
                    log.info("table skill hasn`t been changed");
                }
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update document error ");
            model.addAttribute("code", -1);
            model.addAttribute("message", "update document error");
        }

        return "/common/success";
    }

    //33、删除文档
    @RequestMapping(value = "/a/u/document", method = RequestMethod.DELETE)
    public String deleteDocument(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                              Long[] dids) throws Exception {

        log.info("ready to delete document id: " + dids);

        if (dids == null || dids.length == 0) {
            log.info("params is null");
            model.addAttribute("code", -1000);
            model.addAttribute("message", "document_id is null");
            return "/common/success";
        }

        try {
            List<Long> deleteDocuments = new ArrayList<>();
            for (Long did: dids){
                //去掉数组中为空的情况
                if (did != null){
                    Document document = this.documentService.getObjectById(did);
                    //仅删除成功的document才做关联性处理
                    if (this.documentService.delete(did)) {
                        deleteDocuments.add(did);
                        //去掉技能中统计数
                        Integer type = document.getType();		//取得文档类型
                        Long sid = document.getSid();			//取得文档对应技能id
                        if(sid != null) {
                            Skill skill = skillService.getObjectById(sid);//取得对应Skill
                            if(skill != null) {
                                if(type == Document.Type_Document)	//如果是文档，Skill对应文档数加1
                                    skill.setDocumentCount(skill.getDocumentCount() - 1);
                                if(type == Document.Type_Video)		//如果是视频，Skill对应视频数加1
                                    skill.setVideoCount(skill.getVideoCount() - 1);
                                if(!skillService.update(skill)) {
                                    log.info("update skill error, sid: " + sid);
                                }
                            }
                        }
                    }
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("message", "success delete document_ids:" + deleteDocuments);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete document error");
            model.addAttribute("code", -1);
            model.addAttribute("message", "delete document error");
        }

        return "/common/success";
    }

    //34、详细文档
    @RequestMapping(value = "/a/document/detail", method = RequestMethod.GET)
    public String getSkillDocument(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long did) throws Exception {

        if (did.equals(null)) {
            log.info("did is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        log.info("get document detail:" + did);

        try {

            Document document = this.documentService.getObjectById(did);
            DocumentEx documentEx = new DocumentEx(document);

            log.info("document detail: " + document);

            Long author = document.getAuthor();
            User user = this.userService.getObjectById(author);
            String authorName = user.getNick();
            documentEx.setAuthorName(authorName);

            log.info("author detail: " + user);

            //收藏数
//            Long collection = null;
//            Map<String, Object> param = DynamicUtil.getCollectionRelationListParam(did, 2, 1, true);
//            log.info("count document_id sql: " + param);
//            List<Long> relationIds = this.documentService.getIdsByDynamicCondition(UserDocumentRelation.class, param, 0, Integer.MAX_VALUE);
//
//            if(CollectionUtils.isEmpty(relationIds)) {
//                collection = 0L;
//            } else {
//                collection = relationIds.get(0);
//            }
//            log.info("collect detail: " + collection);
//            documentEx.setCollection(collection);

            //技能名,如果是书籍的时候不关联技能名
            Integer type = document.getType();
            if (type != 3) {
                Long sid = document.getSid();
                Skill skill = this.skillService.getObjectById(sid);
                String skillName = skill.getName();
                log.info("skillName detail: " + skillName);
                documentEx.setSkillName(skillName);
            } else {
                documentEx.setSkillName(null);
            }

            model.addAttribute("code", 0);
            model.addAttribute("message", "success");
            model.addAttribute("documentEx", documentEx);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get document error,did = " + did);
            model.addAttribute("code", -1);
            model.addAttribute("message", "failed");
        }

        return "/common-skill-service/document/json/documentExDetailJson";
    }


    //修改文档对于skill表统计字段的影响，true代表有影响，false代表没有
    public Boolean skillRelatedToDocument(Document documentOld, Document documentNew) throws ServiceException, ServiceDaoException {
        //取得文档类型
        Integer typeOld = documentOld.getType();
        Integer typeNew = documentNew.getType();
        //取得文档对应技能id
        Long sidOld = documentOld.getSid();
        Long sidNew = documentNew.getSid();

        if (sidNew != sidOld){
            Skill skillOld = skillService.getObjectById(sidOld);
            Skill skillNew = skillService.getObjectById(sidNew);

            if (typeNew != typeOld){
                if(typeNew == 1){
                    Integer skillOldVideoCount = skillOld.getVideoCount() - 1;
                    skillOld.setVideoCount(skillOldVideoCount);

                    Integer skillNewDocumentCount = skillNew.getDocumentCount() + 1;
                    skillNew.setDocumentCount(skillNewDocumentCount);
                }else {
                    Integer skillOldDocumentCount = skillOld.getDocumentCount() - 1;
                    skillOld.setVideoCount(skillOldDocumentCount);

                    Integer skillNewVideoCount = skillNew.getVideoCount() + 1;
                    skillNew.setDocumentCount(skillNewVideoCount);
                }
            }else {
                if(typeNew == 1){
                    Integer skillOldDocumentCount = skillOld.getDocumentCount() - 1;
                    skillOld.setVideoCount(skillOldDocumentCount);

                    Integer skillNewDocumentCount = skillNew.getDocumentCount() + 1;
                    skillNew.setDocumentCount(skillNewDocumentCount);
                }else {
                    Integer skillOldVideoCount = skillOld.getVideoCount() - 1;
                    skillOld.setVideoCount(skillOldVideoCount);

                    Integer skillNewVideoCount = skillNew.getVideoCount() + 1;
                    skillNew.setDocumentCount(skillNewVideoCount);
                }
            }

            if (!skillService.update(skillOld)){
                log.info("update oid skill error, sid: " + sidOld);
            }

            if (!skillService.update(skillNew)){
                log.info("update new skill error, sid: " + sidNew);
            }

        }else {
            Skill skill = skillService.getObjectById(sidNew);

            if (typeNew != typeOld){
                if(typeNew == 1){
                    Integer videoCount = skill.getVideoCount() - 1;
                    skill.setVideoCount(videoCount);

                    Integer documentCount = skill.getDocumentCount() + 1;
                    skill.setDocumentCount(documentCount);
                }else {
                    Integer documentCount = skill.getDocumentCount() - 1;
                    skill.setDocumentCount(documentCount);

                    Integer videoCount = skill.getVideoCount() + 1;
                    skill.setVideoCount(videoCount);
                }
                if (!skillService.update(skill)){
                    log.info("update skill error, sid: " + sidNew);
                }
            }else {
                log.info("Table skill doesn`t need to change.");

                return false;
            }
        }

        return true;
    }


    public boolean judgeNecessaryTradition(Long oid, Long sid, Integer type, String url, String introduce, String resource,
                                           String documentName, String img, String writer) {

        logBuf.append(" add a document oid=");
        logBuf.append(oid);
        logBuf.append(" sid=");
        logBuf.append(sid);
        logBuf.append(" type=");
        logBuf.append(type);
        logBuf.append(" url=");
        logBuf.append(url);
        logBuf.append(" introduce=");
        logBuf.append(introduce);
        logBuf.append(" resource=");
        logBuf.append(resource);
        logBuf.append(" documentName=");
        logBuf.append(documentName);
        logBuf.append(" img=");
        logBuf.append(img);
        logBuf.append(" writer=");
        logBuf.append(writer);
        log.info(logBuf.toString());
        logBuf.setLength(0);

        Boolean result = false;

        if (null == oid) {
            result = true;
        }

        if(null == type) {
            result = true;
        }

        switch (type) {
            case 3:
                break;
            default:

                if (null == sid) {
                    result = true;
                }
        }

        if(StringUtils.isBlank(url)) {
            result = true;
        }

        if(StringUtils.isBlank(introduce)) {
            result = true;
        }

        if(StringUtils.isBlank(resource)) {
            result = true;
        }

        if(StringUtils.isBlank(documentName)) {
            result = true;
        }

        if (type == 3) {
            if (StringUtils.isBlank(img)) {
                result = true;
            }

            if (StringUtils.isBlank(writer)) {
                result = true;
            }
        }

        return result;
    }

    public Document createDocumentObj(Long oid, Long sid, Integer type, String url, String introduce, String resource,
                                      String documentName, String img, String writer) {

        Document documentObj = new Document();

        documentObj.setOid(oid);
        documentObj.setSid(sid);
        documentObj.setType(type);
        documentObj.setUrl(url);
        documentObj.setIntroduce(introduce);
        documentObj.setResource(resource);
        documentObj.setDocumentName(documentName);

        if (type == 3) {
            documentObj.setImg(img);
            documentObj.setWriter(writer);
        }

        return documentObj;
    }
}

