package com.ptteng.util;

import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.model.UserArticleRelation;
import com.qding.common.util.DataUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.*;

/**
 * Created by liangxj on 2015/9/7.
 */
public class DynamicUtil {

    private static final Log log = LogFactory.getLog(DynamicUtil.class);

    public static void checkUserGraduateStatus(List<User> users) {
        Long now = System.currentTimeMillis();
        for (User user : users) {
            Long graduateAt = user.getGraduateAt();
            if (DataUtils.isNullOrEmpty(graduateAt)) {
                log.info(" user graduateAt is null ,so he dosen't graduate ");
                user.setGraduated(false);
            } else {
                if (graduateAt <= now) {
                    log.info(" user graduateAt<=now ,so he has graduated ");
                    user.setGraduated(true);
                } else {
                    log.info(" user graduateAt>now , so he dosen't graduate ");
                    user.setGraduated(false);
                }
            }

        }
    }

    /**
     * 查找师兄，用来分配给师弟师兄
     *
     * @param oid
     * @param identify
     * @param orderBy
     * @param count
     * @return
     */
    public static Map<String, Object> getTeacherInfoListParam(Long oid, Integer identify, String orderBy, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();

        tables.add("user");
        tables.add("teacher");

        if (CheckDataUtil.isNotNull(oid)) {
            if (Occupation.CSS_ID.equals(oid)) {
                params.put("user.oid & in ", "(" + Occupation.CSS_ID + "," + Occupation.JS_ID + ")");

            } else {
                params.put("user.oid", oid);
            }
        }
        //只有为结业的可作为师兄，已结业不可
        params.put("(user.graduate_at & > ", System.currentTimeMillis() + " or user.graduate_at is null )");
        //只有正常状态的用户可以作为师兄，退学用户不可
        params.put("user.status", User.Status_Student);
        if (count) {
            params.put("@query", " count(user.id) ");

        } else {
            params.put("@query", " user.id ");
        }


        params.put("user.id", "teacher.id");
        params.put("user.identity", identify);
        params.put("@order", " teacher." + orderBy);

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;


    }


    public static Map<String, Object> getHisStudentRelationListParam(Long teacherId, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();


        if (CheckDataUtil.isNotNull(teacherId)) {
            params.put("teacher_id", teacherId);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", "  id ");
        }

        params.put("@table", "user");

        return params;
    }

    public static Map<String, Object> getCollectionRelationListParam(Long did, Integer status, Integer whether, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (status != null) {
            params.put("status", status);
        }

        if (whether != null) {
            params.put("whether", whether);
        }

        if (did != null) {
            params.put("did", did);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@query", " id ");
        }

        params.put("@table", "userDocumentRelation");

        return params;
    }


    public static Map<String, Object> getSolutionListParam(Long startAt, Long endAt, String type, String createBy, String source, String status, Boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();


        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put(" update_at & >= ", "'" + startAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put(" update_at & <= ", "'" + endAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }
        if (DataUtils.isNotNullOrEmpty(createBy)) {
            params.put("create_by", "'" + createBy + "'");
        }
        if (DataUtils.isNotNullOrEmpty(source)) {
            params.put("source", " '" + source + "' ");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);

        }


        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", " id ");
        }
        params.put("@table", "  article ");

        return params;
    }


    public static Map<String, Object> getQaListParam(Long oid, Long tid, Boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(oid))
            params.put(" oid  ", "" + oid + "");

        if (DataUtils.isNotNullOrEmpty(tid))
            params.put(" tid  ", "" + tid + "");


        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " update_at desc ");
            params.put("@query", " id ");
        }

        params.put("@table", " qa ");

        return params;
    }


    public static Map<String, Object> getServertListParam(Integer type, String support, String deploy, String serverIp, Boolean count) {


        log.info("start select from servert");
        Map<String, Object> params = new HashMap<String, Object>();


        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" type", "'" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(deploy)) {
            params.put("deploy", deploy);
        }

        if (DataUtils.isNotNullOrEmpty(serverIp)) {
            params.put("server_ip &like", "'%" + serverIp + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(support)) {
            params.put("support", " '" + support + "' ");
        }

        log.info("===========");
        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", " id ");
        }
        params.put("@table", "  servert ");

        return params;
    }


    public static Map<String, Object> getOrdertListParam(Integer type, String mobile, Integer status, Long startTime, Long endTime, String name, Boolean count) {


        log.info("start select from order");
        Map<String, Object> params = new HashMap<String, Object>();


        Set<String> tables = new HashSet();
        tables.add("t_order");

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" type", "'" + type + "'");
        }


        if (DataUtils.isNotNullOrEmpty(status)) {

            if (status == 10) {

                if (DataUtils.isNotNullOrEmpty(status)) {
                    params.put("status &<>", 2);
                }

            } else {
                if (DataUtils.isNotNullOrEmpty(status)) {
                    params.put("status", status);
                }


            }

        }


        if (DataUtils.isNotNullOrEmpty(mobile)) {
            params.put("mobile &like", "'%" + mobile + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(name)) {

            if (DataUtils.isNotNullOrEmpty(name)) {
                params.put("user.nick", "'%" + name + "%'");
            }
            params.put("t_order.buyer", "user.id");
            tables.add("user");
        }

        if (DataUtils.isNotNullOrEmpty(startTime)) {
            params.put("buy_time & >=", startTime);
        }

        if (DataUtils.isNotNullOrEmpty(endTime)) {
            params.put("buy_time & <=", endTime);
        }

        log.info("===========");
        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", " t_order.id ");
        }
        params.put("@table", "  t_order ");

        return params;
    }


    public static Map<String, Object> getAccountListParam(Integer type, String support, String deploy, String serverIp, Boolean count, String account, Integer status) {


        log.info("start select from account");
        Map<String, Object> params = new HashMap<String, Object>();


        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" type & = ", "'" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(deploy)) {
            params.put("deploy", deploy);
        }

        if (DataUtils.isNotNullOrEmpty(serverIp)) {
            params.put("server_ip &like", "'%" + serverIp + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(support)) {
            params.put("support", " '" + support + "' ");
        }

        if (DataUtils.isNotNullOrEmpty(account)) {
            params.put("account & like ", "'%" + account + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", " '" + status + "' ");
        }


        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", " id ");
        }
        params.put("@table", "  account ");

        return params;
    }

    public static Map<String, Object> getClassListParam(Long oid, String name, String type, Integer branch, Long startAt, Long endAt, Boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(oid)) {
            params.put("oid", oid);
        }
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name", "'" + name + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", "'" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(branch)) {
            params.put("branch", branch);
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put("create_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put("create_at & <=", endAt);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  create_at desc ");
            params.put("@query", " id ");
        }
        params.put("@table", "  classes ");
        return params;
    }


    public static Map<String, Object> getOccupatoinListParam(Long id,
                                                             String name, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(id)) {
            params.put("id", id);
        }
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name", "'" + name + "'");
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", " id ");
        }
        params.put("@table", "occupation");
        return params;
    }



    public static Map<String, Object> getUserListParam(Long oid, String type, Long studyNum, Integer status, String mobile,
                                                       String nick, Long startAt, Long endAt, Integer identity,
                                                       Long graduateStartAt, Long graduateEndAt, Integer branch,
                                                       Long recommendId, String recommendMobile, Long teacherId, boolean count) {
        log.info(" teacher id = " + teacherId);
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();

        tables.add("user a");

        if (DataUtils.isNotNullOrEmpty(teacherId)) {
            params.put("a.teacher_id", teacherId);
        }
        if (DataUtils.isNotNullOrEmpty(branch)) {
            params.put("a.branch", branch);
        }

        if (DataUtils.isNotNullOrEmpty(oid)) {
            params.put("a.oid", oid);
        }

        if (StringUtils.isNotBlank(nick)) {
            params.put(" a.nick & like ", "'%" + nick + "%'");
        }

        if (StringUtils.isNotBlank(mobile)) {
            params.put(" a.mobile & like ", "'%" + mobile + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("a.status", status);
        }

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("a.type", "'" + type + "'");
        }

        if (DataUtils.isNotNullOrEmpty(studyNum)) {
            params.put("a.study_number", studyNum);
        }

        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put(" a.start_at & > ", startAt);
        }

        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put(" a.start_at & < ", endAt);
        }
        if (DataUtils.isNotNullOrEmpty(identity)) {
            params.put("a.identity", identity);

        }
        if (DataUtils.isNotNullOrEmpty(graduateStartAt)) {
            params.put("a.graduate_at & >= ", graduateStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(graduateEndAt)) {
            params.put("a.graduate_at & <=", graduateEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(recommendId)) {
            params.put("a.recommend_id", recommendId);
        }
        if (StringUtils.isNotEmpty(recommendMobile)) {
            tables.add("user b");
            params.put("a.recommend_id", "b.id");
            params.put("b.mobile", recommendMobile);
        }

        if (count) {

            params.put("@query", " count(a.id) ");

        } else {

            params.put("@order", " a.start_at desc ");

            params.put("@query", " a.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }


    public static Map<String, Object> getTeacherListParam(Long oid, Integer status, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(oid)) {
            switch (oid.intValue()) {
                case 1:
                    params.put(" oid & in", "(1,2)");
                    break;
                case 2:
                    params.put(" oid & in", "(1,2)");
                    break;
                default:
                    params.put("oid", oid);
            }
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        } else {
            params.put(" status & >= ", 0);
        }

        if (count) {

            params.put("@query", " count(id) ");

        } else {

            params.put("@query", " id ");
        }


        params.put("@table", "user");

        return params;
    }


    public static Map<String, Object> getDocumentListParam(Long sid, int type) {        //在document表中获取sid和type所对应的文档或视频的id
        Map<String, Object> params = new HashMap<String, Object>();

        params.put("document.sid", sid);
        params.put("document.type", type);
        params.put("@query", " id");
        params.put("@table", "document");

        return params;
    }

    public static Map<String, Object> getDocumentQueryListParam(Integer type, Long oid, Long[] sids,
                                                                String name, String mobile, String nick, boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("document d ");

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("d.type", type);
        }

        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        if (sids != null) {
            for (Long sid : sids) {
                if (sid != null) {
                    sbuf.append(sid.toString());
                    sbuf.append(",");
                    i++;
                }
            }
        }

        //存在sid时，使用sid做匹配，不用oid；否则使用oid匹配
        if (i > 0) {
            sbuf.deleteCharAt(sbuf.length() - 1);
            params.put("d.sid & in ", "(" + sbuf.toString() + ")");
        } else if (DataUtils.isNotNullOrEmpty(oid)) {
            params.put("d.oid", oid);
        }

        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("d.document_name & like ", "'%" + name + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(mobile)) {
            tables.add("user u ");
            params.put("u.id", "d.author");
            params.put("u.mobile", "'" + mobile + "'");

        } else if (DataUtils.isNotNullOrEmpty(nick)) {
            tables.add("user u ");
            params.put("u.id", "d.author");
            params.put(" u.nick & like ", "'%" + nick + "%'");
        } else {

        }

        if (isCount) {
            params.put("@query", " count(d.id) ");
        } else {
            params.put("@order", "  d.update_at desc ");
            params.put("@query", " d.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }

    public static Map<String, Object> getTaskSkillRelationListParam(Long sid) {        //在task_skill_relation表中根据sid获取关系id
        Map<String, Object> params = new HashMap<String, Object>();

        params.put("task_skill_relation.sid", sid);
        params.put("@query", " id");
        params.put("@table", "task_skill_relation");

        return params;
    }

    public static Map<String, Object> getUserDocumentRelationCountListParam(Long document_id) {        //在task_skill_relation表中根据sid获取关系id
        Map<String, Object> params = new HashMap<String, Object>();

        params.put("document_id", document_id);
        params.put("status", 2);
        params.put("whether", 1);
        params.put("@query", " count(id) ");
        params.put("@table", "user_document_relation");

        return params;
    }

    public static Map<String, Object> getArticleListByParam(Long uid, Long tid, Long cid, Long oid,
                                                            Long createAt, Long endAt, boolean direction, Integer orderBy, Integer sort,
                                                            Integer evaluation, String userType, Long userOid, Integer studyNumber,
                                                            boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("article");


        if (uid != null) {

            params.put("article.uid", uid);

        }


        if (tid != null) {

            params.put("article_task_relation.tid", tid);
            params.put("article.id", "article_task_relation.did");
            tables.add("article_task_relation");

        }

        if (cid != null) {

            params.put("article.cid", cid);

        }


        if (oid != null) {

            params.put("article.oid", oid);

        }


        if (createAt != null) {
            params.put("article.create_at & >= ", createAt);
        }


        if (endAt != null) {
            params.put("article.create_at & <= ", endAt);


        }

        if (DataUtils.isNotNullOrEmpty(evaluation)) {
            params.put(" article.evaluation", "'" + evaluation + "'");
        }
        if (DataUtils.isNotNullOrEmpty(userType)
                || DataUtils.isNotNullOrEmpty(userOid)
                || DataUtils.isNotNullOrEmpty(studyNumber)) {
            tables.add("user");
            params.put("article.uid ", "user.id");
            if (DataUtils.isNotNullOrEmpty(userType)) {
                params.put("user.type ", "'" + userType + "'");
            }
            if (DataUtils.isNotNullOrEmpty(userOid)) {
                params.put(" user.oid ", userOid);
            }
            if (DataUtils.isNotNullOrEmpty(studyNumber)) {
                params.put("user.study_number ", studyNumber);
            }
        }


        if (count) {
            params.put("@query", " count(article.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  article.love ");
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  article.collection ");
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  article.create_at ");
            } else if (UserArticleRelation.COMMENT == orderBy) {
                a.append("  article.reply ");
            } else if (UserArticleRelation.READ == orderBy) {
                a.append("  article.read_count ");
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " article.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

    public static Map<String,Object> getQueryBranchList(String name, Long uid,
                                                        String qq, Integer period, String phone, String url, String address, Integer status, String nick, boolean isCount){


        Map<String,Object> params = new HashMap<String,Object>();
        Set<String> tables = new HashSet();
        tables.add("branch_institute b");
        tables.add("user u");

        if(DataUtils.isNotNullOrEmpty(name)){
            params.put("b.name & like","'%" + name + "%'");
        }

        if(DataUtils.isNotNullOrEmpty(nick)){

            params.put("u.nick & like","'%" + nick + "%'");
        }

        if (uid != null) {

            params.put("b.uid",uid);

        }



        if (DataUtils.isNotNullOrEmpty(qq)) {
            params.put("b.qq", qq);

        }
        if (DataUtils.isNotNullOrEmpty(period)) {
            params.put("b.period", period);
        }




        if (DataUtils.isNotNullOrEmpty(phone)) {
            params.put("b.phone", status);
        }

        if (DataUtils.isNotNullOrEmpty(url)) {
            params.put("b.url",url);
        }

        if (DataUtils.isNotNullOrEmpty(address)) {
            params.put("b.address", address);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("b.status", status);
        }

        params.put("b.uid", "u.id");

        if (isCount) {
            params.put("@query", "count(b.id) ");
        } else {
            params.put("@order", "b.update_at desc ");
            params.put("@query", "b.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }


    public static Map<String, Object> getContentsQueryListParam(Integer[] type,
                                                                Integer status,
                                                                String title,
                                                                Long createBy,
                                                                Long createStartAt,
                                                                Long createEndAt,
                                                                Long publishStartAt,
                                                                Long publishEndAt, boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();


        if (DataUtils.isNotNullOrEmpty(type)) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            if (type != null) {
                for (Integer t : type) {
                    if (t != null) {
                        sb.append(t.toString());
                        sb.append(",");
                        i++;
                    }
                }
            }
            sb.deleteCharAt(sb.length() - 1);
            params.put("type & in ", "(" + sb.toString() + ")");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("title", "'" + title + "'");
        }
        if (DataUtils.isNotNullOrEmpty(createBy)) {
            params.put("create_by", createBy);
        }
        if (DataUtils.isNotNullOrEmpty(createStartAt)) {
            params.put("create_at & >=", createStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(createEndAt)) {
            params.put("create_at & <=", createEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(publishStartAt)) {
            params.put("publish_at & >=", publishStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(publishEndAt)) {
            params.put("publish_at & <=", publishEndAt);
        }


        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "update_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "contents ");

        return params;
    }


    public static Map<String, Object> getUserListParam2(String nick) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(nick)) {
            params.put("nick & like", "'%" + nick + "%'");
        }


        return params;
    }

    //查询请假列表
    public static Map<String, Object> getLeavesListParam(Long uid,String nick, Long oid, Integer identity, String type,
                                                         Long startAt, Long endAt, boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from user and leaves ");
        tables.add("user user");
        tables.add("leaves leaves");
        params.put( "leaves.uid","user.id");

        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("user.id", uid);
        }

        if (StringUtils.isNotBlank(nick)) {
            params.put(" user.nick & like ", "'%" + nick + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(oid)) {
            params.put("user.oid", oid);
        }
        if (DataUtils.isNotNullOrEmpty(identity)) {
            params.put("user.identity", identity);
        }
        if (StringUtils.isNotBlank(type)) {
            params.put("user.type", "'" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put("leaves.start_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put("leaves.start_at &  <= ", endAt);
        }

        if (count) {
            params.put("@query", " count(leaves.id) ");
        } else {
            params.put("@order", " leaves.start_at desc ");
            params.put("@query", " leaves.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    //获取积分记录
    public static Map<String, Object> getScoresListParam(Long uid,String nick, Long oid, Integer identity, String type,
                                                         Long startAt, Long endAt,Integer scoreType,Long score, boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from user and user_score ");
        tables.add("user user");
        tables.add("user_score scores");
        params.put("user.id", "scores.uid");

        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("scores.uid", uid);
        }
        if (StringUtils.isNotBlank(nick)) {
            params.put(" user.nick & like ", "'%" + nick + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(oid)) {
            params.put("user.oid", oid);
        }
        if (DataUtils.isNotNullOrEmpty(identity)) {
            params.put("user.identity", identity);
        }
        if (StringUtils.isNotBlank(type)) {
            params.put("user.type", "'" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put("scores.create_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put("scores.create_at &  <= ", endAt);
        }
        if (DataUtils.isNotNullOrEmpty(scoreType)){
            params.put("scores.scoreType",scoreType);
        }
        if (DataUtils.isNotNullOrEmpty(score)){
            params.put("scores.score",score);
        }


        if (count) {
            params.put("@query", " count(scores.id) ");
        } else {
            params.put("@order", " scores.create_at desc ");
            params.put("@query", " scores.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }
    //查询常量列表
    public static Map<String, Object> getConstantListParam(String type,String name,String value, String comments,Long startAt, Long endAt, boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from constant");
        tables.add("constant");

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" type & like ", "'%" + type + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put(" name & like ", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(value)) {
            params.put(" value & like ", "'%" + value + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(comments)) {
            params.put(" comments & like ", "'%" + comments + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put("leaves.create_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put("leaves.create_at &  <= ", endAt);
        }
        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " create_at desc ");
            params.put("@query", " id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }



    public static Map<String, Object> getCardsQueryListParam( String code, Long tid,
                                                              Long ownerId,
                                                              Long assignId,
                                                              Long verificationId,
                                                              Long createId,
                                                              Integer status,
                                                              Integer cardValid,
                                                              Integer typeValid,
                                                              Long createStartAt,
                                                              Long createEndAt,
                                                              Long assignStartAt,
                                                              Long assignEndAt,
                                                              Long applyStartAt,
                                                              Long applyEndAt,
                                                              Long verificationStartAt,
                                                              Long verificationEndAt, boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from card");
        tables.add("card");

        if (DataUtils.isNotNullOrEmpty(code)) {
            params.put(" code & like ", "'%" + code + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put(" tid ", tid);
        }
        if (DataUtils.isNotNullOrEmpty(ownerId)) {
            params.put(" owner_id ", ownerId);
        }
        if (DataUtils.isNotNullOrEmpty(assignId)) {
            params.put(" assign_id ", assignId);
        }
        if (DataUtils.isNotNullOrEmpty(verificationId)) {
            params.put(" verification_id ", verificationId);
        }
        if (DataUtils.isNotNullOrEmpty(createId)) {
            params.put(" create_by ", createId);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ", status);
        }
        if (DataUtils.isNotNullOrEmpty(cardValid)) {
            params.put(" card_valid ", cardValid);
        }
        if (DataUtils.isNotNullOrEmpty(typeValid)) {
            params.put(" ctype_valid ", typeValid);
        }
        if (DataUtils.isNotNullOrEmpty(createStartAt)) {
            params.put("create_at & >=", createStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(createEndAt)) {
            params.put("create_at & <=", createEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(assignStartAt)) {
            params.put("assign_at & >=", assignStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(assignEndAt)) {
            params.put("assign_at & <=", assignEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(applyStartAt)) {
            params.put("apply_at & >=", applyStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(applyEndAt)) {
            params.put("apply_at & <=", applyEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(verificationStartAt)) {
            params.put("verification_at & >=", verificationStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(verificationEndAt)) {
            params.put("verification_at & <=", verificationEndAt);
        }

        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "update_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "card ");

        return params;
    }

    public static Map<String, Object> getCardsQueryListByManagerParam( String code, Long tid,
                                                              Long ownerId,
                                                              String assignBy,
                                                              String verificationBy,
                                                              String createBy,
                                                              Integer status,
                                                              Integer cardValid,
                                                              Integer typeValid,
                                                              Long createStartAt,
                                                              Long createEndAt,
                                                              Long assignStartAt,
                                                              Long assignEndAt,
                                                              Long applyStartAt,
                                                              Long applyEndAt,
                                                              Long verificationStartAt,
                                                              Long verificationEndAt, boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from card");
        tables.add("card");

        if (DataUtils.isNotNullOrEmpty(code)) {
            params.put(" code & like ", "'%" + code + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put(" tid ", tid);
        }
//        if (DataUtils.isNotNullOrEmpty(owner)) {
//            params.put(" owner_id & in ","(" + owner+ ")");
//        }
        if (DataUtils.isNotNullOrEmpty(ownerId)) {
            params.put(" owner_id ", ownerId);
        }
        if (DataUtils.isNotNullOrEmpty(assignBy)) {
            params.put("assign_id & in ", "("+assignBy+")");
        }
        if (DataUtils.isNotNullOrEmpty(verificationBy)) {
            params.put(" verification_id & in", "("+verificationBy+")");
        }
        if (DataUtils.isNotNullOrEmpty(createBy)) {
            params.put(" create_by & in ", "("+createBy+")");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ", status);
        }
        if (DataUtils.isNotNullOrEmpty(cardValid)) {
            params.put(" card_valid ", cardValid);
        }
        if (DataUtils.isNotNullOrEmpty(typeValid)) {
            params.put(" ctype_valid ", typeValid);
        }
        if (DataUtils.isNotNullOrEmpty(createStartAt)) {
            params.put("create_at & >=", createStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(createEndAt)) {
            params.put("create_at & <=", createEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(assignStartAt)) {
            params.put("assign_at & >=", assignStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(assignEndAt)) {
            params.put("assign_at & <=", assignEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(applyStartAt)) {
            params.put("apply_at & >=", applyStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(applyEndAt)) {
            params.put("apply_at & <=", applyEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(verificationStartAt)) {
            params.put("verification_at & >=", verificationStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(verificationEndAt)) {
            params.put("verification_at & <=", verificationEndAt);
        }

        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "update_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "card ");

        return params;
    }



    public static Map<String, Object> getClogsQueryListParam(String code, Long tid,
                                                              Long createId,
                                                             Long issueId, Long ownerId, Long cessionId, Long verificationId,
                                                              Integer type,
                                                              Long createStartAt, Long createEndAt,
                                                              Long assignStartAt, Long assignEndAt,Long createBy,Long updateBy,
                                                              Long applyStartAt, Long applyEndAt,
                                                              Long cessionStartAt, Long cessionEndAt,
                                                              Long verificationStartAt, Long verificationEndAt, boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();
        log.info("start select from clog");

        if (DataUtils.isNotNullOrEmpty(code)) {
            params.put(" cid & in ", "(select id from card where code like '%" + code +"%')");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" type ", type);
        }
        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put(" tid ", tid);
        }
        if (DataUtils.isNotNullOrEmpty(verificationId)) {
            params.put(" admin_id", verificationId);
            params.put("type & in", "(4,5)");
        }
        if (DataUtils.isNotNullOrEmpty(issueId)) {
            params.put(" admin_id ", issueId);
//            params.put(" type ", 2);
        }

        if (DataUtils.isNotNullOrEmpty(createId)) {
            params.put(" create_by ", createId);
        }
        if (DataUtils.isNotNullOrEmpty(ownerId)) {
            params.put(" use_id ", ownerId);
        }
        if (DataUtils.isNotNullOrEmpty(cessionId)) {
            params.put(" receive_id ", cessionId);
        }
        if (DataUtils.isNotNullOrEmpty(createStartAt)) {
            params.put("create_at & >=", createStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(createEndAt)) {
            params.put("create_at & <=", createEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(createBy)) {
            params.put("create_by", createBy);
        }
        if (DataUtils.isNotNullOrEmpty(updateBy)) {
            params.put("update_by", updateBy);
        }

        if (DataUtils.isNotNullOrEmpty(assignStartAt)) {
            params.put("create_at & >=", assignStartAt);
            params.put("type", 2);
        }
        if (DataUtils.isNotNullOrEmpty(assignEndAt)) {
            params.put("create_at & <=", assignEndAt);
            params.put("type", 2);
        }
        if (DataUtils.isNotNullOrEmpty(applyStartAt)) {
            params.put("create_at & >=", applyStartAt);
            params.put("type", 3);
        }
        if (DataUtils.isNotNullOrEmpty(applyEndAt)) {
            params.put("create_at & <=", applyEndAt);
            params.put("type", 3);
        }
        if (DataUtils.isNotNullOrEmpty(cessionStartAt)) {
            params.put("create_at & >=", cessionStartAt);
            params.put("type", 6);
        }
        if (DataUtils.isNotNullOrEmpty(cessionEndAt)) {
            params.put("create_at & <=", cessionEndAt);
            params.put("type", 6);
        }
        if (DataUtils.isNotNullOrEmpty(verificationStartAt)) {
            params.put("create_at & >=", verificationStartAt);
            params.put("type & in", "(4,5)");
        }
        if (DataUtils.isNotNullOrEmpty(verificationEndAt)) {
            params.put("create_at & <=", verificationEndAt);
            params.put("type & in", "(4,5)");
        }

        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "create_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "clog");

        return params;
    }

    public  static Map<String, Object> getCardsTypeQueryListParam(String title,
                                                                  Integer status,
                                                                  Long createStarAt,
                                                                  Long createEndAt,
                                                                  String  createBy,
                                                                  boolean count){
        Map<String, Object> params = new HashMap<String, Object>();
        log.info("start select from ctype");
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put(" title & like","'%" + title + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ", status);
        }

        if (DataUtils.isNotNullOrEmpty(createStarAt)) {
            params.put(" create_at & >= ", createStarAt);
        }

        if (DataUtils.isNotNullOrEmpty(createEndAt)) {
            params.put(" create_at & <= ", createEndAt);
        }

        if (DataUtils.isNotNullOrEmpty(createBy)) {
            params.put(" create_by ", createBy );
        }

        if (count){
            params.put("@query", "count(id) ");
        }else {
            params.put("@order", "create_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "ctype");

        return params;
    }

    public  static Map<String, Object> getCardsTypeQueryListByCreateByParam(String title,
                                                                  Integer status,
                                                                  Long createStarAt,
                                                                  Long createEndAt,
                                                                  String  createBy,
                                                                  boolean count){
        Map<String, Object> params = new HashMap<String, Object>();
        log.info("start select from ctype");
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put(" title & like","'%" + title + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ", status);
        }

        if (DataUtils.isNotNullOrEmpty(createStarAt)) {
            params.put(" create_at & >= ", createStarAt);
        }

        if (DataUtils.isNotNullOrEmpty(createEndAt)) {
            params.put(" create_at & <= ", createEndAt);
        }

        if (DataUtils.isNotNullOrEmpty(createBy)) {
            params.put(" create_by & in ", "(" + createBy+")" );
        }

        if (count){
            params.put("@query", "count(id) ");
        }else {
            params.put("@order", "create_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "ctype");

        return params;
    }

    public static Map<String, Object> getCtypeInCardsQueryListParam(Long tid,
                                                                Integer cardValid,
                                                                Integer[] statusArr,
                                                                boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();


        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put("tid", tid);
        }

        if (DataUtils.isNotNullOrEmpty(statusArr)){
            params.put("status & in","("+ org.apache.commons.lang3.StringUtils.join(statusArr,",")+")");
        }

        if (DataUtils.isNotNullOrEmpty(cardValid)) {
            params.put("card_valid", cardValid);
        }

        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "update_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "card ");

        return params;
    }

    public static Map<String ,Object> getCtypeQueryByTitleParam(String title,boolean isCount){

        Map<String, Object> params = new HashMap<String, Object>();


        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("title", title);
        }

        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "update_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "ctype");

        return params;
    }

    public static Map<String, Object> getCardsQueryListInTidByParam(String code, String tid,
                                                                    Long ownerId,
                                                                    Long assignId,
                                                                    Long verificationId,
                                                                    Long createId,
                                                                    Integer status, Integer cardValid,
                                                                    Long assignStartAt, Long assignEndAt,
                                                                    Long applyStartAt, Long applyEndAt,
                                                                    Integer sort,
                                                                    Long verificationStartAt, Long verificationEndAt, boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from card");
        tables.add("card");

        if (DataUtils.isNotNullOrEmpty(code)) {
            params.put(" code & like ", "'%" + code + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put(" tid & in ", "(" + tid + ")");
        }
        if (DataUtils.isNotNullOrEmpty(ownerId)) {
            params.put(" owner_id ", ownerId);
        }
        if (DataUtils.isNotNullOrEmpty(assignId)) {
            params.put(" assign_id ", assignId);
        }
        if (DataUtils.isNotNullOrEmpty(verificationId)) {
            params.put(" verification_id ", verificationId);
        }
        if (DataUtils.isNotNullOrEmpty(createId)) {
            params.put(" create_by ", createId);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ", status);
        }
        if (DataUtils.isNotNullOrEmpty(cardValid)) {
            params.put(" card_valid ", cardValid);
        }
        if (DataUtils.isNotNullOrEmpty(assignStartAt)) {
            params.put("assign_at & >=", assignStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(assignEndAt)) {
            params.put("assign_at & <=", assignEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(applyStartAt)) {
            params.put("apply_at & >=", applyStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(applyEndAt)) {
            params.put("apply_at & <=", applyEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(verificationStartAt)) {
            params.put("verification_at & >=", verificationStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(verificationEndAt)) {
            params.put("verification_at & <=", verificationEndAt);
        }


        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            if (DataUtils.isNotNullOrEmpty(sort)) {
                switch (sort) {
                    case 1:
                        params.put("@order", "expire_at asc");
                        break;
                    case 2:
                        params.put("@order", "expire_at desc ");
                        break;
                    case 3:
                        params.put("@order", "assign_at desc ");
                        break;
                    case 4:
                        params.put("@order", "assign_at asc ");
                        break;
                }
            }else {
                params.put("@order", "update_at desc ");
            }
            params.put("@query", "id ");
        }

        params.put("@table", "card ");

        return params;
    }

//    public  static Map<String, Object> getCardTypeCardsTotal(Long id, Integer status, count){
//        Map<String, Object> params = new HashMap<String, Object>();
//        log.info("start select from CardType Cards total");
//            params.put(" id ", id);
//
//        if (DataUtils.isNotNullOrEmpty(status)) {
//            params.put(" status ", status);
//        }
//
//        if (count){
//            params.put("@query", "count(id) ");
//        }else {
//            params.put("@order", "create_at desc ");
//            params.put("@query", "id ");
//        }
//        params.put("@table", "ctype");
//
//        return params;
//    }
}



