package com.ptteng.controller;

import com.ptteng.common.skill.model.UserStatistics;
import com.ptteng.common.skill.service.UserStatisticsService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * UserStatistics  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserStatisticsController {
	private static final Log log = LogFactory.getLog(UserStatisticsController.class);

	@Autowired
	private UserStatisticsService userStatisticsService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/userStatistics", method = RequestMethod.GET)
	public String getuserStatisticsList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/userStatistics  to /userStatistics/view/userStatisticsList");

		return "/common-skill-service/userStatistics/view/userStatisticsList";
	}
    
    

    
	
	@RequestMapping(value = "/c/userStatistics/{id}", method = RequestMethod.GET)
	public String getUserStatistics(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/userStatistics/" + id + "  to /userStatistics/view/userStatisticsDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/common-skill-service/userStatistics/view/userStatisticsDetail";
	}
	
	
	
	    
	

	@RequestMapping(value = "/a/userStatistics/{id}", method = RequestMethod.GET)
	public String getUserStatisticsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			UserStatistics userStatistics = userStatisticsService.getObjectById(id);
			log.info("get userStatistics data is " + userStatistics);

			model.addAttribute("code", 0);

			model.addAttribute("userStatistics", userStatistics);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userStatistics error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userStatistics/json/userStatisticsDetailJson";
	}

	@RequestMapping(value = "/a/userStatistics/{id}", method = RequestMethod.PUT)
	public String updateUserStatisticsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserStatistics userStatistics) throws Exception {
		
		log.info("update userStatistics : userStatistics= " + userStatistics);
		
		try {
			
			userStatisticsService.update(userStatistics);

			model.addAttribute("code", 0);

			model.addAttribute("userStatistics", userStatistics);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userStatistics error,id is  " + userStatistics.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userStatistics", method = RequestMethod.POST)
	public String addUserStatisticsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserStatistics userStatistics, Long id) throws Exception {
		
		log.info("update userStatistics : userStatistics= " + userStatistics);
		
		try { 
			userStatistics.setId(id);

			userStatisticsService.insert(userStatistics);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userStatistics error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userStatistics/{id}", method = RequestMethod.DELETE)
	public String deleteUserStatisticsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete userStatistics : id= " + id);
		try {
			userStatisticsService.delete(id);

			log.info("add userStatistics success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete userStatistics error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/userStatistics", method = RequestMethod.GET)
	public String getMultiUserStatisticsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<UserStatistics> userStatisticsList = userStatisticsService.getObjectsByIds(idList);
			log.info("get  userStatistics data is " + userStatisticsList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",userStatisticsList.size());

			model.addAttribute("userStatisticsList", userStatisticsList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userStatistics error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userStatistics/json/userStatisticsListJson";
	}
	
	
	
	
	
}

