package com.ptteng.controller;
import java.util.*;
import java.util.concurrent.TimeUnit;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.util.MyListUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.ConvertUtil;
import com.ptteng.util.CheckDataUtil;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import com.sleepycat.je.tree.IN;
import com.sun.org.apache.bcel.internal.generic.IF_ACMPEQ;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.OBJ_ADAPTER;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.util.CardIdUtil;
import sun.reflect.generics.reflectiveObjects.LazyReflectiveObjectGenerator;


@Controller
public class CardController {
	private static final Log log = LogFactory.getLog(CardController.class);

	@Autowired
	private CardService cardService;

	@Autowired
	private CtypeService ctypeService;

	@Autowired
	private ClogService clogService;

	@Autowired
	private UserService userService;

	@Autowired
	private MessageService messageService;

	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private ConstantService constantService;

	@Autowired
	private UserStatisticsService userStatisticsService;

    @Autowired
    private ManagerService managerService;


	private static final String CARD_MAX = "999";
	private static final String CARD_MIN = "1";
	/**
	 * 新建卡券
	 * @param tid 卡券类型id
	 * @param count 新建卡券数量
	 * @return "/data/json";
	 * @throws Exception;
	 * */
	@RequestMapping(value = "/a/u/card", method = RequestMethod.POST)
	public String addCards(HttpServletRequest request,
						   HttpServletResponse response,
						   ModelMap model, Long tid, Integer count) throws Exception {

		log.info("Card create, tid is: " + tid + ". count is: " + count);

		// 传参检查
		if (tid == null) {
			model.addAttribute("code",-21000);
			return "/data/json";
		}
		if (count == null) {
			model.addAttribute("code",-21001);
			return "/data/json";
		}

		// 卡券最大最小值
		String cardMax = constantService.getConstantValueByTypeAndName("type", "cardMax");
		String cardMin = constantService.getConstantValueByTypeAndName("type", "cardMin");
		if (cardMax == null) {
			cardMax = CARD_MAX;
		}
		if (cardMin == null) {
			cardMin = CARD_MIN;
		}
		if (count > Integer.parseInt(cardMax) && count < Integer.parseInt(cardMin)) {
			model.addAttribute("code",-21015);
			return "/data/json";
		}

		// 根据tid获取卡券类型
		Ctype cardType;
		try {
			cardType = ctypeService.getObjectById(tid);
			if (CheckDataUtil.isNull(cardType)) {
				model.addAttribute("code",-21020);
				return "/data/json";
			} else {
				log.info("get card type by id: " + tid);
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get type id error,id is " + tid );
			model.addAttribute("code", -21002);
			return "/data/json";
		}


		// 生成卡券编号
		String[] cardId = CardIdUtil.generateCode(tid, count);

		// 获取管理员id
		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
				com.qding.common.util.http.cookie.CookieUtil.USER_ID));

		// 生成card实体并
		List<Card> CardList = new ArrayList<Card>();
		for(int i = 0; i < count; i++) {
			Card card = new Card();
			card.setCode(cardId[i]);
			card.setTid(tid);
			card.setStatus(Card.STATUS_UNISSUED);
			card.setCardValid(cardType.getStatus());
			card.setTypeValid(cardType.getStatus());
			card.setCreateBy(uid);
			card.setCreateAt(System.currentTimeMillis());
			CardList.add(card);
		}
		//list插入到card
		try {

			cardService.insertList(CardList);
			log.info("insert card list success, length is: " + CardList.size());

			//新增卡券计数 新建+count
			setCardTypeStatistics(tid,Card.STATUS_UNISSUED,null,count);
			log.info("updata ctype success, ctype createCount is " + cardType.getCreateCount());

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("insert card list error,id is " + tid );
			model.addAttribute("code", -21003);
			return "/data/json";
		}

		model.addAttribute("code", 0);

		return "/data/json";
	}

    //查看卡券
	/**
	 *
	 * @param id 卡券id
	 * @return "/common-skill-service/card/json/cardDetailJson";
	 * @throws Exception;
	 * */
    @RequestMapping(value = "/a/u/card/{id}", method = RequestMethod.GET)
    public String getCardDetail(HttpServletRequest request,
                                HttpServletResponse response,
                                ModelMap model,
                                @PathVariable Long id) throws Exception {
	    //传参检查
		log.info("get card data : id = " + id);

		if( id == null) {
			model.addAttribute("code",-23004);
			return "/data/json";
		}

        //获取卡券数据
        try {
            Card card = cardService.getObjectById(id);
            User user = userService.getObjectById(card.getOwnerId());

            //获取卡券类型
			Ctype ctype = ctypeService.getObjectById(card.getTid());
			log.info("this card tid is " + card.getTid());

            model.addAttribute("code", 0);
            model.addAttribute("card", card);
            model.addAttribute("user", user);
            model.addAttribute("ctype", ctype);
        }catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update card error,id is " + id );
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/card/json/cardDetailJson";
    }


	/**
	 * 卡券发放
	 * @param ownerId 卡券接收人id;
	 * @param id 卡券id;
	 * @return /data/json;
	 * @throws Exception;
	 * */
	@RequestMapping(value = "/a/u/card/{id}/assign/{ownerId}", method = RequestMethod.PUT)
	public String assignCard(HttpServletRequest request,
								   HttpServletResponse response,
								   ModelMap model,
								   @PathVariable Long id,
								   @PathVariable Long ownerId) throws Exception {
		log.info("assign card, id is: " + id + ", ownerId is: " + ownerId);
		if (null == id) {
			model.addAttribute("code",-21004);
			return "/data/json";
		}
		if (null == ownerId) {
			model.addAttribute("code",-21021);
			return "/data/json";
		}

		//获取用户
		User user = userService.getObjectById(ownerId);
		if (CheckDataUtil.isNull(user)){
			model.addAttribute("code",-15000);
			return "/data/json";
		}else {
			log.info("get user success, owner's name is " + user.getNick());
		}

		// 根据id获取原来的卡券数据
		Card orignCard = cardService.getObjectById(id);
		if (CheckDataUtil.isNull(orignCard)) {
			model.addAttribute("code",-21005);
			return "/data/json";
		}else {
			log.info("get card success, card id is "+ id);
		}
		//获取卡券类型
		Ctype ctype = ctypeService.getObjectById(orignCard.getTid());
		if (CheckDataUtil.isNull(ctype)) {
			model.addAttribute("code",-21020);
			return "/data/json";
		}else {
			log.info("get ctype success, tid is: " + orignCard.getTid());
		}

		//卡券类型禁用，无法进行修改操作
		if (orignCard.getTypeValid() == Ctype.Status_Disable) {
			model.addAttribute("code",-21022);
			return "/data/json";
		}else {
			log.info("this ctype is enabled");
		}


		// 卡券禁用，则无法进行修改操作
		if (orignCard.getCardValid() == Card.CARD_VALID_DISABLE) {
			model.addAttribute("code",-21008);
			return "/data/json";
		} else {
			log.info(id + " card valid is enabled!");
		}

		// 获取管理员id
		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
				com.qding.common.util.http.cookie.CookieUtil.USER_ID));

		if (orignCard.getStatus() == Card.STATUS_UNISSUED) {
			orignCard.setOwnerId(ownerId);
			orignCard.setAssignId(uid);
			orignCard.setAssignAt(System.currentTimeMillis());
			orignCard.setStatus(Card.STATUS_ISSUED);
			orignCard.setUpdateBy(uid);

			//设置过期时间
			Integer expire = ctype.getExpire();
			orignCard.setExpireAt(System.currentTimeMillis() + expire );

		}

		try {
			Boolean isUpdate = cardService.update(orignCard);

			if (isUpdate) {
				log.info("assign card success");

				//卡券类型发放计数
				setCardTypeStatistics(orignCard.getTid(),Card.STATUS_ISSUED,null,null);

				//用户卡券统计-发放未使用
				setUserStatistics(ownerId, Card.STATUS_ISSUED,null);
			} else {
				model.addAttribute("code",-21007);
				return "/data/json";
			}

			//卡券记录
			Clog clog = ConvertUtil.card2Clog(Clog.TYPE_ASSIGN, id, orignCard.getTid(), uid, ownerId, null, null,uid);
			Long clogId = clogService.insert(clog);
			log.info("insert clog, id is: " + clogId);

			//发送发放信息
			sendMessage(ownerId, Clog.TYPE_ASSIGN, orignCard.getCode(), orignCard.getTid(), null);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -21007);
		}

		model.addAttribute("code", 0);

		return "/data/json";

	}

	/**
	 * 卡券核销
	 * @param verification 核销是否通过 0：拒绝 1：通过
	 * @param id 卡券id
	 * @param remark 核销拒绝理由
	 * @return /data/json;
	 * @throws Exception;
	 * */
		@RequestMapping(value = "/a/u/card/{id}/verification/{verification}", method = RequestMethod.PUT)
		public String verifyCard(HttpServletRequest request,
				HttpServletResponse response,
				ModelMap model,
				@PathVariable Long id,
				@PathVariable Integer verification, String remark) throws Exception {

			//传参检查
			log.info("assign card, id is: " + id + ", verification is: " + verification + ", remark is: " + remark);
			if (null == id) {
				model.addAttribute("code",-21004);
				return "/data/json";
			}
			if (null == verification) {
				model.addAttribute("code",-21021);
				return "/data/json";
			}

			// 根据id获取原来的卡券数据
			Card orignCard;
			try{
				orignCard = cardService.getObjectById(id);
				log.info("get card success,id is " + id );
			}catch (Throwable t) {
				t.printStackTrace();
				log.error(t.getMessage());
				log.error("get card error,id is " + id );
				model.addAttribute("code",-21005);
				return "/data/json";
			}

			//获取卡券类型
			Ctype ctype = ctypeService.getObjectById(orignCard.getTid());
			if (CheckDataUtil.isNull(ctype)) {
				model.addAttribute("code",-21020);
				return "/data/json";
			}else {
				log.info("get ctype success, tid is: " + orignCard.getTid());
			}

			//卡券类型禁用，无法进行修改操作
			if (orignCard.getTypeValid() == Ctype.Status_Disable) {
				model.addAttribute("code",-21022);
				return "/data/json";
			}else {
				log.info("this ctype is enabled");
			}

			// 卡券禁用，则无法进行修改操作
			if (orignCard.getCardValid() == Card.CARD_VALID_DISABLE) {
				model.addAttribute("code",-21008);
				return "/data/json";
			} else {
				log.info(id + " card valid is enabled!");
			}


			// 获取管理员id
			Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
					com.qding.common.util.http.cookie.CookieUtil.USER_ID));

			if (orignCard.getStatus() == Card.STATUS_VERIFICATING) {

				if (verification == Card.VERIFICATION_OFF) { //核销拒绝
					orignCard.setStatus(Card.STATUS_ISSUED);
				}else if (verification == Card.VERIFICATION_ON) {  //核销通过
					orignCard.setStatus(Card.STATUS_VERIFICATED);
				}else {
					model.addAttribute("code",-1001);
					return "/data/json";
				}

			} else { // 卡券状态不为3，则无法审核
				model.addAttribute("code",-21007);
				return "/data/json";
			}

			try {
				Boolean isUpdate = cardService.update(orignCard);
				if (isUpdate) {
					log.info("verification card success");
					//核销拒绝
					if(verification == Card.VERIFICATION_OFF){
						//用户卡券使用统计 核销完成-拒绝 核销中-1 未使用+1
						setUserStatistics(orignCard.getOwnerId(),Card.STATUS_VERIFICATED,Card.VERIFICATION_OFF);

						//卡券类型核销计数 核销完成-拒绝  核销中-1  发放未使用+1
						setCardTypeStatistics(orignCard.getTid(),Card.STATUS_VERIFICATED,Card.VERIFICATION_OFF,null);

					}
					//核销通过
					if( verification == Card.VERIFICATION_ON){
						//核销通过记录核销信息
						orignCard.setVerificationId(uid);
						orignCard.setVerificationAt(System.currentTimeMillis());
						orignCard.setUpdateBy(uid);

						//用户卡券使用统计 核销完成-通过 核销中-1 已使用+1
						setUserStatistics(orignCard.getOwnerId(),Card.STATUS_VERIFICATED,Card.VERIFICATION_ON);

						//卡券核销计数 核销完成-通过 核销中-1  已核销+1
						setCardTypeStatistics(orignCard.getTid(),Card.STATUS_VERIFICATED,Card.VERIFICATION_ON,null);
					}

				} else {
					model.addAttribute("code",-21007);
					return "/data/json";
				}

				//卡券记录 发送信息
				Clog clog = null;
				if (verification == Card.VERIFICATION_OFF) {
					//核销拒绝记录
					clog = ConvertUtil.card2Clog(Clog.TYPE_UNVERIFICATED, id, orignCard.getTid(), uid, orignCard.getOwnerId(), null, remark,uid);
					//发送核销拒绝信息
					sendMessage(orignCard.getOwnerId(), Clog.TYPE_UNVERIFICATED, orignCard.getCode(), orignCard.getTid(), remark);
				}
				if (verification == Card.VERIFICATION_ON) {
					//核销通过记录
					clog = ConvertUtil.card2Clog(Clog.TYPE_VERIFICATED, id, orignCard.getTid(), uid, orignCard.getOwnerId(), null, remark,uid);
					//核销通过信息
				sendMessage(orignCard.getOwnerId(), Clog.TYPE_VERIFICATED, orignCard.getCode(), orignCard.getTid(), remark);
				}

				Long clogId = clogService.insert(clog);
				log.info("insert clog, id is: " + clogId);
			} catch (Throwable t) {
				t.printStackTrace();
				log.error(t.getMessage());
				log.error("update card error,id is " + id );
				model.addAttribute("code", -21007);
			}

			model.addAttribute("code", 0);

			return "/data/json";

		}
	/**
	 * 卡券启用禁用
	 * @param cardValid - 是否启用 0：禁用 1：启用
	 * @param id - 卡券id
	 * @return /data/json
	 * @throws Exception；
	 * */
	@RequestMapping(value = "/a/u/card/{id}/status/{cardValid}", method = RequestMethod.PUT)
	public String updateCardIsAble(HttpServletRequest request,
						   HttpServletResponse response,
						   ModelMap model,
						   @PathVariable Long id, @PathVariable Integer cardValid) throws Exception {

		// 传参检查
		log.info("card id is: " + id + ". card valid is: " + cardValid);
		if (id == null) {
			model.addAttribute("code",-21004);
			return "/data/json";
		}
		if (cardValid == null) {
			model.addAttribute("code",-21011);
			return "/data/json";
		}

		// 根据id获取原来的卡券数据
		Card orignCard;
		try{
			orignCard = cardService.getObjectById(id);
			log.info("get card success,id is " + id );
		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get card error,id is " + id );
			model.addAttribute("code",-21005);
			return "/data/json";
		}

		// 检测传递的状态和卡券原本状态是否一致，一致则无需修改
		if (cardValid.equals(orignCard.getCardValid())) {
			model.addAttribute("code",-21014);
			return "/data/json";
		} else {
			log.info("card valid is different from database");
		}

		// 检测卡券类型是否禁用，禁用则不可操作
		try {
			if(orignCard.getTypeValid() == Ctype.Status_Disable) {
				model.addAttribute("code",-21022 );
				return "/data/json";
			}
		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get ctype error,card id is " + id );
			model.addAttribute("code",-21020);
			return "/data/json";
		}

		// 获取管理员id
		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
				com.qding.common.util.http.cookie.CookieUtil.USER_ID));


		orignCard.setCardValid(cardValid);
		orignCard.setUpdateAt(System.currentTimeMillis());
		orignCard.setUpdateBy(uid);

		try {
			Boolean isUpdate =  cardService.update(orignCard);
			if (isUpdate) {
				log.info("card update success.");
			} else {
				model.addAttribute("code",-21007);
				return "/data/json";
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -21007);
		}

		model.addAttribute("code", 0);

		return "/data/json";
	}


	/**
	 * 卡券列表
	 * @param page 页码
	 * @param size 分页条数
	 * @param tid 卡券类型
	 * @param ownerId 卡券持有人ID
	 * @param assignBy 卡券发放人名字
	 * @param verificationBy 卡券核销人名字
	 * @param createBy 卡券创建人名字
	 * @param status 卡券状态
	 * @param cardValid 卡券启用、禁用状态
	 * @param createStartAt 卡券创建时间开始
	 * @param createEndAt 卡券创建时间结束
	 * @param assignStartAt 卡券发放时间开始
	 * @param assignEndAt 卡券发放时间结束
	 * @param applyStartAt 卡券使用时间开始
	 * @param applyEndAt 卡券使用时间结束
	 * @param verificationStartAt 卡券核销时间开始
	 * @param verificationEndAt 卡券核销时间结束、
	  * @return json
	 * @throws Exception;
	 * */
	@RequestMapping(value = "/a/u/card/search", method = RequestMethod.GET)
	public String getCardList(HttpServletRequest request,
						   HttpServletResponse response,
						   ModelMap model, Integer page, Integer size,
							  String code, Long tid,
							  Long ownerId,
//							  String owner,
							  String assignBy,
							  String verificationBy,
							  String createBy,
							  Integer status, Integer cardValid,
							  Integer ctypeValid,
							  Long createStartAt, Long createEndAt,
							  Long assignStartAt, Long assignEndAt,
							  Long applyStartAt, Long applyEndAt,
							  Long verificationStartAt, Long verificationEndAt) throws Exception {

		log.info("card list, code = " + code + ", tid = " + tid + ", ownerId = " + ownerId + ", assignId = " + assignBy +
				", verificationName = " + verificationBy + ", createId = " + createBy + ", status = " + status +
				", cardValid = " + cardValid + ", createStartAt = " + createStartAt + ", createEndAt = " + createEndAt +
				", assignStartAt = " + assignStartAt + ", assignEndAt = " + assignEndAt + ", applyStartAt = " + applyStartAt +
				", applyEndAt = " + applyEndAt + ", verificationStartAt = " + verificationStartAt + ", verificationEndAt = " + verificationEndAt);

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		log.info("pageList : page= " + start + " , size=" + size);


		try {


			//模糊搜索manager，匹配卡券创建人



			if (CheckDataUtil.isNotNull(createBy) && !createBy.isEmpty()){
				createBy = getManagerIdsByName(createBy);
				Card[] cardList={};
				if( createBy ==null || createBy.isEmpty() ){
					model.addAttribute("code",0);
					model.addAttribute("page", page);
					model.addAttribute("size", size);
					model.addAttribute("total", 0);
					model.addAttribute("cardList",cardList );
					return "/common-skill-service/card/json/cardListJson";
				}
			}
			if (CheckDataUtil.isNotNull(assignBy) && !assignBy.isEmpty()){
				assignBy = getManagerIdsByName(assignBy);
				Card[] cardList={};
				if( assignBy ==null || assignBy.isEmpty() ){
					model.addAttribute("code",0);
					model.addAttribute("page", page);
					model.addAttribute("size", size);
					model.addAttribute("total", 0);
					model.addAttribute("cardList",cardList );
					return "/common-skill-service/card/json/cardListJson";
				}
			}
			if (CheckDataUtil.isNotNull(verificationBy) && !verificationBy.isEmpty()){
				verificationBy = getManagerIdsByName(verificationBy);
				Card[] cardList={};
				if( verificationBy ==null || verificationBy.isEmpty() ){
					model.addAttribute("code",0);
					model.addAttribute("page", page);
					model.addAttribute("size", size);
					model.addAttribute("total", 0);
					model.addAttribute("cardList",cardList );
					return "/common-skill-service/card/json/cardListJson";
				}
			}
//			if (CheckDataUtil.isNotNull(owner) && !owner.isEmpty()){
//				owner = getUserIdsByName(owner);
//			}

			log.info("ctype createBy is " + createBy+" ctype assignBy is " + assignBy+" ctype verificationBy is " + verificationBy);
			Map<String, Object> param = DynamicUtil.getCardsQueryListByManagerParam(code,tid,ownerId,assignBy,verificationBy,createBy,status,cardValid,ctypeValid,createStartAt,
						createEndAt,assignStartAt,assignEndAt,applyStartAt,applyEndAt,verificationStartAt,verificationEndAt,false);
				log.info("get cardType params is: " + param);
			List<Long> ids = cardService.getIdsByDynamicCondition(Card.class,param,start,size);
			Integer total = cardService.getIdsByDynamicCondition(Card.class,param,0,Integer.MAX_VALUE).size();


			if (CollectionUtils.isEmpty(ids)) {
				model.addAttribute("code",0);
				model.addAttribute("page", page);
				model.addAttribute("size", size);
				model.addAttribute("total", 0);
				model.addAttribute("cardList", ids);
				return "/common-skill-service/card/json/cardListJson";
			} else {
				log.info("get card ids is: " + ids);
                log.info("get card list ids size is: " + ids.size());
			}

			List<Card> cardList = cardService.getObjectsByIds(ids);
			log.info("get card list success, length is: " + cardList.size());


			// 获取type的内容 && 获取用户名
			Set<Long> tids = new HashSet<>();
			Set<Long> uids = new HashSet<>();
			for (Card cardTemp : cardList) {
				tids.add(cardTemp.getTid());
				uids.add(cardTemp.getOwnerId());
			}
			List<Ctype> ctypeList = ctypeService.getObjectsByIds(new ArrayList<Long>(tids));

			Map<Long, Ctype> id_ctype = MyListUtil.convert2Map(Ctype.class.getDeclaredField("id"), ctypeList);

			List<User> ownerList = userService.getObjectsByIds(new ArrayList<Long>(uids));
			Map<Long, User> id_owner = MyListUtil.convert2Map(User.class.getDeclaredField("id"), ownerList);

			List<Long> managerIds=managerService.getManagerIds(0,Integer.MAX_VALUE);
			log.info("get managerIds size is " + managerIds.size());
			List<Manager> managers = managerService.getObjectsByIds(managerIds);
			Map<Long, User> manager = MyListUtil.convert2Map(Manager.class.getDeclaredField("id"), managers);

			log.info("get card size is " + total);



			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("cardList", cardList);
			model.addAttribute("idCtype", id_ctype);
			model.addAttribute("idOwner", id_owner);
            model.addAttribute("manager", manager);


		}  catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get card list error");
			model.addAttribute("code", -21007);
		}


		return "/common-skill-service/card/json/cardListJson";
	}


	// 消息通知
	private void sendMessage(Long uid, Integer type, String code, Long tid, String remark) throws Exception {

		log.info("send message args, uid: " + uid + ". type: " + type + ". code: " + code + ". tid: " + tid + ". remark" + remark);
		// 获取用户信息
		User user = userService.getObjectById(uid);
		String userName = user.getNick();
		log.info("user name is: " + userName);

		// 获取卡券类型信息
		Ctype ctype = ctypeService.getObjectById(tid);
		String title = ctype.getTitle();

		//获取卡券信息

		Map<String, Object> params = DynamicUtil.getCardsQueryListParam(code,null,null,null,null,null,null,null,null,null,null,null,null,
				null,null,null,null,false);
		List<Long> ids= cardService.getIdsByDynamicCondition(Card.class,params,0,Integer.MAX_VALUE);
		log.info("ids is " +ids);
		Card card = cardService.getObjectsByIds(ids).get(0);

		//存入系统消息
		Message message = new Message();
		message.setSendName("admin");
		message.setSendId(0L);
		message.setReceiveName(userName);
		message.setReceiveId(uid);
		message.setContent("");
		message.setStatus(1);
		message.setUnread(1);
		message.setType(Message.CARD_TYPE);
		Long mid = messageService.insert(message);

		//发送系统信息
		String content = "";
		if (type == Clog.TYPE_ASSIGN) {
			// {发放人名称}给你发放了一张{卡券类型名称}
			content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
					"<span class=\\\"font-green\\\">管理员</span>给您发放了一张" +
					"<a data-mid=" + mid + " ng-click=\"sendAlertMsg(li.id);vm.goCard(" + code + ")\" class=\\\"font-orange\\\" >"+ title + "[" + code + "]" +"</a>" +
					"</span>";
		} else if (type == Clog.TYPE_VERIFICATED) {
			// 核销通过：你的{卡券类型名称}{卡券编号}已审核通过并生效
			content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
					"您的<a data-mid=" + mid + " ng-click=\"sendAlertMsg(li.id);vm.goCard(" + code + ")\" class=\\\"font-orange\\\" >"+ title + "[" + code + "]" +"</a>已审核通过并生效" +
					"</span>";
		} else if (type == Clog.TYPE_UNVERIFICATED) {
			// 核销拒绝：你的{卡券类型名称}{卡券编号}已审核拒绝
			content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
					"您的<a data-mid=" + mid + " ng-click=\"sendAlertMsg(li.id);vm.goCard(" + code + ")\" class=\\\"font-orange\\\" >"+ title + "[" + code + "]" +"</a>已审核拒绝，拒绝理由是：" + remark +
					"</span>";
		} else {
			log.info("message error");
			return;
		}

		adminSend(user.getMobile(), content);
		message = messageService.getObjectById(mid);
		message.setContent(content);
		log.info("message mid is " + mid);

		Boolean result = messageService.update(message);
		log.info("message update result is " + result);


		//更新用户信息
		user.setIsLook(user.getIsLook() + 1);
		user.setLatestMsg(Message.CARD_TYPE);
		userService.update(user);

	}

	//设置卡券类型统计信息
	/**
	 * @param tid 卡券类型id
	 * @param type 卡券类型统计
	 * @param status 核销结果
	 * @throws Exception;
	 * */
	private void setCardTypeStatistics(Long tid, Integer type, Integer status , Integer count) throws Exception {
		log.info("setCardTypeStatistics start, tid is " + tid + " , type is " + type + " , status is " + status);

		Ctype ctype = ctypeService.getObjectById(tid);

		switch (type) {
			//卡券新建未发放 新增+count
			case Card.STATUS_UNISSUED:
				ctype.setCreateCount(ctype.getCreateCount()+count);
				log.info("setCardTypeStatistics, ctype id is " + tid + ",card: create " + count);
				break;
			//卡券发放 未使用+1
			case Card.STATUS_ISSUED:
				ctype.setAssignCount(ctype.getAssignCount() + 1);
				log.info("setCardTypeStatistics, ctype id is " + tid + ",card: Assign");
				break;
			//核销完成
			case Card.STATUS_VERIFICATED:
				//拒絕 发放未使用+1 核销中-1
				if(status == Card.VERIFICATION_OFF){
					ctype.setAssignCount(ctype.getAssignCount()+1);
					ctype.setVerifyingCount(ctype.getVerifyingCount()-1);
					log.info("setCardTypeStatistics, ctype id is " + tid + ",card: verifying --> assign");
				}else if (status == Card.VERIFICATION_ON){
					//通过 已核销+1 核销中-1
					ctype.setVerifiedCount(ctype.getVerifiedCount()+1);
					ctype.setVerifyingCount(ctype.getVerifyingCount()-1);
					log.info("setCardTypeStatistics, ctype id is " + tid + ",card: verifying --> applied");
				}else {
					log.info("setCardTypeStatistics, Need status");
				}
				break;
			//卡券过期 发放未使用-1 已过期+1
			case Card.STATUS_EXPIRE:
				ctype.setAssignCount(ctype.getAssignCount()-1);
				ctype.setExpiredCount(ctype.getExpiredCount()+1);
				log.info("setCardTypeStatistics, ctype id is " + tid + ",card: Expired");
				break;
			default:
				log.info("setCardTypeStatistics, type error");
				break;
		}

		try {
			ctypeService.update(ctype);
			log.info("update CardType success, tid is " + tid);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update CardTypeStatistics error ");
		}


	}

    //设置用户卡券统计信息
	private void setUserStatistics(Long uid, Integer type, Integer status) throws Exception{
		log.info("setUserStatistics uid is " + uid +" ,type is " + type + " , status is" + status);

		UserStatistics userStatistics = userStatisticsService.getObjectById(uid);
		switch (type){
			//未使用
			case Card.STATUS_ISSUED:
				userStatistics.setCardUnused(userStatistics.getCardUnused()+1);
				log.info("update UserStatistics , user id is " + uid + " ,unused card is "+ userStatistics.getCardUnused());
				break;
			//申请中,未使用-1 核销中+1
			case Card.STATUS_VERIFICATING:
				userStatistics.setCardVerifying(userStatistics.getCardVerifying()+1);
				userStatistics.setCardUnused(userStatistics.getCardUnused()-1);
				log.info("update UserStatistics , user id is " + uid + " ,Verifying card is "+ userStatistics.getCardVerifying() + " ,unused card is "+ userStatistics.getCardUnused());
				break;
			//核销
			case Card.STATUS_VERIFICATED:
				if(status == Card.VERIFICATION_OFF){//拒绝 未使用+1 核销中-1
					userStatistics.setCardUnused(userStatistics.getCardUnused()+1);
					log.info("update UserStatistics , user id is " + uid + " ,unused card is "+ userStatistics.getCardUsed() + " ,Verifying card is "+ userStatistics.getCardVerifying());
				}
				if(status == Card.VERIFICATION_ON) {//通过 已使用+1 核销中-1 已核销+1
					userStatistics.setCardUsed(userStatistics.getCardUsed()+1);
					userStatistics.setCardVerified(userStatistics.getCardVerified()+1);
					log.info("update UserStatistics , user id is " + uid + " ,used card is "+ userStatistics.getCardUsed() + " ,Verifying card is "+ userStatistics.getCardVerifying());
				}
				userStatistics.setCardVerifying(userStatistics.getCardVerifying()-1);
				break;
			//已过期，未使用-1 已过期+1
			case Card.STATUS_EXPIRE:
				userStatistics.setCardExpired(userStatistics.getCardExpired()+1);
				userStatistics.setCardUnused(userStatistics.getCardUnused()-1);
				log.info("update UserStatistics , user id is " + uid + " ,Expired card is "+ userStatistics.getCardExpired() + " ,unused card is "+ userStatistics.getCardUnused());
				break;
				//已转让 未使用-1 已转让+1
			case 6:
				userStatistics.setCardCession(userStatistics.getCardCession()+1);
				userStatistics.setCardUnused(userStatistics.getCardUnused()-1);
				break;
			default:
				log.info("setUserStatistics type error, uid is " + uid + " ,type is " + type );
				break;
		}

		try {
			userStatisticsService.update(userStatistics);
			log.info("update CardTypeStatistics success, uid is " + uid);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update CardTypeStatistics error ");
		}

	}
	private static String adminSend(String mobile, String content) {


		String param = "{\n" +
				"    \"target_type\" : \"users\", \n" +
				"    \"target\" : [\"" + mobile + "\"],   \n" +
				"                                   \n" +
				"                                   \n" +
				"    \"msg\" : {\n" +
				"        \"type\" : \"txt\",\n" +
				"        \"msg\" : \"" + content + "\" \n" +
				"        },\n" +
				"    \"from\" : \"admin\"\n" +
				"}";
		String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");


		return result;
	}

	private String getManagerIdsByName(String name) throws Exception{
		log.info("getManagerByName, name is " + name);
			Map<String,Object> params =new HashMap<>();
			params.put(" name & like","'%"+name+"%'");
			List<Long> managerIds = managerService.getIdsByDynamicCondition(Manager.class,params,0,Integer.MAX_VALUE);
			return org.apache.commons.lang3.StringUtils.join(managerIds,",");
	}

	private String getUserIdsByName(String name) throws Exception{
		log.info("getUserIdsByName, name is " + name);
			Map<String,Object> params =new HashMap<>();
			params.put(" nick & like","'%"+name+"%'");
			List<Long> userIds = userService.getIdsByDynamicCondition(User.class,params,0,Integer.MAX_VALUE);
			return org.apache.commons.lang3.StringUtils.join(userIds,",");
	}


}

