package com.ptteng.controller;

import com.ptteng.common.skill.model.User;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.qding.common.util.FileUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.UUID;

/**
 * Created by asus on 2015/10/22.
 */
@Controller
public class imgController {
    private static final Log log = LogFactory.getLog(imgController.class);

    @Autowired
    private ImgStorageUtil imgStorageUtil;

    @Autowired
    private CookieUtil cookieUtil;


    //38 .图片上传
    @RequestMapping(value = "/a/u/img/{module}", method = RequestMethod.POST)
    public String uploadFile(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model,
                             @RequestParam MultipartFile file, @PathVariable String module)
            throws Exception {
        log.info("hello upload " + module);
        if (StringUtils.isBlank(module)) {
            log.info("type is null");
        }
        int code = 0;
        log.info(file.getOriginalFilename());

        try {

            String extend = FileUtil.getFileExtension(file.getOriginalFilename());

            String fileName = UUID.randomUUID().toString() + "." + extend;
            log.info("new name is " + fileName);
//			String filePath = "/temp/" + fileName;
            String filePath = "/data/img/skill/" + module + "/" + fileName;
            String dirPath = "/data/img/skill/" + module;

            File dir = new File("/data/img/skill/" + module);
            if (dir.exists()) {
                log.info("创建目录" + dirPath + "失败，目标目录已经存在");
            } else {
                //创建目录
                if (dir.mkdirs()) {
                    log.info("创建目录" + dirPath + "成功！");
                } else {
                    log.info("创建目录" + dirPath + "失败！");
                }
            }

            File tempPic = new File(filePath);
            file.transferTo(tempPic);
            String url = this.imgStorageUtil.imgStorage(null, "skill/"+ module + "/"
                    + fileName, filePath);
            log.info(module + " upload success ,and file name is " + fileName
                    + "temp path is " + filePath + " access url is " + url);
			tempPic.delete();
//			log.info(file.getOriginalFilename() + " delete success ");
            model.addAttribute("url", url);
            model.addAttribute("code", 0);

            return "/common/img";
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }
}