package com.ptteng.controller;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.Account;
import com.ptteng.common.skill.model.Message;
import com.ptteng.common.skill.model.Order;
import com.ptteng.common.skill.model.Servert;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.AccountService;
import com.ptteng.common.skill.service.MessageService;
import com.ptteng.common.skill.service.OrderService;
import com.ptteng.common.skill.service.ServertService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;

/**
 * Servert  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 *
 */
@Controller
public class ServertController {
	private static final Log log = LogFactory.getLog(ServertController.class);

	@Autowired
	private ServertService servertService;



	@Autowired
	private CookieUtil cookieUtil;


	@Autowired
	private AccountService accountService;


	@Autowired
	private OrderService orderService;



	@Autowired
	private MessageService messageService;

	@Autowired
	private UserService userService;
	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

		@RequestMapping(value = "/a/u/servert", method = RequestMethod.GET)
	public String getServertIdsByTypeJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Integer type, String support, String deploy,String serverIp) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids = new ArrayList<>();

			Map<String, Object> param = DynamicUtil.getServertListParam(type, support, deploy, serverIp, false);

			ids= servertService.getIdsByDynamicCondition(Servert.class,param,start,size);
		    log.info("get countServertIdsByType size is " + ids.size());

			List<Servert> servertList = servertService.getObjectsByIds(ids);
			log.info("get servert data is " + servertList.size());

			Integer total = servertService. countServertIds();
			log.info("get servert count is " + total);


			// 遍历所有的服务器账号,确定每个账号下子账号的总数和已使用数

			HashMap serverTotalHash = new HashMap();
			for (Servert servert :servertList){

				log.info("-----------");
				List accountTotal = accountService.getAccountIdsByServerId(servert.getId(), 0, Integer.MAX_VALUE);


				log.info("账号的总数是"+accountTotal.size());
				servert.setTotal(accountTotal.size());

			}

			HashMap serverUsedHash = new HashMap();

			for (Servert servert :servertList){
				List accountUsed = accountService.getAccountIdsByServerIdandStatus(servert.getId(),1,0,Integer.MAX_VALUE);

				log.info("账号的使用数是"+accountUsed.size());

				servert.setUsed(accountUsed.size());
			}


			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);

			model.addAttribute("servertList", servertList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get servert list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -1);
		}

		return "/common-skill-service/servert/json/servertListJson";
	}


	@RequestMapping(value = "/a/u/servert/{id}", method = RequestMethod.GET)
	public String getServertJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Servert servert = servertService.getObjectById(id);
			log.info("get servert data is " + servert);

			model.addAttribute("code", 0);

			model.addAttribute("servert", servert);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get servert error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/common-skill-service/servert/json/servertDetailJson";
	}

	@RequestMapping(value = "/a/u/servert/{id}", method = RequestMethod.PUT)
	public String updateServertJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Servert servert,@PathVariable Long id) throws Exception {

		log.info("update servert : servert= " + servert);

		try {


			List<Long> accountids = accountService.getAccountIdsByServerId(id, 0, Integer.MAX_VALUE);
			List<Account> accountList = accountService.getObjectsByIds(accountids);

			if (accountList.size() != 0){
				Account account = accountList.get(0);
				account.setEndTime(servert.getEndTime());
                boolean bool = accountService.update(account);

				log.info("the update is" + bool);
			}

			Order order = orderService.getObjectByOrderId(servert.getOrderId());
			if (order != null){
				order.setStatus(4);
				boolean bool = orderService.update(order);
				log.info("the update status is" + bool);
			}

			servertService.update(servert);

			model.addAttribute("code", 0);

			model.addAttribute("servert", servert);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update servert error,id is  " + servert.getId());
			model.addAttribute("code", -1);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/servert", method = RequestMethod.POST)
	public String addServertJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Servert servert) throws Exception {

		log.info("update servert : servert= " + servert);

		try {

			Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
					com.qding.common.util.http.cookie.CookieUtil.USER_ID));

			if (null != servert){

				servert.setCreateBy(uid);
				servert.setUpdateBy(uid);
				servert.setId(null);

				Long id = servertService.insert(servert);
				if (servert.getMobile() != null){ // 那么要生成账号

					log.info("make a account");
					Account account = new Account();
					account.setBuyer(servert.getBuyer());
					account.setPwd(servert.getRootPwd());
					account.setAccount(servert.getUserName());
					account.setServerIp(servert.getServerIp());
                    account.setBuyTime(System.currentTimeMillis());
                    account.setEndTime(servert.getEndTime());
					account.setServerId(id);
					account.setDeploy(servert.getDeploy());
					account.setCreateBy(uid);
					account.setUpdateBy(uid);
                    account.setType(2);
					account.setStatus(1); // 状态1表示使用中
                    account.setMobile(servert.getMobile());
					accountService.insert(account);
					log.info("the accountid is"+account);


					// 更改订单状态
					Order order = orderService.getObjectByOrderId(servert.getOrderId());
					order.setStatus(4);
					order.setSendAt(System.currentTimeMillis());

					boolean bool = orderService.update(order);
					log.info("the order status is" + bool);


					// 发送系统消息
					Long uid1 = userService.getUserIdByMobile(order.getMobile());
					User receiver = userService.getObjectById(uid1);


					//存入系统消息
					Message message = new Message();
					message.setStatus(1);
					message.setReceiveName(receiver.getNick());
					message.setSendName("admin");
					message.setSendId(0L);
					message.setContent("");
					message.setReceiveId(receiver.getId());
					message.setUnread(1);
					message.setType(Message.DAILY_TYPE);
//                            message.setRelationId(did);
					Long mid = messageService.insert(message);
					SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
					String time = df.format(new Date(order.getPayAt()));

					//发送系统信息href=\"/skill/Information/"
					String content =  "<span  class=\\\"font-16px system-alert-outline\\\">" + "<span class=\\\"font-green\\\">您</span>" +
							"<span class=\\\"font-orange\\\" data-mid=" + mid + ">" +time+"</span>" +
							"购买的服务器已发货,<a   data-mid=" + mid + " class=\\\"font-blue\\\" target=\"_blank\" href=\\\"/skill/userMessage///myAccount/"+uid1+"#1"+"\\\">点击查看</a>" +
							"</span>";

					log.info("user : " + receiver.getMobile() + " send : " + content);
					adminSend(receiver.getMobile(), content);

					message = messageService.getObjectById(mid);
					message.setContent(content);
					log.info("message is " + message);

					Boolean result = messageService.update(message);
					log.info("result is " + result);

					// 获取用户,更改用户查看消息列表的状态
					receiver.setIsLook(receiver.getIsLook()+1);
					receiver.setLatestMsg(Message.DAILY_TYPE);
					userService.update(receiver);





				}

				model.addAttribute("code", 0);

			}

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add servert error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}


	public static String adminSend(String mobile, String content) {


		String param = "{\n" +
				"    \"target_type\" : \"users\", \n" +
				"    \"target\" : [\"" + mobile + "\"],   \n" +
				"                                   \n" +
				"                                   \n" +
				"    \"msg\" : {\n" +
				"        \"type\" : \"txt\",\n" +
				"        \"msg\" : \"" + content + "\" \n" +
				"        },\n" +
				"    \"from\" : \"admin\"\n" +
				"}";
		String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");


		return result;
	}


	@RequestMapping(value = "/a/u/servert/{id}", method = RequestMethod.DELETE)
	public String deleteServertJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete servert : id= " + id);
		try {
			servertService.delete(id);
			List<Long>  accountIds = accountService.getAccountIdsByServerId(id, 0, Integer.MAX_VALUE);
			if (accountIds != null){
				accountService.deleteList(Account.class,accountIds);
			}

			log.info("add servert success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete servert error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}


	@RequestMapping(value = "/web/a/multi/servert", method = RequestMethod.GET)
	public String getMultiServertJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {

		List<Long> idList = new ArrayList();
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<Servert> servertList = servertService.getObjectsByIds(idList);
			log.info("get  servert data is " + servertList.size());

			model.addAttribute("code", 0);
			model.addAttribute("total",servertList.size());

			model.addAttribute("servertList", servertList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get servert error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/servert/json/servertListJson";
	}


}

