package com.ptteng.controller;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.common.skill.model.Card;
import com.ptteng.common.skill.model.Clog;
import com.ptteng.common.skill.service.CardService;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.skill.model.Ctype;
import com.ptteng.common.skill.service.CtypeService;

/**
 * Ctype  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CtypeController {
	private static final Log log = LogFactory.getLog(CtypeController.class);

	@Autowired
	private CtypeService ctypeService;

	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private CardService cardService;


	
	//卡券类型禁用启用
	@RequestMapping(value = "/a/u/cardType/{id}/status", method = RequestMethod.PUT)
	public String editCardTypeStatus(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {


		if(id == null){
			model.addAttribute("code", -100000);
		}else{
//			model.addAttribute("id", 0);
		}


		try {
			Ctype ctype = ctypeService.getObjectById(id);
			Integer status = ctype.getStatus();
			log.info("Ctype id is" + id + "Change this status into:" + status);
			//卡券类型禁用启用
			if (status == 0){
				ctype.setStatus(1);
			}else if (status ==1){
				ctype.setStatus(0);
			}else {
				model.addAttribute("code", -23018);
			}

			log.info("get ctype data is " + ctype);

			ctypeService.update(ctype);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get ctype error,id is  " + id);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/data/json";
	}
	
	
	
	    		
			
    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 //卡券类型列表
		@RequestMapping(value = "/a/u/cardType/search", method = RequestMethod.GET)
	public String getCtypeIdsByStatusOrderByCreateAtJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page, Integer size,Integer status, String title, Long createStartAt, Long createEndAt, String createBy
		) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			//获取卡券类型列表
			Map<String, Object> param = DynamicUtil.getCardsTypeQueryListParam(title, status, createStartAt, createEndAt, createBy, false);
			log.info("get cardType params is: " + param);

			List<Long> tids= ctypeService.getIdsByDynamicCondition(Ctype.class,param,start,size);
		 	log.info("get Ctype Ids is " + tids);

			List<Ctype> ctypeList = ctypeService.getObjectsByIds(tids);
//

			//获取卡券total
			Map<String, Object> paramCount = DynamicUtil.getCardsTypeQueryListParam(title, status, createStartAt,createEndAt, createBy, true);
			log.info("get ctype total sql :" + paramCount);

			List<Long> totalList = ctypeService.getIdsByDynamicCondition(Ctype.class, paramCount,0,Integer.MAX_VALUE);
			log.info("totalList  is: " + totalList);
			Integer total = totalList.get(0).intValue();
			log.info("get ctype size is " + total);


			//创建卡券数
			Map<Long,Integer> createCount = new HashMap<Long, Integer>();
			for (Long tid:tids){
				Map<String, Object> cidParams = DynamicUtil.getCtypeInCardsQueryListParam(tid,null,null, true);
				List<Long> cardTotal = cardService.getIdsByDynamicCondition(Card.class, cidParams, 0, Integer.MAX_VALUE);

				createCount.put(tid,cardTotal.get(0).intValue());
			}

			//卡券发放数
			Map<Long,Integer> assignCount = new HashMap<Long, Integer>();
			Integer[] assignStatus = {
					Clog.TYPE_APPLY,
					Clog.TYPE_VERIFICATED,
					Clog.TYPE_UNVERIFICATED,
					Clog.TYPE_CESSION,
					Clog.TYPE_EXPIRE};
			for (Long tid:tids){
				Map<String, Object> cidParams = DynamicUtil.getCtypeInCardsQueryListParam(tid,null,assignStatus,true);
				log.info("=============================== cidparams is"+cidParams);
				List<Long> cardTotal = cardService.getIdsByDynamicCondition(Card.class, cidParams, 0, Integer.MAX_VALUE);

				assignCount.put(tid,cardTotal.get(0).intValue());
			}

			//卡券核销数
			Map<Long,Integer> verificationCount = new HashMap<Long, Integer>();
			for (Long tid:tids){
				Map<String, Object> cidParams = DynamicUtil.getCtypeInCardsQueryListParam(tid, Clog.TYPE_VERIFICATED,null,true);
				List<Long> cardTotal = cardService.getIdsByDynamicCondition(Card.class, cidParams, 0, Integer.MAX_VALUE);

				verificationCount.put(tid,cardTotal.get(0).intValue());
			}


			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("ctypeList", ctypeList);
			model.addAttribute("createCount", createCount);
			model.addAttribute("assignCount", assignCount);
			model.addAttribute("verificationCount", verificationCount);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get ctype list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/ctype/json/ctypeListJson";
	}

	
	
		
	
	
	//查看卡券类型详情
	@RequestMapping(value = "/a/u/cardType/{id}", method = RequestMethod.GET)
	public String getCtypeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Ctype ctype = ctypeService.getObjectById(id);
			log.info("get ctype data is " + ctype);

			model.addAttribute("code", 0);

			model.addAttribute("ctype", ctype);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get ctype error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/ctype/json/ctypeDetailJson";
	}

    //编辑卡券类型
	@RequestMapping(value = "/a/u/cardType/{id}", method = RequestMethod.PUT)
	public String updateCtypeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Ctype ctype, @PathVariable Long id, String title, String img, String description, Integer expire, Integer status) throws Exception {
		
//		log.info("update ctype : ctype= " + ctype);

		//传参检查
		if (title == null || img == null || description == null || expire == null ||status == null) {
			model.addAttribute("code",-21017);
			return "/data/json";
		}
		//获取cookie中用户id
		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
				com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		log.info("ctype id is :"+ id);
		ctype.setId(id);
		ctype.setTitle(title);
		ctype.setImg(img);
		ctype.setDescription(description);
		ctype.setExpire(expire);
		ctype.setStatus(status);
		ctype.setCreateBy(uid);
		ctype.setUpdateBy(uid);
		ctype.setCreateAt(System.currentTimeMillis());
		ctype.setUpdateAt(System.currentTimeMillis());
		log.info("ctype is ================" +ctype);
		
		try {
			
			ctypeService.update(ctype);

			model.addAttribute("code", 0);

			model.addAttribute("ctype", ctype);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update ctype error,id is  " + ctype.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}
	//新增卡券类型
	@RequestMapping(value = "/a/u/cardType", method = RequestMethod.POST)
	public String addCtypeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Ctype ctype, String title, String img, String description, Integer expire, Integer status) throws Exception {
		
		log.info("update ctype : ctype= " + ctype);

		//传参检查
		if (title == null || img == null || description == null || expire == null ||status == null) {
			model.addAttribute("code",-21017);
			return "/data/json";
		}
		//获取cookie中用户id
		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
				com.qding.common.util.http.cookie.CookieUtil.USER_ID));

		ctype.setId(null);
		ctype.setTitle(title);
		ctype.setImg(img);
		ctype.setDescription(description);
		ctype.setExpire(expire);
		ctype.setStatus(status);
		ctype.setCreateBy(uid);
		ctype.setUpdateBy(uid);
		ctype.setCreateAt(System.currentTimeMillis());
		ctype.setUpdateAt(System.currentTimeMillis());
		log.info("ctype is ================" +ctype);

		try {
			ctypeService.insert(ctype);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add ctype error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}
    //删除卡券类型
	@RequestMapping(value = "/a/u/cardType/{id}", method = RequestMethod.DELETE)
	public String deleteCtypeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete ctype : id= " + id);
		try {
			//判断ID是否有效
			Ctype ctype = ctypeService.getObjectById(id);

			if (ctype == null) {
				model.addAttribute("code", -21002);
				log.info("The ctype does not exist");
				return "/common/success";
			}

			// get total
			Map<String, Object> paramCount = DynamicUtil.getCardsQueryListParam(null, id, null, null,null,null,null, null, null,
					null, null, null, null, null, null,null,false);
			List<Long> totalList = cardService.getIdsByDynamicCondition(Card.class, paramCount, 0, Integer.MAX_VALUE);


            //使用中卡券数量
			Map<String, Object> paramCountUsing = DynamicUtil.getCardsQueryListParam(null, id, null, null,null,null,Card.STATUS_ISSUED, null, null,
					null, null, null, null, null, null,null,true);
			List<Long> totalUsingList = cardService.getIdsByDynamicCondition(Card.class, paramCountUsing, 0, Integer.MAX_VALUE);
			Integer totalUsing = totalUsingList.get(0).intValue();
			log.info("get usingCard size is " + totalUsing);
			log.info("get usingCard ids is " + totalUsingList);


			//核销中卡券数量
			Map<String, Object> paramCountNotUsing = DynamicUtil.getCardsQueryListParam(null, id, null, null,null,null,Card.STATUS_VERIFICATING, null, null,
					null, null, null, null, null, null,null,true);
			List<Long> totalNotUsingList = cardService.getIdsByDynamicCondition(Card.class, paramCountNotUsing, 0, Integer.MAX_VALUE);
			Integer totalNotUsing = totalNotUsingList.get(0).intValue();
			log.info("get notUsingCard size is " + totalNotUsing);
			log.info("get notUsingCard ids is " + totalNotUsing);


			//判断是否符合删除条件，删除后删除所有卡券类型下卡券
			if((totalNotUsing+totalUsing)==0){
				ctypeService.delete(id);
				cardService.deleteList(Card.class, totalList);
				log.info("delete ctype success");
				model.addAttribute("code", 0);
			}else {
				model.addAttribute("code", -21019);
			}

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete ctype error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/ctype", method = RequestMethod.GET)
	public String getMultiCtypeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {



			List<Ctype> ctypeList = ctypeService.getObjectsByIds(idList);
			log.info("get  ctype data is " + ctypeList.size());

			model.addAttribute("code", 0);			
			model.addAttribute("total",ctypeList.size());

			model.addAttribute("ctypeList", ctypeList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get ctype error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/skill-service/ctype/json/ctypeListJson";
	}
	
	
	
	
	
}

