package com.ptteng.controller;
import java.util.*;
import java.util.concurrent.TimeUnit;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.util.MyListUtil;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.ConvertUtil;
import com.ptteng.util.CheckDataUtil;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.util.CardIdUtil;

import com.ptteng.common.skill.model.Card;
import com.ptteng.common.skill.model.Ctype;
import com.ptteng.common.skill.model.Clog;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.model.Message;


@Controller
public class CardController {
	private static final Log log = LogFactory.getLog(CardController.class);

	@Autowired
	private CardService cardService;

	@Autowired
	private CtypeService ctypeService;

	@Autowired
	private ClogService clogService;

	@Autowired
	private UserService userService;

	@Autowired
	private MessageService messageService;

	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private ConstantService constantService;


	/**
	 * 新建卡券
	 * @param tid
	 * @param count
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/card", method = RequestMethod.POST)
	public String addCards(HttpServletRequest request,
						   HttpServletResponse response,
						   ModelMap model, Long tid, Integer count) throws Exception {

		log.info("Card create, tid is: " + tid + ". count is: " + count);

		// 传参检查
		if (tid == null) {
			model.addAttribute("code",-21000);
			return "/data/json";
		}
		if (count == null) {
			model.addAttribute("code",-21001);
			return "/data/json";
		}

		// 卡券最大最小值
		String cardMax = constantService.getConstantValueByTypeAndName("type", "cardMax");
		String cardMin = constantService.getConstantValueByTypeAndName("type", "cardMin");
		if (cardMax == null) {
			cardMax = "999";
		}
		if (cardMin == null) {
			cardMin = "1";
		}
		if (count > Integer.parseInt(cardMax) && count < Integer.parseInt(cardMin)) {
			model.addAttribute("code",-21015);
			return "/data/json";
		}

		// 根据tid获取卡券类型
		Ctype cardType = null;
		try {
			cardType = ctypeService.getObjectById(tid);
			if (CheckDataUtil.isNull(cardType)) {
				model.addAttribute("code",-21020);
				return "/data/json";
			} else {
				log.info("get card type by id: " + tid);
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get type id error,id is " + tid );
			model.addAttribute("code", -21002);

		}


		// 生成卡券编号
		String[] cardId = CardIdUtil.generateCode(tid, count);

		// 获取管理员id
		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
				com.qding.common.util.http.cookie.CookieUtil.USER_ID));

		// 生成card实体并
		List<Card> CardList = new ArrayList<Card>();
		for(int i = 0; i < count; i++) {
			Card card = new Card();
			card.setCode(cardId[i]);
			card.setTid(tid);
			card.setStatus(Card.STATUS_UNISSUED);
			card.setCardValid(cardType.getStatus());
			card.setCreateBy(uid);
			card.setCreateAt(System.currentTimeMillis());
			CardList.add(card);
		}
		//list插入到card
		try {
			cardService.insertList(CardList);
			log.info("insert card list success, length is: " + CardList.size());
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("insert card list error,id is " + tid );
			model.addAttribute("code", -21003);
		}

		model.addAttribute("code", 0);

		return "/data/json";
	}

    //查看卡券
    @RequestMapping(value = "/a/u/card/{id}", method = RequestMethod.GET)
    public String getCardDetail(HttpServletRequest request,
                                HttpServletResponse response,
                                ModelMap model,
                                @PathVariable Long id) throws Exception {
	    //传参检查
		log.info("get card data : id = " + id);

		if( id == null) {
			model.addAttribute("code",-23004);
			return "/data/json";
		}

        //获取卡券数据
        try {
            Card card = cardService.getObjectById(id);
            if (CheckDataUtil.isNull(card)) {
				model.addAttribute("code",-21005);
				return "/data/json";
			} else {
				log.info("get card by id: " + id);
			}

            model.addAttribute("code", 0);
            model.addAttribute("card", card);
        }catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update card error,id is " + id );
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/card/json/cardDetailJson";
    }


	/**
	 * 卡券发放
	 * @param ownerId 卡券接收人id
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/card/{id}/assign/{ownerId}", method = RequestMethod.PUT)
	public String assignCard(HttpServletRequest request,
								   HttpServletResponse response,
								   ModelMap model,
								   @PathVariable Long id,
								   @PathVariable Long ownerId) throws Exception {
		log.info("assign card, id is: " + id + ", ownerId is: " + ownerId);
		if (null == id) {
			model.addAttribute("code",-21004);
			return "/data/json";
		}
		if (null == ownerId) {
			model.addAttribute("code",-21021);
			return "/data/json";
		}

		// 根据id获取原来的卡券数据
		Card orignCard = null;
		try {
			orignCard = cardService.getObjectById(id);
			if (CheckDataUtil.isNull(orignCard)) {
				model.addAttribute("code",-21005);
				return "/data/json";
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -21005);
		}

		// 卡券禁用，则无法进行修改操作
		if (orignCard.getCardValid() == Card.CARD_VALID_DISABLE) {
			model.addAttribute("code",-21008);
			return "/data/json";
		} else {
			log.info(id + " card valid is enabled!");
		}

		// 获取管理员id
		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
				com.qding.common.util.http.cookie.CookieUtil.USER_ID));

		if (orignCard.getStatus() == Card.STATUS_UNISSUED) {
			orignCard.setOwnerId(ownerId);
			orignCard.setAssignId(uid);
			orignCard.setAssignAt(System.currentTimeMillis());
			orignCard.setStatus(Card.STATUS_UNISSUED);
			orignCard.setUpdateBy(uid);

			Ctype ctype = ctypeService.getObjectById(orignCard.getTid());
			if (CheckDataUtil.isNull(ctype)) {
				model.addAttribute("code",-21020);
				return "/data/json";
			} else {
				log.info("get ctype success, tid is: " + orignCard.getTid());
			}
			Integer expire = ctype.getExpire();
			orignCard.setExpireAt(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(expire));
		}

		try {
			Boolean isUpdate = cardService.update(orignCard);
			if (isUpdate) {
				log.info("assign card success");
			} else {
				model.addAttribute("code",-21007);
				return "/data/json";
			}


			Clog clog = ConvertUtil.card2Clog(Clog.TYPE_ASSIGN, id, orignCard.getTid(), uid, ownerId, null, null);
			Long clogId = clogService.insert(clog);
			log.info("insert clog, id is: " + clogId);
			sendMessage(ownerId, Clog.TYPE_ASSIGN, orignCard.getCode(), orignCard.getTid(), null);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -21007);
		}

		model.addAttribute("code", 0);

		return "/data/json";

	}

	/**
	 * 卡券核销
	 * @param verification 核销是否通过 0：拒绝 1：通过
	 * @return
	 * @throws Exception
	 * */
		@RequestMapping(value = "/a/u/card/{id}/verification/{verification}", method = RequestMethod.PUT)
		public String verifyCard(HttpServletRequest request,
				HttpServletResponse response,
				ModelMap model,
				@PathVariable Long id,
				@PathVariable Integer verification, String remark) throws Exception {
			log.info("assign card, id is: " + id + ", ownerId is: " + verification);
			if (null == id) {
				model.addAttribute("code",-21004);
				return "/data/json";
			}
			if (null == verification) {
				model.addAttribute("code",-21021);
				return "/data/json";
			}

			// 根据id获取原来的卡券数据
			Card orignCard = null;
			try {
				orignCard = cardService.getObjectById(id);
				if (CheckDataUtil.isNull(orignCard)) {
					model.addAttribute("code",-21005);
					return "/data/json";
				}
			} catch (Throwable t) {
				t.printStackTrace();
				log.error(t.getMessage());
				log.error("update card error,id is " + id );
				model.addAttribute("code", -21005);
			}

			// 卡券禁用，则无法进行修改操作
			if (orignCard.getCardValid() == Card.CARD_VALID_DISABLE) {
				model.addAttribute("code",-21008);
				return "/data/json";
			} else {
				log.info(id + " card valid is enabled!");
			}



			// 获取管理员id
			Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
					com.qding.common.util.http.cookie.CookieUtil.USER_ID));

			if (orignCard.getStatus() == Card.STATUS_VERIFICATING) {
				if (verification == Card.VERIFICATION_OFF) {
					orignCard.setStatus(Card.STATUS_ISSUED);
				}
				if (verification == Card.VERIFICATION_ON) {
					orignCard.setStatus(Card.STATUS_VERIFICATED);
				}
				orignCard.setVerificationId(uid);
				orignCard.setVerificationAt(System.currentTimeMillis());
				orignCard.setUpdateBy(uid);
			} else { // 卡券状态不为3，则无法审核
				model.addAttribute("code",-21007);
				return "/data/json";
			}

			try {
				Boolean isUpdate = cardService.update(orignCard);
				if (isUpdate) {
					log.info("assign card success");
				} else {
					model.addAttribute("code",-21007);
					return "/data/json";
				}

				Clog clog = null;
				if (verification == Card.VERIFICATION_OFF) {
					clog = ConvertUtil.card2Clog(Clog.TYPE_VERIFICATED, id, orignCard.getTid(), uid, orignCard.getOwnerId(), null, remark);
					sendMessage(orignCard.getOwnerId(), Clog.TYPE_VERIFICATED, orignCard.getCode(), orignCard.getTid(), remark);
				}
				if (verification == Card.VERIFICATION_ON) {
					clog = ConvertUtil.card2Clog(Clog.TYPE_UNVERIFICATED, id, orignCard.getTid(), uid, orignCard.getOwnerId(), null, remark);
					sendMessage(orignCard.getOwnerId(), Clog.TYPE_UNVERIFICATED, orignCard.getCode(), orignCard.getTid(), remark);
				}
				Long clogId = clogService.insert(clog);
				log.info("insert clog, id is: " + clogId);
			} catch (Throwable t) {
				t.printStackTrace();
				log.error(t.getMessage());
				log.error("update card error,id is " + id );
				model.addAttribute("code", -21007);
			}

			model.addAttribute("code", 0);

			return "/data/json";

		}
	/**
	 * 卡券启用禁用
	 * @param cardValid - 是否启用 0：禁用 1：启用
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/card/{id}/status/{cardValid}", method = RequestMethod.PUT)
	public String updateCardIsAble(HttpServletRequest request,
						   HttpServletResponse response,
						   ModelMap model,
						   @PathVariable Long id, @PathVariable Integer cardValid) throws Exception {

		// 传参检查
		log.info("card id is: " + id + ". card valid is: " + cardValid);
		if (id == null) {
			model.addAttribute("code",-21004);
			return "/data/json";
		}
		if (cardValid == null) {
			model.addAttribute("code",-21011);
			return "/data/json";
		}

		// 根据id获取原来的卡券数据
		Card orignCard = null;
		try {
			orignCard = cardService.getObjectById(id);
			if (CheckDataUtil.isNull(orignCard)) {
				model.addAttribute("code",-21005);
				return "/data/json";
			} else {
				log.info("get card by id success, id is: " + id);
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -21005);
		}

		// 检测传递的状态和卡券原本状态是否一致，一致则无需修改
		if (cardValid.equals(orignCard.getCardValid())) {
			model.addAttribute("code",-21014);
			return "/data/json";
		} else {
			log.info("card valid is different from database");
		}

		// 获取管理员id
		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
				com.qding.common.util.http.cookie.CookieUtil.USER_ID));


		orignCard.setCardValid(cardValid);
		orignCard.setUpdateAt(System.currentTimeMillis());
		orignCard.setUpdateBy(uid);

		try {
			Boolean isUpdate =  cardService.update(orignCard);
			if (isUpdate) {
				log.info("card update success.");
			} else {
				model.addAttribute("code",-21007);
				return "/data/json";
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -21007);
		}

		model.addAttribute("code", 0);

		return "/data/json";
	}


	/**
	 * 卡券列表
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/card/search", method = RequestMethod.GET)
	public String getCardList(HttpServletRequest request,
						   HttpServletResponse response,
						   ModelMap model, Integer page, Integer size,
							  String code, Long tid,
							  Long ownerId,
							  Long assignId,
							  Long verificationId,
							  Long createId,
							  Integer status, Integer cardValid,
							  Long createStartAt, Long createEndAt,
							  Long assignStartAt, Long assignEndAt,
							  Long applyStartAt, Long applyEndAt,
							  Long verificationStartAt, Long verificationEndAt) throws Exception {

		log.info("card list, code = " + code + ", tid = " + tid + ", ownerId = " + ownerId + ", assignId = " + assignId +
				", verificationId = " + verificationId + ", createId = " + createId + ", status = " + status +
				", cardValid = " + cardValid + ", createStartAt = " + createStartAt + ", createEndAt = " + createEndAt +
				", assignStartAt = " + assignStartAt + ", assignEndAt = " + assignEndAt + ", applyStartAt = " + applyStartAt +
				", applyEndAt = " + applyEndAt + ", verificationStartAt = " + verificationStartAt + ", verificationEndAt = " + verificationEndAt);

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		log.info("pageList : page= " + start + " , size=" + size);


		try {
			Map<String, Object> param = DynamicUtil.getCardsQueryListParam(code, tid, ownerId,assignId,verificationId,createId, status, cardValid, createStartAt, createEndAt,
					assignStartAt,assignEndAt, applyStartAt, applyEndAt, verificationStartAt, verificationEndAt, false);
			List<Long> ids = cardService.getIdsByDynamicCondition(Card.class, param, start, size);
			if (CollectionUtils.isEmpty(ids)) {
				model.addAttribute("code",-21010);
				return "/data/json";
			} else {
				log.info("get card ids is: " + ids);
			}

			List<Card> cardList = cardService.getObjectsByIds(ids);
			log.info("get card list success, length is: " + cardList.size());


			// 获取type的内容 && 获取用户名
			Set<Long> tids = new HashSet<>();
			Set<Long> uids = new HashSet<>();
			for (Card cardTemp : cardList) {
				tids.add(cardTemp.getTid());
				uids.add(cardTemp.getOwnerId());
			}
			List<Ctype> ctypeList = ctypeService.getObjectsByIds(new ArrayList<Long>(tids));
			Map<Long, Ctype> id_ctype = MyListUtil.convert2Map(Ctype.class.getDeclaredField("id"), ctypeList);

			List<User> ownerList = userService.getObjectsByIds(new ArrayList<Long>(uids));
			Map<Long, User> id_owner = MyListUtil.convert2Map(User.class.getDeclaredField("id"), ownerList);



			// get total
			Map<String, Object> paramCount = DynamicUtil.getCardsQueryListParam(code, tid, ownerId,assignId,verificationId,createId, status, cardValid, createStartAt, createEndAt,
					assignStartAt,assignEndAt, applyStartAt, applyEndAt, verificationStartAt, verificationEndAt,true);
			List<Long> totalList = cardService.getIdsByDynamicCondition(Card.class, paramCount, 0, Integer.MAX_VALUE);
			Integer total = totalList.get(0).intValue();
			log.info("get card size is " + total);


			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("cardList", cardList);
			model.addAttribute("idCtype", id_ctype);
			model.addAttribute("idOwner", id_owner);


		}  catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get card list error");
			model.addAttribute("code", -21007);
		}


		return "/common-skill-service/card/json/cardListJson";
	}


	// 消息通知
	private void sendMessage(Long uid, Integer type, String code, Long tid, String remark) throws Exception {

		log.info("send message args, uid: " + uid + ". type: " + type + ". code: " + code + ". tid: " + tid + ". remark" + remark);
		// 获取用户信息
		User user = userService.getObjectById(uid);
		String userName = user.getNick();
		log.info("user name is: " + userName);

		// 获取卡券类型信息
		Ctype ctype = ctypeService.getObjectById(tid);
		String title = ctype.getTitle();

		//存入系统消息
		Message message = new Message();
		message.setSendName("admin");
		message.setSendId(0L);
		message.setReceiveName(userName);
		message.setReceiveId(uid);
		message.setContent("");
		message.setStatus(1);
		message.setUnread(1);
		message.setType(Message.CARD_TYPE);
		Long mid = messageService.insert(message);

		//发送系统信息
		String content = "";
		if (type == Clog.TYPE_ASSIGN) {
			// {发放人名称}给你发放了一张{卡券类型名称}
			content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
					"<span class=\\\"font-green\\\">管理员</span>给您发放了一张" +
					"<a data-mid=" + mid + " ng-click=\"sendAlertMsg(li.id)\" class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/school/"+uid+"/myCard/////\\\">"+ title + "[" + code + "]" +"</a>" +
					"</span>";
		} else if (type == Clog.TYPE_VERIFICATED) {
			// 核销通过：你的{卡券类型名称}{卡券编号}已审核通过并生效
			content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
					"您的<a data-mid=" + mid + " ng-click=\"sendAlertMsg(li.id)\" class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/school/"+uid+"/myCard/////\\\">"+ title + "[" + code + "]" +"</a>已审核通过并生效" +
					"</span>";
		} else if (type == Clog.TYPE_UNVERIFICATED) {
			// 核销拒绝：你的{卡券类型名称}{卡券编号}已审核拒绝
			content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
					"您的<a data-mid=" + mid + " ng-click=\"sendAlertMsg(li.id)\" class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/school/"+uid+"/myCard/////\\\">"+ title + "[" + code + "]" +"</a>已审核拒绝，拒绝理由是：" + remark +
					"</span>";
		} else {
			log.info("message error");
			return;
		}

		adminSend(user.getMobile(), content);
		message = messageService.getObjectById(mid);
		message.setContent(content);
		log.info("message mid is " + mid);

		Boolean result = messageService.update(message);
		log.info("message update result is " + result);


		//更新用户信息
		user.setIsLook(user.getIsLook() + 1);
		user.setLatestMsg(Message.CARD_TYPE);
		userService.update(user);

	}
	private static String adminSend(String mobile, String content) {


		String param = "{\n" +
				"    \"target_type\" : \"users\", \n" +
				"    \"target\" : [\"" + mobile + "\"],   \n" +
				"                                   \n" +
				"                                   \n" +
				"    \"msg\" : {\n" +
				"        \"type\" : \"txt\",\n" +
				"        \"msg\" : \"" + content + "\" \n" +
				"        },\n" +
				"    \"from\" : \"admin\"\n" +
				"}";
		String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");


		return result;
	}

	
}

