package com.ptteng.onway.admin.waimai.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.jiabangou.mtwmsdk.api.MtWmClient;
import com.jiabangou.mtwmsdk.api.OrderService;
import com.jiabangou.mtwmsdk.api.impl.MtWmClientImpl;
import com.jiabangou.mtwmsdk.api.impl.MtWmInMemoryConfigStorage;
import com.jiabangou.mtwmsdk.exception.MtWmErrorException;
import com.jiabangou.mtwmsdk.model.OrderDetail;
import com.ptteng.onway.admin.waimai.MeituanWaimaiPushService;
import com.ptteng.onway.platform.model.WaimaiOrderMappingDTO;
import com.ptteng.onway.platform.model.WaimaiStoreMappingDTO;
import com.ptteng.onway.platform.service.TrademarkParamsRelationService;
import com.ptteng.onway.platform.service.WaimaiService;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yangsui on 16/10/10.
 */
@Service
public class MeituanWaimaiPushServiceImpl implements MeituanWaimaiPushService {

    private Logger logger = Logger.getLogger(MeituanWaimaiPushServiceImpl.class);

    @Autowired
    WaimaiService waimaiService;

    @Autowired
    TrademarkParamsRelationService trademarkParamsRelationService;


    @Override
    public void createOrder(Long mchId, OrderDetail orderDetail) throws ServiceException, ServiceDaoException {
        String storeMappingId = String.valueOf(orderDetail.getApp_poi_code());
        String orderTargetId = String.valueOf(orderDetail.getOrder_id());

        WaimaiStoreMappingDTO storeMapping = waimaiService.findStoreMappingByMappingIdPlatformType(storeMappingId, "meituan");
        if (storeMapping == null) {
            return;
        }

        WaimaiOrderMappingDTO orderMapping = waimaiService.findOrderMappingByTargetIdPlatformType(orderTargetId, "meituan");
        if (orderMapping != null) {
            return;
        }

        waimaiService.saveOrderMapping(mchId, storeMapping.getStoreId(), Long.valueOf(orderTargetId), orderTargetId, orderDetail.getWm_order_id_view(),
                "meituan");

        logger.info("begin order!");

        //TODO:将美团外卖订单对象转换为自有平台订单对象
//        OrderCreateMeituanDTO meituanOrder = meituanTransformService.transform(orderDetail, storeMapping);
        Long orderId = null;
        //TODO:保存外卖平台订单到自有平台
//            final OrderCreateResultDTO result = orderService.createWaimaiPlatformOrder(meituanOrder);
//        orderId = Long.valueOf("111111");
    }

    @Override
    public void confirmedOrder(Long mchId, OrderDetail orderDetail) throws ServiceException, ServiceDaoException {
        String storeMappingId = String.valueOf(orderDetail.getApp_poi_code());
        String orderTargetId = String.valueOf(orderDetail.getOrder_id());

        WaimaiStoreMappingDTO storeMapping = waimaiService.findStoreMappingByMappingIdPlatformType(storeMappingId, "meituan");
        if (storeMapping == null) {
            return;
        }

        WaimaiOrderMappingDTO orderMapping = waimaiService.findOrderMappingByTargetIdPlatformType(orderTargetId, "meituan");
        if (orderMapping == null) {
            return;
        }

        //TODO:查看订单是否是美团订单
//        if (!isMeituanOrder(orderMapping.getOrderId())){
//            return;
//        }

        if (orderDetail.getOrder_id().equals(Long.valueOf(orderMapping.getTargetId()))) {
            return;
        }
        //TODO：获取订单状态列表
//        final List<OrderStatusDTO> statuses = orderQueryService.findOrderStatusesByOrderId(orderMapping.getOrderId());
//        if (CollectionUtils.isEmpty(statuses)) {
//            return;
//        }

        final Integer meituanOrderStatus = orderDetail.getStatus();
        if (meituanOrderStatus != 3) {
            return;
        }

        //TODO:如果订单状态中不包含已确认的状态说明美团推送了未被确认的订单
//        if ( ! statuses.contains(OrderConstants.TakeOutStatus.CONFIRMED.getStatusCode()) ) {
//            logger.error(String.format("美团推送了未被确认的订单, 美团订单ID：%s, 平台订单ID: %s",
//                    orderTargetId,
//                    String.valueOf(orderMapping.getOrderId())));
//        }
    }

    @Override
    public void completedOrder(Long mchId, OrderDetail orderDetail) throws ServiceException, ServiceDaoException {
        String storeMappingId = String.valueOf(orderDetail.getApp_poi_code());
        String orderTargetId = String.valueOf(orderDetail.getOrder_id());

        WaimaiStoreMappingDTO storeMapping = waimaiService.findStoreMappingByMappingIdPlatformType(storeMappingId, "meituan");
        if (storeMapping == null) {
            return;
        }

        WaimaiOrderMappingDTO orderMapping = waimaiService.findOrderMappingByTargetIdPlatformType(orderTargetId, "meituan");
        if (orderMapping == null) {
            return;
        }

        //TODO:查看订单是否是美团订单
//        if (!isMeituanOrder(orderMapping.getOrderId())){
//            return;
//        }

        if (Long.valueOf(orderMapping.getTargetId()).equals(orderDetail.getOrder_id())) {
            return;
        }

        //TODO：获取订单状态列表
//        final List<OrderStatusDTO> statuses = orderQueryService.findOrderStatusesByOrderId(orderMapping.getOrderId());
//        if (CollectionUtils.isEmpty(statuses)) {
//            return;
//        }

        final Integer meituanOrderStatus = orderDetail.getStatus();
        if (meituanOrderStatus != 8) {
            return;
        }

        //TODO:如果订单状态中不包含已确认的状态说明美团推送了未被确认的订单
//        if ( ! statuses.contains(OrderConstants.TakeOutStatus.CONFIRMED.getStatusCode()) ) {
//            logger.error(String.format("美团推送了未被确认的订单, 美团订单ID：%s, 平台订单ID: %s",
//                    orderTargetId,
//                    String.valueOf(orderMapping.getOrderId())));
//        }

        //TODO:如果订单状态中包含已完成的订单状态说明有错误逻辑
//        if (statuses.contains(OrderConstants.TakeOutStatus.DELIVERY_SUCCESS.getStatusCode()) ) {
//            logger.error(String.format("美团推送了已完成的订单但是自有平台该订单已经完成了, 美团订单ID：%s, 平台订单ID: %s",
//                    orderTargetId,
//                    String.valueOf(orderMapping.getOrderId())));
//        }
        //TODO:更新自有平台订单状态为已完成
//        OrderUpdateStatusDTO status = new OrderUpdateStatusDTO();
//        status.setOrderIdList(Collections.singletonList(orderMapping.getOrderId()));
//        status.setStatus(OrderConstants.TakeOutStatus.DELIVERY_SUCCESS.getStatusCode());
//        status.setRemark(String.format("美团推送已完成订单状态, 美团订单ID：%s, 平台订单ID: %s", orderTargetId, String.valueOf(orderMapping.getOrderId())));
//        orderUpdateService.updateOrderStatus(status);
    }

    @Override
    public void cancelOrder(Long mchId, String thirdOrderId, Integer reasonCode, String reason) throws ServiceException, ServiceDaoException {

        WaimaiOrderMappingDTO orderMapping = waimaiService.findOrderMappingByTargetIdPlatformType(thirdOrderId, "meituan");
        if (orderMapping == null) {
            return;
        }

        WaimaiStoreMappingDTO storeMapping = waimaiService.findStoreMappingByStoreIdPlatformType(orderMapping.getStoreId(), "meituan");
        if (storeMapping == null) {
            return;
        }

        //TODO:查看订单是否是美团订单
//        if (!isMeituanOrder(orderMapping.getOrderId())){
//            return;
//        }

        this.handleMeituanCancelOrder(mchId, orderMapping.getOrderId(), orderMapping.getTargetId());
    }

    private void handleMeituanCancelOrder(Long mchId, Long orderId, String targetId) throws ServiceException{
        //获取订单信息
//        final OrderDTO order = orderQueryService.findOneById(orderId);
        //已退款,不处理
        //TODO:如果自平台订单状态为已取消，已退款，已完成则不做处理
//        if(StringUtils.equals(order.getStatus(), OrderConstants.TakeOutStatus.REFUNDED.getStatusCode())){
//            return;
//        }
        //配送完成,不处理
//        if(StringUtils.equals(order.getStatus(), OrderConstants.TakeOutStatus.DELIVERY_SUCCESS.getStatusCode())){
//            return;
//        }

        //TODO：更新自由平台订单状态为已取消

        //TODO:这是客服或者用户发起的取消订单，需要给用户退款
        MtWmClient client = getMeituanClient(mchId);
        OrderService orderService = client.getOrderService();
        try{
            orderService.agreeRefund(targetId, "同意退款");
        } catch (MtWmErrorException e){
            throw new ServiceException(e.getMessage(), e);
        }
    }

    private MtWmClient getMeituanClient(Long mchId) {

        //TODO：需要根据平台类型获取外卖配置信息
//        WaimaiAppConfigDTO waimaiAppConfigDTO = trademarkParamsRelationService.getObjectById(mchId,
//                WaimaiConstants.PlatformType.MEITUAN);
//
//        if (Objects.isNull(waimaiAppConfigDTO)) {
//            return null;
//        }
//
//        if (!waimaiAppConfigDTO.getSource().equals(appId)) {
//            return null;
//        }

        final MtWmClientImpl client = new MtWmClientImpl();
        MtWmInMemoryConfigStorage configStorage = new MtWmInMemoryConfigStorage();
        configStorage.setAppId("a");
        configStorage.setSecret("b");
        client.setConfigStorage(configStorage);

//        client.setLogListener((String cmd, String method, boolean isSuccess, String request, String response) -> {
//            logger.info("cmd:" + cmd + "\n" + "isSuccess:" + isSuccess + "\n" +
//                    "request:" + request + "\n" + "response:" + response);
//            try{
//                waimaiService.saveWaiMaiLog(cmd, method, isSuccess, request, response);
//            } catch (Exception e){
//                logger.error(e.getMessage());
//            }
//        });
        return client;
    }

    @Override
    public void refundOrder(Long mchId, String thirdOrderId, String notifyType, String reason) throws ServiceException, ServiceDaoException {
        WaimaiOrderMappingDTO orderMapping = waimaiService.findOrderMappingByTargetIdPlatformType(thirdOrderId, "meituan");
        if (orderMapping == null) {
            return;
        }

        WaimaiStoreMappingDTO storeMapping = waimaiService.findStoreMappingByStoreIdPlatformType(orderMapping.getStoreId(), "meituan");
        if (storeMapping == null) {
            return;
        }

        //TODO:查看订单是否是美团订单
//        if (!isMeituanOrder(orderMapping.getOrderId())){
//            return;
//        }

        // 美团外卖的状态是字符串
        //notify_type	通知类型，apply：用户客服发起退款
        //agree：确认退款
        //reject：驳回退款
        //cancelRefund：用户取消退款申请
        //cancelRefundComplaint :取消退款申诉
        short refundStatus = 0;

        //TODO：更新订自有平台单状态

    }

    //转换退款状态
    //TODO:转换退款状态
    private String translateRefundOrderStatus(String notifyType) {
        String translatedOrderStatus =  StringUtils.EMPTY;

        if (StringUtils.equals(notifyType, "apply")) {
//            translatedOrderStatus = OrderConstants.TakeOutStatus.REFUNDING.getStatusCode();
        }else if (StringUtils.equals(notifyType, "agree")) {
//            translatedOrderStatus = OrderConstants.TakeOutStatus.REFUNDED.getStatusCode();
        }else if (StringUtils.equals(notifyType, "reject")) {

        }else if (StringUtils.equals(notifyType, "cancelRefund")) {

        }else if (StringUtils.equals(notifyType, "cancelRefundComplaint")) {

        }
        return translatedOrderStatus;
    }

    //转换订单配送状态
    //TODO:将外卖平台订单状态转换成自有平台订单状态
    private String translateOrderStatusDelivery(int status) {
        String translatedOrderStatus =  StringUtils.EMPTY;
        switch (status){
            case 0: //配送单发往配送
                break;
            case 10: //	配送单已确认
                break;
            case 20: //骑手已取餐
//                translatedOrderStatus = OrderConstants.TakeOutStatus.DELIVERING.getStatusCode();
                break;
            case 40: //骑手已送达
//                translatedOrderStatus = OrderConstants.TakeOutStatus.DELIVERY_SUCCESS.getStatusCode();
                break;
            case 100: //配送单已取消
                break;
            default:
        }
        return translatedOrderStatus;
    }

}
