package com.ptteng.onway.admin.unit;

import com.google.gson.reflect.TypeToken;
import com.google.gson.Gson;
import com.ptteng.onway.admin.constents.WaimaiConstents;
import com.ptteng.onway.platform.model.*;
import com.ptteng.onway.platform.model.mtERP.*;
import com.qding.common.util.DataUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * Created by shaobo on 2017/12/7；
 */
public class CoverUtil {
    private static final Log log = LogFactory.getLog(CoverUtil.class);

    /**
     * show 美团订单JSON转model
     * @param order 订单JSON字符串
     * @param trademarkId 品牌id
     * @return com.ptteng.onway.platform.model.UserOrder
     * @author lishaobo
     * @date    2018/1/23
     */
    public static UserOrder orderEPRCover2UserOrder(String order, Long trademarkId) {
        JSONObject jsonObject = JSONObject.fromObject(order);
        OrderEPR orderEPR = (OrderEPR) JSONObject.toBean(jsonObject, OrderEPR.class);
        UserOrder userOrder = new UserOrder();
        userOrder.setId(null);
        userOrder.setStoreName(orderEPR.getPoiName());
        //是否首次下单
        if (orderEPR.getIsPoiFirstOrder()) {
            userOrder.setBuyCount(1);
        } else {
            userOrder.setBuyCount(2);
        }
        //门店id
        userOrder.setStoreId(orderEPR.getePoiId());
        //品牌id
        userOrder.setTrademarkId(trademarkId);
        //渠道
        userOrder.setPlatform(WaimaiConstents.platform_meitian);
        //用户名
        userOrder.setUserName(orderEPR.getRecipientName());
        //手机号
        userOrder.setMobile(orderEPR.getRecipientPhone());
        //送货地址
        userOrder.setDeliveryAddress(orderEPR.getRecipientAddress());
        //期望送到时间
        userOrder.setExpectTime(String.valueOf(orderEPR.getDeliveryTime()));
        //购买时间
        userOrder.setBuyAt(orderEPR.getCtime() * 1000);
        //接单状态
        //订单状态
        switch (orderEPR.getStatus()) {
            //用户已提交订单
            case 1:
                userOrder.setAcceptStatus(UserOrder.ACCEPT_STATUS_WAIT);
                userOrder.setOrderStatus(UserOrder.ORDER_STATUS_UNDONE);
                break;
            //2-可推送到App方平台也可推送到商家
            case 2:
                userOrder.setAcceptStatus(UserOrder.ACCEPT_STATUS_WAIT);
                userOrder.setOrderStatus(UserOrder.ORDER_STATUS_UNDONE);
                break;
            //4-商家已确认
            case 4:
                userOrder.setAcceptAt(orderEPR.getUtime() * 1000);
                userOrder.setAcceptStatus(UserOrder.ACCEPT_STATUS_FINISH);
                userOrder.setOrderStatus(UserOrder.ORDER_STATUS_UNDONE);
                break;
            //6-已配送
            case 6:
                userOrder.setAcceptStatus(UserOrder.ACCEPT_STATUS_FINISH);
                userOrder.setOrderStatus(UserOrder.ORDER_STATUS_PROCESSING);
                break;
            //8-已完成
            case 8:
                userOrder.setAcceptStatus(UserOrder.ACCEPT_STATUS_FINISH);
                userOrder.setOrderStatus(UserOrder.ORDER_STATUS_FINISH);
                //订单更新时间为结束时间
                userOrder.setEndAt(orderEPR.getUtime() * 1000);
                break;
            //已取消
            case 9:
                userOrder.setAcceptStatus(UserOrder.ACCEPT_STATUS_FINISH);
                userOrder.setOrderStatus(UserOrder.ORDER_STATUS_REFUNDING);
                break;
            default:
                log.warn("order status is " + orderEPR.getStatus());

        }
        JSONArray jsonArray = JSONArray.fromObject(orderEPR.getDetail());
        Double boxFee = 0.00;
        //遍历json数组内容
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject orderDetailEPRJson = jsonArray.getJSONObject(i);
            boxFee += (orderDetailEPRJson.getDouble("box_price") * orderDetailEPRJson.getDouble("box_num"));
        }
        //订单金额（订单原价）
        userOrder.setOrderPrice(orderEPR.getOriginalPrice());
        log.info("orderEPR OriginalPrice is " + orderEPR.getOriginalPrice());
        //餐盒费
        userOrder.setBoxFee(BigDecimal.valueOf(boxFee).setScale(2, BigDecimal.ROUND_HALF_UP));
        //配送费
        userOrder.setDeliveryFee(orderEPR.getShippingFee());
        //支付金额（订单总价）
        userOrder.setPayFee(orderEPR.getTotal());
        //优惠金额

        //抽取佣金

        //平台补贴

        //流水单号
        userOrder.setSort(orderEPR.getDaySeq());
        //支付途径 1：货到付款；2：在线支付
        userOrder.setPayWay(orderEPR.getPayType());
        //第三方订单号(订单展示id）
        userOrder.setPlatformOrderNum(orderEPR.getOrderIdView().toString());
        //第三方订单id
        userOrder.setPlatformOrderId(orderEPR.getOrderId());
        //配送方式
        userOrder.setDeliveryMethod(orderEPR.getLogisticsCode().toString());
        //是否需要发票
        userOrder.setInvoice(orderEPR.getHasInvoiced());
        //发票抬头
        userOrder.setInvoiceTitle(orderEPR.getInvoiceTitle());
        //税号
        userOrder.setTaxNum(orderEPR.getTaxpayerId());
        //详情
        userOrder.setDetail(orderEPR.getDetail());
        //用餐人数
        userOrder.setDinnersNumber(orderEPR.getDinnersNumber());
        jsonStrCover2OrderDetailEPRList(userOrder.getDetail());
        //订单备注
        userOrder.setOrderRemarks(orderEPR.getCaution());
        return userOrder;
    }

    public static List<FoodOrderRelation> orderDetailErpToFoodOrderRelationList (List<OrderDetailEPR> orderDetailEPRS,Long ePoiId,Long trademarkId,Long orderId) {
        List<FoodOrderRelation> foodOrderRelationList = new ArrayList<>();
        for (OrderDetailEPR orderDetailEPR : orderDetailEPRS) {
            FoodOrderRelation foodOrderRelation = new FoodOrderRelation();
            foodOrderRelation.setOrderId(orderId);
            foodOrderRelation.setTrademarkId(trademarkId);
            foodOrderRelation.setStoreId(ePoiId);
            foodOrderRelation.setFoodName(orderDetailEPR.getFoodName());
            foodOrderRelation.setFoodId(orderDetailEPR.getAppFoodCode());
            foodOrderRelation.setQuantity(orderDetailEPR.getQuantity());
            foodOrderRelation.setPrice(orderDetailEPR.getPrice());
            foodOrderRelation.setFoodDiscount(orderDetailEPR.getFoodDiscount());
            foodOrderRelation.setPlatform(WaimaiConstents.platform_meitian);
            foodOrderRelationList.add(foodOrderRelation);
            log.info("food id is " + foodOrderRelation.getFoodId() + " ,food name is " + foodOrderRelation.getFoodName());
        }
        return  foodOrderRelationList;
    }








    /**
     * show 拼接成美团菜品
     *
     * @param food          菜品基本信息
     * @param foodType      菜品类信息
     * @param skusEPRS      菜品规格信息
     * @param foodSolid     菜品价格信息
     * @param groupFoodSort 菜品排序信息
     * @param storeId       门店id
     * @return com.ptteng.onway.platform.model.mtERP.DishesEPR
     * @author lishaobo
     * @date 2018/1/22
     */

    public static DishesEPR foodCover2DishesEPR(Food food, String foodType, List<SkusEPR> skusEPRS, FoodSolid foodSolid, GroupFoodSort groupFoodSort, Long storeId) {

        DishesEPR dishesEPR = new DishesEPR();
        dishesEPR.setBoxNum(food.getPackageBoxNum());
        dishesEPR.setBoxPrice(food.getPackageFee());
        dishesEPR.setCategoryName(foodType);
        dishesEPR.setDescription(food.getDescription());
        dishesEPR.setDishName(food.getName());
        dishesEPR.setEDishCode(food.getId());
        dishesEPR.setePoiId(storeId);
        dishesEPR.setIsSoldOut(0);
        dishesEPR.setMinOrderCount(food.getMinOrderNum());
        dishesEPR.setPicture(food.getPic());
        dishesEPR.setSequence(groupFoodSort.getGroupRank());
        dishesEPR.setPrice(foodSolid.getPrice());
        dishesEPR.setMinOrderCount(food.getMinOrderNum());
        dishesEPR.setBoxPrice(food.getPackageFee());
        if (DataUtils.isNotNullOrEmpty(skusEPRS)) {
            dishesEPR.setSkus(skusEPRS);
        }
        String format = "";
        switch (food.getFormat()) {
            case 1:
                format = "份";
                break;
            case 2:
                format = "个";
                break;
            case 3:
                format = "斤";
                break;
            default:
                format = "份";
                break;
        }
        dishesEPR.setUnit(format);

        return dishesEPR;

    }

    public static List<SkusEPR> foodSpecsCover2SkusEPRList(List<FoodSpecRelation> foodSpecs, FoodSolid foodSolid, Map<Integer, BusinessHours> businessHoursMap) {
        try {
            List<SkusEPR> skusEPRList = new ArrayList<>();
            for (int i = 0; i < foodSpecs.size(); i++) {
                SkusEPR skusEPR = new SkusEPR();
                FoodSpecRelation foodSpecRelation = foodSpecs.get(i);
                skusEPR.setAvailableTimes(foodSpecRelation.getAvailableTimes());
                skusEPR.setPrice(foodSolid.getPrice().add(foodSpecRelation.getPrice()));
                skusEPR.setSkuId(foodSolid.getFoodNum() + i);
                skusEPR.setSpec(foodSpecRelation.getSpecName());
                skusEPR.setStock(foodSolid.getStock());
                if (foodSolid.getStatus().equals(FoodSolid.STATUS_ON)){
                    AvailableTimes availableTimes = MtErpUtil.getAvailableTimes(foodSolid.getMealType(), businessHoursMap);
                    skusEPR.setAvailableTimes(availableTimes);
                }else {
                    //状态为不上架时，调整菜品售卖时间为0：00-0：00
                    AvailableTimes availableTimes = MtErpUtil.getAvailableTimes(BusinessHours.DISABLE, businessHoursMap);
                    skusEPR.setAvailableTimes(availableTimes);
                }

                skusEPRList.add(skusEPR);
            }

            return skusEPRList;
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("foodSpecsCover2SkusEPRList error");
            return null;

        }


    }

    public static List<OrderDetailEPR> jsonStrCover2OrderDetailEPRList(String detail) {
        List<OrderDetailEPR> orderDetailEPRList = new ArrayList<>();
        JSONArray jsonArray = JSONArray.fromObject(detail);
        log.info("a jsonArray " + jsonArray);
        for (int i = 0; i < jsonArray.size(); i++) {     //遍历json数组内容
            JSONObject orderDetailEPRJson = jsonArray.getJSONObject(i);
            OrderDetailEPR orderDetailEPR = new OrderDetailEPR();
            orderDetailEPR.setAppFoodCode(orderDetailEPRJson.getLong("app_food_code"));
            orderDetailEPR.setBoxNum(orderDetailEPRJson.getInt("box_num"));
            orderDetailEPR.setBoxPrice(BigDecimal.valueOf(orderDetailEPRJson.getDouble("box_price")));
            orderDetailEPR.setCartId(orderDetailEPRJson.getInt("cart_id"));
            orderDetailEPR.setFoodDiscount(BigDecimal.valueOf(orderDetailEPRJson.getDouble("food_discount")));
            orderDetailEPR.setFoodName(orderDetailEPRJson.getString("food_name"));
            orderDetailEPR.setFoodProperty(orderDetailEPRJson.getString("food_property"));
            orderDetailEPR.setQuantity(orderDetailEPRJson.getInt("quantity"));
            orderDetailEPR.setPrice(BigDecimal.valueOf(orderDetailEPRJson.getDouble("price")));
//            orderDetailEPR.setFoodShareFeeChargeByPoi(orderDetailEPRJson.getDouble("foodShareFeeChargeByPoi"));
            orderDetailEPR.setSkuId(orderDetailEPRJson.getString("sku_id"));
            orderDetailEPR.setUnit(orderDetailEPRJson.getString("unit"));
            orderDetailEPR.setSpec(orderDetailEPRJson.getString("spec"));

            orderDetailEPRList.add(orderDetailEPR);
        }
        log.info("orderDetailEPRList size is " + orderDetailEPRList.size());

        return orderDetailEPRList;

    }

    public static List<EvaluateOrderRelation> EPRJsonStrCover2EvaluateOrderRelationList(String JsonStr, Long storeId, Long evaId) {
        List<EvaluateOrderRelation> evaluateOrderRelationList = new ArrayList<>();
        JSONArray jsonArray = JSONArray.fromObject(JsonStr);
        //遍历json数组内容
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            EvaluateOrderRelation evaluateOrderRelation = new EvaluateOrderRelation();
            evaluateOrderRelation.setOrderScore(jsonObject.getInt("orderCommentScore"));
            evaluateOrderRelation.setFoodCommentScore(jsonObject.getInt("foodCommentScore"));
            evaluateOrderRelation.setDeliveryCommentScore(jsonObject.getInt("orderCommentScore"));
            evaluateOrderRelation.setContent(jsonObject.getString("commentContent"));
            evaluateOrderRelation.setPlatform(WaimaiConstents.platform_meitian);
            //美团返回时间戳为秒，加3个000转为毫秒
            evaluateOrderRelation.setAddCommentTime(jsonObject.getString("addCommentTime") + "000");
            evaluateOrderRelation.setAddComment(jsonObject.getString("addComment"));
            evaluateOrderRelation.setStoreId(storeId);
            evaluateOrderRelation.setPlatformEvaId(jsonObject.getLong("commentId"));

//            evaluateOrderRelation.setEvaluateAt(System.currentTimeMillis());
            //数据中大于库里id的数据才是新数据
            if (evaId != null && (evaluateOrderRelation.getPlatformEvaId() > evaId)) {
                evaluateOrderRelationList.add(evaluateOrderRelation);
            } else if (evaId == null) {
                evaluateOrderRelationList.add(evaluateOrderRelation);
            }

        }
        log.info("orderDetailEPRList size is " + evaluateOrderRelationList.size());

        return evaluateOrderRelationList;

    }

    public static List<FoodSpecRelation> FoodSpecRelationList(String JsonStr, Long id) {
        List<FoodSpecRelation> FoodSpecRelationList = new ArrayList<>();


        log.info("JsonStr==== " + JsonStr);
        JSONArray jsonArray = JSONArray.fromObject(JsonStr);
        log.info("jsonArray==== " + jsonArray);
        //遍历json数组内容
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            FoodSpecRelation foodSpecRelation = new FoodSpecRelation();

            foodSpecRelation = CoverUtil.JSONStringCover2Model(jsonObject.toString(), foodSpecRelation.getClass());
            foodSpecRelation.setTargetId(id);

            FoodSpecRelationList.add(foodSpecRelation);
        }
        log.info("orderDetailEPRList size is " + FoodSpecRelationList.size());

        return FoodSpecRelationList;

    }

    public static List<ZbShippingFee> Cover2ZbShippingFee(String json) {
        Gson gson = new Gson();
        List<ZbShippingFee> zbShippingFees = gson.fromJson(json, new TypeToken<List<ZbShippingFee>>() {
        }.getType());
        log.info("zbShippingFees is " + zbShippingFees);
        return zbShippingFees;
    }

    public static <T> T JSONStringCover2Model(String json, Class<T> tClass) {
        Gson gson = new Gson();
        return gson.fromJson(json, tClass);

    }

}
