package com.ptteng.squirrel.home.interceptor;

import com.gemantic.common.util.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;

public class VersionInterceptor extends HandlerInterceptorAdapter {

	private static final Log log = LogFactory.getLog(VersionInterceptor.class);



	private static final String PARAM_VERSION = "version";

	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {

		try {
			String version = request.getParameter(PARAM_VERSION);
			if (StringUtil.isEmpty(version)) {
				version = request.getHeader(PARAM_VERSION);
			}
			log.info("version interceptor version is: " + version);

			if (StringUtil.isEmpty(version)) {
				log.info("arg version is empty need force updating");
				return versionUpdate(response);
			}

			return true;
		} catch (Throwable t) {
			log.error(t.getMessage(), t);
			return false;
		}
	}

	/**
	 * 强制更新版本
	 *
	 * @param response
	 * @return
	 * @throws IOException
	 */
	private boolean versionUpdate(HttpServletResponse response) throws IOException {

		log.info("force to update version begin...");
		response.sendRedirect("/a/force/update/version");
		/*
		 * RequestDispatcher rd =
		 * request.getRequestDispatcher("/r/json/version.json"); try {
		 * rd.forward(request, response); } catch (ServletException e) {
		 * e.printStackTrace(); } catch (IOException e) { e.printStackTrace(); }
		 */
		return false;
	}

	@Override
	public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
			ModelAndView modelAndView) throws Exception {

		log.info("p =========================================== ");
	}

}
