package com.ptteng.onway.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.onway.admin.constents.WaimaiConstents;
import com.ptteng.onway.admin.unit.DynamicUtil;
import com.ptteng.onway.admin.unit.QueryUtil;
import com.ptteng.onway.platform.model.Role;
import com.ptteng.onway.platform.model.Store;
import com.ptteng.onway.platform.model.Trademark;
import com.ptteng.onway.platform.model.TrademarkParamsRelation;
import com.ptteng.onway.platform.service.TrademarkParamsRelationService;
import com.ptteng.onway.platform.service.TrademarkService;
import com.ptteng.onway.platform.unit.TrademarkParamsList;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.Data;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Trademark  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class TrademarkController {
    private static final Log log = LogFactory.getLog(TrademarkController.class);

    @Autowired
    private TrademarkService trademarkService;
    @Autowired
    private TrademarkParamsRelationService trademarkParamsRelationService;


    /**
     * 品牌列表
     *
     * @param page 页码
     * @param size 每页数据
     * @param name 品牌名称
     * @param platform 已申请对接平台
     */
    @RequestMapping(value = "/a/u/trademark/list", method = RequestMethod.GET)
    public String getTrademarkList(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Integer page, Integer size, String name, String platform) throws Exception {
        log.info("get  /a/u/trademark/list");
        log.info("params : page is " + page + " size is " + size + " name is " + name + " platform is " + platform);

        Role role = (Role) request.getAttribute("role");
        if (!role.getIdentity().equals(Role.SYSTEM_MANAGER)) {
            model.addAttribute("code", -10);
            return "/common/success";
        }

        if (page == null) {
            page = 1;
        }

        if (size == null || size == 0) {
            size = 20;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {

            Map<String, Object> param = DynamicUtil.getTrademarkList(name, platform);

            List<Long> ids = trademarkService.getIdsByDynamicCondition(Trademark.class, param, start, size);
            log.info("trademarkList ids size is " + ids.size());

            List<Trademark> trademarkList = trademarkService.getObjectsByIds(ids);

            Integer total = trademarkService.getTrademarkIds(0, Integer.MAX_VALUE).size();
            model.addAttribute("total", total);
            model.addAttribute("trademarkList", trademarkList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get trademark list error");
            model.addAttribute("code", -1);
        }

        model.addAttribute("code", 0);
        model.addAttribute("size", size);
        model.addAttribute("page", page);


        return "/onway-platform-service/trademark/json/trademarkListJson";
    }

    //excel导出
    @RequestMapping(value = "/a/trademark/list/excel", method = RequestMethod.GET)
    public String getTrademarkListExcel(HttpServletRequest request,
                                        HttpServletResponse response, ModelMap model, Integer page, Integer size, String name, String platform) throws Exception {
        log.info("get  /a/trademark/list");
        log.info("params : page is " + page + " size is " + size + " name is " + name + " platform is " + platform);
        page = 1;
        size = 99999999;
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("platform is " + platform);
        try {

            Map<String, Object> param = DynamicUtil.getTrademarkList(name, platform);

            List<Long> ids = trademarkService.getIdsByDynamicCondition(Trademark.class, param, start, size);
            log.info("trademarkList ids size is " + ids.size());

            List<Trademark> trademarkList = trademarkService.getObjectsByIds(ids);

            Integer total = trademarkService.getTrademarkIds(0, Integer.MAX_VALUE).size();
            model.addAttribute("total", total);
            model.addAttribute("trademarkList", trademarkList);

            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet("sheet");
            Row header_row = sheet.createRow(0);
            String headers[] = new String[]{"序号", "品牌编号", "品牌名称", "已申请对接平台"};
            for (int i = 0; i < headers.length; i++) {
                HSSFCell cell = (HSSFCell) header_row.createCell(i);
                cell.setCellValue(headers[i]);
            }
            for (int i = 1; i < trademarkList.size(); i++) {
                Row rose = sheet.createRow(i);
                for (int j = 0; j < headers.length; j++) {
                    Trademark trademark = trademarkList.get(i);
                    HSSFCell cell0 = (HSSFCell) rose.createCell(0);
                    cell0.setCellValue(i);
                    HSSFCell cell1 = (HSSFCell) rose.createCell(1);
                    cell1.setCellValue(trademark.getTrademarkNum());
                    HSSFCell cell2 = (HSSFCell) rose.createCell(2);
                    cell2.setCellValue(trademark.getName());
                    HSSFCell cell3 = (HSSFCell) rose.createCell(3);
                    cell3.setCellValue(trademark.getPlatform());
                }

            }
            Long excelDate = System.currentTimeMillis();
            String url = "/data/webs/onway-admin-web/excel/品牌参数" + excelDate + ".xls";
            FileOutputStream output = new FileOutputStream(url);
            url = "/exceldownload/品牌参数" + excelDate + ".xls";
            wb.write(output);
            output.flush();
            model.addAttribute("url", url);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get trademark list error");
            model.addAttribute("code", -1);
        }

        model.addAttribute("code", 0);

        return "/common/url";
    }


    /**
     * 品牌参数详情
     *
     * @param id 品牌id
     */

    @RequestMapping(value = "/a/u/trademark/params/{id}", method = RequestMethod.GET)
    public String getTrademarkParamsRelationIdsByTrademarkIdJsonList(HttpServletRequest request,
                                                                     HttpServletResponse response, ModelMap model, @PathVariable Long id
    ) throws Exception {

        log.info("get /a/trademark/params/" + id);
        Role role = (Role) request.getAttribute("role");
        if (!role.getIdentity().equals(Role.SYSTEM_MANAGER)) {
            model.addAttribute("code", -10);
            return "/common/success";
        }

        try {
            List<Long> ids = trademarkParamsRelationService.getTrademarkParamsRelationIdsByTrademarkId(id, 0, Integer.MAX_VALUE);
            log.info("get TrademarkParamsRelationIdsByTrademarkId size is " + ids.size());

            List<TrademarkParamsRelation> trademarkParamsRelationList = trademarkParamsRelationService.getObjectsByIds(ids);
            log.info("get TrademarkParamsRelation data is " + trademarkParamsRelationList.size());

            Integer total = trademarkParamsRelationService.countTrademarkParamsRelationIdsByTrademarkId(id);
            log.info("get TrademarkParamsRelation count is " + total);

            model.addAttribute("code", 0);
            model.addAttribute("total", total);

            model.addAttribute("trademarkParamsRelationList", trademarkParamsRelationList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            log.error("get TrademarkParamsRelation list error");
            // for test
            model.addAttribute("code", -100000);
        }

        return "/onway-platform-service/trademarkParamsRelation/json/trademarkParamsRelationListJson";
    }


    /**
     * 品牌参数设置
     *
     * @param id 品牌id
     *           品牌参数传JSON数组,判断是否存在，存在则更新，不存在则插入数据
     */

    @RequestMapping(value = "/a/u/trademark/params/{id}", method = RequestMethod.PUT)
    public String updateTrademarkParamsRelationJson(HttpServletRequest request,
                                                    HttpServletResponse response, ModelMap model, @PathVariable Long id, @RequestBody TrademarkParamsList trademarkParamsList) throws Exception {

        log.info("PUT /a/trademark/params/" + id);

        log.info("get /a/trademark/params/" + id);
        Role role = (Role) request.getAttribute("role");
        if (!role.getIdentity().equals(Role.SYSTEM_MANAGER)) {
            model.addAttribute("code", -10);
            return "/common/success";
        }

        //参数校验
        List<TrademarkParamsRelation> trademarkParams = trademarkParamsList.getTrademarkParamsList();

        log.info("update TrademarkParamsRelation : TrademarkParamsList= " + trademarkParams);
        if (null == trademarkParams || CollectionUtils.isEmpty(trademarkParams)) {
            model.addAttribute("code", -2007);
            return "/common/success";
        }

        try {
            //获取品牌
            Trademark trademark = trademarkService.getObjectById(id);
            if (null == trademark) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }
            //获取该品牌参数列表
            List<Long> oTrademarkIds = trademarkParamsRelationService.getTrademarkParamsRelationIdsByTrademarkId(id, 0, 4);
            log.info("oTrademarkIds size is " + oTrademarkIds.size());
            //旧数据
            List<TrademarkParamsRelation> oTrademarkList = trademarkParamsRelationService.getObjectsByIds(oTrademarkIds);
            List<TrademarkParamsRelation> mtParamsList = new ArrayList<>();
            Map<String, List<TrademarkParamsRelation>> oldTrademarkParamsRelationMap = new HashMap<>();
            for (TrademarkParamsRelation oTrademarkParamsRelation : oTrademarkList) {
                //美团有两种接入方式，所以可能有两条数据
                if (oTrademarkParamsRelation.getPlatform().equals(WaimaiConstents.platform_meitian)) {
                    mtParamsList.add(oTrademarkParamsRelation);
                    oldTrademarkParamsRelationMap.put(oTrademarkParamsRelation.getPlatform(),mtParamsList);
                }else {
                    List<TrademarkParamsRelation> paramsRelations = new ArrayList<>();
                    paramsRelations.add(oTrademarkParamsRelation);
                    oldTrademarkParamsRelationMap.put(oTrademarkParamsRelation.getPlatform(), paramsRelations);

                }
            }

            //新数据
            List<TrademarkParamsRelation> newTrademarkParamList = new ArrayList<>();
            List<TrademarkParamsRelation> oldTrademarkParamList = new ArrayList<>();

            //检验params列表参数
            List<String> platformList = new ArrayList<>();
            for (TrademarkParamsRelation trademarkParamsRelation : trademarkParams) {
                String platform = trademarkParamsRelation.getPlatform();
                if (trademarkParamsRelation.getIsEnabled().equals(1)) {
                    platformList.add(platform);
                }

                if (DataUtils.isNullOrEmpty(platform)) {
                    model.addAttribute("code", -2004);
                    return "/common/success";
                }

                if (null == trademarkParamsRelation.getAppid()) {
                    model.addAttribute("code", -2005);
                    return "/common/success";
                }

                if (null == trademarkParamsRelation.getSecret()) {
                    model.addAttribute("code", -2006);
                    return "/common/success";
                }

                //DB里的品牌参数数据
                //1.美团两种参数类型处理
                if (platform.equals(WaimaiConstents.platform_meitian)) {
                    List<TrademarkParamsRelation> oldMtTrademarkParams = oldTrademarkParamsRelationMap.get(platform);
                    Map<Integer,TrademarkParamsRelation> mtParamsMap = MyListUtil.convert2Map(TrademarkParamsRelation.class.getDeclaredField("type"),oldMtTrademarkParams);
                    log.info("mtParamsMap is " + mtParamsMap);


                    // MAP有数据，则为需要更新的数据
                    if (DataUtils.isNotNullOrEmpty(mtParamsMap.get(1)) && trademarkParamsRelation.getType().equals(1)) {
                        TrademarkParamsRelation mtParamsBrand = mtParamsMap.get(1);
                        mtParamsBrand.setIsEnabled(trademarkParamsRelation.getIsEnabled());
                        mtParamsBrand.setSecret(trademarkParamsRelation.getSecret());
                        mtParamsBrand.setAppid(trademarkParamsRelation.getAppid());

                      oldTrademarkParamList.add(mtParamsBrand);
                        log.info("oldTrademarkParamList is " + oldTrademarkParamList);
                    }else if (DataUtils.isNotNullOrEmpty(mtParamsMap.get(2)) && trademarkParamsRelation.getType().equals(2)){
                        TrademarkParamsRelation mtParamsBrand = mtParamsMap.get(2);
                        mtParamsBrand.setIsEnabled(trademarkParamsRelation.getIsEnabled());
                        mtParamsBrand.setSecret(trademarkParamsRelation.getSecret());
                        mtParamsBrand.setAppid(trademarkParamsRelation.getAppid());

                        oldTrademarkParamList.add(mtParamsBrand);
                        log.info("oldTrademarkParamList is " + oldTrademarkParamList);
                    } else {
                        trademarkParamsRelation.setTrademarkId(id);
                        newTrademarkParamList.add(trademarkParamsRelation);
                    }


                }else {
                    TrademarkParamsRelation oldTrademarkParam = oldTrademarkParamsRelationMap.get(platform).get(0);
                    log.info("oldTrademarkParam is " + oldTrademarkParam);
                    // MAP有数据，则为需要更新的数据
                    if (DataUtils.isNotNullOrEmpty(oldTrademarkParam)) {
                        oldTrademarkParam.setAppid(trademarkParamsRelation.getAppid());
                        oldTrademarkParam.setIsEnabled(trademarkParamsRelation.getIsEnabled());

                        oldTrademarkParam.setSecret(trademarkParamsRelation.getSecret());
                        oldTrademarkParamList.add(oldTrademarkParam);
                        log.info("oldTrademarkParamList is " + oldTrademarkParamList);
                    } else {
                        trademarkParamsRelation.setTrademarkId(id);
                        newTrademarkParamList.add(trademarkParamsRelation);
                    }
                }

            }
            //执行更新、插入
            if (CollectionUtils.isEmpty(oldTrademarkParamList)) {
                log.info("No data needs to be updated");
            } else {
                trademarkParamsRelationService.updateList(oldTrademarkParamList);
                log.info("update success");
            }

            if (CollectionUtils.isEmpty(newTrademarkParamList)) {
                log.info("No data needs to be insert");
            } else {
                List<TrademarkParamsRelation> result = trademarkParamsRelationService.insertList(newTrademarkParamList);
                log.info("insert success , TrademarkParamsRelation is " + result);
            }
            String trademarkPlatform = QueryUtil.setPlatform(platformList);
            log.info("trademarkPlatform is " + trademarkPlatform);
            trademark.setPlatform(trademarkPlatform);
            trademarkService.update(trademark);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(t.getMessage());
            log.error("update TrademarkParamsRelation error");
            model.addAttribute("code", -1);

        }

        return "/common/insertListSuccess";
    }


    /**
     * 新增、编辑品牌
     *
     * @param trademark 品牌
     * @return code,message
     */
    @RequestMapping(value = "/a/u/trademark", method = RequestMethod.POST)
    public String addTrademarkJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Trademark trademark) throws Exception {

        log.info("insert trademark : trademark= " + trademark);
        Role role = (Role) request.getAttribute("role");
        if (!role.getIdentity().equals(Role.SYSTEM_MANAGER)) {
            model.addAttribute("code", -10);
            return "/common/success";
        }
        //校验品牌名
        if (null == trademark.getName()) {
            log.info("trademark name is null");
            model.addAttribute("code", -2001);
            return "/common/success";
        }
        //校验品牌编号
        log.info("brandNum is "+ role.getBrandNum()) ;
        if (null == trademark.getTrademarkNum() && DataUtils.isNullOrEmpty(role.getBrandNum())) {
            model.addAttribute("code",-2003);
            return "/common/success";
        }else if (DataUtils.isNullOrEmpty(trademark.getTrademarkNum())){
            trademark.setTrademarkNum(role.getBrandNum());
        }

        try {
            Long id = trademarkService.getTrademarkByTrademarkNum(trademark.getTrademarkNum());
            if(id == null) {
               log.info("add new trademark ");
                trademark.setId(null);
                trademark.setCreateBy(Long.valueOf(role.getUserId()));
                trademark.setUpdateBy(Long.valueOf(role.getUserId()));
                id = trademarkService.insert(trademark);
                model.addAttribute("id", id);
            }else {
                log.info("update trademark ,id is " + id);
                Trademark oTrademark = trademarkService.getObjectById(id);
                oTrademark.setName(trademark.getName());
                oTrademark.setUpdateBy(Long.valueOf(role.getUserId()));
                trademarkService.update(oTrademark);
            }
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add trademark error ");
            model.addAttribute("code", -1);
        }

        return "/common/insertSuccess";
    }

}

