package com.ptteng.onway.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ptteng.onway.admin.constents.WaimaiConstents;
import com.ptteng.onway.admin.unit.CoverUtil;
import com.ptteng.onway.admin.unit.QueryUtil;
import com.ptteng.onway.admin.unit.TimeUtil;
import com.ptteng.onway.admin.unit.WaimaiEPRUtil;
import com.ptteng.onway.platform.model.*;
import com.ptteng.onway.platform.model.mtERP.PoiStatus;
import com.ptteng.onway.platform.service.*;
import com.ptteng.onway.platform.unit.BusinessHoursList;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.IdentityUtil;
import com.qding.common.util.json.GsonUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.Data;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Store  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class StoreController {
    private static final Log log = LogFactory.getLog(StoreController.class);

    @Autowired
    private StoreService storeService;
    @Autowired
    private TrademarkService trademarkService;
    @Autowired
    private TrademarkParamsRelationService trademarkParamsRelationService;
    @Autowired
    private WaimaiStoreConsumerService waimaiStoreConsumerService;
    @Autowired
    EvaluateOrderRelationService evaluateOrderRelationService;
    @Autowired
    BusinessHoursService businessHoursService;

    /**
     * 门店信息
     *
     * @return code, message, 门店信息
     */

    @RequestMapping(value = "/a/u/store", method = RequestMethod.GET)
    public String getStoreJson(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model)
            throws Exception {
        log.info("get  /a/store");

        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();
        log.info("role identity is " + role);
        log.info("get data : id= " + storeId);

        try {
            Store store = storeService.getObjectById(storeId);

            if (null == store) {
                model.addAttribute("code", -2301);
                return "/common/success";
            } else {
                Trademark trademark = trademarkService.getObjectById(store.getId());
                if (null == trademark) {
                    log.info("trademark does not exist");
                } else {
                    log.info("trademark id is " + trademark.getId());

                    //获取品牌appid
                    List<Long> ids = trademarkParamsRelationService.getTrademarkParamsRelationIdsByTrademarkIdAndPlatform(trademark.getId(), WaimaiConstents.platform_meitian, 0, 2);
                    if (ids.size() > 0) {
                        List<TrademarkParamsRelation> trademarkParamsRelationList = trademarkParamsRelationService.getObjectsByIds(ids);
                        Map<Integer, TrademarkParamsRelation> trademarkParamsRelationMap = MyListUtil.convert2Map(TrademarkParamsRelation.class.getDeclaredField("type"), trademarkParamsRelationList);
                        TrademarkParamsRelation mtERPParams = trademarkParamsRelationMap.get(2);
                        log.info("meituan trademarkParamsRelation is " + mtERPParams);
                        model.addAttribute("mtERPParams", mtERPParams);
                    }

                    model.addAttribute("trademark", trademark);


                }
            }

            //每次查看门店信息的时候都会更新门店评价数据
            /**
             **美团评价处理，美团这里没有返回时间、订单数据
             * 根据美团的评价id与库里存储的美团最新评价的id比对，判断是否为新数据入库
             * 如果一次数据量不满20条，说明后面已经没有数据；
             * */

            if (store.getMtConnectionMethod().equals(Store.CONNECTION_ERP)) {
                //1.查找最近的一条评价数据读取第三方评价id
                List<Long> ids = evaluateOrderRelationService.getEvaluateOrderRelationIdsByStoreIdPlatform(storeId, WaimaiConstents.platform_meitian, 0, 1);
                Long platformEvaId = 0L;
                log.info("ids size is " + ids.size());
                if (CollectionUtils.isNotEmpty(ids)) {
                    EvaluateOrderRelation evaluateOrderRelation = evaluateOrderRelationService.getObjectById(ids.get(0));
                    platformEvaId = evaluateOrderRelation.getPlatformEvaId();
                }
                log.info("last platformEvaId " + platformEvaId);

                Integer offset = 0;
                //2.请求门店评价数据-时间节点为0点到现在，不满20条就不用再执行了，否则重复执行拉取所有数据
                List<EvaluateOrderRelation> evaluateOrderRelationList = new ArrayList<>();
                String result = "";
                while (true) {
                    result = WaimaiEPRUtil.takeoutPoiQueryReviewList(store.getMtAppAuthToken(), store.getId().toString(), TimeUtil.getTimesTodayMorningInMillis(), System.currentTimeMillis(), offset, 20);

                    if (WaimaiEPRUtil.checkResultForArray(result)) {
                        evaluateOrderRelationList.addAll(CoverUtil.EPRJsonStrCover2EvaluateOrderRelationList(WaimaiEPRUtil.getJsonResultByKey(result, "data", "array"), storeId, platformEvaId));

                    }
                    //不满20调终止循环，否则累加查询起始位置
                    if (evaluateOrderRelationList.size() < 20) {
                        evaluateOrderRelationService.insertList(evaluateOrderRelationList);
                        log.info("insert evaluate list success ,size is " + evaluateOrderRelationList.size());
                        break;
                    } else {
                        offset += 20;
                    }
                }
            }


            model.addAttribute("store", store);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get store error,id is  " + storeId);
            model.addAttribute("code", -100000);
        }
        model.addAttribute("code", 0);

        return "/onway-platform-service/store/json/storeDetailJson";
    }


    /**
     * show 上下线门店（EPR没有提供api），这里设置门店的营业与歇业状态
     *
     * @param platform 平台
     * @param status   上下线状态(营业、歇业）
     * @return code, message
     */
    @RequestMapping(value = "/a/u/store/status", method = RequestMethod.PUT)
    public String onlineStoreJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, String platform, Integer status) throws Exception {

        log.info("online store : platform= " + platform + " ,status is " + status);
        Role role = (Role) request.getAttribute("role");
        Long id = role.getStoreId();
        if (null != id) {
            model.addAttribute("id", id);
        } else {
            model.addAttribute("id", -1);
            return "/common/success";
        }
        if (null == platform) {
            model.addAttribute("code", -2302);
            return "/common/success";
        }

        if (null == status) {
            model.addAttribute("code", -2303);
            return "/common/success";
        }

        try {

            Store oStore = storeService.getObjectById(id);

            String platformName = "";
            switch (platform) {
                case WaimaiConstents.platform_meitian:
                    platformName = "meituan";
                    break;
                case WaimaiConstents.platform_baidu:
                    platformName = "baidu";
                    break;
                case WaimaiConstents.platform_ele:
                    platformName = "ele";
                    break;
                default:
                    log.info("platform error ,platform is " + platform);
                    break;
            }
            log.info("platformName is " + platformName);

            String resultJson = "";
            switch (platform) {
                case WaimaiConstents.platform_meitian:
                    //美团不同接入方式选择不一样的接口；
                    if (status.equals(WaimaiConstents.Online_Status)) {
                        if (oStore.getMtConnectionMethod().equals(Store.CONNECTION_ERP)) {
                            log.info("=====美团ERP门店营业=====");
                            String appAuthToken = oStore.getMtAppAuthToken();
                            log.info("this store appAuthToken is " + appAuthToken);
                            resultJson = WaimaiEPRUtil.takeoutPoiOpen(appAuthToken);
                            log.info("erp store open");
                        } else {

                            //这里还有问题
//					    waimaiStoreConsumerService.onlineStoreByPlatform(oStore.getTrademarkId(),oStore.getId(),platformName);

                        }

                    } else if (status.equals(WaimaiConstents.Offline_Status)) {
                        if (oStore.getMtConnectionMethod().equals(Store.CONNECTION_ERP)) {
                            log.info("=====美团ERP门店歇业=====");
                            resultJson = WaimaiEPRUtil.takeoutPoiClose(oStore.getMtAppAuthToken());
                            log.info("erp store close");
                        } else {
                            //这里还有问题
//					    waimaiStoreConsumerService.offlineStoreByPlatform(oStore.getTrademarkId(),oStore.getId(),platformName);
                        }
                    }
                    break;
                case WaimaiConstents.platform_baidu:
                    break;
                case WaimaiConstents.platform_ele:
                    break;
                default:
                    log.info("platform error ,platform is " + platform);
                    break;
            }


            if (WaimaiEPRUtil.checkResult(resultJson)) {
                model.addAttribute("code", 0);
            } else {
                model.addAttribute("code", -1);
            }
            model.addAttribute("message", WaimaiEPRUtil.getResultMessage(resultJson, "message"));
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            log.error("update store error,id is  " + id);
            model.addAttribute("code", -1);
            return "/common/success";
        }

        return "/common/result";
    }


    /**
     * show 门店外卖相关信息在此接口进行变更
     * @param onlinePlatform 上线门店
     * @param invoice 是否支持发票
     * @param synchronize 同步平台
     * @param autoOrders 同步平台
     * @return JSON
     * @exception Exception 异常信息
     * @author lishaobo
     * @date    2018/1/18
     */
    @RequestMapping(value = "/a/u/store", method = RequestMethod.PUT)
    public String updateStoreJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, String onlinePlatform, Integer invoice, String synchronize, Integer autoOrders) throws Exception {
        log.info("update store : OnlinePlatform= " + onlinePlatform + " , invoice= " + invoice + " , synchronize=" + synchronize + " , autoOrders=" + autoOrders);
        Role role = (Role) request.getAttribute("role");
        Long id = role.getStoreId();

        if (null != id) {
            model.addAttribute("id", id);
        } else {
            model.addAttribute("id", -1);
        }

        try {
            Store oStore = storeService.getObjectById(id);

            if (null == oStore) {
                model.addAttribute("id", -2301);
                return "/common/success";
            }
////            if (DataUtils.isNotNullOrEmpty(onlinePlatform)) {
//                oStore.setOnlinePlatform(onlinePlatform);
//                log.info("update onlinePlatform, onlinePlatform is " + onlinePlatform);
////            }
            if (DataUtils.isNotNullOrEmpty(invoice)) {
                oStore.setInvoice(invoice);
                log.info("update invoice, invoice is " + invoice);

            }
            if (DataUtils.isNotNullOrEmpty(synchronize)) {
                oStore.setSynchronize(synchronize);
                log.info("update synchronize, synchronize is " + synchronize);

            } else {
                synchronize = oStore.getSynchronize();
            }
            if (DataUtils.isNotNullOrEmpty(autoOrders)) {
                oStore.setAutoOrders(autoOrders);
                log.info("update autoOrders, autoOrders is " + autoOrders);

            }
            //更新信息入库
            storeService.update(oStore);
            log.info("update store success");

            //获取门店营业时间信息
            List<Long> businessHoursIds = businessHoursService.getBusinessHoursIdsByTargetIdAndStatus(id, BusinessHours.OPEN, 0, Integer.MAX_VALUE);
            List<BusinessHours> businessHoursList = businessHoursService.getObjectsByIds(businessHoursIds);
            log.info("businessHoursList size is " + businessHoursList.size());

            List<String> monday = new ArrayList<>();
            List<String> tuesday = new ArrayList<>();
            List<String> wednesday = new ArrayList<>();
            List<String> thursday = new ArrayList<>();
            List<String> friday = new ArrayList<>();
            List<String> saturday = new ArrayList<>();
            List<String> sunday = new ArrayList<>();

            if (QueryUtil.inPlatform(synchronize, "meituan")) {
                //美团ERP同步逻辑,美团ERP无接口修改门店信息
                if (oStore.getMtConnectionMethod().equals(Store.CONNECTION_ERP)) {
                    //1.设置营业时间
                    if (CollectionUtils.isEmpty(businessHoursList)) {
                        model.addAttribute("code", -2315);
                        return "/common/success";
                    }
                    for (BusinessHours businessHours : businessHoursList) {
                        String week = businessHours.getWeek();
                        //周一时间
                        if (week.contains(BusinessHours.MONDAY + "")) {
                            monday.add(businessHours.getStartTime() + "-" + businessHours.getEndTime());
                        }
                        //周二时间
                        if (week.contains(BusinessHours.TUESDAY + "")) {
                            tuesday.add(businessHours.getStartTime() + "-" + businessHours.getEndTime());
                        }
                        //周三时间
                        if (week.contains(BusinessHours.WEDNESDAY + "")) {
                            wednesday.add(businessHours.getStartTime() + "-" + businessHours.getEndTime());
                        }
                        //周四时间
                        if (week.contains(BusinessHours.THURSDAY + "")) {
                            thursday.add(businessHours.getStartTime() + "-" + businessHours.getEndTime());
                        }
                        //周五时间
                        if (week.contains(BusinessHours.FRIDAY + "")) {
                            friday.add(businessHours.getStartTime() + "-" + businessHours.getEndTime());
                        }
                        //周六时间
                        if (week.contains(BusinessHours.SATURDAY + "")) {
                            saturday.add(businessHours.getStartTime() + "-" + businessHours.getEndTime());
                        }
                        //周日时间
                        if (week.contains(BusinessHours.SUNDAY + "")) {
                            sunday.add(businessHours.getStartTime() + "-" + businessHours.getEndTime());
                        }
                    }
                    String openTime =
                            String.join(",", monday) + ";" +
                                    String.join(",", tuesday) + ";" +
                                    String.join(",", wednesday) + ";" +
                                    String.join(",", thursday) + ";" +
                                    String.join(",", friday) + ";" +
                                    String.join(",", saturday) + ";" +
                                    String.join(",", sunday);
                    log.info("open time is " + openTime);

                    WaimaiEPRUtil.takeoutPoiUpdateOpenTime(oStore.getMtAppAuthToken(), openTime);
                }


            }
            /*三方平台執行同步*/
            doStoreSynchronize(id);


            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update store error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    public void doStoreSynchronize(Long id) throws Exception {
        try {
            Store store = storeService.getObjectById(id);
            log.info("store is " + store);
            WaimaiStoreDTO waiMaiStoreDTO = new WaimaiStoreDTO();
            //支持发票
            waiMaiStoreDTO.setIsInvoice(store.getInvoice());
            //门店名字-美团、饿了么
            waiMaiStoreDTO.setName(store.getName());
            //客服电话-美团、百度
            waiMaiStoreDTO.setServicePhone(store.getServicePhone());
//            //营业时间
//            waiMaiStoreDTO.setOpenTime(store.getOpenTime());
            //店铺图片地址
            waiMaiStoreDTO.setShopLogo(store.getShopLogo());
            //是否接收预下单-美团、饿了么
            waiMaiStoreDTO.setIsBookable(store.getIsBookable());
            //门店电话
            waiMaiStoreDTO.setPhone(store.getPhone());
            //门店支持开发票的最小订单价
            waiMaiStoreDTO.setInvoiceMinAmount(store.getInvoiceMinAmount());
            //满xx免餐盒费-饿了么
            waiMaiStoreDTO.setNoAgentFeeTotal(store.getNoAgentFeeTotal());
            //订单打包费-饿了么
            waiMaiStoreDTO.setPackingFee(store.getPackingFee());
            //外卖起送价-百度
            waiMaiStoreDTO.setMinOrderPrice(store.getMinOrderPrice());
            //餐盒费-百度
            waiMaiStoreDTO.setPackageBoxPrice(store.getPackageBoxPrice());
            //门店公告信息
            waiMaiStoreDTO.setPromotionInfo((store.getPromotionInfo()));

            log.info("update store info is " + waiMaiStoreDTO);
            //同步门店信息
            waimaiStoreConsumerService.updateStore(store.getTrademarkId(), id, waiMaiStoreDTO);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("synchronize store error,id is  " + id);
        }

    }


    /**
     * show 根据请求的门店返回美团ERP门店绑定的url
     * @return 符合绑定条件返回url
     * @exception Exception 异常信息
     * @author lishaobo
     * @date    2018/1/18
     */
    @RequestMapping(value = "/a/u/store/releaseBinding", method = RequestMethod.GET)
    public String storeReleaseBinding(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model) throws Exception {



        log.info(" store releaseBinding");
        Role role = (Role) request.getAttribute("role");
        Long id = role.getStoreId();
        try {
            Store store = storeService.getObjectById(id);

            if (null == store) {
                log.info("this store does not exist");
            } else if (store.getMtConnectionMethod().equals(Store.CONNECTION_ERP)) {
                log.info(" releasebinding store id is " + store.getId());

                String appAuthToken = store.getMtAppAuthToken();
                Long pid = trademarkParamsRelationService.getTrademarkParamsRelationIdsByTrademarkIdAndPlatformAndType(store.getTrademarkId(), WaimaiConstents.platform_meitian, Store.CONNECTION_ERP);
                if (null == pid) {
                    model.addAttribute("code", -2314);
                    return "/common/success";
                }

                TrademarkParamsRelation trademarkParamsRelation = trademarkParamsRelationService.getObjectById(pid);
                String signKey = trademarkParamsRelation.getSecret();

                String url = "https://open-erp.meituan.com/releasebinding?signKey=" + signKey + "&businessId=2&appAuthToken=" + appAuthToken;
                log.info("releasebinding url is " + url);
                model.addAttribute("message", url);
            } else if (store.getMtConnectionMethod().equals(Store.CONNECTION_NOT)) {
                model.addAttribute("code", -2313);
                return "/common/success";
            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update store error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/callbackSuccess";
    }

    /**
     * show 根据发起请求的门店，符合要求的门店则返回绑定跳转的url
     * @return 门店绑定所需要跳转的url
     * @exception Exception 异常信息
     * @author lishaobo
     * @date    2018/1/18
     */
    @RequestMapping(value = "/a/u/store/binding", method = RequestMethod.GET)
    public String storeBinding(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model) throws Exception {


        log.info(" store binding");
        Role role = (Role) request.getAttribute("role");
        if (!role.getIdentity().equals(Role.STORE_MANAGER)) {
            model.addAttribute("code", -10);
            return "/common/success";
        }
        Long id = role.getStoreId();
        try {
            Store store = storeService.getObjectById(id);

            if (null == store) {
                log.info("this store does not exist");
            } else if (store.getMtConnectionMethod().equals(Store.CONNECTION_NOT)) {
                log.info(" binding store is " + store);

                Long pid = trademarkParamsRelationService.getTrademarkParamsRelationIdsByTrademarkIdAndPlatformAndType(store.getTrademarkId(), WaimaiConstents.platform_meitian, Store.CONNECTION_ERP);
                if (null == pid) {
                    model.addAttribute("code", -2314);
                    return "/common/success";
                }
                TrademarkParamsRelation trademarkParamsRelation = trademarkParamsRelationService.getObjectById(pid);
                String url = "https://open-erp.meituan.com/storemap?developerId=" + trademarkParamsRelation.getAppid() + "&businessId=2&ePoiId=" + store.getId() + "&signKey=" + trademarkParamsRelation.getSecret() + "&ePoiName=" + store.getName();
                log.info("binding url is " + url);
                model.addAttribute("message", url);
            } else if (store.getMtConnectionMethod().equals(Store.CONNECTION_ERP)) {
                model.addAttribute("code", -2312);
                return "/common/success";
            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update store error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/callbackSuccess";
    }


    /**
     * 美团EPR接入回调接口，在映射完成后的会调配
     *
     * @param appAuthToken 门店绑定的授权token，将来的门店业务操作必须要传
     * @param businessId   1为团购业务；2为外卖业务
     * @param ePoiId       门店绑定时，传入的erp厂商分配给门店的唯一标识
     * @param timestamp    门店绑定的时间戳
     */
    @RequestMapping(value = "/a/store/map", method = RequestMethod.POST)
    public String storeMapCallBackJson(HttpServletRequest request,
                                       HttpServletResponse response, ModelMap model, String appAuthToken, String businessId, Long ePoiId, String timestamp) throws Exception {

        log.info(" store map: appAuthToken= " + appAuthToken + " , businessId= " + businessId + " , ePoiId=" + ePoiId + " , timestamp=" + timestamp);

        try {
            Store store = storeService.getObjectById(ePoiId);

            if (null == store) {
                log.info("this store does not exist");
            } else {
                log.info(" map store id is " + store.getId());
                store.setMtAppAuthToken(appAuthToken);
                store.setMtConnectionMethod(Store.CONNECTION_ERP);
                storeService.update(store);
            }
            model.addAttribute("message", "success");
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update store error,id is  " + ePoiId);
            model.addAttribute("code", -1);

        }

        return "/common/callbackSuccess";
    }





    /**
     * 美团EPR解绑回调接口，在解绑完成后的会调配
     *
     * @param developerId 开发者id
     * @param businessId  1为团购业务；2为外卖业务
     * @param ePoiId      门店绑定时，传入的erp厂商分配给门店的唯一标识
     * @param timestamp   门店绑定的时间戳
     *
     */
    @RequestMapping(value = "/a/store/releasebinding", method = RequestMethod.POST)
    public String storeReleasebindingCallBackJson(HttpServletRequest request,
                                                  HttpServletResponse response, ModelMap model, String developerId, String businessId, Long ePoiId, String timestamp) throws Exception {

        log.info(" store releasebinding: developerId= " + developerId + " , businessId= " + businessId + " , ePoiId=" + ePoiId + " , timestamp=" + timestamp);

        try {
            Store store = storeService.getObjectById(ePoiId);

            if (null == store) {
                log.info("this store does not exist");
            } else {
                log.info(" map store is " + store);
                store.setMtAppAuthToken("0");
                store.setMtConnectionMethod(Store.CONNECTION_NOT);
                storeService.update(store);
            }
            log.info("releasebinding success ,store id is " + store.getId());
            model.addAttribute("message", "success");
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update store error,id is  " + ePoiId);
            model.addAttribute("code", -1);

        }

        return "/common/callbackSuccess";
    }


    /**
     * show 美团ERP心跳检测
     * @return java.lang.String
     * @exception Exception 异常信息
     * @author lishaobo
     * @date    2018/1/18
     */
    @RequestMapping(value = "/a/heartbeat", method = RequestMethod.POST)
    public String heartbeatCallBackJson(HttpServletRequest request,
                                        HttpServletResponse response, ModelMap model) throws Exception {

        log.info("meituan heartbeat request");

        try {


            model.addAttribute("message", "OK");
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("heartbeat error");
            model.addAttribute("code", -1);

        }

        return "/common/callbackSuccess";
    }

    /**
     * show 提供美团ERP门店状态变动时回调
     * @param developerId 开发者id
     * @param sign 秘钥
     * @param poiStatus 门店状态参数
     * @return java.lang.String
     * @exception Exception 异常信息
     * @author lishaobo
     * @date    2018/1/18
     */

    @RequestMapping(value = "/a/store/status", method = RequestMethod.POST)
    public String storeStatusCallback(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, Integer developerId, String sign, String poiStatus) throws Exception {


        log.info("store status change poiStatus is " + poiStatus);

        try {
            Gson gson = new Gson();
            PoiStatus poiStatusData = gson.fromJson(poiStatus, PoiStatus.class);
            Long storeId = Long.valueOf(poiStatusData.getePoiId());

            Store store = storeService.getObjectById(storeId);
            String onlinePlatform = store.getOnlinePlatform();
            switch (poiStatusData.getPoiStatus()) {
                case PoiStatus.CLOSE:
                    log.info("====store close===");
                    onlinePlatform = QueryUtil.updatePlatformStr(WaimaiConstents.platform_meitian, Store.CLOSE, store.getOnlinePlatform());
                    break;
                case PoiStatus.OPEN:
                    log.info("====store open===");
                    onlinePlatform = QueryUtil.updatePlatformStr(WaimaiConstents.platform_meitian, Store.OPEN, store.getOnlinePlatform());
                    break;
                case PoiStatus.OFFLINE:
                    log.info("====store offline===");
                    onlinePlatform = QueryUtil.updatePlatformStr(WaimaiConstents.platform_meitian, Store.CLOSE, store.getOnlinePlatform());

                    break;
                case PoiStatus.ONLINE:
                    log.info("====store online===");
                    onlinePlatform = QueryUtil.updatePlatformStr(WaimaiConstents.platform_meitian, Store.OPEN, store.getOnlinePlatform());
                    break;
                default:
                    log.info("poiStatus error ,status is " + poiStatusData.getPoiStatus());
            }
            log.info("onlinePlatform is " + onlinePlatform);
            store.setOnlinePlatform(onlinePlatform);
            storeService.update(store);
            log.info("status change success");
            model.addAttribute("message", "OK");
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("heartbeat error");
            model.addAttribute("code", -1);

        }

        return "/common/callbackSuccess";
    }

    /**
     * show 新增修改门店信息，根据storeNum进行判断新增与修改
     * @param  store 门店信息
     * @return java.lang.String
     * @exception Exception 异常信息
     * @author lishaobo
     * @date    2018/1/18
     */
    @RequestMapping(value = "/a/u/storeInfo", method = RequestMethod.POST)
    public String addStoreJson(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, Store store,String businessHoursList ) throws Exception {

        log.info(" storeInfo= " + store);
        Role role = (Role) request.getAttribute("role");

        if (!role.getIdentity().equals(Role.SYSTEM_MANAGER)) {
            model.addAttribute("code", -10);
            return "/common/success";
        }

        //参数校验
        log.info("role brandNum");
        if (DataUtils.isNullOrEmpty(store.getTrademarkNum()) && DataUtils.isNullOrEmpty(role.getBrandNum())) {
            model.addAttribute("code", -2118);
            return "/common/success";
        }else if(DataUtils.isNullOrEmpty(store.getTrademarkNum())) {
            log.info("store trademarkNum is null ,use role brandNum");
            store.setTrademarkNum(role.getBrandNum());
        }

        if (DataUtils.isNullOrEmpty(store.getName())) {
            model.addAttribute("code", -2300);
            return "/common/success";
        }
        if (DataUtils.isNullOrEmpty(store.getStoreNum())) {
            model.addAttribute("code", -2311);
            return "/common/success";
        }
        try {

            Long oid = storeService.getStoreIdByStoreNum(store.getStoreNum());
            log.info("store id is " + oid);
            Long tid = trademarkService.getTrademarkByTrademarkNum(store.getTrademarkNum());
            if (null == tid) {
                model.addAttribute("code", -2000);
                return "common/success";
            } else {
                log.info("trademark id is " + tid);
                store.setTrademarkId(tid);
            }
            //能找到id执行更新，找不到执行插入
            if (null == oid) {
                log.info("add new store ");
                store.setId(null);
                store.setTrademarkNum(role.getBrandNum());
                store.setCreateBy(Long.valueOf(role.getUserId()));
                store.setUpdateBy(Long.valueOf(role.getUserId()));

                oid = storeService.insert(store);
                log.info("add store success ,id is " + oid);
                model.addAttribute("id", oid);
            } else {
                log.info("update store,id is " + oid);
                Store oStore = storeService.getObjectById(oid);
                //是否支持发票不在此端口设置，用原数据
                store.setInvoice(oStore.getInvoice());
                //是否开启自动接单不在此端口设置，用原数据
                store.setAutoOrders(oStore.getAutoOrders());
                //同步平台设置不在此端口设置，用原数据
                store.setSynchronize(oStore.getSynchronize());

                store.setId(oStore.getId());
                store.setOnlinePlatform(oStore.getOnlinePlatform());
                store.setCreateAt(oStore.getCreateAt());
                store.setMtAppAuthToken(oStore.getMtAppAuthToken());
                store.setUpdateBy(Long.valueOf(role.getUserId()));
                store.setCreateBy(oStore.getCreateBy());
                storeService.update(store);
                log.info("update store is " + store);
            }
            if (DataUtils.isNotNullOrEmpty(businessHoursList)) {
                Gson gson = new Gson();
                List<BusinessHours> businessHoursListData =  gson.fromJson(businessHoursList,new TypeToken<List<BusinessHours>>(){}.getType());
                for (BusinessHours businessHours : businessHoursListData) {
                    if (null == businessHours.getMealType()) {
                        model.addAttribute("code", -2306);
                        return "common/success";
                    }
                    if (businessHours.getStatus().equals(BusinessHours.OPEN)) {
                        if (DataUtils.isNullOrEmpty(businessHours.getWeek())) {
                            model.addAttribute("code", -2307);
                            return "common/success";
                        }
                        if (DataUtils.isNullOrEmpty(businessHours.getStartTime())) {
                            model.addAttribute("code", -2308);
                            return "common/success";
                        }
                        if (DataUtils.isNullOrEmpty(businessHours.getEndTime())) {
                            model.addAttribute("code", -2309);
                            return "common/success";
                        }

                    }
                    businessHours.setTragetId(oid);
                }

                log.info("update store businessHoursList");
                //删除原来的信息
                List<Long> oIds = businessHoursService.getBusinessHoursIdsByTargetId(oid, 0, Integer.MAX_VALUE);
                log.info("delete old data ,id is " + oIds);
                businessHoursService.deleteList(BusinessHours.class, oIds);

                log.info("insert new data");
                List<BusinessHours> newBusinessHours = businessHoursService.insertList(businessHoursListData);
                log.info("insert new data success, size is " + newBusinessHours.size());

            }



//            doStoreSynchronize(oid);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add store error ");
            model.addAttribute("code", -1);
        }

        return "/common/insertSuccess";
    }

//
//    /**
//     * 修改门店基本信息
//     *
//     * @param store 门店
//     */
//    @RequestMapping(value = "/a/u/storeInfo", method = RequestMethod.PUT)
//    public String updateStore(HttpServletRequest request,
//                              HttpServletResponse response, ModelMap model, Store store) throws Exception {
//
//        log.info("update store : store= " + store);
//
//        Role role = (Role) request.getAttribute("role");
//        Long id = role.getStoreId();
//        try {
//            Store oStore = storeService.getObjectById(id);
//            //没有的时候进行数据添加-再执行同步
//            if (null == oStore) {
//                model.addAttribute("code", -2301);
//                return "/common/success";
//            } else {
//
//                store.setStoreNum(oStore.getStoreNum());
//                store.setTrademarkNum(oStore.getTrademarkNum());
//                //是否支持发票不在此端口设置，用原数据
//                store.setInvoice(oStore.getInvoice());
//                //是否开启自动接单不在此端口设置，用原数据
//                store.setAutoOrders(oStore.getAutoOrders());
//                //同步平台设置不在此端口设置，用原数据
//                store.setSynchronize(oStore.getSynchronize());
//                store.setTrademarkId(oStore.getTrademarkId());
//                store.setId(oStore.getId());
//                store.setOnlinePlatform(oStore.getOnlinePlatform());
//                store.setCreateAt(oStore.getCreateAt());
//                store.setMtAppAuthToken(oStore.getMtAppAuthToken());
//                if (DataUtils.isNullOrEmpty(store.getName())) {
//                    store.setName(oStore.getName());
//                }
//
//                log.info("update store is " + store);
//
//                store.setUpdateBy(Long.valueOf(role.getUserId()));
//                storeService.update(store);
//
//                Store newStore = storeService.getObjectById(id);
//                String appAuthToken = newStore.getMtAppAuthToken();
//                String openTime = newStore.getOpenTime();
//
////
////                //调整营业时间
////                String resultJson = WaimaiEPRUtil.takeoutPoiUpdateOpenTime(appAuthToken, openTime);
////
////
////                if (WaimaiEPRUtil.checkResult(resultJson)) {
////                    model.addAttribute("code", 0);
////                } else {
////                    model.addAttribute("code", -1);
////                }
////                model.addAttribute("message", WaimaiEPRUtil.getResultMessage(resultJson, "message"));
////                return "/common/result";
//            }
//            //同步门店
//            doStoreSynchronize(id);
//
//        } catch (Throwable t) {
//            t.printStackTrace();
//            log.error(t.getMessage());
//            log.error("add store error ");
//            model.addAttribute("code", -1);
//        }
//
//        return "/common/success";
//    }


    /**
     * show 门店营业时间新增与修改，每次都会清除旧数据，加入新数据
     * @param businessHoursList 营业时间List
     * @return : java.lang.String
     * @exception  Exception 代码异常
     * @author lishaobo
     * @date   2018/1/18
     */

    @RequestMapping(value = "/a/u/store/businessHours", method = RequestMethod.POST)
    public String updateStoreBusinessHours(HttpServletRequest request,
                                           HttpServletResponse response, ModelMap model, String businessHoursList) throws Exception {


        log.info("businessHoursList is " + businessHoursList);
//        List<BusinessHours> businessHoursListData = businessHoursList.getBusinessHoursList();
        Gson gson = new Gson();
        List<BusinessHours> businessHoursListData =  gson.fromJson(businessHoursList,new TypeToken<List<BusinessHours>>(){}.getType());

        log.info("update store open time : businessHours= " + businessHoursListData);
        Role role = (Role) request.getAttribute("role");
        Long id = role.getStoreId();
        log.info("store num is " + role.getStoreNum()+" , id is " +id);
        if (DataUtils.isNullOrEmpty(id)) {
            model.addAttribute("code", -2311);
            return "common/success";
        }
        for (BusinessHours businessHours : businessHoursListData) {
            if (null == businessHours.getMealType()) {
                model.addAttribute("code", -2306);
                return "common/success";
            }
            if (businessHours.getStatus().equals(BusinessHours.OPEN)) {
                if (DataUtils.isNullOrEmpty(businessHours.getWeek())) {
                    model.addAttribute("code", -2307);
                    return "common/success";
                }
                if (DataUtils.isNullOrEmpty(businessHours.getStartTime())) {
                    model.addAttribute("code", -2308);
                    return "common/success";
                }
                if (DataUtils.isNullOrEmpty(businessHours.getEndTime())) {
                    model.addAttribute("code", -2309);
                    return "common/success";
                }

            }
            businessHours.setTragetId(id);
        }

        try {
            //删除原来的信息
            List<Long> oIds = businessHoursService.getBusinessHoursIdsByTargetId(id, 0, Integer.MAX_VALUE);
            log.info("delete old data ,id is " + oIds);
            businessHoursService.deleteList(BusinessHours.class, oIds);

            log.info("insert new data");
            List<BusinessHours> newBusinessHours = businessHoursService.insertList(businessHoursListData);
            List ids = MyListUtil.getList(BusinessHours.class.getDeclaredField("id"), newBusinessHours);
            log.info("insert success ,size is " + newBusinessHours.size());

            model.addAttribute("code", 0);
            model.addAttribute("ids", ids);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add store error ");
            model.addAttribute("code", -1);
        }

        return "/common/insertListSuccess";
    }


}

