package com.ptteng.onway.admin.controller;

import com.google.common.base.Strings;
import com.jiabangou.mtwmsdk.api.MtWmClient;
import com.jiabangou.mtwmsdk.api.PushConsumer;
import com.jiabangou.mtwmsdk.api.impl.MtWmClientImpl;
import com.jiabangou.mtwmsdk.api.impl.MtWmInMemoryConfigStorage;
import com.jiabangou.mtwmsdk.model.ResultMessage;
import com.ptteng.onway.admin.waimai.MeituanWaimaiPushConsumer;
import com.ptteng.onway.admin.waimai.MeituanWaimaiPushService;
import com.ptteng.onway.platform.service.TrademarkService;
import com.ptteng.onway.platform.service.WaimaiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * Author wanglei
 * Created on 17-11-19
 */
@Controller
public class MeituanOrderPushController {

    private static final Logger logger = LoggerFactory.getLogger(MeituanOrderPushController.class);

    @Autowired
    private TrademarkService trademarkService;

    @Autowired
    private MeituanWaimaiPushService meituanWaimaiPushService;

    @Autowired
    private WaimaiService waimaiService;

    @RequestMapping(value = "/waimai/m/{mchId:[0-9]+}/meituan/{pushAction:[a-z_]+}/callback.json", method = RequestMethod.GET)
    public String callbackGet(HttpServletRequest request,
                           HttpServletResponse response,
                           ModelMap model,
                           @PathVariable Long mchId,
                           @PathVariable String pushAction,
                           String appId) throws Exception {

        if(Strings.isNullOrEmpty(appId)){
            model.addAttribute("data", "ok");
            return "/waimai/order/sucess";
        }

        return handle(request, response, model, mchId, pushAction, appId);
    }

    @RequestMapping(value = "/waimai/m/{mchId:[0-9]+}/meituan/{pushAction:[a-z_]+}/callback.json", method = RequestMethod.POST)
    public String callbackPost(HttpServletRequest request,
                           HttpServletResponse response,
                           ModelMap model,
                           @PathVariable Long mchId,
                           @PathVariable String pushAction,
                           String appId) throws Exception {

        if(Strings.isNullOrEmpty(appId)){
            model.addAttribute("data", "ok");
            return "/waimai/order/sucess";
        }

        return handle(request, response, model, mchId, pushAction, appId);
    }


    public String handle(HttpServletRequest request,
                           HttpServletResponse response,
                           ModelMap model,
                           @PathVariable Long mchId,
                           @PathVariable String pushAction,
                           String appId) {

        logger.info("meituan平台订单订单推送信息");
        final MtWmClient client = getMeituanClient(mchId, appId);

        if (client == null) {
            model.addAttribute("data", "无权访问当前接口");
            return "/waimai/order/error";
        }

        switch (pushAction){
            case PushConsumer.CREATE_ORDER:
                break;
            case PushConsumer.CONFIRMED_ORDER:
                break;
            case PushConsumer.COMPLETED_ORDER:
                break;
            case PushConsumer.CANCEL_ORDER:
                break;
            case PushConsumer.REFUND_ORDER:
                break;
            case PushConsumer.LOGISTICS_STATUS:
                break;
            default:
                model.addAttribute("data", "下行action错误");
                return "/waimai/order/error";
        }

        Map params = request.getParameterMap();
        ResultMessage resultMessage = client.pushHandle(request.getRequestURI(), params, pushAction);
        model.addAttribute("data", resultMessage.getData());
        return "/waimai/order/success";

    }

    private MtWmClient getMeituanClient(Long mchId, String appId) {

        //TODO：需要根据平台类型获取外卖配置信息
//        WaimaiAppConfigDTO waimaiAppConfigDTO = waimaiAppConfigService.findOneByMchIdType(mchId,
//                WaimaiConstants.PlatformType.MEITUAN);
//
//        if (Objects.isNull(waimaiAppConfigDTO)) {
//            return null;
//        }
//
//        if (!waimaiAppConfigDTO.getSource().equals(appId)) {
//            return null;
//        }

        final MtWmClientImpl client = new MtWmClientImpl();
        MtWmInMemoryConfigStorage configStorage = new MtWmInMemoryConfigStorage();
        configStorage.setAppId("a");
        configStorage.setSecret("b");
        client.setConfigStorage(configStorage);

//        client.setLogListener((String cmd, String method, boolean isSuccess, String request, String response) -> {
//            logger.info("cmd:" + cmd + "\n" + "isSuccess:" + isSuccess + "\n" +
//                    "request:" + request + "\n" + "response:" + response);
//            try{
//                waimaiService.saveWaiMaiLog(cmd, method, isSuccess, request, response);
//            } catch (Exception e){
//                logger.error(e.getMessage());
//            }
//        });

        client.setPushConsumer(new MeituanWaimaiPushConsumer(mchId, meituanWaimaiPushService));
        return client;
    }

}
