package com.ptteng.onway.admin.controller;

import com.ptteng.onway.platform.model.Role;
import com.ptteng.onway.platform.model.Store;
import com.ptteng.onway.platform.model.Trademark;
import com.ptteng.onway.platform.service.StoreService;
import com.ptteng.onway.platform.service.TrademarkService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.IdentityUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Master on 2017/12/22.
 */
@Controller
public class ManagerController {
    private static final Log log = LogFactory.getLog(ManagerController.class);
    @Autowired
    StoreService storeService;
    @Autowired
    TrademarkService trademarkService;

    @RequestMapping(value = "/a/nologin")
    public String noLogin(HttpServletRequest request,
                          HttpServletResponse response, ModelMap model, Integer page,
                          Integer size) throws Exception {
        log.info(" login wrong ");
        model.addAttribute("code", -2);
        return "/common/success";
    }



    @RequestMapping(value = "/a/u/manager", method = RequestMethod.GET)
    public String getStoreJson(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model)
            throws Exception {
        log.info("get  /a/u/manager");
        Role role = (Role) request.getAttribute("role");
        log.info("role identity is " + role.getIdentity() + " ,brandNum is " + role.getBrandNum()  + " ,storeNum is " + role.getStoreNum() );
        Long trademarkId = null;
        try {
            if (role.getIdentity().equals(1)) {
                log.info("role is storeNum manager");
                Long id = storeService.getStoreIdByStoreNum(role.getStoreNum());

                Store store = storeService.getObjectById(id);
                if (null == store) {
                    model.addAttribute("code",-2301);
                    return "common/success";
                }
                trademarkId = store.getTrademarkId();

                model.addAttribute("store", store);


            } else if (role.getIdentity().equals(Role.BRAND_MANAGER)) {
                log.info("role is brand manager");
                Long id = trademarkService.getTrademarkByTrademarkNum(role.getBrandNum());
                log.info("id is " + id);
                if (null != id) {
                    Trademark trademark = trademarkService.getObjectById(id);
                    log.info("trademark is " + trademark);
                    if (null != trademark) {
                        trademarkId = id;
                    }
                }
            }else {
                log.info("role is system manager");
            }
            model.addAttribute("trademarkId", trademarkId);
            model.addAttribute("role", role);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get token error " );
            model.addAttribute("code", -100000);
        }
        model.addAttribute("code", 0);

        return "/common/token";
    }


    @RequestMapping(value = "/a/token", method = RequestMethod.GET)
    public String getToken(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model,String brandNum,String storeNum,String identity,Long userId)
            throws Exception {
        log.info("get  /a/token:brandNum="+brandNum+" , storeNum=" +storeNum+" , identity=" +identity+" , userId=" +userId);


        try {
            Map<String,String> params = new HashMap<>();
            if (DataUtils.isNotNullOrEmpty(brandNum)) {
                params.put("brandNum", brandNum);
            }
            if (DataUtils.isNotNullOrEmpty(storeNum)) {
                params.put("storeNum", storeNum);
            }
            if (DataUtils.isNotNullOrEmpty(identity)) {
                params.put("identity", identity);
            }
            if (DataUtils.isNotNullOrEmpty(userId)) {
                params.put("userId", userId.toString());
            }
            String token = IdentityUtil.encodeCookie(params, userId);

            model.addAttribute("message", token);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get token error " );
            model.addAttribute("code", -100000);
        }
        model.addAttribute("code", 0);

        return "/common/callbackSuccess";
    }
}
