package com.ptteng.onway.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ptteng.onway.admin.unit.DynamicUtil;
import com.ptteng.onway.admin.unit.WaimaiEPRUtil;
import com.ptteng.onway.platform.model.*;
import com.ptteng.onway.platform.model.mtERP.DishSkuStocks;
import com.ptteng.onway.platform.model.mtERP.SkusEPR;
import com.ptteng.onway.platform.service.*;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Food  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class FoodController {
    private static final Log log = LogFactory.getLog(FoodController.class);

    @Autowired
    private FoodService foodService;

    @Autowired
    private FoodTypeRelationService foodTypeRelationService;

    @Autowired
    private TemplateTestService templateTestService;

    @Autowired
    private TrademarkService trademarkService;
    @Autowired
    private StoreService storeService;
    @Autowired
    private SynRecordService synRecordService;
    @Autowired
    private WaimaiDishConsumerService waimaiDishConsumerService;
    @Autowired
    private FoodSpecRelationService foodSpecRelationService;
    @Autowired
    private BusinessHoursService businessHoursService;
    @Autowired
    private FoodSolidService foodSolidService;
    @Autowired
    private GroupFoodSortService groupFoodSortService;


    //foodList_Excel 数据为假数据
    @RequestMapping(value = "/a/u/food/list/excel", method = RequestMethod.GET)
    public String getFoodListExcel(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Integer page, Integer size, String platform, String timeStart, String timeEnd) throws Exception {
        log.info("get /a/food/list/excel " + ",platform : " + platform + ", timeStart:" + timeStart + ",timeEnd : " + timeEnd);
        page = 1;
        size = 999999999;


        long current = System.currentTimeMillis();
        long date = current / (1000 * 3600 * 24) * (1000 * 3600 * 24) - TimeZone.getDefault().getRawOffset();
        Integer meituan = null;
        Integer baidu = null;
        Integer ele = null;
        Food ofood = new Food();
        String meituanLock = ofood.locking;
        String eleLock = ofood.locking;
        String baiduLock = ofood.locking;

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Long dateStart = null;
        Long dateEnd = null;
        if (DataUtils.isNotNullOrEmpty(timeStart)) {
            dateStart = (format.parse(timeStart)).getTime();
        }
        if (DataUtils.isNotNullOrEmpty(timeEnd)) {
            dateEnd = (format.parse(timeEnd)).getTime();
        }
        log.info(",dateStart" + dateStart + ",dateEnd" + dateEnd);
        Map<String, Object> params = DynamicUtil.getFoodList(null, meituan, baidu, ele, dateStart, dateEnd);
        List<Long> idList = foodService.getIdsByDynamicCondition(Food.class, params, 0, size);

        List<Food> foodList = foodService.getObjectsByIds(idList);

        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("sheet");
        Row header_row = sheet.createRow(0);
        String headers[] = new String[]{"序号", "商品编号", "商品名称", "价格", "规格", "库存数量", "美团外卖", "饿了吗", "百度外卖"};
        for (int i = 0; i < headers.length; i++) {
            HSSFCell cell = (HSSFCell) header_row.createCell(i);
            cell.setCellValue(headers[i]);
        }
        log.info(foodList);
        for (int i = 0; i < foodList.size(); i++) {
            Row rose = sheet.createRow(i + 1);
            for (int j = 0; j < headers.length; j++) {
                Food food = foodList.get(i);
                HSSFCell cell0 = (HSSFCell) rose.createCell(0);
                cell0.setCellValue(i + 1);
                HSSFCell cell1 = (HSSFCell) rose.createCell(1);
                cell1.setCellValue(food.getFoodNum());
                HSSFCell cell2 = (HSSFCell) rose.createCell(2);
                cell2.setCellValue(food.getName());
                HSSFCell cell3 = (HSSFCell) rose.createCell(3);
//                cell3.setCellValue(food.getPrice().toString());
                HSSFCell cell4 = (HSSFCell) rose.createCell(4);
                String foodType = "";
//                switch (food.getFoodType()) {
//                    case 1:
//                        foodType = food.liangCai1;
//                        break;
//                    case 2:
//                        foodType = food.reCai2;
//                        break;
//                    case 3:
//                        foodType = food.jiushui3;
//                        break;
//                }
                cell4.setCellValue(foodType);
                HSSFCell cell5 = (HSSFCell) rose.createCell(5);
//                cell5.setCellValue(food.getStock());
                meituan = food.getMeituanStatus();
                baidu = food.getBaiduStatus();
                ele = food.getEleStatus();
                if (null != meituan && meituan == 1) {
                    meituanLock = ofood.unLocking;
                }
                if (null != ele && ele == 1) {
                    eleLock = ofood.unLocking;
                }
                if (null != baidu && baidu == 1) {
                    baiduLock = ofood.unLocking;
                }
                HSSFCell cell6 = (HSSFCell) rose.createCell(6);
                cell6.setCellValue(meituanLock);
                HSSFCell cell7 = (HSSFCell) rose.createCell(7);
                cell7.setCellValue(eleLock);
                HSSFCell cell8 = (HSSFCell) rose.createCell(8);
                cell8.setCellValue(baiduLock);

            }

        }
        log.info("success");
        Long excelDate = System.currentTimeMillis();
        String url = "/data/webs/onway-admin-web/excel/销售菜品" + excelDate + ".xls";
        FileOutputStream output = new FileOutputStream(url);
        url = "/exceldownload/销售菜品" + excelDate + ".xls";
        wb.write(output);
        output.flush();
        model.addAttribute("code", 0);
        model.addAttribute("url", url);
        return "/common/url";
    }

    /**
     * 外卖菜品销售统计
     *
     * @param timeStart 下单时间开始i
     * @param timeEnd   下单时间结束
     */
    @RequestMapping(value = "/a/u/food/statistics", method = RequestMethod.GET)
    public String getFoodStatistics(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Long timeStart, Long timeEnd)
            throws Exception {

        log.info("get /a/u/statistics/food  timeStart is " + timeStart + " ,timeEnd is " + timeEnd);
        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();

        if (null == storeId) {
            model.addAttribute("code", -2101);
            return "/common/success";
        }
        try {

            Store store = storeService.getObjectById(storeId);
            if (null == store) {
                model.addAttribute("code", -2301);
                return "/common/success";
            }
            Long trademarkId = store.getTrademarkId();
            log.info("trademark id is " + trademarkId);
            Trademark trademark = trademarkService.getObjectById(trademarkId);
            log.info("trademark  is " + trademark);

            //统计品牌相关信息
            List<FoodStatistics> trademarkFoodStatistics = templateTestService.getTrademarkFoodStatisticsByTime(timeStart, timeEnd, trademarkId);
            log.info("trademarkFoodStatistics is " + trademarkFoodStatistics);

            //统计门店相关信息
            List<FoodStatistics> storeFoodStatistics = templateTestService.getStoreFoodStatisticsByTime(timeStart, timeEnd, storeId);
            log.info("storeFoodStatistics is " + storeFoodStatistics);

            model.addAttribute("code", 0);
            model.addAttribute("trademarkFoodStatistics", trademarkFoodStatistics.get(0));
            model.addAttribute("storeFoodStatistics", storeFoodStatistics.get(0));
            model.addAttribute("trademark", trademark);
            model.addAttribute("store", store);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get food error,id is  ");
            model.addAttribute("code", -1);
        }

        return "/onway-platform-service/food/json/foodStatisticsJson";
    }


    /**
     * 外卖菜品销售详情统计
     *
     * @param timeStart 下单时间开始i
     * @param timeEnd   下单时间结束
     */
    @RequestMapping(value = "/a/u/food/statistics/detail", method = RequestMethod.GET)
    public String getFoodStatisticsDetail(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model, Long timeStart, Long timeEnd, Integer foodType, Integer sort)
            throws Exception {
        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();
        log.info("get /a/statistics/food/detail,  storeId is " + storeId + " ,timeStart is " + timeStart + " ,timeEnd is " + timeEnd + " ,foodType is " + foodType + " ,sort is " + sort);

        if (null == storeId) {
            model.addAttribute("code", -2101);
            return "/common/success";
        }
        try {

            List<FoodStatistics> foodStatisticsList = templateTestService.getStoreFoodStatisticsDetailBuyTime(timeStart, timeEnd, storeId, sort, foodType);
            log.info("foodStatistics is " + foodStatisticsList);
            model.addAttribute("foodStatisticsList", foodStatisticsList);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get food error,id is  ");
            model.addAttribute("code", -1);
        }

        return "/onway-platform-service/food/json/foodStatisticsDetailJson";
    }


    /**
     * 修改菜品库存
     *
     * @param id    菜品id
     * @param stock 库存值
     */
    @RequestMapping(value = "/a/u/set/threshold/{id}", method = RequestMethod.PUT)
    public String updateFoodJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer stock, Long skuId) throws Exception {

        log.info("update food stock: id is " + id + " ,stock is " + stock + " ,skuId is " + skuId);
        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();
        if (storeId == null) {
            model.addAttribute("code", -2101);
            return "/common/success";
        }

        if (stock == null) {
            model.addAttribute("code", -2505);
            return "/common/success";
        }

        try {
            Food food = foodService.getObjectById(id);
            FoodSpecRelation foodSpecRelation = foodSpecRelationService.getObjectById(skuId);
            if (foodSpecRelation == null) {
                model.addAttribute("code", -2509);
                return "/common/success";
            }

            foodSpecRelation.setStock(stock);
            foodSpecRelationService.update(foodSpecRelation);

            Store store = storeService.getObjectById(storeId);
            String appAuthToken = store.getMtAppAuthToken();
            if (DataUtils.isNullOrEmpty(appAuthToken)) {
                log.info("this store appAuthToken is null ,id is " + storeId);
            } else {
                log.info("this store appAuthToken is  " + appAuthToken);
            }

            //库存同步至美团
//			waimaiDishConsumerService.setThreshold(trademarkId,food);

            //美团erp同步库存
            List<SkusEPR> skusEPRS = new ArrayList<>();
            SkusEPR skusEPR = new SkusEPR();
            skusEPR.setSkuId(skuId.toString());
            skusEPR.setStock(stock);
            skusEPRS.add(skusEPR);
            DishSkuStocks dishSkuStocks = new DishSkuStocks();
            dishSkuStocks.seteDishCode(id.toString());

            dishSkuStocks.setSkus(skusEPRS);
            String resultJson = "";
            resultJson = WaimaiEPRUtil.takeoutDishStockUpdateRequest(store.getMtAppAuthToken(), storeId.toString(), dishSkuStocks.toString());

            log.info("resultJson is " + resultJson);

            model.addAttribute("code", 0);

            model.addAttribute("food", food);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update food error");
            model.addAttribute("code", -6003);
        }

        return "/common/success";
    }


    /**
     * 菜品上下架
     *
     * @param storeId     门店id
     * @param trademarkId 品牌id
     * @param id          菜品id
     */
    @RequestMapping(value = "/a/u/food/{id}/status", method = RequestMethod.PUT)
    public String offlineFood(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, Long storeId, Long trademarkId, @PathVariable Long id, Integer status) throws Exception {

        log.info("update food stock: storeId is = " + storeId + " ,trademarkId is " + trademarkId + " ,id is " + id + " ,status is " + status);
        Role role = (Role) request.getAttribute("role");


        if (storeId == null) {
            model.addAttribute("code", -2101);
            return "/common/success";
        }
        if (!status.equals(Food.Offline) && !status.equals(Food.Online)) {
            model.addAttribute("code", -2510);
            return "/common/success";
        }

        try {
            Food food = foodService.getObjectById(id);
            if (food == null) {
                model.addAttribute("code", -2509);
                return "/common/success";
            }
            food.setMeituanStatus(status);
            foodService.update(food);
            //美团下架菜品
            waimaiDishConsumerService.offlineDish(trademarkId, storeId, id);
            model.addAttribute("code", 0);

            model.addAttribute("food", food);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update food error");
            model.addAttribute("code", -6003);
        }

        return "/common/success";
    }


    //    private DishesEPR dealFood(Food food,FoodTypeRelation foodTypeRelation,String format) {
//        DishesEPR dishesEPR = new DishesEPR();
//        try {
//            dishesEPR.setBoxNum(food.getPackageBoxNum());
//            dishesEPR.setBoxPrice(food.getPackageFee());
//            dishesEPR.setCategoryName(foodTypeRelation.getName());
//            dishesEPR.setDescription(food.getDescription());
//            dishesEPR.setDishName(food.getName());
//            dishesEPR.setEDishCode(food.getId());
//            dishesEPR.setePoiId(food.getStoreId());
//            dishesEPR.setIsSoldOut(0);
//            dishesEPR.setMinOrderCount(food.getMinOrderNum());
//            dishesEPR.setPicture(food.getPic());
//            dishesEPR.setSequence(food.getRank());
//            dishesEPR.setPrice(food.getPrice());
//            dishesEPR.setUnit(format);
//        } catch (Throwable t) {
//            log.info("dealFood error ,data is " + t.getMessage());
//        }
//        return dishesEPR;
//    }
//
//    //菜品新增
//    @RequestMapping(value = "/a/u/food", method = RequestMethod.POST)
//    public String addFoodJson(HttpServletRequest request,
//                              HttpServletResponse response, ModelMap model, @RequestBody FoodListUnit foods) throws Exception {
//        List<Food> foodList = foods.getfoodList();
//        log.info("url is :/a/food,insert food : foodList==== " + foodList);
//
//        Role role = (Role) request.getAttribute("role");
//
//
//
//
//        try {
//            List<Long> foodTypeIds = foodTypeRelationService.getFoodTypeRelationIds(0,Integer.MAX_VALUE);
//            List<FoodTypeRelation> foodTypeRelationList = foodTypeRelationService.getObjectsByIds(foodTypeIds);
//            Map<String,FoodTypeRelation> foodTypeMap = MyListUtil.convert2Map(FoodTypeRelation.class.getDeclaredField("typeNum"),foodTypeRelationList);
//
//            for (Food food : foodList) {
//                //参数判断
//                if (DataUtils.isNullOrEmpty(food.getName())) {
//                    log.error("food name is null");
//                    model.addAttribute("code", -2502);
//                }
//                if (DataUtils.isNullOrEmpty(food.getPrice())) {
//                    log.error("food price is null");
//                    model.addAttribute("code", -2503);
//                }
//                if (DataUtils.isNullOrEmpty(food.getFormat())) {
//                    log.error("food format is null");
//                    model.addAttribute("code", -2504);
//                }
//                if (DataUtils.isNullOrEmpty(food.getStock())) {
//                    log.error("food stock is null");
//                    model.addAttribute("code", -2505);
//                }
//                if (DataUtils.isNullOrEmpty(food.getStoreId())) {
//                    log.error("food storeId is null");
//                    model.addAttribute("code", -2511);
//                }
//                if (DataUtils.isNullOrEmpty(food.getAvailableTimes())) {
//                    log.error("food availableTimes is null");
//                    model.addAttribute("code", -2512);
//                }
//                if (DataUtils.isNullOrEmpty(food.getTrademarkId())) {
//                    log.error("food trademarkId is null");
//                    model.addAttribute("code", -2513);
//                }
//
//                food.setFoodType(foodTypeMap.get(food.getFoodTypeNum()).getId().intValue());
//
//                for (FoodSpecRelation foodSpecRelation : food.getSpecs()) {
//                    if (DataUtils.isNullOrEmpty(foodSpecRelation.getSpecName())) {
//                        log.warn("spec name is null");
//                        model.addAttribute("code", -2504);
//                    }
//                }
//            }
//
//
//
//            Long storeId = storeService.getStoreIdByStoreNum(role.getStoreNum());
//            Store store = storeService.getObjectById(storeId);
//
//            //插入菜品信息
//            List<Food> insertFoodList = foodService.insertList(foodList);
//
//
//            List<FoodSpecRelation> foodSpecRelationList = new ArrayList<>();
//            //门店餐别信息
//            List<Long> mealTypeIds = businessHoursService.getBusinessHoursIdsByTargetIdAndStatus(storeId,BusinessHours.OPEN, 0, Integer.MAX_VALUE);
//            List<BusinessHours> businessHoursList = businessHoursService.getObjectsByIds(mealTypeIds);
//            Map<Integer,BusinessHours> businessHoursMap = MyListUtil.convert2Map(BusinessHours.class.getDeclaredField("mealType"),businessHoursList);
//
//
//            List<String> monday = new ArrayList<>();
//            List<String> tuesday = new ArrayList<>();
//            List<String> wednesday = new ArrayList<>();
//            List<String> thursday =new ArrayList<>();
//            List<String> friday =new ArrayList<>();
//            List<String> saturday = new ArrayList<>();
//            List<String> sunday = new ArrayList<>();
//
//            for (int i = 0; i < foodList.size(); i++) {
//                List<FoodSpecRelation> foodSpecRelations = foodList.get(i).getSpecs();
//                List<String> mealTypes = Arrays.asList(foodList.get(i).getMealType().split(","));
//                for (String mealType:mealTypes) {
//                    BusinessHours businessHours =  businessHoursMap.get(Integer.valueOf(mealType));
//                    log.info("businessHours is " +businessHours );
//                    String week  = businessHours.getWeek();
//                    //周一时间
//                    if (week.contains(BusinessHours.MONDAY+"")){
//                        monday.add(businessHours.getStartTime()+"-"+businessHours.getEndTime());
//                    }
//                    //周二时间
//                    if (week.contains(BusinessHours.TUESDAY+"")){
//                        tuesday.add(businessHours.getStartTime()+"-"+businessHours.getEndTime());
//                    }
//                    //周三时间
//                    if (week.contains(BusinessHours.WEDNESDAY+"")){
//                        wednesday.add(businessHours.getStartTime()+"-"+businessHours.getEndTime());
//                    }
//                    //周四时间
//                    if (week.contains(BusinessHours.THURSDAY+"")){
//                        thursday.add(businessHours.getStartTime()+"-"+businessHours.getEndTime());
//                    }
//                    //周五时间
//                    if (week.contains(BusinessHours.FRIDAY+"")){
//                        friday.add(businessHours.getStartTime()+"-"+businessHours.getEndTime());
//                    }
//                    //周六时间
//                    if (week.contains(BusinessHours.SATURDAY+"")){
//                        saturday.add(businessHours.getStartTime()+"-"+businessHours.getEndTime());
//                    }
//                    //周日时间
//                    if (week.contains(BusinessHours.SUNDAY+"")){
//                        sunday.add(businessHours.getStartTime()+"-"+businessHours.getEndTime());
//                    }
//
//                }
//
//                AvailableTimes availableTimes = new AvailableTimes();
//                availableTimes.setMonday(String.join(",",monday));
//                availableTimes.setTuesday(String.join(",",tuesday));
//                availableTimes.setWednesday(String.join(",",wednesday));
//                availableTimes.setThursday(String.join(",",thursday));
//                availableTimes.setFriday(String.join(",",friday));
//                availableTimes.setSaturday(String.join(",",saturday));
//                availableTimes.setSunday(String.join(",",sunday));
//
//                log.info("availableTimes " +GsonUtil.toJson(availableTimes));
//                for (FoodSpecRelation foodSpecRelation : foodSpecRelations) {
//                    foodSpecRelation.setTargetId(insertFoodList.get(i).getId());
//                    foodSpecRelation.setAvailableTimes(availableTimes);
//
//                    foodSpecRelationList.add(foodSpecRelation);
//                }
//
//            }
//            log.info("===============" + GsonUtil.toJson(foodSpecRelationList));
//            //插入菜品spec(sku)信息
//            List<FoodSpecRelation> insertSpecsList = foodSpecRelationService.insertList(foodSpecRelationList);
//
//
//            Map<Long,List<FoodSpecRelation>> foodSpecsListMap = MyListUtil.convert2ListMap(FoodSpecRelation.class.getDeclaredField("targetId"),insertSpecsList);
//
//            log.info("insert specs size is " + insertSpecsList.size());
//
//
//            //美团菜品批量上传、更新逻辑
//            List<DishesEPR> dishesEPRList = new ArrayList<>();
//            //1.model转换
//            for (Food food:insertFoodList) {
//               DishesEPR dishesEPR = CoverUtil.FoodCover2DishesEPR(food,foodTypeMap.get(food.getFoodTypeNum()).getName(),CoverUtil.FoodSpecsCover2SkusEPRList(foodSpecsListMap.get(food.getId())));
//                dishesEPRList.add(dishesEPR);
//            }
//            log.info(" GsonUtil.toJson(dishesEPRList) is" + GsonUtil.toJson(dishesEPRList));
//             String result =WaimaiEPRUtil.takeoutDishBatchUpload(store.getMtAppAuthToken(), GsonUtil.toJson(dishesEPRList),storeId.toString());
//            log.info("result is :" + result);
//
//            //新增异常信息
//            SynRecord synRecord = new SynRecord();
//            synRecord.setSynType(SynRecord.SYN_TYPE_DISH);
//            synRecord.setStoreId(storeId);
//            synRecord.setTrademarkId(store.getTrademarkId());
//            synRecord.setTrademarkNum(store.getTrademarkNum());
//            synRecord.setPlatform(WaimaiConstents.platform_meitian);
//
//            if (WaimaiEPRUtil.checkResult(result)) {
//                synRecord.setStatus(SynRecord.SYN_STATUS_SUCCESS);
//            } else {
//                synRecord.setStatus(SynRecord.SYN_STATUS_ERROR);
//                JSONObject jsonObject = new JSONObject(result);
//                synRecord.setErrorMsg((String) jsonObject.getJSONObject("error").get("message"));
//            }
//            Long synRecordId = synRecordService.insert(synRecord);
//            log.info("synRecordId is " + synRecordId);
//
////            model.addAttribute("id", synRecordId);
//            model.addAttribute("code", 0);
//        } catch (Throwable t) {
//            t.printStackTrace();
//            log.error(t.getMessage());
//            log.error("add food error ");
//            model.addAttribute("code", -1);
//        }
//
//        return "/common/insertSuccess";
//    }

//


    @RequestMapping(value = "/a/u/food/list", method = RequestMethod.GET)
    public String getFoodList(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, Integer page, Integer size, Integer type, String platform) throws Exception {
        log.info("get /a/food/list " + ", type : " + type + ",platform:" + platform);

        Role role = (Role) request.getAttribute("role");
        if (page == null) {
            page = 1;
        }
        if (size == null || size == 0) {
            size = 20;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        Integer meituan = null;
        Integer baidu = null;
        Integer ele = null;
        //对传进来的六位数拆分,比如000111 前三位无用，第四位开始，分别是美团,百度,饿了么
        if (DataUtils.isNotNullOrEmpty(platform)) {
            meituan = Integer.valueOf(platform.substring(3, 4));
            baidu = Integer.valueOf(platform.substring(4, 5));
            ele = Integer.valueOf(platform.substring(5, 6));
        }

        try {
            //获取可售清单
            Map<String, Object> params = DynamicUtil.getFoodSolidListAll(meituan, baidu, ele, type, role.getStoreNum());
            List<Long> foodSolidIds = foodSolidService.getIdsByDynamicCondition(FoodSolid.class, params, 0, Integer.MAX_VALUE);
            List<FoodSolid> foodSolidList = foodSolidService.getObjectsByIds(foodSolidIds);
            log.info("foodSolidList.size is :" + foodSolidList.size());
            List<String> foodNumList = MyListUtil.getList(FoodSolid.class.getDeclaredField("foodNum"), foodSolidList);

            Integer total = foodSolidIds.size();
            log.info("foodSolid ids size is :" + total);

            //获取可售清单里的菜品信息
            Map<String, Object> foodParams = DynamicUtil.getFoodListByFoodNums(foodNumList);
            List<Long> foodIds = foodService.getIdsByDynamicCondition(Food.class, foodParams, start, size);
            List<Food> foodList = foodService.getObjectsByIds(foodIds);
            Map<String, Food> foodMap = MyListUtil.convert2Map(Food.class.getDeclaredField("foodNum"), foodList);

            //取关联foodType列表
            List<Long> foodTypeIds = foodTypeRelationService.getFoodTypeRelationIds(0, Integer.MAX_VALUE);
            List<FoodTypeRelation> foodTypeRelationList = foodTypeRelationService.getObjectsByIds(foodTypeIds);
            Map<String, FoodTypeRelation> foodTypeRelationMap = MyListUtil.convert2Map(FoodTypeRelation.class.getDeclaredField("typeNum"), foodTypeRelationList);


            model.addAttribute("code", 0);
            model.addAttribute("size", size);
            model.addAttribute("page", page);
            model.addAttribute("total", total);
            model.addAttribute("foodMap", foodMap);
            model.addAttribute("foodSolidList", foodSolidList);
            model.addAttribute("foodTypeRelationMap", foodTypeRelationMap);
            return "/onway-platform-service/food/json/foodListJson";
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update or insert food error");
            model.addAttribute("code", -1);
            return "/common/success";
        }


    }


    /**
     * 新增修改菜品信息
     *
     * @param food 菜品信息
     */
    @RequestMapping(value = "/a/u/saveGoods", method = RequestMethod.POST)
    public String updateStore(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, Food food) throws Exception {

        log.info("saveGoods: food= " + food);
        Role role = (Role) request.getAttribute("role");
        if (Role.BRAND_MANAGER != role.getIdentity()) {
            model.addAttribute("code", -10);
            return "common/success";
        }
        if (DataUtils.isNullOrEmpty(food.getName())) {
            model.addAttribute("code", -2502);
            return "common/success";
        }
        if (DataUtils.isNullOrEmpty(food.getFoodNum())) {
            model.addAttribute("code", -2525);
            return "common/success";
        }
        if (DataUtils.isNullOrEmpty(food.getFormat())) {
            model.addAttribute("code", -2504);
            return "common/success";
        }


        try {
            Long id = foodService.getFoodIdByFoodNum(food.getFoodNum());
            Food originalFood = foodService.getObjectById(id);
            Gson gson = new Gson();

            List<FoodSpecRelation> foodSpecRelationList = gson.fromJson(food.getSpecs(), new TypeToken<List<FoodSpecRelation>>() {
            }.getType());
            if (null == originalFood) {
                log.info("not found this foodNum, add food logic");
                food.setCreateBy(Long.valueOf(role.getUserId()));
                food.setUpdateBy(Long.valueOf(role.getUserId()));
                food.setTrademarkId(role.getTrademarkId());
                Long insertId = foodService.insert(food);
                log.info("insert food success,id is " + insertId);
                for (FoodSpecRelation foodSpecRelation : foodSpecRelationList) {
                    foodSpecRelation.setTargetId(insertId);
                    foodSpecRelation.setStock(0);
                }

                foodSpecRelationService.insertList(foodSpecRelationList);
                log.info("insert spec list success,size is " + foodSpecRelationList.size());


                model.addAttribute("id", insertId);
            } else {
                log.info("update food logic");
                food.setId(id);
                food.setCreateAt(originalFood.getCreateAt());
                food.setCreateBy(originalFood.getCreateBy());
                food.setUpdateBy(Long.valueOf(role.getUserId()));
                food.setTrademarkId(originalFood.getTrademarkId());
                foodService.update(food);
                log.info("update food success,id is " + id);
                //刪除菜品原來的規格信息
                List<Long> ids = foodSpecRelationService.getFoodSpecRelationIdsByTargetId(id, 0, Integer.MAX_VALUE);
                foodSpecRelationService.deleteList(FoodSpecRelation.class, ids);
                log.info("delete old spec success ,size is " + ids.size());
                //插入菜品新的规格信息
                for (FoodSpecRelation foodSpecRelation : foodSpecRelationList) {
                    foodSpecRelation.setTargetId(id);
                    foodSpecRelation.setStock(0);
                }
                foodSpecRelationService.insertList(foodSpecRelationList);
                log.info("insert new spec success ,size is " + foodSpecRelationList.size());
            }

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update or insert food error");
            model.addAttribute("code", -1);
        }

        return "/common/insertSuccess";
    }


    /**
     * 删除外卖菜品
     *
     * @param id 菜品id
     * @throws Exception；
     */
    @RequestMapping(value = "/a/u/food/{id}", method = RequestMethod.DELETE)
    public String deleteIntroduceJson(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete food : id= " + id);
        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();
        try {
            Food food = foodService.getObjectById(id);
            if (null == food) {
                model.addAttribute("code", -2509);
                return "common/success";
            }
            Store store = storeService.getObjectById(storeId);
            String appAuthToken = store.getMtAppAuthToken();


            // 准备接收返回Json
            String resultJson = WaimaiEPRUtil.takeoutDishDelete(appAuthToken, id.toString(), store.getId().toString());
            log.info("resultJson is" + resultJson);
            if (WaimaiEPRUtil.checkResult(resultJson)) {
                model.addAttribute("id", id);
                model.addAttribute("code", 0);
            } else {
                JSONObject jsonObject = new JSONObject(resultJson);
                model.addAttribute("code", -1000);
                model.addAttribute("message", jsonObject.getJSONObject("error").get("message"));
                return "/common/result";
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete introduce error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }

    /**
     * addSolidList更新可售菜品列表，全删全插方法，接收JSON串
     *
     * @param solidList JSON串，包换字段:groupNum菜品类编号，foodNum菜品编号，status可售非可售，price，价格
     * @return code, message
     * @throws Exception；
     */
    @RequestMapping(value = "/a/u/addSolidList", method = RequestMethod.POST)
    public String addSolidList(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, String solidList)
            throws Exception {


        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();
        log.info("addSolidList : storeId= " + storeId);
        try {
            Gson gson = new Gson();

            List<FoodSolid> foodSolidList = gson.fromJson(solidList, new TypeToken<List<FoodSolid>>() {
            }.getType());
            for (FoodSolid foodSolid : foodSolidList) {
                foodSolid.setCreateBy(Long.valueOf(role.getUserId()));
                foodSolid.setUpdateBy(Long.valueOf(role.getUserId()));
                foodSolid.setStoreNum(role.getStoreNum());
            }
            log.info("foodSolidList size is " + foodSolidList.size());

            //查找该门店可售清单并删除
            List<Long> foodSolidIds = foodSolidService.getFoodSolidIdsByStoreNum(role.getStoreNum(), 0, Integer.MAX_VALUE);
            foodSolidService.deleteList(FoodSolid.class, foodSolidIds);

            foodSolidService.insertList(foodSolidList);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("addSolidList,id is  ");
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    /**
     * addGroupGoodSort
     *
     * @param foodList 菜品分类下菜品排序，参数为JSON串，包含字段：groupNum 分类编号 、groupRank分类下排序、foodNum菜品编号
     * @return code, message
     * @throws Exception；
     */
    @RequestMapping(value = "/a/u/addGroupGoodSort", method = RequestMethod.POST)
    public String addGroupGoodSort(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, String foodList)
            throws Exception {

        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();
        log.info("addGroupGoodSort : storeId= " + storeId);
        try {
            Gson gson = new Gson();
            List<GroupFoodSort> groupFoodSorts = gson.fromJson(foodList, new TypeToken<List<GroupFoodSort>>() {
            }.getType());
            log.info("foodList size is " + groupFoodSorts.size());
            log.info("foodList  is " + groupFoodSorts);
            for (GroupFoodSort groupFoodSort : groupFoodSorts) {
                groupFoodSort.setStoreNum(role.getStoreNum());
                groupFoodSort.setCreateBy(Long.valueOf(role.getUserId()));
                groupFoodSort.setUpdateBy(Long.valueOf(role.getUserId()));
            }
            //查找该门店菜品排序并删除
            List<Long> foodSortIds = groupFoodSortService.getGroupFoodSortIdsByStoreNum(role.getStoreNum(), 0, Integer.MAX_VALUE);
            groupFoodSortService.deleteList(GroupFoodSort.class, foodSortIds);
            log.info("delete success ,size is " + foodSortIds.size());
            groupFoodSortService.insertList(groupFoodSorts);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("addGroupGoodSort error ");
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


}