/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.muscle.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.util.notice.NoticeUtil;
import com.ptteng.muscle.common.model.Message;
import com.ptteng.muscle.common.model.UserMessage;
import com.ptteng.muscle.common.service.MessageService;
import com.ptteng.muscle.main.service.UserService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MessageServiceImpl
extends BaseDaoServiceImpl
implements MessageService {
    @Autowired
    private NoticeUtil androidPushServiceImpl;
    @Autowired
    private NoticeUtil iosPushServiceImpl;
    private UserService userService;
    private static final Log log = LogFactory.getLog(MessageServiceImpl.class);

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public Long insert(Message message) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + message));
        if (message == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        message.setCreateAt(Long.valueOf(currentTimeMillis));
        message.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)message);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + message));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Message> insertList(List<Message> messageList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (messageList == null ? "null" : Integer.valueOf(messageList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(messageList)) {
            return new ArrayList<Message>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Message message : messageList) {
            message.setCreateAt(Long.valueOf(currentTimeMillis));
            message.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(messageList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + messageList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Message.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Message message) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (message == null ? "null" : message.getId())));
        boolean result = false;
        if (message == null) {
            return true;
        }
        message.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)message);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + message));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + message));
        }
        return result;
    }

    public boolean updateList(List<Message> messageList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (messageList == null ? "null" : Integer.valueOf(messageList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(messageList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Message message : messageList) {
            message.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(messageList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + messageList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + messageList.size()));
        return result;
    }

    public Message getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Message message = null;
        if (id == null) {
            return message;
        }
        try {
            message = (Message)this.dao.get(Message.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return message;
    }

    public List<Message> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List message = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Message>();
        }
        try {
            message = this.dao.getList(Message.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (message == null ? "null" : Integer.valueOf(message.size()))));
        return message;
    }

    public List<Long> getMessageIdsByTypeAndStatus(Integer type, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by type,status,start,limit  : " + type + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getMessageIdsByTypeAndStatus", new Object[]{type, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by type,status,start,limit)  : " + type + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countMessageIdsByTypeAndStatus(Integer type, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by type,status  : " + type + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getMessageIdsByTypeAndStatus", new Object[]{type, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by type,status)  : " + type + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getMessageIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getMessageIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countMessageIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getMessageIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getMessageIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public void sendNotice(Message message) throws ServiceException, ServiceDaoException {
    }

    public void sendNoticeUnicast(UserMessage message, String deviceToken, String os) throws ServiceException, ServiceDaoException {
        log.info((Object)" youmeng unicast notice start ... ");
        log.info((Object)(" uid = " + message.getUid() + "deviceToken = " + deviceToken + " os = " + os));
        Long startAt = System.currentTimeMillis();
        Long endAt = startAt + 604800000L;
        log.info((Object)(" endAt = " + endAt));
        if (StringUtil.isNotEmpty((String)os)) {
            if ("android".equals(os)) {
                log.info((Object)" android ");
                if (StringUtil.isNotEmpty((String)deviceToken)) {
                    String anResult = null;
                    try {
                        anResult = this.androidPushServiceImpl.pushMessaeForList("android", "notification", "unicast", deviceToken, message.getTitle(), message.getTitle(), message.getSummary(), "go_app", "", "", "", "", null, "", "true", endAt, "\u91d1\u4fe1\u4f18\u5ba2\u901a\u77e5");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    log.info((Object)(" anResult = " + anResult));
                    JSONObject jsonObject = JSONObject.fromObject(anResult);
                    if ("SUCCESS".equals((String)jsonObject.get("ret"))) {
                        log.info((Object)" push success ");
                    } else {
                        log.info((Object)("fail" + jsonObject.get("data")));
                        JSONObject data = JSONObject.fromObject((Object)jsonObject.get("data").toString());
                        log.info((Object)(" data = " + data));
                        log.info((Object)(" errorCode = " + data.get("error_code")));
                    }
                }
            } else {
                log.info((Object)" ios ");
                if (StringUtil.isNotEmpty((String)deviceToken)) {
                    String iosResult = null;
                    try {
                        iosResult = this.iosPushServiceImpl.pushMessaeForList("ios", "notification", "unicast", deviceToken, message.getTitle(), message.getTitle(), message.getSummary(), "go_app", "", "", "", "", null, "", "true", endAt, "\u91d1\u4fe1\u4f18\u5ba2\u901a\u77e5");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    log.info((Object)(" iosResult = " + iosResult));
                    JSONObject jsonObjectios = JSONObject.fromObject(iosResult);
                    if ("SUCCESS".equals((String)jsonObjectios.get("ret"))) {
                        log.info((Object)" push success ");
                    } else {
                        log.info((Object)(" ==== " + jsonObjectios.get("data")));
                        JSONObject data = JSONObject.fromObject((Object)jsonObjectios.get("data").toString());
                        log.info((Object)(" data = " + data));
                        log.info((Object)(" errorCode = " + data.get("error_code")));
                    }
                }
            }
        }
        log.info((Object)" youmeng unicast notice end ...  ");
    }
}

