-- ----------------------------
-- Table structure for `hardness_detection`
-- ----------------------------
-- DROP TABLE IF EXISTS `hardness_detection`;
CREATE TABLE `hardness_detection` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `mobile` varchar(100) NOT NULL   COMMENT '用户手机号',  
    `rig` double NOT NULL   COMMENT '头部硬度',  
    `tum` double NOT NULL   COMMENT '头部周径',  
    `root_rig` double NOT NULL   COMMENT '根部硬度',  
    `detection_at` varchar(100) NOT NULL   COMMENT '检测时间',  
    `root_tum` double NOT NULL   COMMENT '根部周径',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint    COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `hardness_report`
-- ----------------------------
-- DROP TABLE IF EXISTS `hardness_report`;
CREATE TABLE `hardness_report` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `mobile` varchar(100) NOT NULL   COMMENT '用户手机号',  
    `detection_at` varchar(100) NOT NULL   COMMENT '检测时间',  
    `event_number` int(2) NOT NULL   COMMENT '事件号',  
    `event_time` int(2) NOT NULL   COMMENT '事件时长',  
    `nineteen` int(2) NOT NULL   COMMENT '0-19%时长',  
    `thirty_nine` int(2) NOT NULL   COMMENT '20-39%时长',  
    `fifty_nine` int(2) NOT NULL   COMMENT '40-59%时长',  
    `seventy_nine` int(2) NOT NULL   COMMENT '60-79%时长',  
    `hundred` int(2) NOT NULL   COMMENT '80-100%时长',  
    `hardness_avg` double NOT NULL   COMMENT '平均硬度',  
    `circumference_baseline` double NOT NULL   COMMENT '周径基线',  
    `circumference_avg` double NOT NULL   COMMENT '平均周径',  
    `swelling_rate` double NOT NULL   COMMENT '肿胀增率',  
    `rau` double NOT NULL   COMMENT 'rau',  
    `tau` double NOT NULL   COMMENT 'tau',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint    COMMENT '创建人',  
    `update_by` bigint    COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `sensitivity_report`
-- ----------------------------
-- DROP TABLE IF EXISTS `sensitivity_report`;
CREATE TABLE `sensitivity_report` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `mobile` varchar(100) NOT NULL   COMMENT '用户手机号',  
    `detection_at` varchar(100) NOT NULL   COMMENT '检测时间',  
    `sensitivity_cold_base` int NOT NULL   COMMENT '基准线冷觉温度',  
    `sensitivity_pain_base` int NOT NULL   COMMENT '基准线冷痛温度',  
    `sensitivity_hot_base` int NOT NULL   COMMENT '基准线热觉温度',  
    `sensitivity_hot_pain_base` int NOT NULL   COMMENT '基准线热痛温度',  
    `sensitivity_cold_upper_limit` double NOT NULL   COMMENT '上限冷觉温度',  
    `sensitivity_pain_upper_limit` double NOT NULL   COMMENT '上限冷痛温度',  
    `sensitivity_hot_upper_limit` double NOT NULL   COMMENT '上限热觉温度',  
    `sensitivity_hot_pain_upper_limit` double NOT NULL   COMMENT '上限热痛温度',  
    `sensitivity_cold_lower_limit` double NOT NULL   COMMENT '下限冷觉温度',  
    `sensitivity_pain_lower_limit` double NOT NULL   COMMENT '下限冷痛温度',  
    `sensitivity_hot_lower_limit` double NOT NULL   COMMENT '下限热觉温度',  
    `sensitivity_hot_pain_lower_limit` double NOT NULL   COMMENT '下限热痛温度',  
    `sensitivity_cold_avg` double NOT NULL   COMMENT '冷觉温度平均值',  
    `sensitivity_pain_avg` double NOT NULL   COMMENT '冷痛温度平均值',  
    `sensitivity_hot_avg` double NOT NULL   COMMENT '热觉温度平均值',  
    `sensitivity_hot_pain_avg` double NOT NULL   COMMENT '热痛温度平均值',  
    `sensitivity_cold_sta_dff` double NOT NULL   COMMENT '冷觉温度标准差',  
    `sensitivity_pain_sta_dff` double NOT NULL   COMMENT '冷痛温度标准差',  
    `sensitivity_hot_sta_dff` double NOT NULL   COMMENT '热觉温度标准差',  
    `sensitivity_hot_pain_sta_dff` double NOT NULL   COMMENT '热痛温度标准差',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint    COMMENT '更新时间',  
    `create_by` bigint    COMMENT '创建人',  
    `update_by` bigint    COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `temperature_check`
-- ----------------------------
-- DROP TABLE IF EXISTS `temperature_check`;
CREATE TABLE `temperature_check` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `mobile` varchar(100) NOT NULL   COMMENT '用户手机号',  
    `detection_at` varchar(100) NOT NULL   COMMENT '检测时间',  
    `sensitivity_cold` double NOT NULL   COMMENT '冷觉温度',  
    `sensitivity_pain` double NOT NULL   COMMENT '冷痛温度',  
    `sensitivity_hot` double NOT NULL   COMMENT '热觉温度',  
    `sensitivity_hot_pain` double NOT NULL   COMMENT '热痛温度',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint    COMMENT '创建人',  
    `update_by` bigint    COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `temperature_check_stem`
-- ----------------------------
-- DROP TABLE IF EXISTS `temperature_check_stem`;
CREATE TABLE `temperature_check_stem` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `mobile` varchar(100) NOT NULL   COMMENT '用户手机号',  
    `detection_at` varchar(100) NOT NULL   COMMENT '检测时间',  
    `sensitivity_cold_stem` double NOT NULL   COMMENT '茎体冷觉温度',  
    `sensitivity_pain_stem` double NOT NULL   COMMENT '茎体冷痛温度',  
    `sensitivity_hot_stem` double NOT NULL   COMMENT '茎体热觉温度',  
    `sensitivity_hot_pain_stem` double NOT NULL   COMMENT '茎体热痛温度',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint    COMMENT '创建人',  
    `update_by` bigint    COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `bloodFlow_report`
-- ----------------------------
-- DROP TABLE IF EXISTS `bloodFlow_report`;
CREATE TABLE `bloodFlow_report` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `mobile` varchar(100) NOT NULL   COMMENT '用户手机号',  
    `detection_at` varchar(100) NOT NULL   COMMENT '检测时间',  
    `radial_artery` double NOT NULL   COMMENT '桡动脉血流速度',  
    `dorsal_artery` double NOT NULL   COMMENT '背动脉血流速度',  
    `back_deep_artery` double NOT NULL   COMMENT '背深动脉1血流速度',  
    `back_deep_artery_second` double NOT NULL   COMMENT '背深动脉2血流速度',  
    `pfi` double NOT NULL   COMMENT 'pfi',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint    COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `hardness_report_root`
-- ----------------------------
-- DROP TABLE IF EXISTS `hardness_report_root`;
CREATE TABLE `hardness_report_root` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `mobile` varchar(100) NOT NULL   COMMENT '用户手机号',  
    `detection_at` varchar(100) NOT NULL   COMMENT '检测时间',  
    `event_number_root` int(2) NOT NULL   COMMENT '根部事件号',  
    `event_time_root` int(2) NOT NULL   COMMENT '根部事件时长',  
    `nineteen_root` int(2) NOT NULL   COMMENT '根部0-19%时长',  
    `thirty_nine_root` int(2) NOT NULL   COMMENT '根部20-39%时长',  
    `fifty_nine_root` int(2) NOT NULL   COMMENT '根部40-59%时长',  
    `seventy_nine_root` int(2) NOT NULL   COMMENT '根部60-79%时长',  
    `hundred_root` int(2) NOT NULL   COMMENT '根部80-100%时长',  
    `hardness_avg_root` double NOT NULL   COMMENT '根部平均硬度',  
    `circumference_baseline_root` double NOT NULL   COMMENT '根部周径基线',  
    `circumference_avg_root` double NOT NULL   COMMENT '根部平均周径',  
    `swelling_rate_root` double NOT NULL   COMMENT '根部肿胀增率',  
    `rau_root` double NOT NULL   COMMENT '根部rau',  
    `tau_root` double NOT NULL   COMMENT '根部tau',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint    COMMENT '创建人',  
    `update_by` bigint    COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `sensitivity_report_stem`
-- ----------------------------
-- DROP TABLE IF EXISTS `sensitivity_report_stem`;
CREATE TABLE `sensitivity_report_stem` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `mobile` varchar(100) NOT NULL   COMMENT '用户手机号',  
    `detection_at` varchar(100) NOT NULL   COMMENT '检测时间',  
    `sensitivity_cold_base_stem` int NOT NULL   COMMENT '茎体基准线冷觉温度',  
    `sensitivity_pain_base_stem` int NOT NULL   COMMENT '茎体基准线冷痛温度',  
    `sensitivity_hot_base_stem` int NOT NULL   COMMENT '茎体基准线热觉温度',  
    `sensitivity_hot_pain_base_stem` int NOT NULL   COMMENT '茎体基准线热痛温度',  
    `sensitivity_cold_upper_limit_stem` double NOT NULL   COMMENT '茎体上限冷觉温度',  
    `sensitivity_pain_upper_limit_stem` double NOT NULL   COMMENT '茎体上限冷痛温度',  
    `sensitivity_hot_upper_limit_stem` double NOT NULL   COMMENT '茎体上限热觉温度',  
    `sensitivity_hot_pain_upper_limit_stem` double NOT NULL   COMMENT '茎体上限热痛温度',  
    `sensitivity_cold_lower_limit_stem` double NOT NULL   COMMENT '茎体下限冷觉温度',  
    `sensitivity_pain_lower_limit_stem` double NOT NULL   COMMENT '茎体下限冷痛温度',  
    `sensitivity_hot_lower_limit_stem` double NOT NULL   COMMENT '茎体下限热觉温度',  
    `sensitivity_hot_pain_lower_limit_stem` double NOT NULL   COMMENT '茎体下限热痛温度',  
    `sensitivity_cold_avg_stem` double NOT NULL   COMMENT '茎体冷觉温度平均值',  
    `sensitivity_pain_avg_stem` double NOT NULL   COMMENT '茎体冷痛温度平均值',  
    `sensitivity_hot_avg_stem` double NOT NULL   COMMENT '茎体热觉温度平均值',  
    `sensitivity_hot_pain_avg_stem` double NOT NULL   COMMENT '茎体热痛温度平均值',  
    `sensitivity_cold_sta_dff_stem` double NOT NULL   COMMENT '茎体冷觉温度标准差',  
    `sensitivity_pain_sta_dff_stem` double NOT NULL   COMMENT '茎体冷痛温度标准差',  
    `sensitivity_hot_sta_dff_stem` double NOT NULL   COMMENT '茎体热觉温度标准差',  
    `sensitivity_hot_pain_sta_dff_stem` double NOT NULL   COMMENT '茎体热痛温度标准差',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint    COMMENT '更新时间',  
    `create_by` bigint    COMMENT '创建人',  
    `update_by` bigint    COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





