package com.ptteng.course.home.controller;

import com.ptteng.learn.admin.model.Constant;
import com.ptteng.learn.admin.service.ConstantService;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * DictationPeriod  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class DictationPeriodController {
	private static final Log log = LogFactory.getLog(DictationPeriodController.class);

	@Autowired
	private DictationPeriodService dictationPeriodService;

	@Autowired
	private DperiodTypeRelationService dperiodTypeRelationService;

	@Autowired
	private DictationLessonService dictationLessonService;

	@Autowired
	private DictationSubjectService dictationSubjectService;

	@Autowired
	private DictationLevelService dictationLevelService;

	@Autowired
	private ConstantService constantService;


	@Autowired
	private UserDperiodRelationService userDperiodRelationService;

	
	/**
	 * @Description 听写课时详情
	 * @param 
	 * @Author: PeiyuFeng
	 * @Time 2017/5/17 14:40
	 */
	@RequestMapping(value = "/a/u/dictation/period/detail/{id}", method = RequestMethod.GET)
	public String getDictationPeriod(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		User user = (User) request.getAttribute("user");
		Long uid = user.getId();

		try {
			DictationPeriod dictationPeriod = dictationPeriodService.getObjectById(id);
			if(dictationPeriod == null){
				log.info("period not exist");
				model.addAttribute("code", -2112);
				return "/common/success";
			}else {
				log.info("get dictationPeriod data is " + dictationPeriod);
			}

			DictationLesson lesson = dictationLessonService.getObjectById(dictationPeriod.getLid());
			if (lesson == null) {
				log.info("lesson not exist");
				model.addAttribute("code", -2100);
				return "/common/success";
			} else {
				log.info("get dictation lesson data is " + lesson);
			}

			DictationSubject subject = dictationSubjectService.getObjectById(lesson.getSid());
			if (subject == null) {
				log.info("subject not exist");
				model.addAttribute("code", -2106);
				return "/common/success";
			} else {
				log.info("get dictation subject data is " + subject);
			}

			DictationLevel level = dictationLevelService.getObjectById(lesson.getLevelId());

			List<Long> typeIds = new ArrayList<>();
			List<Long> relationIds = dperiodTypeRelationService.getIdsByPeriodId(id, 0, Integer.MAX_VALUE);
			List<DperiodTypeRelation> relations = dperiodTypeRelationService.getObjectsByIds(relationIds);
			for (DperiodTypeRelation relation : relations) {
				typeIds.add(relation.getTypeId());
			}

			List<Constant> types = constantService.getObjectsByIds(typeIds);

			Long rid = userDperiodRelationService.getIdsByUserIdAndPeriodId(uid, id);
			UserDperiodRelation relation = userDperiodRelationService.getObjectById(rid);
			relation.setStatus(UserDperiodRelation.STATUS_AGAIN);
			userDperiodRelationService.update(relation);

			model.addAttribute("code", 0);
			model.addAttribute("types", types);
			model.addAttribute("lessonName", lesson.getName());
			model.addAttribute("lessonImg", lesson.getImg());
			model.addAttribute("subjectName", subject.getName());
			model.addAttribute("levelName", level.getName());
			model.addAttribute("dictationPeriod", dictationPeriod);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get dictationPeriod error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/dictationPeriod/json/dictationPeriodDetailJson";
	}

	
	/**
	 * @Description 听写种类常量列表
	 * @param 
	 * @Author: PeiyuFeng
	 * @Time 2017/5/17 14:40
	 */
	@RequestMapping(value = "/a/u/dictation/type/list", method = RequestMethod.GET)
	public String getDictationTypeList(HttpServletRequest request,
											HttpServletResponse response, ModelMap model) throws Exception {
		
		log.info("get dictation type list");
		
		try {

			List<Long> ids = constantService.getConstantIdsByType("dictationType", 0 , Integer.MAX_VALUE);
			List<Constant> types = constantService.getObjectsByIds(ids);

			model.addAttribute("code", 0);
			model.addAttribute("total", types.size());
			model.addAttribute("types", types);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get dictation type list error");
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/dictationPeriod/json/dictationType";
	}

	
}

