package com.ptteng.course.home.controller;

import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.course.util.DynamicUtil;

import com.ptteng.learn.admin.model.Article;
import com.ptteng.learn.admin.service.ArticleService;
import com.ptteng.learn.admin.service.ManagerService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * Article  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ArticleController {
    private static final Log log = LogFactory.getLog("article");

    private final String Img_Module_Common = "common";
    @Autowired
    private ArticleService articleService;

    @Autowired
    private ImgStorageUtil imgStorageUtil;

//	@Autowired
//	private ManagerService managerService;


    @Autowired
    private com.qding.common.util.http.cookie.CookieUtil cookieUtil;


    /**
     * 单个查询展示内容
     *
     * @param request
     * @param response
     * @param model
     * @param aid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/article/{aid}", method = RequestMethod.GET)
    public String getArticleJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long aid)
            throws Exception {

        log.info("get article data : id= " + aid);
        try {
            if (aid == null) {
                model.addAttribute("code", -1000);
                return "/common/success";
            } else {

                Article article = articleService.getObjectById(aid);
                if (article.getStatus() == 2) {
                    model.addAttribute("code", -5052);
                    return "/common/success";
                }
                if (article == null) {
                    model.addAttribute("code", 2);
                    return "/common/success";
                } else {
                    log.info("get article data is " + article.getId());
                    model.addAttribute("code", 0);
                    model.addAttribute("article", article);
                }

                log.info("article read count before " + article.getReadCount());
                article.setReadCount(article.getReadCount() + 1);
                log.info("article read count later " + article.getReadCount());

                articleService.update(article);
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get article error,id is  " + aid);
            model.addAttribute("code", -1);
        }

        return "/admin/article/json/articleDetailJson";
    }


    /**
     * 条件查询内容
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param startAt
     * @param endAt
     * @param type
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/list", method = RequestMethod.GET)
    public String getArticleList(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Integer page, Integer size,
                                 Long startAt, Long endAt, Integer type, String source, String status, String title)
            throws Exception {
        log.info("/web/a/article/list ,page is:" + page + ",size is" + size + ",startAt is" + startAt + ",endAt is" + endAt + ", type is " +
                "" + type + " , source is " + source + " createBy is " + " status is " + status);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Integer total = null;
        List<Long> count = null;
        List<Long> ids = null;
        try {


                Map<String, Object> param = DynamicUtil.getArticleListParam(startAt, endAt, type, title, source, ""+Article.Status_Published);
                log.info("        param is    " + param);
                log.info("pageList : page= " + start + " , size=" + size);
                ids = articleService.getIdsByDynamicCondition(Article.class, param, start, size);
                count = articleService.getIdsByDynamicCondition(Article.class, param, 0, Integer.MAX_VALUE);
                total = count.size();
                log.info("===============================================2" + ids + "=====" + total);


            if (ids != null && ids.size() > 0) {

                log.info("get article list ids is" + ids);
                List<Article> articleList = articleService.getObjectsByIds(ids);
                model.addAttribute("articleList", articleList);
            }
// else{
//				model.addAttribute("code", 2);
//				return "/common/success";
//			}
            Boolean next = false;
            Integer nex = start + size;

            if (total > nex) {

                next = true;
            }
            model.addAttribute("next", next);


            Integer totalPage = 1;
            if (total > 0) {

                totalPage = (total - 1) / size + 1;
            }
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("size", size);
            model.addAttribute("code", 0);
            model.addAttribute("next", next);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get articleList error,qfrom is" + startAt + ",qto is" + endAt + ", type is " +
                    "" + type + " , source is " + source + " createBy is " + " status is " + status);
            model.addAttribute("code", -100000);
        }

        return "/admin/article/json/articleMultiJson";
    }



    @RequestMapping(value = "/a/ceshi", method = RequestMethod.GET)
    public String getArticleLisst(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Integer page, Integer size,
                                 Long startAt, Long endAt, Integer type, String source, String status, String title)
            throws Exception {

            model.addAttribute("code",998);


        return "/admin/article/json/articleMultiJson";
    }

}