package com.ptteng.wealth.finance.etl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.gemantic.common.util.StringUtil;
import com.ptteng.common.util.notice.NoticeUtil;
import com.ptteng.learn.common.model.Message;
import com.ptteng.learn.common.model.UserMessageRelation;
import com.ptteng.learn.common.service.MessageService;
import com.ptteng.learn.common.service.UserMessageRelationService;
import com.ptteng.learn.course.model.User;
import com.ptteng.learn.course.service.UserService;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class ConsignPayEtl {

	private static final int TASK_LEN = 100;// 一次任务检测的条数

	private static final long SLEEP_MILLISECOND = 30000;// ====空转任务间隔休息毫秒数

	private static final Log log = LogFactory.getLog("autoScan");


	private MessageService messageService;
    private UserService userService;
    private UserMessageRelationService userMessageRelationService;
	@Autowired
	private NoticeUtil androidPushServiceImpl;
	@Autowired
	private NoticeUtil iosPushServiceImpl;
    private Long interval=2000L;


	public ConsignPayEtl() {
		super();
	}

	public void process() throws InterruptedException {

		while (true) {

			try {



				//1. get data of unconfirm order
				List<Message> messages=getMessages();
				if(CollectionUtils.isEmpty(messages)){
					log.info("messages etl not get any id ,sleep "+SLEEP_MILLISECOND+" ms ");
					Thread.sleep(SLEEP_MILLISECOND);

				}
				//2.query result from consignment,if success
				processOrder(messages);




			} catch (Throwable t) {

				t.printStackTrace();
				Thread.sleep(SLEEP_MILLISECOND);
				log.error("process goods bytime status error ,sleep " + t.getMessage());
			}

		}

	}



//	private void updateOrders(List<Order> completeOrders) {
//		if(CollectionUtils.isEmpty(completeOrders)){
//
//		}else{
//			log.info("will update order size is "+completeOrders.size());
//			try {
//				this.orderService.updateList(completeOrders);
//			} catch (Throwable t) {
//				// TODO Auto-generated catch block
//				t.printStackTrace();
//				log.error(t);
//				log.error("wrong update orders "+completeOrders);
//			}
//		}
//
//	}

	private List<Message> getMessages() {
		List<Message> messages=new ArrayList();
		Map<String, Object> conditions = new HashMap<String, Object>();

		//判断messageType是否为及时发送
		conditions.put("message_type", Message.later);

		//是否为下架
		conditions.put("up_down", Message.status_freeze);

        //是否为消息
        conditions.put("type", Message.Type_Message);

		//下一次扫描发通知的时间
		//conditions.put("publish_at &>=  ",System.currentTimeMillis() );
		conditions.put("@table"," message ");
		Long now = System.currentTimeMillis();
		try {
			List<Long> ids = this.messageService.getIdsByDynamicCondition(Message.class, conditions, 0, TASK_LEN);
			if(CollectionUtils.isEmpty(ids)){

				log.info("not ger any process message ");
			}else{
				messages=this.messageService.getObjectsByIds(ids);
				for(Message message : messages){
					if(now>=message.getPublishAt()){
						log.info(" message id = "+message.getId());
						message.setUpAndDown(Message.status_normal);
						noticePush(message);
					}
				}
				this.messageService.updateList(messages);

				log.info("get process messages is "+messages.size());
			}

		} catch (Throwable t) {
			// TODO Auto-generated catch block
			t.printStackTrace();
			log.error(t);
		}

		return messages;
	}

	/**
	 * 检测过期商品，修改状态
	 * @param messages
	 *
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 * @throws InterruptedException
	 */
	private void processOrder(List<Message> messages) throws ServiceException, ServiceDaoException, InterruptedException {
		List<Message> readyMessages=new ArrayList();

		if(CollectionUtils.isEmpty(readyMessages)){
			log.info("no query messages ");
			return ;
		}else{

			log.info(this.interval+" will query messages id is "+readyMessages);
		}

		Integer status= 0;

        try {
            for(Message message:readyMessages){

                status = message.getUpAndDown();


                if(Message.status_normal.equals(status)){
                    //已上架跳过

                    continue;

                }else{

					message.setUpAndDown(Message.status_normal);
					messageService.update(message);


				}

            }
        }catch (Exception e){
            log.error(e);
        }


	}


    public MessageService getMessageService() {
        return messageService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }


    public UserService getUserService() {
        return userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public UserMessageRelationService getUserMessageRelationService() {
        return userMessageRelationService;
    }

    public void setUserMessageRelationService(UserMessageRelationService userMessageRelationService) {
        this.userMessageRelationService = userMessageRelationService;
    }

    public Long getInterval() {
		return interval;
	}

	public void setInterval(Long interval) {
		this.interval = interval;
	}


    public void messageUp(Message message) throws Exception{

        message.setPublishAt(System.currentTimeMillis());
        message.setStatus(Message.status_normal);
        List<Long> userIds = null;
        UserMessageRelation userMessageRelation = new UserMessageRelation();
        userMessageRelation.setTargetId(message.getId());
        if (message.getGrade() == 7) {
            userIds = userService.getUserIds(0, Integer.MAX_VALUE);
        } else {
            userIds = userService.getUserIdByGrade(message.getGrade());
        }
        for (Long userId : userIds) {
            userMessageRelation.setUserId(userId);
            userMessageRelationService.insert(userMessageRelation);
        }

    }


	public static void main(String [] arg){

	}


	private   String noticePush(Message message) throws ServiceException, ServiceDaoException, IOException {
		log.info(" noticePush start ... ");
		Integer status =  message.getStatus();
		log.info(" status is =  "+status);

		Integer grade = message.getGrade();
		String result = "";
		if(Message.synchronization.equals(status)){
			List<Long> userIds = new ArrayList<>();
			log.info(" synchronization is true ");
			if(User.allGrade.equals(grade)) {
				log.info(" all ");

				userIds = userService.getUserIds(0,Integer.MAX_VALUE);
			}else{
				userIds =  userService.getUserIdByGrade(grade);
			}
			log.info(" user size = "+userIds.size());

			if(userIds.size()>0){
				List<User> users = userService.getObjectsByIds(userIds);

				StringBuilder anDevicceTokens = new StringBuilder("");
				StringBuilder iosDevicceTokens = new StringBuilder("");
				for(int i=0;i<users.size();i++){
					if("android".equals(users.get(i).getPlatform())){

						if(StringUtil.isNotEmpty(users.get(i).getDeviceToken()) ){
							anDevicceTokens.append(users.get(i).getDeviceToken()+",");
						}

					}else if("ios".equals(users.get(i).getPlatform())){

						if(StringUtil.isNotEmpty(users.get(i).getDeviceToken())){
							iosDevicceTokens.append(users.get(i).getDeviceToken()+",");
						}
					}else{
//						log.info("user "+users.get(i).getId()+ "is  another platfrorm = "+users.get(i).getPlatform());
					}
				}
//				log.info(" anDevicceTokens ="+anDevicceTokens);
//				log.info(" iosDevicceTokens =" + iosDevicceTokens);
				Long startAt = null;
				Long endAt = message.getCreateAt()+(7*24*60*60*1000);
				log.info(" endAt = "+endAt);
				if(StringUtil.isNotEmpty(anDevicceTokens.toString())){
					log.info(" android ");
					result= androidPushServiceImpl.pushMessaeForList("android", "notification", "listcast", anDevicceTokens.toString(), message.getName(), message.getName(), message.getContent(), "go_app", "", "", "",
							"", startAt, "", "true",endAt,"回家学习通知");
					JSONObject jsonObject = JSONObject.fromObject(result);

					if("SUCCESS".equals((String)jsonObject.get("ret"))){
						log.info(" push success ");
					}else{
						log.info("fail"+jsonObject.get("data"));
						JSONObject data =JSONObject.fromObject(jsonObject.get("data").toString());
						log.info(" data = "+data);
						log.info(" errorCode = "+data.get("error_code"));

					}
				}
				if(StringUtil.isNotEmpty(iosDevicceTokens.toString())) {
					log.info(" ios ");
					result= iosPushServiceImpl.pushMessaeForList("ios", "notification", "listcast", iosDevicceTokens.toString(), message.getName(), message.getName(), message.getContent(), "go_app", "", "", "",
							"", startAt, "", "true",endAt,"回家学习通知");
					log.info(" result = "+result);
					JSONObject jsonObjectios = JSONObject.fromObject(result);

					if("SUCCESS".equals((String) jsonObjectios.get("ret"))){
						log.info(" push success ");
					}else{
						log.info(" ==== "+jsonObjectios.get("data"));
						JSONObject data =JSONObject.fromObject(jsonObjectios.get("data").toString());
						log.info(" data = "+data);
						log.info(" errorCode = "+data.get("error_code"));

					}
				}




			}

		}

		return result;

	}





}
