-- ----------------------------
-- Table structure for `book`
-- ----------------------------
-- DROP TABLE IF EXISTS `book`;
CREATE TABLE `book` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(1000)   ,  
    `introduce` varchar(5000)   ,  
    `press` varchar(1000)   ,  
    `grade` int(10)   ,
    `img` varchar(100)   ,  
    `sort` int(10)   ,
    `study_count` int(10)   ,
    `favorite_count` int(10)   ,
    `period_count` int(10)   ,
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `lesson`
-- ----------------------------
-- DROP TABLE IF EXISTS `lesson`;
CREATE TABLE `lesson` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(1000)   ,  
    `introduce` varchar(5000)   ,  
    `recommend` int(10)   ,
    `recommend_img` varchat(100)   ,  
    `level` int(10)   ,
    `subject` int(10)    ,
    `img` varchar(100)   ,  
    `sort` int(10)    ,
    `study_count` int(10)    ,
    `favorite_count` int(10)    ,
    `period_count` int(10)    ,
    `paper_count` int(10)    ,
    `locked` int(10)    ,
    `collaborate_id` bigint NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `collaborate`
-- ----------------------------
-- DROP TABLE IF EXISTS `collaborate`;
CREATE TABLE `collaborate` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(1000)   ,  
    `introduce` varchar(5000)   ,  
    `img` varchar(100)   ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `paper`
-- ----------------------------
-- DROP TABLE IF EXISTS `paper`;
CREATE TABLE `paper` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(1000)   ,  
    `introduce` varchar(5000)   ,  
    `url` varchar(100)   ,  
    `count` int(10)    ,
    `price` varchar(100)   ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `period`
-- ----------------------------
-- DROP TABLE IF EXISTS `period`;
CREATE TABLE `period` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(1000)   ,  
    `introduce` varchar(5000)   ,  
    `level` int(10)    ,
    `img` varchar(100)   ,  
    `sort` int(10)    ,
    `favorite_count` int(10)    ,
    `task_count` int(10)    ,
    `locked` int(10)    ,
    `lesson_id` bigint NOT NULL  ,  
    `paper_id` bigint NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `task`
-- ----------------------------
-- DROP TABLE IF EXISTS `task`;
CREATE TABLE `task` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(1000)   ,  
    `introduce` varchar(5000)   ,  
    `level` int(10)    ,
    `img` varchar(100)   ,  
    `hint_content` varchar(100)   ,  
    `hint_type` int(10)    ,
    `sort` int(10)    ,
    `unit_count` int(10)    ,
    `period_id` bigint NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `unit`
-- ----------------------------
-- DROP TABLE IF EXISTS `unit`;
CREATE TABLE `unit` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(1000)   ,  
    `introduce` varchar(5000)   ,  
    `type` int(10)    ,
    `link` varchar(100)   ,  
    `sort` int(10)    ,
    `length` int(10)    ,
    `task_id` bigint NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `progress`
-- ----------------------------
-- DROP TABLE IF EXISTS `progress`;
CREATE TABLE `progress` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `user_id` bigint NOT NULL  ,  
    `target_id` bigint NOT NULL  ,  
    `type` int(10)    ,
    `status` int(10)    ,
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_task_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_task_relation`;
CREATE TABLE `user_task_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `user_id` bigint NOT NULL  ,  
    `progress` bigint NOT NULL  ,  
    `period_id` bigint NOT NULL  ,  
    `lesson_id` bigint NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_favorite_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_favorite_relation`;
CREATE TABLE `user_favorite_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `user_id` bigint NOT NULL  ,  
    `target_id` bigint NOT NULL  ,  
    `type` int(10)    ,
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `locks`
-- ----------------------------
-- DROP TABLE IF EXISTS `locks`;
CREATE TABLE `locks` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `user_id` bigint NOT NULL  ,  
    `target_id` bigint NOT NULL  ,  
    `type` int(10)    ,
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_openid_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_openid_relation`;
CREATE TABLE `user_openid_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `uid` bigint NOT NULL  ,  
    `openid` varchar(50) NOT NULL  ,  
    `type` varchar(20) NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user`
-- ----------------------------
-- DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `pwd` varchar(300) NOT NULL  ,
    `mobile` varchar(20) NOT NULL  ,
    `name` varchar(100)   ,
    `img` varchar (300)   ,
    `grade` int(10)    ,
    `term` int (10)   ,
    `learn_time` int(10)    ,
    `learn_score` int(10)    ,
    `learn_buy` int(10)    ,
    `score` float NOT NULL  ,  
    `register_at` bigint NOT NULL  ,  
    `last_login_at` bigint NOT NULL  ,  
    `status` bigint NOT NULL  ,  
    `wrong_count` int NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





-- ----------------------------
-- Table structure for `grade_class_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `grade_class_relation`;
CREATE TABLE `grade_class_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,
    `suject_id` bigint NOT NULL  ,
    `name` varchar(100) NOT NULL  ,
    `grade_name` varchar(100) NOT NULL  ,
    `sort` int   ,
    `create_by` bigint   ,
    `update_by` bigint   ,
    `update_at` bigint NOT NULL  ,
    `create_at` bigint NOT NULL  ,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `subject`
-- ----------------------------
-- DROP TABLE IF EXISTS `subject`;
CREATE TABLE `subject` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,
    `name` varchar(100) NOT NULL  ,
    `type` int(10) NOT NULL  ,
    `grade_name` varchar(100) NOT NULL  ,
    `sort` int(10)   ,
    `class_id` bigint NOT NULL  ,
    `create_by` bigint   ,
    `update_by` bigint   ,
    `update_at` bigint NOT NULL  ,
    `create_at` bigint NOT NULL  ,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for `user_order`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_order`;
CREATE TABLE `user_order` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,
    `user_id` bigint NOT NULL  ,
    `target_id` bigint NOT NULL  ,
    `pay_at` bigint NOT NULL  ,
    `buy_at` bigint NOT NULL  ,
    `pay_type` int(10) NOT NULL  ,
    `buy_type` int(10) NOT NULL  ,
    `address` varchar(100)   ,
    `create_by` bigint   ,
    `update_by` bigint   ,
    `update_at` bigint NOT NULL  ,
    `create_at` bigint NOT NULL  ,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for `introduce`
-- ----------------------------
-- DROP TABLE IF EXISTS `introduce`;
CREATE TABLE `introduce` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,
    `level` int(10) NOT NULL  ,
    `subject_id` bigint NOT NULL  ,
    `lesson_id` bigint NOT NULL  ,
    `img` varchar(100) NOT NULL  ,
    `create_by` bigint   ,
    `update_by` bigint   ,
    `update_at` bigint NOT NULL  ,
    `create_at` bigint NOT NULL  ,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for `user_unit_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_unit_relation`;
CREATE TABLE `user_unit_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `user_id` bigint    COMMENT '用户id',
    `unit_id` bigint    COMMENT '单元id',
    `score` int(10)    COMMENT '所得分数',
    `url` varchar(300)String    COMMENT '录音url',
    `create_by` bigint    COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for `scoreRecord`
-- ----------------------------
-- DROP TABLE IF EXISTS `scoreRecord`;
CREATE TABLE `scoreRecord` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT 'id',
    `uid` bigint NOT NULL   COMMENT '用户ID',
    `score` int(20) NOT NULL   COMMENT '充值数',
    `totalScore` int(20) NOT NULL   COMMENT '剩余数',
    `create_by` bigint NOT NULL   COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `coupon`
-- ----------------------------
-- DROP TABLE IF EXISTS `coupon`;
CREATE TABLE `coupon` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `number` varchar(11) NOT NULL   COMMENT '卡号',
    `pwd` varchar(8) NOT NULL   COMMENT '密码',
    `period` varchar(30) NOT NULL   COMMENT '有效期（天）',
    `deadline` bigint NOT NULL   COMMENT '失效日期',
    `name` varchar(1000) NOT NULL   COMMENT '套餐名称',
    `price` varchar(30) NOT NULL   COMMENT '价格',
    `status` int(1) NOT NULL   COMMENT '状态',
    `create_by` bigint NOT NULL   COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;
-- ----------------------------
-- Table structure for `member`
-- ----------------------------
-- DROP TABLE IF EXISTS `member`;
CREATE TABLE `member` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `name` varchar(1000) NOT NULL   COMMENT '名字',
    `period` varchar(30) NOT NULL   COMMENT '期限',
    `price` varchar(30) NOT NULL   COMMENT '价格',
    `status` int(1) NOT NULL   COMMENT '状态',
    `create_by` bigint NOT NULL   COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





-- ----------------------------
-- Table structure for `user_member_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_member_relation`;
CREATE TABLE `user_member_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `uid` bigint NOT NULL   COMMENT '用户ID',
    `name` varchar(1000) NOT NULL   COMMENT '套餐名字',
    `period` varchar(30) NOT NULL   COMMENT '套餐期限',
    `price` varchar(30) NOT NULL   COMMENT '套餐价格',
    `start_at` bigint NOT NULL   COMMENT '开始时间',
    `end_at` bigint NOT NULL   COMMENT '结束时间',
    `status` int(1) NOT NULL   COMMENT '状态',
    `coupon_id` bigint    COMMENT '卡券ID',
    `create_by` bigint NOT NULL   COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for `recommendStatistics`
-- ----------------------------
-- DROP TABLE IF EXISTS `recommendStatistics`;
CREATE TABLE `recommendStatistics` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT 'user id',
    `amount` varchar(30) NOT NULL   COMMENT '消费金额',
    `registers` varchar(30) NOT NULL   COMMENT '注册量',
          static_at bigint NOT NULL  COMMENT '统计日期',
    `create_by` bigint NOT NULL   COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `game_score_rank`
-- ----------------------------
-- DROP TABLE IF EXISTS `game_score_rank`;
CREATE TABLE `game_score_rank` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT 'id',  
    `type` int(2)    COMMENT '游戏种类',  
    `user_id` bigint NOT NULL   COMMENT '用户id',  
    `statistics_at` bigint NOT NULL   COMMENT '记录周标识（周一0点）',  
    `game_score` bigint    COMMENT '游戏积分',  
    `rank` bigint NOT NULL   COMMENT '排行',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `game_score_records`
-- ----------------------------
-- DROP TABLE IF EXISTS `game_score_records`;
CREATE TABLE `game_score_records` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT 'id',  
    `type` int(2)    COMMENT '游戏种类',  
    `user_id` bigint NOT NULL   COMMENT '用户id',  
    `score` bigint    COMMENT '游戏积分',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for `user_taskRecord_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_taskRecord_relation`;
CREATE TABLE `user_taskRecord_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `task_id` bigint    COMMENT '任务',
    `user_id` bigint    COMMENT '用户ID',
    `note_type` bigint    COMMENT '错题本类型',
    `result` varchar(2000)    COMMENT '用户答案',
    `create_by` bigint    COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;















