/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.GameScoreRank;
import com.ptteng.learn.course.service.GameScoreRankService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GameScoreRankServiceImpl
extends BaseDaoServiceImpl
implements GameScoreRankService {
    private static final Log log = LogFactory.getLog(GameScoreRankServiceImpl.class);

    public Long insert(GameScoreRank gameScoreRank) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + gameScoreRank));
        if (gameScoreRank == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        gameScoreRank.setCreateAt(Long.valueOf(currentTimeMillis));
        gameScoreRank.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)gameScoreRank);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + gameScoreRank));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<GameScoreRank> insertList(List<GameScoreRank> gameScoreRankList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (gameScoreRankList == null ? "null" : Integer.valueOf(gameScoreRankList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(gameScoreRankList)) {
            return new ArrayList<GameScoreRank>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (GameScoreRank gameScoreRank : gameScoreRankList) {
            gameScoreRank.setCreateAt(Long.valueOf(currentTimeMillis));
            gameScoreRank.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(gameScoreRankList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + gameScoreRankList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(GameScoreRank.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(GameScoreRank gameScoreRank) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (gameScoreRank == null ? "null" : gameScoreRank.getId())));
        boolean result = false;
        if (gameScoreRank == null) {
            return true;
        }
        gameScoreRank.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)gameScoreRank);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + gameScoreRank));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + gameScoreRank));
        }
        return result;
    }

    public boolean updateList(List<GameScoreRank> gameScoreRankList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (gameScoreRankList == null ? "null" : Integer.valueOf(gameScoreRankList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(gameScoreRankList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (GameScoreRank gameScoreRank : gameScoreRankList) {
            gameScoreRank.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(gameScoreRankList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + gameScoreRankList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + gameScoreRankList.size()));
        return result;
    }

    public GameScoreRank getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        GameScoreRank gameScoreRank = null;
        if (id == null) {
            return gameScoreRank;
        }
        try {
            gameScoreRank = (GameScoreRank)this.dao.get(GameScoreRank.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return gameScoreRank;
    }

    public List<GameScoreRank> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List gameScoreRank = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<GameScoreRank>();
        }
        try {
            gameScoreRank = this.dao.getList(GameScoreRank.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (gameScoreRank == null ? "null" : Integer.valueOf(gameScoreRank.size()))));
        return gameScoreRank;
    }

    public List<Long> getGameScoreRankIdsByUserIdOrderByCreateAt(Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by userId,start,limit  : " + userId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGameScoreRankIdsByUserIdOrderByCreateAt", new Object[]{userId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by userId,start,limit)  : " + userId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAt(Long stasticsAt, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by stasticsAt,start,limit  : " + stasticsAt + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAt", new Object[]{stasticsAt}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by stasticsAt,start,limit)  : " + stasticsAt + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countGameScoreRankIdsByUserIdOrderByCreateAt(Long userId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by userId  : " + userId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getGameScoreRankIdsByUserIdOrderByCreateAt", new Object[]{userId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by userId)  : " + userId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAt(Long stasticsAt) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by stasticsAt  : " + stasticsAt));
        }
        Integer count = null;
        try {
            count = this.dao.count("getGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAt", new Object[]{stasticsAt});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by stasticsAt)  : " + stasticsAt));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getGameScoreRankIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGameScoreRankIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countGameScoreRankIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getGameScoreRankIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getGameScoreRankIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

