/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.DictationNote;
import com.ptteng.learn.course.service.DictationNoteService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DictationNoteServiceImpl
extends BaseDaoServiceImpl
implements DictationNoteService {
    private static final Log log = LogFactory.getLog(DictationNoteServiceImpl.class);

    public Long insert(DictationNote dictationNote) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + dictationNote));
        if (dictationNote == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        dictationNote.setCreateAt(Long.valueOf(currentTimeMillis));
        dictationNote.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)dictationNote);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + dictationNote));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<DictationNote> insertList(List<DictationNote> dictationNoteList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (dictationNoteList == null ? "null" : Integer.valueOf(dictationNoteList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(dictationNoteList)) {
            return new ArrayList<DictationNote>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (DictationNote dictationNote : dictationNoteList) {
            dictationNote.setCreateAt(Long.valueOf(currentTimeMillis));
            dictationNote.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(dictationNoteList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + dictationNoteList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(DictationNote.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(DictationNote dictationNote) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (dictationNote == null ? "null" : dictationNote.getId())));
        boolean result = false;
        if (dictationNote == null) {
            return true;
        }
        dictationNote.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)dictationNote);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + dictationNote));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + dictationNote));
        }
        return result;
    }

    public boolean updateList(List<DictationNote> dictationNoteList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (dictationNoteList == null ? "null" : Integer.valueOf(dictationNoteList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(dictationNoteList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (DictationNote dictationNote : dictationNoteList) {
            dictationNote.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(dictationNoteList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + dictationNoteList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + dictationNoteList.size()));
        return result;
    }

    public DictationNote getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        DictationNote dictationNote = null;
        if (id == null) {
            return dictationNote;
        }
        try {
            dictationNote = (DictationNote)this.dao.get(DictationNote.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return dictationNote;
    }

    public List<DictationNote> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List dictationNote = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<DictationNote>();
        }
        try {
            dictationNote = this.dao.getList(DictationNote.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (dictationNote == null ? "null" : Integer.valueOf(dictationNote.size()))));
        return dictationNote;
    }

    public List<Long> getDictationNoteIdsByUidAndSid(Long uid, Long sid) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids by uid,sid " + uid + " , " + sid));
        List idList = null;
        try {
            idList = this.dao.getIdList("getDictationNoteIdsByUidAndSid", new Object[]{uid, sid}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids wrong by uid,sid : " + uid + " , " + sid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getDictationNoteIdsByUidAndSidAndName(Long uid, Long sid, String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by uid , sid , name  : " + uid + " , " + sid + " , " + name));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getDictationNoteIdsByUidAndSidAndName", new Object[]{uid, sid, name});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by uid , sid , name  : " + uid + " , " + sid + " , " + name));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Long getDefaultDictationNoteIdByUidAndSid(Long uid, Long sid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by uid , sid : " + uid + " , " + sid));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getDefaultDictationNoteIdByUidAndSid", new Object[]{uid, sid});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by uid , sid : " + uid + " , " + sid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getDictationNoteIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getDictationNoteIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countDictationNoteIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getDictationNoteIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getDictationNoteIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

